/**
 */
package distributions;

import distributions.math.ModeDistribution;

import expressions.Expression;

import java.math.BigDecimal;

import org.apache.commons.math3.random.RandomGenerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Log Normal Distribution</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link distributions.LogNormalDistribution#getShape <em>Shape</em>}</li>
 *   <li>{@link distributions.LogNormalDistribution#getScale <em>Scale</em>}</li>
 *   <li>{@link distributions.LogNormalDistribution#getInverseCumAccuracy <em>Inverse Cum Accuracy</em>}</li>
 *   <li>{@link distributions.LogNormalDistribution#getShapeExp <em>Shape Exp</em>}</li>
 *   <li>{@link distributions.LogNormalDistribution#getScaleExp <em>Scale Exp</em>}</li>
 *   <li>{@link distributions.LogNormalDistribution#getInverseCumAccuracyExp <em>Inverse Cum Accuracy Exp</em>}</li>
 * </ul>
 *
 * @see distributions.DistributionsPackage#getLogNormalDistribution()
 * @model
 * @generated
 */
public interface LogNormalDistribution extends Distribution
{
    /**
     * Returns the value of the '<em><b>Shape</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Shape</em>' attribute.
     * @see distributions.DistributionsPackage#getLogNormalDistribution_Shape()
     * @model transient="true" changeable="false" volatile="true" derived="true"
     * @generated
     */
    BigDecimal getShape();

    /**
     * Returns the value of the '<em><b>Scale</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Scale</em>' attribute.
     * @see distributions.DistributionsPackage#getLogNormalDistribution_Scale()
     * @model transient="true" changeable="false" volatile="true" derived="true"
     * @generated
     */
    BigDecimal getScale();

    /**
     * Returns the value of the '<em><b>Inverse Cum Accuracy</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Inverse Cum Accuracy</em>' attribute.
     * @see distributions.DistributionsPackage#getLogNormalDistribution_InverseCumAccuracy()
     * @model transient="true" changeable="false" volatile="true" derived="true"
     * @generated
     */
    BigDecimal getInverseCumAccuracy();

    /**
     * Returns the value of the '<em><b>Shape Exp</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Shape Exp</em>' containment reference.
     * @see #setShapeExp(Expression)
     * @see distributions.DistributionsPackage#getLogNormalDistribution_ShapeExp()
     * @model containment="true" required="true"
     * @generated
     */
    Expression getShapeExp();

    /**
     * Sets the value of the '{@link distributions.LogNormalDistribution#getShapeExp <em>Shape Exp</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Shape Exp</em>' containment reference.
     * @see #getShapeExp()
     * @generated
     */
    void setShapeExp(Expression value);

    /**
     * Returns the value of the '<em><b>Scale Exp</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Scale Exp</em>' containment reference.
     * @see #setScaleExp(Expression)
     * @see distributions.DistributionsPackage#getLogNormalDistribution_ScaleExp()
     * @model containment="true" required="true"
     * @generated
     */
    Expression getScaleExp();

    /**
     * Sets the value of the '{@link distributions.LogNormalDistribution#getScaleExp <em>Scale Exp</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Scale Exp</em>' containment reference.
     * @see #getScaleExp()
     * @generated
     */
    void setScaleExp(Expression value);

    /**
     * Returns the value of the '<em><b>Inverse Cum Accuracy Exp</b></em>' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Inverse Cum Accuracy Exp</em>' containment reference.
     * @see #setInverseCumAccuracyExp(Expression)
     * @see distributions.DistributionsPackage#getLogNormalDistribution_InverseCumAccuracyExp()
     * @model containment="true"
     * @generated
     */
    Expression getInverseCumAccuracyExp();

    /**
     * Sets the value of the '{@link distributions.LogNormalDistribution#getInverseCumAccuracyExp <em>Inverse Cum Accuracy Exp</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Inverse Cum Accuracy Exp</em>' containment reference.
     * @see #getInverseCumAccuracyExp()
     * @generated
     */
    void setInverseCumAccuracyExp(Expression value);

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @model dataType="distributions.ModeDistribution" required="true" generatorDataType="distributions.RandomGenerator"
     * @generated
     */
    ModeDistribution createModeDistribution(RandomGenerator generator);

} // LogNormalDistribution
