/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.scheduler.simulator.main;

import expressions.Expression;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import machine.Axis;
import machine.Distance;
import machine.HasResourcePeripheral;
import machine.IResource;
import machine.Position;
import machine.SymbolicPosition;
import org.eclipse.emf.common.util.EList;
import org.eclipse.lsat.scheduler.simulator.common.Common;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import setting.MotionSettings;
import setting.PhysicalLocation;
import setting.PhysicalSettings;
import setting.Settings;

public class GenerateSettingsTemplate {
    public static CharSequence generateSettingsJavaScript(Settings model) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// TODO: Adapt these locations to match the screen resolution");
        _builder.newLine();
        Functions.Function1 _function = it -> it.fqn();
        List _sortBy = IterableExtensions.sortBy((Iterable)model.getTransitivePhysicalSettings(), (Functions.Function1)_function);
        for (PhysicalSettings physicalSettings : _sortBy) {
            Functions.Function1 _function_1 = it -> ((Axis)it.getKey()).getName();
            List list = IterableExtensions.sortBy((Iterable)physicalSettings.getMotionSettings(), (Functions.Function1)_function_1);
            for (Map.Entry motionSettings : list) {
                Object _name_1;
                boolean _not;
                Functions.Function1 _function_2 = it -> ((Position)it.getKey()).getName();
                List _sortBy_2 = IterableExtensions.sortBy((Iterable)((MotionSettings)motionSettings.getValue()).getLocationSettings(), (Functions.Function1)_function_2);
                for (Map.Entry locationSettings : _sortBy_2) {
                    _builder.append("var ");
                    String _positionID = Common.getPositionID((HasResourcePeripheral)physicalSettings, (Position)locationSettings.getKey());
                    _builder.append(_positionID);
                    _builder.append("_");
                    String _name = ((Axis)motionSettings.getKey()).getName();
                    _builder.append(_name);
                    _builder.append(" = ");
                    BigDecimal _default = ((PhysicalLocation)locationSettings.getValue()).getDefault();
                    _builder.append((Object)_default);
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                }
                boolean _isEmpty = physicalSettings.getPeripheral().getDistances().isEmpty();
                boolean bl = _not = !_isEmpty;
                if (_not) {
                    _builder.append("var ");
                    String _positionID_1 = Common.getPositionID((HasResourcePeripheral)physicalSettings, "_INITIAL_POSITION");
                    _builder.append(_positionID_1);
                    _builder.append("_");
                    _name_1 = ((Axis)motionSettings.getKey()).getName();
                    _builder.append((String)_name_1);
                    _builder.append(" = 0;");
                    _builder.newLineIfNotEmpty();
                }
                Functions.Function1 _function_3 = it -> ((Distance)it.getKey()).getName();
                List _sortBy_3 = IterableExtensions.sortBy((Iterable)((MotionSettings)motionSettings.getValue()).getDistanceSettings(), (Functions.Function1)_function_3);
                _name_1 = _sortBy_3.iterator();
                while (_name_1.hasNext()) {
                    Map.Entry distanceSettings = (Map.Entry)_name_1.next();
                    _builder.append("var ");
                    String _distanceID = Common.getDistanceID((HasResourcePeripheral)physicalSettings, (Distance)distanceSettings.getKey());
                    _builder.append(_distanceID);
                    _builder.append("_");
                    String _name_2 = ((Axis)motionSettings.getKey()).getName();
                    _builder.append(_name_2);
                    _builder.append(" = ");
                    BigDecimal _evaluate = ((Expression)distanceSettings.getValue()).evaluate();
                    _builder.append((Object)_evaluate);
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                }
            }
        }
        _builder.newLine();
        _builder.append("// Auto generated, do not modify!");
        _builder.newLine();
        Functions.Function1 _function_4 = it -> it.fqn();
        List _sortBy_4 = IterableExtensions.sortBy((Iterable)model.getTransitivePhysicalSettings(), (Functions.Function1)_function_4);
        for (PhysicalSettings physicalSettings_1 : _sortBy_4) {
            Collection<? extends IResource> _itemsOrResource = Common.getItemsOrResource(physicalSettings_1.getResource());
            for (IResource iResource : _itemsOrResource) {
                boolean _not_1;
                EList _positions = physicalSettings_1.getPeripheral().getPositions();
                for (SymbolicPosition position : _positions) {
                    _builder.append("var ");
                    String _positionID_2 = Common.getPositionID(iResource, physicalSettings_1.getPeripheral(), (Position)position);
                    _builder.append(_positionID_2);
                    _builder.append(" = {");
                    EList _axes = physicalSettings_1.getPeripheral().getType().getAxes();
                    boolean _hasElements = false;
                    for (Iterator axis : _axes) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "");
                        }
                        String _name_3 = axis.getName();
                        _builder.append(_name_3);
                        _builder.append(":");
                        String _positionID_3 = Common.getPositionID((HasResourcePeripheral)physicalSettings_1, position.getPosition((Axis)axis));
                        _builder.append(_positionID_3);
                        _builder.append("_");
                        String _name_4 = axis.getName();
                        _builder.append(_name_4);
                    }
                    _builder.append("};");
                    _builder.newLineIfNotEmpty();
                }
                boolean _isEmpty_1 = physicalSettings_1.getPeripheral().getDistances().isEmpty();
                boolean bl = _not_1 = !_isEmpty_1;
                if (_not_1) {
                    Iterator axis;
                    _builder.append("var ");
                    String _positionID_4 = Common.getPositionID(iResource, physicalSettings_1.getPeripheral(), "_INITIAL_POSITION");
                    _builder.append(_positionID_4);
                    _builder.append(" = {");
                    EList _axes_1 = physicalSettings_1.getPeripheral().getType().getAxes();
                    boolean _hasElements_1 = false;
                    axis = _axes_1.iterator();
                    while (axis.hasNext()) {
                        Axis axis_1 = (Axis)axis.next();
                        if (!_hasElements_1) {
                            _hasElements_1 = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "");
                        }
                        String _name_5 = axis_1.getName();
                        _builder.append(_name_5);
                        _builder.append(":");
                        String _positionID_5 = Common.getPositionID((HasResourcePeripheral)physicalSettings_1, "_INITIAL_POSITION");
                        _builder.append(_positionID_5);
                        _builder.append("_");
                        String _name_6 = axis_1.getName();
                        _builder.append(_name_6);
                    }
                    _builder.append("};");
                    _builder.newLineIfNotEmpty();
                }
                EList _distances = physicalSettings_1.getPeripheral().getDistances();
                for (Distance distance : _distances) {
                    _builder.append("var ");
                    String _distanceID_1 = Common.getDistanceID(iResource, physicalSettings_1.getPeripheral(), distance);
                    _builder.append(_distanceID_1);
                    _builder.append(" = {");
                    EList _axes_2 = physicalSettings_1.getPeripheral().getType().getAxes();
                    boolean _hasElements_2 = false;
                    for (Axis axis_2 : _axes_2) {
                        if (!_hasElements_2) {
                            _hasElements_2 = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "");
                        }
                        String _name_7 = axis_2.getName();
                        _builder.append(_name_7);
                        _builder.append(":");
                        String _distanceID_2 = Common.getDistanceID((HasResourcePeripheral)physicalSettings_1, distance);
                        _builder.append(_distanceID_2);
                        _builder.append("_");
                        String _name_8 = axis_2.getName();
                        _builder.append(_name_8);
                    }
                    _builder.append("};");
                    _builder.newLineIfNotEmpty();
                }
            }
        }
        return _builder;
    }
}

