/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.common.jfreechart.chart;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.plot.Pannable;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.Zoomable;

public class ZoomAndPanKeyboardHandler
extends KeyAdapter {
    @Override
    public void keyPressed(KeyEvent event) {
        Object source = event.getSource();
        if (!(source instanceof ChartPanel)) {
            return;
        }
        ChartPanel chartPanel = (ChartPanel)source;
        double centerX = chartPanel.getBounds().getCenterX();
        double centerY = chartPanel.getBounds().getCenterY();
        Plot plot = chartPanel.getChart().getPlot();
        Pannable pannable = plot instanceof Pannable ? (Pannable)plot : null;
        Zoomable zoomable = plot instanceof Zoomable ? (Zoomable)plot : null;
        switch (event.getKeyCode()) {
            case 38: 
            case 104: 
            case 224: {
                if (event.isControlDown() && zoomable != null) {
                    if (zoomable.getOrientation() == PlotOrientation.VERTICAL && zoomable.isRangeZoomable()) {
                        chartPanel.zoomInRange(centerX, centerY);
                        event.consume();
                        break;
                    }
                    if (!zoomable.isDomainZoomable()) break;
                    chartPanel.zoomInDomain(centerX, centerY);
                    event.consume();
                    break;
                }
                if (pannable == null) break;
                if (pannable.getOrientation() == PlotOrientation.VERTICAL && pannable.isRangePannable()) {
                    chartPanel.panRange(chartPanel.getDefaultPanFactor(), centerX, centerY);
                    event.consume();
                    break;
                }
                if (!pannable.isDomainPannable()) break;
                chartPanel.panDomain(chartPanel.getDefaultPanFactor(), centerX, centerY);
                event.consume();
                break;
            }
            case 39: 
            case 102: 
            case 227: {
                if (event.isControlDown() && zoomable != null) {
                    if (zoomable.getOrientation() == PlotOrientation.HORIZONTAL && zoomable.isRangeZoomable()) {
                        chartPanel.zoomInRange(centerX, centerY);
                        event.consume();
                        break;
                    }
                    if (!zoomable.isDomainZoomable()) break;
                    chartPanel.zoomInDomain(centerX, centerY);
                    event.consume();
                    break;
                }
                if (pannable == null) break;
                if (pannable.getOrientation() == PlotOrientation.HORIZONTAL && pannable.isRangePannable()) {
                    chartPanel.panRange(chartPanel.getDefaultPanFactor(), centerX, centerY);
                    event.consume();
                    break;
                }
                if (!pannable.isDomainPannable()) break;
                chartPanel.panDomain(chartPanel.getDefaultPanFactor(), centerX, centerY);
                event.consume();
                break;
            }
            case 40: 
            case 98: 
            case 225: {
                if (event.isControlDown() && zoomable != null) {
                    if (zoomable.getOrientation() == PlotOrientation.VERTICAL && zoomable.isRangeZoomable()) {
                        chartPanel.zoomOutRange(centerX, centerY);
                        event.consume();
                        break;
                    }
                    if (!zoomable.isDomainZoomable()) break;
                    chartPanel.zoomOutDomain(centerX, centerY);
                    event.consume();
                    break;
                }
                if (pannable == null) break;
                if (pannable.getOrientation() == PlotOrientation.VERTICAL && pannable.isRangePannable()) {
                    chartPanel.panRange(-chartPanel.getDefaultPanFactor(), centerX, centerY);
                    event.consume();
                    break;
                }
                if (!pannable.isDomainPannable()) break;
                chartPanel.panDomain(-chartPanel.getDefaultPanFactor(), centerX, centerY);
                event.consume();
                break;
            }
            case 37: 
            case 100: 
            case 226: {
                if (event.isControlDown() && zoomable != null) {
                    if (zoomable.getOrientation() == PlotOrientation.HORIZONTAL && zoomable.isRangeZoomable()) {
                        chartPanel.zoomOutRange(centerX, centerY);
                        event.consume();
                        break;
                    }
                    if (!zoomable.isDomainZoomable()) break;
                    chartPanel.zoomOutDomain(centerX, centerY);
                    event.consume();
                    break;
                }
                if (pannable == null) break;
                if (pannable.getOrientation() == PlotOrientation.HORIZONTAL && pannable.isRangePannable()) {
                    chartPanel.panRange(-chartPanel.getDefaultPanFactor(), centerX, centerY);
                    event.consume();
                    break;
                }
                if (!pannable.isDomainPannable()) break;
                chartPanel.panDomain(-chartPanel.getDefaultPanFactor(), centerX, centerY);
                event.consume();
                break;
            }
            case 61: 
            case 107: {
                if (!event.isControlDown()) break;
                chartPanel.zoomInBoth(centerX, centerY);
                event.consume();
                break;
            }
            case 45: 
            case 109: {
                if (!event.isControlDown()) break;
                chartPanel.zoomOutBoth(centerX, centerY);
                event.consume();
                break;
            }
            case 96: {
                if (!event.isControlDown()) break;
                chartPanel.restoreAutoBounds();
                event.consume();
                break;
            }
        }
    }
}

