/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.model.types;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.escet.cif.plcgen.model.types.PlcType;
import org.eclipse.escet.common.java.Strings;

public class PlcElementaryType
extends PlcType {
    public static final PlcElementaryType BOOL_TYPE = new PlcElementaryType("BOOL", 1);
    public static final PlcElementaryType INT_TYPE = new PlcElementaryType("INT", 16);
    public static final PlcElementaryType DINT_TYPE = new PlcElementaryType("DINT", 32);
    public static final PlcElementaryType LINT_TYPE = new PlcElementaryType("LINT", 64);
    public static final PlcElementaryType REAL_TYPE = new PlcElementaryType("REAL", 32);
    public static final PlcElementaryType LREAL_TYPE = new PlcElementaryType("LREAL", 64);
    public static final PlcElementaryType TIME_TYPE = new PlcElementaryType("TIME", 0);
    public static final PlcElementaryType BYTE_TYPE = new PlcElementaryType("BYTE", 8);
    public static final PlcElementaryType WORD_TYPE = new PlcElementaryType("WORD", 16);
    public static final PlcElementaryType DWORD_TYPE = new PlcElementaryType("DWORD", 32);
    public static final PlcElementaryType LWORD_TYPE = new PlcElementaryType("LWORD", 64);
    public static final List<PlcElementaryType> INTEGER_TYPES_32 = List.of(INT_TYPE, DINT_TYPE);
    public static final List<PlcElementaryType> INTEGER_TYPES_64 = List.of(INT_TYPE, DINT_TYPE, LINT_TYPE);
    public static final List<PlcElementaryType> INTEGER_TYPES_ALL = INTEGER_TYPES_64;
    public static final List<PlcElementaryType> REAL_TYPES_32 = List.of(REAL_TYPE);
    public static final List<PlcElementaryType> REAL_TYPES_64 = List.of(REAL_TYPE, LREAL_TYPE);
    public static final List<PlcElementaryType> REAL_TYPES_ALL = REAL_TYPES_64;
    public static final List<PlcElementaryType> BIT_STRING_TYPES_32 = List.of(BOOL_TYPE, BYTE_TYPE, WORD_TYPE, DWORD_TYPE);
    public static final List<PlcElementaryType> BIT_STRING_TYPES_64 = List.of(BOOL_TYPE, BYTE_TYPE, WORD_TYPE, DWORD_TYPE, LWORD_TYPE);
    public static final List<PlcElementaryType> BIT_STRING_TYPES_ALL = BIT_STRING_TYPES_64;
    public final String name;
    public final int bitSize;

    private PlcElementaryType(String name, int bitSize) {
        this.name = name;
        this.bitSize = bitSize;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object other) {
        void elementaryType;
        if (this == other) {
            return true;
        }
        if (!(other instanceof PlcElementaryType)) {
            return false;
        }
        PlcElementaryType plcElementaryType = (PlcElementaryType)other;
        return this.name.equals(elementaryType.name);
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public String toString() {
        return "PlcElementaryType(\"" + this.name + "\")";
    }

    public static PlcElementaryType getTypeByRequiredCount(int neededCount, List<PlcElementaryType> availableTypes) {
        int neededBits = 32 - Integer.numberOfLeadingZeros(neededCount - 1);
        return PlcElementaryType.getTypeByRequiredBits(Math.max(1, neededBits), availableTypes);
    }

    public static PlcElementaryType getTypeByRequiredBits(int neededBits, List<PlcElementaryType> availableTypes) {
        int bestType = availableTypes.size() - 1;
        while (bestType > 0 && availableTypes.get((int)(bestType - 1)).bitSize >= neededBits) {
            --bestType;
        }
        PlcElementaryType result = availableTypes.get(bestType);
        if (result.bitSize < neededBits) {
            String typesText = availableTypes.stream().map(t -> t.name).collect(Collectors.joining(", "));
            String msg = Strings.fmt((String)"Requested size of %d bits cannot be resolved with the available %s types.", (Object[])new Object[]{neededBits, typesText});
            throw new AssertionError((Object)msg);
        }
        return result;
    }

    public static boolean isIntType(PlcType type) {
        return INTEGER_TYPES_ALL.contains(type);
    }

    public static boolean isRealType(PlcType type) {
        return REAL_TYPES_ALL.contains(type);
    }

    public static boolean isBitStringType(PlcType type) {
        return BIT_STRING_TYPES_ALL.contains(type);
    }
}

