/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.palette;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.SimpleRootEditPart;
import org.eclipse.gef.internal.ui.palette.PaletteSelectionTool;
import org.eclipse.gef.internal.ui.palette.editparts.DrawerEditPart;
import org.eclipse.gef.internal.ui.palette.editparts.PaletteStackEditPart;
import org.eclipse.gef.internal.ui.palette.editparts.ToolEntryEditPart;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteListener;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteStack;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.ui.palette.DefaultPaletteViewerPreferences;
import org.eclipse.gef.ui.palette.PaletteCustomizer;
import org.eclipse.gef.ui.palette.PaletteEditPartFactory;
import org.eclipse.gef.ui.palette.PaletteViewerPreferences;
import org.eclipse.gef.ui.palette.customize.PaletteCustomizerDialog;
import org.eclipse.gef.ui.palette.editparts.PaletteAnimator;
import org.eclipse.gef.ui.palette.editparts.PaletteEditPart;
import org.eclipse.gef.ui.parts.PaletteViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;

public class PaletteViewer
extends ScrollingGraphicalViewer {
    private static final PaletteViewerPreferences PREFERENCE_STORE = new DefaultPaletteViewerPreferences();
    private ToolEntry activeEntry = null;
    private PaletteCustomizer customizer = null;
    private PaletteCustomizerDialog customizerDialog = null;
    private boolean globalScrollbar = false;
    private final List<PaletteListener> paletteListeners = new ArrayList<PaletteListener>();
    private PaletteRoot paletteRoot = null;
    private final PreferenceListener prefListener = new PreferenceListener();
    private PaletteViewerPreferences prefs = PREFERENCE_STORE;
    private Font font = null;
    private PaletteAnimator paletteAnimator;

    public PaletteViewer() {
        EditDomain domain = new EditDomain();
        domain.setDefaultTool(new PaletteSelectionTool());
        domain.loadDefaultTool();
        this.setEditDomain(domain);
        this.setKeyHandler(new PaletteViewerKeyHandler(this));
        this.setEditPartFactory(new PaletteEditPartFactory());
    }

    public void addPaletteListener(PaletteListener paletteListener) {
        this.paletteListeners.add(paletteListener);
    }

    @Override
    protected void createDefaultRoot() {
        this.setRootEditPart(new SimpleRootEditPart());
    }

    private void disposeFont() {
        if (this.font != null) {
            this.font.dispose();
            this.font = null;
        }
    }

    public void enableVerticalScrollbar(boolean value) {
        this.globalScrollbar = value;
    }

    private DrawerEditPart findContainingDrawer(EditPart part) {
        if (part == null) {
            return null;
        }
        if (part instanceof DrawerEditPart) {
            DrawerEditPart dEP = (DrawerEditPart)part;
            return dEP;
        }
        return this.findContainingDrawer(part.getParent());
    }

    protected void fireModeChanged() {
        this.paletteListeners.forEach(pl -> pl.activeToolChanged(this, this.activeEntry));
    }

    public PaletteCustomizer getCustomizer() {
        return this.customizer;
    }

    public PaletteCustomizerDialog getCustomizerDialog() {
        if (this.customizerDialog == null) {
            this.customizerDialog = new PaletteCustomizerDialog(this.getControl().getShell(), this.getCustomizer(), this.getPaletteRoot());
        }
        return this.customizerDialog;
    }

    public ToolEntry getActiveTool() {
        return this.activeEntry;
    }

    public PaletteAnimator getPaletteAnimator() {
        return this.paletteAnimator;
    }

    public PaletteRoot getPaletteRoot() {
        return this.paletteRoot;
    }

    public PaletteViewerPreferences getPaletteViewerPreferences() {
        return this.prefs;
    }

    private ToolEntryEditPart getToolEntryEditPart(ToolEntry entry) {
        return (ToolEntryEditPart)this.getEditPartForModel(entry);
    }

    @Override
    protected void handleDispose(DisposeEvent e) {
        super.handleDispose(e);
        this.disposeFont();
    }

    @Override
    protected void handleFocusGained(FocusEvent fe) {
        super.handleFocusGained(fe);
        if (this.focusPart == null) {
            IFigure fig = ((GraphicalEditPart)this.getFocusEditPart()).getFigure();
            fig.internalGetEventDispatcher().requestFocus(fig);
        }
    }

    @Override
    protected void hookControl() {
        super.hookControl();
        FigureCanvas canvas = this.getFigureCanvas();
        canvas.getViewport().setContentsTracksWidth(true);
        canvas.getViewport().setContentsTracksHeight(!this.globalScrollbar);
        canvas.setHorizontalScrollBarVisibility(FigureCanvas.NEVER);
        canvas.setVerticalScrollBarVisibility(this.globalScrollbar ? FigureCanvas.ALWAYS : FigureCanvas.AUTOMATIC);
        if (this.prefs != null) {
            this.prefs.addPropertyChangeListener(this.prefListener);
        }
        this.updateFont();
    }

    public boolean isExpanded(PaletteDrawer drawer) {
        EditPart ep = this.getEditPartForModel(drawer);
        if (ep instanceof DrawerEditPart) {
            DrawerEditPart dep = (DrawerEditPart)ep;
            return dep.isExpanded();
        }
        return false;
    }

    public boolean isPinned(PaletteDrawer drawer) {
        EditPart ep = this.getEditPartForModel(drawer);
        if (ep instanceof DrawerEditPart) {
            DrawerEditPart dep = (DrawerEditPart)ep;
            return dep.isPinnedOpen();
        }
        return false;
    }

    public void removePaletteListener(PaletteListener paletteListener) {
        this.paletteListeners.remove(paletteListener);
    }

    public boolean restoreState(IMemento memento) {
        try {
            PaletteEditPart part = (PaletteEditPart)this.getEditPartForModel(this.getPaletteRoot());
            if (part != null) {
                part.restoreState(memento);
            }
        }
        catch (RuntimeException re) {
            return false;
        }
        return true;
    }

    @Override
    public void reveal(EditPart part) {
        DrawerEditPart drawer = this.findContainingDrawer(part.getParent());
        if (drawer != null && !drawer.isExpanded()) {
            drawer.setExpanded(true);
        }
        if (part.getParent() instanceof PaletteStackEditPart) {
            ((PaletteStack)part.getParent().getModel()).setActiveEntry((PaletteEntry)part.getModel());
        }
        super.reveal(part);
    }

    public void saveState(IMemento memento) {
        PaletteEditPart base = (PaletteEditPart)this.getEditPartForModel(this.getPaletteRoot());
        if (base != null) {
            base.saveState(memento);
        }
    }

    public void setCustomizer(PaletteCustomizer customizer) {
        this.customizer = customizer;
    }

    public void setActiveTool(ToolEntry newMode) {
        ToolEntryEditPart editpart;
        if (newMode == null) {
            newMode = this.getPaletteRoot().getDefaultEntry();
        }
        if (this.activeEntry != null) {
            this.getToolEntryEditPart(this.activeEntry).setToolSelected(false);
        }
        this.activeEntry = newMode;
        if (this.activeEntry != null && (editpart = this.getToolEntryEditPart(this.activeEntry)) != null) {
            editpart.setToolSelected(true);
        }
        this.fireModeChanged();
    }

    public void setPaletteAnimator(PaletteAnimator paletteAnimator) {
        this.paletteAnimator = paletteAnimator;
    }

    public void setPaletteRoot(PaletteRoot root) {
        if (root == this.paletteRoot) {
            return;
        }
        this.paletteRoot = root;
        if (this.paletteRoot != null) {
            EditPart palette = this.getEditPartFactory().createEditPart(this.getRootEditPart(), root);
            this.getRootEditPart().setContents(palette);
        }
    }

    public void setPaletteViewerPreferences(PaletteViewerPreferences prefs) {
        if (this.prefs != null) {
            this.prefs.removePropertyChangeListener(this.prefListener);
        }
        this.prefs = prefs;
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            this.prefs.addPropertyChangeListener(this.prefListener);
        }
    }

    @Override
    protected void unhookControl() {
        super.unhookControl();
        this.disposeFont();
        if (this.prefs != null) {
            this.prefs.removePropertyChangeListener(this.prefListener);
        }
    }

    private void updateFont() {
        this.disposeFont();
        if (this.getControl() == null || this.getControl().isDisposed()) {
            return;
        }
        this.font = new Font((Device)Display.getCurrent(), this.getPaletteViewerPreferences().getFontData());
        this.getControl().setFont(this.font);
        this.getFigureCanvas().getViewport().invalidateTree();
        this.getFigureCanvas().getViewport().revalidate();
        this.getFigureCanvas().redraw();
    }

    private class PreferenceListener
    implements PropertyChangeListener {
        private PreferenceListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String property = evt.getPropertyName();
            EditPart root = PaletteViewer.this.getRootEditPart().getContents();
            if (property.equals("Palette Font")) {
                PaletteViewer.this.updateFont();
                this.refreshAllEditParts(root);
            } else if (property.equals("Layout Setting") || property.equals("Auto-Collapse Setting") || property.equals(DefaultPaletteViewerPreferences.convertLayoutToPreferenceName(PaletteViewer.this.getPaletteViewerPreferences().getLayoutSetting()))) {
                this.refreshAllEditParts(root);
            }
        }

        private void refreshAllEditParts(EditPart part) {
            part.refresh();
            part.getChildren().forEach(this::refreshAllEditParts);
        }
    }
}

