/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editpolicies;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.SelectionHandlesEditPolicy;
import org.eclipse.gef.handles.BendpointCreationHandle;
import org.eclipse.gef.handles.BendpointHandle;
import org.eclipse.gef.handles.BendpointMoveHandle;
import org.eclipse.gef.requests.BendpointRequest;

public abstract class BendpointEditPolicy
extends SelectionHandlesEditPolicy
implements PropertyChangeListener {
    private static final List<Bendpoint> NULL_CONSTRAINT = new ArrayList<Bendpoint>();
    private List<Bendpoint> originalConstraint;
    private boolean isDeleting = false;
    private static final Point ref1 = new Point();
    private static final Point ref2 = new Point();

    @Override
    public void activate() {
        super.activate();
        this.getConnection().addPropertyChangeListener("points", (PropertyChangeListener)this);
    }

    private List<BendpointCreationHandle> createHandlesForAutomaticBendpoints() {
        ArrayList<BendpointCreationHandle> list = new ArrayList<BendpointCreationHandle>();
        ConnectionEditPart connEP = this.getHost();
        PointList points = this.getConnection().getPoints();
        int i = 0;
        while (i < points.size() - 1) {
            list.add(new BendpointCreationHandle(connEP, 0, i));
            ++i;
        }
        return list;
    }

    private List<BendpointHandle> createHandlesForUserBendpoints() {
        ArrayList<BendpointHandle> list = new ArrayList<BendpointHandle>();
        ConnectionEditPart connEP = this.getHost();
        PointList points = this.getConnection().getPoints();
        List<Bendpoint> bendPoints = this.getRoutingConstraint();
        int bendPointIndex = 0;
        Point currBendPoint = null;
        if (bendPoints == null) {
            bendPoints = NULL_CONSTRAINT;
        } else if (!bendPoints.isEmpty()) {
            currBendPoint = bendPoints.get(0).getLocation();
        }
        int i = 0;
        while (i < points.size() - 1) {
            list.add(new BendpointCreationHandle(connEP, bendPointIndex, i));
            if (i < points.size() - 1 && bendPointIndex < bendPoints.size() && currBendPoint.equals((Object)points.getPoint(i + 1))) {
                list.add(new BendpointMoveHandle(connEP, bendPointIndex, i + 1));
                if (++bendPointIndex < bendPoints.size()) {
                    currBendPoint = bendPoints.get(bendPointIndex).getLocation();
                }
            }
            ++i;
        }
        return list;
    }

    @Override
    protected List createSelectionHandles() {
        if (this.isAutomaticallyBending()) {
            return this.createHandlesForAutomaticBendpoints();
        }
        return this.createHandlesForUserBendpoints();
    }

    @Override
    public void deactivate() {
        this.getConnection().removePropertyChangeListener("points", (PropertyChangeListener)this);
        super.deactivate();
    }

    protected void eraseConnectionFeedback(BendpointRequest request) {
        this.restoreOriginalConstraint();
        this.originalConstraint = null;
    }

    @Override
    public void eraseSourceFeedback(Request request) {
        if ("move bendpoint".equals(request.getType()) || "create bendpoint".equals(request.getType())) {
            this.eraseConnectionFeedback((BendpointRequest)request);
        }
    }

    @Override
    public Command getCommand(Request request) {
        if ("move bendpoint".equals(request.getType())) {
            if (this.isDeleting) {
                return this.getDeleteBendpointCommand((BendpointRequest)request);
            }
            return this.getMoveBendpointCommand((BendpointRequest)request);
        }
        if ("create bendpoint".equals(request.getType())) {
            return this.getCreateBendpointCommand((BendpointRequest)request);
        }
        return null;
    }

    protected Connection getConnection() {
        return (Connection)this.getHost().getFigure();
    }

    protected abstract Command getCreateBendpointCommand(BendpointRequest var1);

    protected abstract Command getDeleteBendpointCommand(BendpointRequest var1);

    @Override
    public ConnectionEditPart getHost() {
        return (ConnectionEditPart)super.getHost();
    }

    private List<Bendpoint> getRoutingConstraint() {
        return (List)this.getConnection().getRoutingConstraint();
    }

    protected abstract Command getMoveBendpointCommand(BendpointRequest var1);

    private boolean isAutomaticallyBending() {
        List<Bendpoint> constraint = this.getRoutingConstraint();
        PointList points = this.getConnection().getPoints();
        return points.size() > 2 && (constraint == null || constraint.isEmpty());
    }

    private static boolean lineContainsPoint(Point p1, Point p2, Point p) {
        int tolerance = 7;
        Rectangle rect = Rectangle.SINGLETON;
        rect.setSize(0, 0);
        rect.setLocation(p1.x, p1.y);
        rect.union(p2.x, p2.y);
        rect.expand(tolerance, tolerance);
        if (!rect.contains(p.x, p.y)) {
            return false;
        }
        double result = 0.0;
        if (p1.x != p2.x && p1.y != p2.y) {
            int v1x = p2.x - p1.x;
            int v1y = p2.y - p1.y;
            int v2x = p.x - p1.x;
            int v2y = p.y - p1.y;
            int numerator = v2x * v1y - v1x * v2y;
            int denominator = v1x * v1x + v1y * v1y;
            result = (numerator << 10) / denominator * numerator >> 10;
        }
        return result <= (double)(tolerance * tolerance);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.getHost().getSelected() != 0) {
            this.addSelectionHandles();
        }
    }

    protected void restoreOriginalConstraint() {
        if (this.originalConstraint != null) {
            if (this.originalConstraint == NULL_CONSTRAINT) {
                this.getConnection().setRoutingConstraint(null);
            } else {
                this.getConnection().setRoutingConstraint(this.originalConstraint);
            }
        }
    }

    protected void saveOriginalConstraint() {
        this.originalConstraint = this.getRoutingConstraint();
        if (this.originalConstraint == null) {
            this.originalConstraint = NULL_CONSTRAINT;
        }
        this.getConnection().setRoutingConstraint(new ArrayList<Bendpoint>(this.originalConstraint));
    }

    private void setReferencePoints(BendpointRequest request) {
        PointList points = this.getConnection().getPoints();
        int bpIndex = -1;
        List<Bendpoint> bendPoints = this.getRoutingConstraint();
        Point bp = bendPoints.get(request.getIndex()).getLocation();
        int smallestDistance = -1;
        int i = 1;
        while (i < points.size() - 1) {
            if (smallestDistance == -1 || points.getPoint(i).getDistance2(bp) < smallestDistance) {
                bpIndex = i;
                smallestDistance = points.getPoint(i).getDistance2(bp);
                if (smallestDistance == 0) break;
            }
            ++i;
        }
        points.getPoint(ref1, bpIndex - 1);
        this.getConnection().translateToAbsolute((Translatable)ref1);
        points.getPoint(ref2, bpIndex + 1);
        this.getConnection().translateToAbsolute((Translatable)ref2);
    }

    protected void showCreateBendpointFeedback(BendpointRequest request) {
        List<Bendpoint> constraint;
        Point p = new Point(request.getLocation());
        this.getConnection().translateToRelative((Translatable)p);
        AbsoluteBendpoint bp = new AbsoluteBendpoint(p);
        if (this.originalConstraint == null) {
            this.saveOriginalConstraint();
            constraint = this.getRoutingConstraint();
            constraint.add(request.getIndex(), (Bendpoint)bp);
        } else {
            constraint = this.getRoutingConstraint();
        }
        constraint.set(request.getIndex(), (Bendpoint)bp);
        this.getConnection().setRoutingConstraint(constraint);
    }

    protected void showDeleteBendpointFeedback(BendpointRequest request) {
        if (this.originalConstraint == null) {
            this.saveOriginalConstraint();
            List<Bendpoint> constraint = this.getRoutingConstraint();
            constraint.remove(request.getIndex());
            this.getConnection().setRoutingConstraint(constraint);
        }
    }

    protected void showMoveBendpointFeedback(BendpointRequest request) {
        Point p = new Point(request.getLocation());
        if (!this.isDeleting) {
            this.setReferencePoints(request);
        }
        if (BendpointEditPolicy.lineContainsPoint(ref1, ref2, p)) {
            if (!this.isDeleting) {
                this.isDeleting = true;
                this.eraseSourceFeedback(request);
                this.showDeleteBendpointFeedback(request);
            }
            return;
        }
        if (this.isDeleting) {
            this.isDeleting = false;
            this.eraseSourceFeedback(request);
        }
        if (this.originalConstraint == null) {
            this.saveOriginalConstraint();
        }
        List<Bendpoint> constraint = this.getRoutingConstraint();
        this.getConnection().translateToRelative((Translatable)p);
        AbsoluteBendpoint bp = new AbsoluteBendpoint(p);
        constraint.set(request.getIndex(), (Bendpoint)bp);
        this.getConnection().setRoutingConstraint(constraint);
    }

    @Override
    public void showSourceFeedback(Request request) {
        if ("move bendpoint".equals(request.getType())) {
            this.showMoveBendpointFeedback((BendpointRequest)request);
        } else if ("create bendpoint".equals(request.getType())) {
            this.showCreateBendpointFeedback((BendpointRequest)request);
        }
    }
}

