/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.util;

import java.util.Iterator;
import java.util.function.Function;
import org.eclipse.lsat.common.util.AppendableIterator;
import org.eclipse.lsat.common.util.BranchIterator;
import org.eclipse.lsat.common.util.IteratorUtil;
import org.eclipse.lsat.common.util.UniqueIterator;

public class ClosureIteratorMany<E>
extends UniqueIterator<E>
implements BranchIterator<E> {
    private final AppendableIterator<E> closureCandidates;
    boolean canPrune = false;

    public ClosureIteratorMany(Iterator<? extends E> iterator, Function<E, Iterator<? extends E>> functor) {
        this(new AppendableIterator<E>(iterator), functor);
    }

    private ClosureIteratorMany(AppendableIterator<E> closureCandidates, Function<E, Iterator<? extends E>> functor) {
        super(IteratorUtil.flatten(IteratorUtil.notNull(IteratorUtil.map(closureCandidates, functor))));
        this.closureCandidates = closureCandidates;
    }

    @Override
    public E next() {
        Object next = super.next();
        if (this.closureCandidates.append(next)) {
            this.canPrune = true;
        }
        return next;
    }

    @Override
    public void prune() {
        if (!this.canPrune) {
            throw new IllegalStateException("Prune is not allowed");
        }
        this.closureCandidates.undoAppend();
        this.canPrune = false;
    }
}

