/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format.experimental;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.TextEdit;
import org.junit.jupiter.api.Test;

public class XMLFormatterExperimentalIndentTest
extends AbstractCacheBasedTest {
    @Test
    public void startWithSpaces() throws BadLocationException {
        String content = "\r\n       <a></a>";
        String expected = "<a></a>";
        XMLFormatterExperimentalIndentTest.assertFormat(content, expected, XMLAssert.te(0, 0, 1, 7, ""));
        XMLFormatterExperimentalIndentTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void oneElementsInSameLine() throws BadLocationException {
        String content;
        String expected = content = "<a></a>";
        XMLFormatterExperimentalIndentTest.assertFormat(content, expected, new TextEdit[0]);
        expected = content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<a></a>";
        XMLFormatterExperimentalIndentTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Test
    public void oneElementsInDifferentLine() throws BadLocationException {
        String content = "<a>\r\n</a>";
        String expected = "<a> </a>";
        XMLFormatterExperimentalIndentTest.assertFormat(content, expected, XMLAssert.te(0, 3, 1, 0, " "));
        XMLFormatterExperimentalIndentTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void oneElementsInDifferentLineWithSpace() throws BadLocationException {
        String content = "<a>\r\n  </a>";
        String expected = "<a> </a>";
        XMLFormatterExperimentalIndentTest.assertFormat(content, expected, XMLAssert.te(0, 3, 1, 2, " "));
        XMLFormatterExperimentalIndentTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void twoElementsInSameLine() throws BadLocationException {
        String content = "<a><b></b></a>";
        String expected = "<a>" + System.lineSeparator() + "  <b></b>" + System.lineSeparator() + "</a>";
        XMLFormatterExperimentalIndentTest.assertFormat(content, expected, XMLAssert.te(0, 3, 0, 3, System.lineSeparator() + "  "), XMLAssert.te(0, 10, 0, 10, System.lineSeparator()));
        XMLFormatterExperimentalIndentTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void textSpaces() throws BadLocationException {
        String content = "<a>b  c</a>";
        String expected = "<a>b c</a>";
        XMLFormatterExperimentalIndentTest.assertFormat(content, expected, XMLAssert.te(0, 4, 0, 6, " "));
        XMLFormatterExperimentalIndentTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void mixedContent() throws BadLocationException {
        String content = "<a><b>B</b></a>";
        String expected = "<a>" + System.lineSeparator() + "  <b>B</b>" + System.lineSeparator() + "</a>";
        XMLFormatterExperimentalIndentTest.assertFormat(content, expected, XMLAssert.te(0, 3, 0, 3, System.lineSeparator() + "  "), XMLAssert.te(0, 11, 0, 11, System.lineSeparator()));
        XMLFormatterExperimentalIndentTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void mixedContentWithTabs4Spaces() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setInsertSpaces(true);
        settings.getFormattingSettings().setTabSize(4);
        String content = "<a><b>B</b></a>";
        String expected = "<a>" + System.lineSeparator() + "    <b>B</b>" + System.lineSeparator() + "</a>";
        XMLFormatterExperimentalIndentTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 0, 3, System.lineSeparator() + "    "), XMLAssert.te(0, 11, 0, 11, System.lineSeparator()));
        XMLFormatterExperimentalIndentTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void mixedContentWithTabs() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setInsertSpaces(false);
        String content = "<a><b>B</b></a>";
        String expected = "<a>" + System.lineSeparator() + "\t<b>B</b>" + System.lineSeparator() + "</a>";
        XMLFormatterExperimentalIndentTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 0, 3, System.lineSeparator() + "\t"), XMLAssert.te(0, 11, 0, 11, System.lineSeparator()));
        XMLFormatterExperimentalIndentTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void multipleRootNestedIssue634() throws BadLocationException {
        String content = "<parent>\r\n  <child>\r\n    test\r\n  </child>\r\n</parent><parent>\r\n  <child>\r\n    test\r\n  </child>\r\n</parent>";
        String expected = "<parent>\r\n  <child> test </child>\r\n</parent>\r\n<parent>\r\n  <child> test </child>\r\n</parent>";
        XMLFormatterExperimentalIndentTest.assertFormat(content, expected, XMLAssert.te(1, 9, 2, 4, " "), XMLAssert.te(2, 8, 3, 2, " "), XMLAssert.te(4, 9, 4, 9, "\r\n"), XMLAssert.te(5, 9, 6, 4, " "), XMLAssert.te(6, 8, 7, 2, " "));
        XMLFormatterExperimentalIndentTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void multipleRootEmptyIssue634() throws BadLocationException {
        String content;
        String expected = content = "<foo />\r\n<bar />\r\n<fizz />\r\n<buzz />";
        XMLFormatterExperimentalIndentTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Test
    public void mixedContent2() throws BadLocationException {
        String content;
        String expected = content = "<a>A<b>B</b></a>";
        XMLFormatterExperimentalIndentTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Test
    public void multipleLineContentIssue600JoinContentLinesTrue() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setJoinContentLines(true);
        String content = "<a>\r\n  <b>\r\n    foo\r\n    bar\r\n  </b>\r\n</a>";
        String expected = "<a>\r\n  <b> foo bar </b>\r\n</a>";
        XMLFormatterExperimentalIndentTest.assertFormat(content, expected, settings, XMLAssert.te(1, 5, 2, 4, " "), XMLAssert.te(2, 7, 3, 4, " "), XMLAssert.te(3, 7, 4, 2, " "));
        XMLFormatterExperimentalIndentTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void multipleLineContentIssue600JoinContentLinesFalse() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setJoinContentLines(false);
        String content = "<a>\r\n  <b>\r\n    foo\r\n    bar\r\n  </b>\r\n</a>";
        String expected = "<a>\r\n  <b> foo\r\n    bar </b>\r\n</a>";
        XMLFormatterExperimentalIndentTest.assertFormat(content, expected, settings, XMLAssert.te(1, 5, 2, 4, " "), XMLAssert.te(3, 7, 4, 2, " "));
        XMLFormatterExperimentalIndentTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void multipleLineContentIssue600PreserveSpaces() throws BadLocationException {
        String content;
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveEmptyContent(true);
        String expected = content = "<a>\r\n  <b>\r\n    foo\r\n    bar\r\n  </b>\r\n</a>";
        XMLFormatterExperimentalIndentTest.assertFormat(content, expected, settings, new TextEdit[0]);
    }

    @Test
    public void xsDocumentationTextContentIssue662JoinContentTrue() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setJoinContentLines(true);
        String content = "<xs:schema attributeFormDefault=\"unqualified\" elementFormDefault=\"unqualified\">\r\n  <xs:complexType name=\"myType\">\r\n    <xs:annotation>\r\n           <xs:documentation>\r\n    Content that spans\r\n    multiple lines.\r\n</xs:documentation>\r\n           </xs:annotation>\r\n           </xs:complexType>\r\n</xs:schema>";
        String expected = "<xs:schema attributeFormDefault=\"unqualified\" elementFormDefault=\"unqualified\">\r\n  <xs:complexType name=\"myType\">\r\n    <xs:annotation>\r\n      <xs:documentation> Content that spans multiple lines. </xs:documentation>\r\n    </xs:annotation>\r\n  </xs:complexType>\r\n</xs:schema>";
        XMLFormatterExperimentalIndentTest.assertFormat(content, expected, settings, XMLAssert.te(2, 19, 3, 11, "\r\n      "), XMLAssert.te(3, 29, 4, 4, " "), XMLAssert.te(4, 22, 5, 4, " "), XMLAssert.te(5, 19, 6, 0, " "), XMLAssert.te(6, 19, 7, 11, "\r\n    "), XMLAssert.te(7, 27, 8, 11, "\r\n  "));
        XMLFormatterExperimentalIndentTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void xsDocumentationTextContentIssue662JoinContentFalse() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        String content = "<xs:schema attributeFormDefault=\"unqualified\" elementFormDefault=\"unqualified\">\r\n  <xs:complexType name=\"myType\">\r\n    <xs:annotation>\r\n           <xs:documentation>\r\n    Content that spans\r\n    multiple lines.\r\n</xs:documentation>\r\n           </xs:annotation>\r\n           </xs:complexType>\r\n</xs:schema>";
        String expected = "<xs:schema attributeFormDefault=\"unqualified\" elementFormDefault=\"unqualified\">\r\n  <xs:complexType name=\"myType\">\r\n    <xs:annotation>\r\n      <xs:documentation> Content that spans\r\n    multiple lines. </xs:documentation>\r\n    </xs:annotation>\r\n  </xs:complexType>\r\n</xs:schema>";
        XMLFormatterExperimentalIndentTest.assertFormat(content, expected, settings, XMLAssert.te(2, 19, 3, 11, "\r\n      "), XMLAssert.te(3, 29, 4, 4, " "), XMLAssert.te(5, 19, 6, 0, " "), XMLAssert.te(6, 19, 7, 11, "\r\n    "), XMLAssert.te(7, 27, 8, 11, "\r\n  "));
        XMLFormatterExperimentalIndentTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void xsDocumentationTextContentIssue662Preserve() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        String content = "<xs:schema attributeFormDefault=\"unqualified\" elementFormDefault=\"unqualified\">\r\n  <xs:complexType name=\"myType\">\r\n    <xs:annotation>\r\n           <xs:documentation xml:space=\"preserve\">\r\n    Content that spans\r\n    multiple lines.\r\n</xs:documentation>\r\n           </xs:annotation>\r\n           </xs:complexType>\r\n</xs:schema>";
        String expected = "<xs:schema attributeFormDefault=\"unqualified\" elementFormDefault=\"unqualified\">\r\n  <xs:complexType name=\"myType\">\r\n    <xs:annotation>\r\n      <xs:documentation xml:space=\"preserve\">\r\n    Content that spans\r\n    multiple lines.\r\n</xs:documentation>\r\n    </xs:annotation>\r\n  </xs:complexType>\r\n</xs:schema>";
        XMLFormatterExperimentalIndentTest.assertFormat(content, expected, settings, XMLAssert.te(2, 19, 3, 11, "\r\n      "), XMLAssert.te(6, 19, 7, 11, "\r\n    "), XMLAssert.te(7, 27, 8, 11, "\r\n  "));
        XMLFormatterExperimentalIndentTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    private static void assertFormat(String unformatted, String actual, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterExperimentalIndentTest.assertFormat(unformatted, actual, new SharedSettings(), expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterExperimentalIndentTest.assertFormat(unformatted, expected, sharedSettings, "test://test.html", expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterExperimentalIndentTest.assertFormat(unformatted, expected, sharedSettings, uri, true, expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, Boolean considerRangeFormat, TextEdit ... expectedEdits) throws BadLocationException {
        sharedSettings.getFormattingSettings().setExperimental(true);
        XMLAssert.assertFormat(null, unformatted, expected, sharedSettings, uri, considerRangeFormat, expectedEdits);
    }
}

