/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.uriresolver;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.eclipse.lemminx.uriresolver.CacheResourceDownloadedException;
import org.eclipse.lemminx.uriresolver.CacheResourcesManager;
import org.eclipse.lemminx.uriresolver.URIResolverExtension;

public class XMLCacheResolverExtension
implements URIResolverExtension {
    private final CacheResourcesManager cacheResourcesManager = new CacheResourcesManager();

    @Override
    public String resolve(String baseLocation, String publicId, String systemId) {
        return null;
    }

    @Override
    public XMLInputSource resolveEntity(XMLResourceIdentifier resourceIdentifier) throws XNIException, IOException {
        String url = resourceIdentifier.getExpandedSystemId();
        Path file = this.getCachedResource(url);
        if (file != null) {
            XMLInputSource source = new XMLInputSource(resourceIdentifier);
            source.setByteStream(Files.newInputStream(file, new OpenOption[0]));
            return source;
        }
        return null;
    }

    public Path getCachedResource(String url) throws IOException, CacheResourceDownloadedException {
        if (this.cacheResourcesManager.canUseCache(url)) {
            return this.cacheResourcesManager.getResource(url);
        }
        return null;
    }

    public void setUseCache(boolean useCache) {
        this.cacheResourcesManager.setUseCache(useCache);
    }

    public boolean isUseCache() {
        return this.cacheResourcesManager.isUseCache();
    }
}

