/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.net;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.net.IP4Address;
import org.eclipse.kura.net.NetConfig4;
import org.eclipse.kura.net.NetConfigIP;
import org.eclipse.kura.net.NetInterfaceStatus;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class NetConfigIP4
extends NetConfigIP<IP4Address>
implements NetConfig4 {
    private List<IP4Address> winsServers = new ArrayList<IP4Address>();

    public NetConfigIP4(NetInterfaceStatus status, boolean autoConnect) {
        super(status, autoConnect);
    }

    public NetConfigIP4(NetInterfaceStatus status, boolean autoConnect, boolean dhcp) {
        super(status, autoConnect, dhcp);
    }

    public NetConfigIP4(NetInterfaceStatus status, boolean autoConnect, IP4Address address, short networkPrefixLength, IP4Address gateway) throws KuraException {
        super(status, autoConnect, address, networkPrefixLength, gateway);
    }

    public NetConfigIP4(NetInterfaceStatus status, boolean autoConnect, IP4Address address, IP4Address subnetMask, IP4Address gateway) throws KuraException {
        super(status, autoConnect, address, subnetMask, gateway);
    }

    public List<IP4Address> getWinsServers() {
        if (this.winsServers != null) {
            return Collections.unmodifiableList(this.winsServers);
        }
        return null;
    }

    public void setWinsServers(List<IP4Address> winsServers) {
        this.winsServers = winsServers;
    }

    @Override
    public boolean isValid() {
        return super.isValid();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("NetConfigIP4 [winsServers=");
        builder.append(this.winsServers);
        builder.append(", super.toString()=");
        builder.append(super.toString());
        builder.append("]");
        return builder.toString();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.winsServers == null ? 0 : this.winsServers.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NetConfigIP4 other = (NetConfigIP4)obj;
        return !(this.winsServers == null ? other.winsServers != null : !this.winsServers.equals(other.winsServers));
    }
}

