/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.status.runnables;

import org.eclipse.kura.KuraException;
import org.eclipse.kura.core.status.LedManager;
import org.eclipse.kura.core.status.runnables.StatusRunnable;

public class OnOffStatusRunnable
implements StatusRunnable {
    private final LedManager ledManager;
    private boolean ledEnabled = false;
    private boolean enabled;

    public OnOffStatusRunnable(LedManager ledManager, boolean ledEnabled) {
        this.ledManager = ledManager;
        this.ledEnabled = ledEnabled;
        this.enabled = true;
    }

    @Override
    public void run() {
        while (this.enabled) {
            try {
                this.ledManager.writeLed(this.ledEnabled);
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                this.enabled = false;
            }
            catch (KuraException kuraException) {
                this.enabled = false;
            }
        }
    }

    @Override
    public void stopRunnable() {
        this.enabled = false;
    }
}

