/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.ble;

import com.github.hypfvieh.bluetooth.DeviceManager;
import com.github.hypfvieh.bluetooth.DiscoveryTransport;
import com.github.hypfvieh.bluetooth.wrapper.BluetoothAdapter;
import com.github.hypfvieh.bluetooth.wrapper.BluetoothDevice;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.kura.KuraBluetoothDiscoveryException;
import org.eclipse.kura.KuraBluetoothRemoveException;
import org.eclipse.kura.bluetooth.le.BluetoothLeAdapter;
import org.eclipse.kura.bluetooth.le.BluetoothLeDevice;
import org.eclipse.kura.bluetooth.le.BluetoothTransportType;
import org.eclipse.kura.internal.ble.BluetoothLeDeviceImpl;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.types.UInt16;
import org.freedesktop.dbus.types.Variant;

public class BluetoothLeAdapterImpl
implements BluetoothLeAdapter {
    private static final Logger logger = LogManager.getLogger(BluetoothLeAdapterImpl.class);
    private static final String STOP_DISCOVERY_FAILED = "Stop discovery failed";
    private static final String START_DISCOVERY_FAILED = "Start discovery failed";
    private final BluetoothAdapter adapter;

    public BluetoothLeAdapterImpl(BluetoothAdapter adapter) {
        this.adapter = adapter;
    }

    public String getAddress() {
        return this.adapter.getAddress();
    }

    public String getName() {
        return this.adapter.getName();
    }

    public String getInterfaceName() {
        return this.adapter.getDeviceName();
    }

    public String getModalias() {
        return this.adapter.getModAlias();
    }

    public String getAlias() {
        return this.adapter.getAlias();
    }

    public void setAlias(String value) {
        this.adapter.setAlias(value);
    }

    public long getBluetoothClass() {
        Integer deviceClass = this.adapter.getDeviceClass();
        return deviceClass == null ? -1 : deviceClass;
    }

    public boolean isPowered() {
        return this.adapter.isPowered();
    }

    public void setPowered(boolean value) {
        this.adapter.setPowered(value);
    }

    public boolean isDiscoverable() {
        Boolean discoverable = this.adapter.isDiscoverable();
        if (discoverable != null) {
            return discoverable;
        }
        return false;
    }

    public void setDiscoverable(boolean value) {
        this.adapter.setDiscoverable(value);
    }

    public long getDiscoverableTimeout() {
        Integer timeout = this.adapter.getDiscoverableTimeout();
        return timeout == null ? -1 : timeout;
    }

    public void setDiscoverableTimout(long value) {
        this.setDiscoverableTimeout(value);
    }

    public void setDiscoverableTimeout(long value) {
        this.adapter.setDiscoverableTimeout(Integer.valueOf((int)value));
    }

    public boolean isPairable() {
        Boolean pairable = this.adapter.isPairable();
        if (pairable != null) {
            return pairable;
        }
        return false;
    }

    public void setPairable(boolean value) {
        this.adapter.setPairable(value);
    }

    public long getPairableTimeout() {
        Integer timeout = this.adapter.getPairableTimeout();
        return timeout == null ? -1 : timeout;
    }

    public void setPairableTimeout(long value) {
        this.adapter.setPairableTimeout(Integer.valueOf((int)value));
    }

    public boolean isDiscovering() {
        return this.adapter.isDiscovering();
    }

    public UUID[] getUUIDs() {
        ArrayList<UUID> uuidList = new ArrayList<UUID>();
        String[] strUuids = this.adapter.getUuids();
        if (strUuids != null) {
            String[] stringArray = strUuids;
            int n = strUuids.length;
            int n2 = 0;
            while (n2 < n) {
                String uuid = stringArray[n2];
                uuidList.add(UUID.fromString(uuid));
                ++n2;
            }
        }
        UUID[] uuids = new UUID[uuidList.size()];
        return uuidList.toArray(uuids);
    }

    public void startDiscovery() throws KuraBluetoothDiscoveryException {
        try {
            if (!this.adapter.startDiscovery()) {
                throw new KuraBluetoothDiscoveryException((Object)START_DISCOVERY_FAILED);
            }
        }
        catch (DBusExecutionException dBusExecutionException) {
            throw new KuraBluetoothDiscoveryException((Object)START_DISCOVERY_FAILED);
        }
    }

    public void stopDiscovery() throws KuraBluetoothDiscoveryException {
        try {
            if (!this.adapter.stopDiscovery()) {
                throw new KuraBluetoothDiscoveryException((Object)STOP_DISCOVERY_FAILED);
            }
        }
        catch (DBusExecutionException dBusExecutionException) {
            throw new KuraBluetoothDiscoveryException((Object)STOP_DISCOVERY_FAILED);
        }
    }

    public Future<BluetoothLeDevice> findDeviceByAddress(long timeout, String address) {
        return new BluetoothFuture<BluetoothLeDevice>(timeout, null, address);
    }

    public Future<BluetoothLeDevice> findDeviceByName(long timeout, String name) {
        return new BluetoothFuture<BluetoothLeDevice>(timeout, name, null);
    }

    public void findDeviceByAddress(long timeout, String address, Consumer<BluetoothLeDevice> consumer) {
        BluetoothFuture<BluetoothLeDevice> future = new BluetoothFuture<BluetoothLeDevice>(timeout, null, address);
        future.setConsumer(consumer);
    }

    public void findDeviceByName(long timeout, String name, Consumer<BluetoothLeDevice> consumer) {
        BluetoothFuture<BluetoothLeDevice> future = new BluetoothFuture<BluetoothLeDevice>(timeout, name, null);
        future.setConsumer(consumer);
    }

    public Future<List<BluetoothLeDevice>> findDevices(long timeout) {
        return new BluetoothFuture<List<BluetoothLeDevice>>(timeout);
    }

    public void findDevices(long timeout, Consumer<List<BluetoothLeDevice>> consumer) {
        BluetoothFuture<List<BluetoothLeDevice>> future = new BluetoothFuture<List<BluetoothLeDevice>>(timeout, null, null);
        future.setConsumer(consumer);
    }

    public int removeDevices() throws KuraBluetoothRemoveException {
        int removedDevices = 0;
        try {
            List devices = this.getDeviceManager().getDevices(this.adapter.getAddress(), true);
            for (BluetoothDevice device : devices) {
                this.adapter.removeDevice(device.getRawDevice());
                ++removedDevices;
            }
        }
        catch (DBusException e) {
            throw new KuraBluetoothRemoveException((Throwable)e, (Object)"Failed to remove devices");
        }
        return removedDevices;
    }

    public void setDiscoveryFilter(List<UUID> uuids, int rssi, int pathloss, BluetoothTransportType transportType) {
        this.setDiscoveryFilter(uuids, rssi, pathloss, transportType, false);
    }

    public void setDiscoveryFilter(List<UUID> uuids, int rssi, int pathloss, BluetoothTransportType transportType, boolean duplicateData) {
        LinkedHashMap<String, Variant> filter = new LinkedHashMap<String, Variant>();
        if (uuids != null && !uuids.isEmpty()) {
            String[] strUuids = new String[uuids.size()];
            int i = 0;
            while (i < uuids.size()) {
                strUuids[i] = uuids.get(i).toString();
                ++i;
            }
            filter.put("UUIDs", new Variant((Object)strUuids));
        }
        if (rssi != 0) {
            filter.put("RSSI", new Variant((Object)((short)rssi)));
        } else if (pathloss != 0) {
            filter.put("Pathloss", new Variant((Object)new UInt16(pathloss)));
        }
        filter.put("Transport", new Variant((Object)this.toDiscoveryTransport(transportType).toString()));
        filter.put("DuplicateData", new Variant((Object)duplicateData));
        try {
            this.adapter.setDiscoveryFilter(filter);
        }
        catch (DBusException | DBusExecutionException e) {
            logger.error("Failed to set discovery filter", e);
        }
    }

    public void setRssiDiscoveryFilter(int rssi) {
        this.setDiscoveryFilter(null, rssi, 0, BluetoothTransportType.AUTO, false);
    }

    private DiscoveryTransport toDiscoveryTransport(BluetoothTransportType type) {
        switch (type) {
            case AUTO: {
                return DiscoveryTransport.AUTO;
            }
            case BREDR: {
                return DiscoveryTransport.BREDR;
            }
            case LE: {
                return DiscoveryTransport.LE;
            }
        }
        return DiscoveryTransport.AUTO;
    }

    public DeviceManager getDeviceManager() {
        return DeviceManager.getInstance();
    }

    public class BluetoothFuture<T>
    extends CompletableFuture<T>
    implements Runnable {
        private final long internalTimeout;
        private String name;
        private String address;
        private Consumer<T> consumer;

        public BluetoothFuture(long timeout) {
            this.internalTimeout = timeout * 1000L;
            new Thread(this).start();
        }

        public BluetoothFuture(long timeout, String name, String address) {
            this.internalTimeout = timeout * 1000L;
            this.name = name;
            this.address = address;
            new Thread(this).start();
        }

        public void setConsumer(Consumer<T> consumer) {
            this.consumer = consumer;
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            logger.info("The timeout value provided by get(...) method will be ignored");
            return this.get();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            try {
                if (!BluetoothLeAdapterImpl.this.adapter.stopDiscovery()) {
                    logger.error(BluetoothLeAdapterImpl.STOP_DISCOVERY_FAILED);
                    return false;
                }
            }
            catch (DBusExecutionException ex) {
                logger.error(BluetoothLeAdapterImpl.STOP_DISCOVERY_FAILED, (Throwable)ex);
                return false;
            }
            return super.cancel(mayInterruptIfRunning);
        }

        @Override
        public void run() {
            if (BluetoothLeAdapterImpl.this.isDiscovering()) {
                this.completeExceptionally(new KuraBluetoothDiscoveryException((Object)"The BLE adapter is already discovering..."));
            }
            try {
                if (!BluetoothLeAdapterImpl.this.adapter.startDiscovery()) {
                    logger.error(BluetoothLeAdapterImpl.START_DISCOVERY_FAILED);
                }
            }
            catch (DBusExecutionException ex) {
                logger.error(BluetoothLeAdapterImpl.START_DISCOVERY_FAILED, (Throwable)ex);
            }
            this.waitForStop();
            List devices = BluetoothLeAdapterImpl.this.getDeviceManager().getDevices(BluetoothLeAdapterImpl.this.adapter.getAddress(), true);
            if (devices.isEmpty()) {
                this.complete(null);
            }
            if (this.name != null || this.address != null) {
                this.getDevice(devices);
            } else {
                ArrayList<BluetoothLeDeviceImpl> leDevices = new ArrayList<BluetoothLeDeviceImpl>();
                for (BluetoothDevice device : devices) {
                    leDevices.add(new BluetoothLeDeviceImpl(device));
                }
                this.complete(leDevices);
                if (this.consumer != null) {
                    this.consumer.accept(leDevices);
                }
            }
            try {
                if (!BluetoothLeAdapterImpl.this.adapter.stopDiscovery()) {
                    logger.error(BluetoothLeAdapterImpl.STOP_DISCOVERY_FAILED);
                }
            }
            catch (DBusExecutionException ex) {
                logger.error(BluetoothLeAdapterImpl.STOP_DISCOVERY_FAILED, (Throwable)ex);
            }
        }

        private void getDevice(List<BluetoothDevice> devices) {
            BluetoothDevice leDevice = null;
            for (BluetoothDevice device : devices) {
                if ((this.address == null || !device.getAddress().equals(this.address)) && (this.name == null || !device.getName().equals(this.name))) continue;
                leDevice = device;
                break;
            }
            if (leDevice == null) {
                this.complete(null);
            } else {
                this.complete(new BluetoothLeDeviceImpl(leDevice));
            }
            if (leDevice != null && this.consumer != null) {
                this.consumer.accept(new BluetoothLeDeviceImpl(leDevice));
            }
        }

        private void waitForStop() {
            long start = System.currentTimeMillis();
            while (System.currentTimeMillis() - start <= this.internalTimeout) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.completeExceptionally(e);
                }
            }
        }
    }
}

