/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.session;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public interface SecurityHandler {
    public boolean handleSecurity(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    default public SecurityHandler onFailure(FailureHandler handler) {
        SecurityHandler self = this;
        return (req, res) -> {
            boolean authorized;
            try {
                authorized = self.handleSecurity(req, res);
            }
            catch (Exception exception) {
                authorized = false;
            }
            if (!authorized) {
                handler.onFailure(req, res);
            }
            return authorized;
        };
    }

    default public SecurityHandler redirectOnFailure(String location) {
        return this.onFailure((req, res) -> res.sendRedirect(location));
    }

    default public SecurityHandler sendErrorOnFailure(int status) {
        return this.onFailure((req, res) -> res.sendError(status));
    }

    public static SecurityHandler chain(SecurityHandler ... handlers) {
        return (req, res) -> {
            SecurityHandler[] securityHandlerArray2 = handlers;
            int n = handlers.length;
            int n2 = 0;
            while (n2 < n) {
                SecurityHandler handler = securityHandlerArray2[n2];
                if (!handler.handleSecurity(req, res)) {
                    return false;
                }
                ++n2;
            }
            return true;
        };
    }

    public static interface FailureHandler {
        public void onFailure(HttpServletRequest var1, HttpServletResponse var2) throws IOException;
    }
}

