/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.pdt.docgen.wizard.pages;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.polarsys.kitalpha.pdt.docgen.wizard.general.HTMLDocGenContext;
import org.polarsys.kitalpha.pdt.docgen.wizard.pages.Messages;

public class HTMLDocGenWizardFirstPage
extends WizardPage
implements Listener {
    private IFile selection;
    private Composite container;
    private Button currentFolderGenerationRadioButton;
    private Button specifiedFolderGenerationRadioButton;
    private Button digramsInclusionRadioButton;
    private Button relatedModelGenerationRadioButton;
    private Button browseButton;
    private Text folderPath;
    private SelectionDialog dialog;
    private HTMLDocGenContext context = HTMLDocGenContext.INSTANCE;

    public HTMLDocGenWizardFirstPage(IFile selectedFile) {
        this(selectedFile.getName());
        this.selection = selectedFile;
    }

    public boolean specifiedRepositoryIsChecked() {
        return this.specifiedFolderGenerationRadioButton.getSelection();
    }

    protected HTMLDocGenWizardFirstPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.PageTitle);
        this.setDescription(Messages.PageDescription);
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 4);
        GridLayout compositeLayout = new GridLayout();
        this.container.setLayout((Layout)compositeLayout);
        this.addSpecsGroup();
        this.addResultsGroup();
        this.setControl((Control)this.container);
        this.handleEvent(null);
    }

    private void addResultsGroup() {
        Group HTMLResultsGroup = new Group(this.container, 4);
        HTMLResultsGroup.setText(Messages.ResultsGroup);
        HTMLResultsGroup.setLayoutData((Object)new GridData(1808));
        GridLayout specLayout = new GridLayout();
        specLayout.numColumns = 1;
        HTMLResultsGroup.setLayout((Layout)specLayout);
        this.digramsInclusionRadioButton = new Button((Composite)HTMLResultsGroup, 32);
        this.digramsInclusionRadioButton.setText(Messages.ResultsDiagramsInclusionsRadioButton);
        this.digramsInclusionRadioButton.setSelection(true);
        this.digramsInclusionRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button btn = (Button)event.getSource();
                boolean buttonSelection = btn.getSelection();
                HTMLDocGenWizardFirstPage.this.context.setDiagramsInclusion(buttonSelection);
            }
        });
        this.relatedModelGenerationRadioButton = new Button((Composite)HTMLResultsGroup, 32);
        this.relatedModelGenerationRadioButton.setText(Messages.ResultsGenerationOfRelatedModelsRadioButton);
        this.relatedModelGenerationRadioButton.setSelection(false);
        this.relatedModelGenerationRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button btn = (Button)event.getSource();
                boolean buttonSelection = btn.getSelection();
                HTMLDocGenWizardFirstPage.this.context.setDiagramsGeneration(buttonSelection);
            }
        });
    }

    private void addSpecsGroup() {
        Group HTMLSpecGroup = new Group(this.container, 4);
        HTMLSpecGroup.setText(Messages.SpecificationsGroupLabel);
        HTMLSpecGroup.setLayoutData((Object)new GridData(1808));
        GridLayout specLayout = new GridLayout();
        specLayout.numColumns = 1;
        HTMLSpecGroup.setLayout((Layout)specLayout);
        this.currentFolderGenerationRadioButton = new Button((Composite)HTMLSpecGroup, 16);
        this.currentFolderGenerationRadioButton.setText(Messages.SpecificationsCurrentFolderRadioButtonLabel);
        this.currentFolderGenerationRadioButton.setToolTipText(Messages.SpecificationsCurrentFolderRadioButtonTooltip);
        this.currentFolderGenerationRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button btn = (Button)event.getSource();
                boolean buttonSelection = btn.getSelection();
                HTMLDocGenWizardFirstPage.this.context.setRepoSpecification(buttonSelection);
                HTMLDocGenWizardFirstPage.this.browseButton.setEnabled(!buttonSelection);
                HTMLDocGenWizardFirstPage.this.folderPath.setEnabled(!buttonSelection);
            }
        });
        this.specifiedFolderGenerationRadioButton = new Button((Composite)HTMLSpecGroup, 16);
        this.specifiedFolderGenerationRadioButton.setText(Messages.SpecificationsSpecifiedRadioButtonLabel);
        this.specifiedFolderGenerationRadioButton.setToolTipText(Messages.SpecificationsSpecifiedRadioButtonTooltip);
        this.specifiedFolderGenerationRadioButton.addListener(13, (Listener)this);
        Group pathSpecification = new Group((Composite)HTMLSpecGroup, 4);
        pathSpecification.setText("Path");
        GridLayout pathSpecGroupLayout = new GridLayout();
        pathSpecGroupLayout.numColumns = 2;
        pathSpecification.setLayout((Layout)pathSpecGroupLayout);
        this.folderPath = new Text((Composite)pathSpecification, 2052);
        this.folderPath.setLayoutData((Object)new GridData(768));
        this.selection.getLocationURI();
        IPath path = this.selection.getProjectRelativePath();
        String projectName = this.selection.getProject().getName();
        this.folderPath.setText(String.valueOf(projectName) + "/" + path.removeLastSegments(1));
        this.folderPath.addListener(2, (Listener)this);
        this.browseButton = new Button((Composite)pathSpecification, 8);
        this.browseButton.setText("Browse...");
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                HTMLDocGenWizardFirstPage.this.dialog = (SelectionDialog)new ContainerSelectionDialog(HTMLDocGenWizardFirstPage.this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), true, "Folder Path Specification");
                HTMLDocGenWizardFirstPage.this.dialog.open();
                Object[] result = HTMLDocGenWizardFirstPage.this.dialog.getResult();
                String dir = result[0].toString();
                if (dir != null) {
                    HTMLDocGenWizardFirstPage.this.folderPath.setText(dir);
                    HTMLDocGenWizardFirstPage.this.folderPath.setLayoutData((Object)new GridData(768));
                    String projectNameTemp = dir.replaceFirst("/", "");
                    String[] projectName = projectNameTemp.split("/");
                    HTMLDocGenWizardFirstPage.this.context.setProjectName(projectName[0]);
                    String outputFolderPath = projectNameTemp.substring(projectName[0].length());
                    HTMLDocGenWizardFirstPage.this.context.setOutputFolderName(outputFolderPath.replaceFirst("/", ""));
                }
            }
        });
    }

    public void handleEvent(Event event) {
    }
}

