/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.math3.complex.Complex;
import org.eclipse.january.dataset.BooleanDataset;
import org.eclipse.january.dataset.BroadcastIterator;
import org.eclipse.january.dataset.ByteDataset;
import org.eclipse.january.dataset.Comparisons;
import org.eclipse.january.dataset.ComplexDoubleDataset;
import org.eclipse.january.dataset.ComplexFloatDataset;
import org.eclipse.january.dataset.CompoundByteDataset;
import org.eclipse.january.dataset.CompoundDataset;
import org.eclipse.january.dataset.CompoundDoubleDataset;
import org.eclipse.january.dataset.CompoundFloatDataset;
import org.eclipse.january.dataset.CompoundIntegerDataset;
import org.eclipse.january.dataset.CompoundLongDataset;
import org.eclipse.january.dataset.CompoundShortDataset;
import org.eclipse.january.dataset.DTypeUtils;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DatasetUtils;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.FloatDataset;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.IntegerDataset;
import org.eclipse.january.dataset.LongDataset;
import org.eclipse.january.dataset.Operations;
import org.eclipse.january.dataset.PositionIterator;
import org.eclipse.january.dataset.ShortDataset;
import org.eclipse.january.dataset.SingleInputBroadcastIterator;

public class Maths {
    public static Object unwrap(Dataset o, Object a) {
        return a instanceof Dataset ? o : o.getObject();
    }

    public static Object unwrap(Dataset o, Object a, Object b) {
        return a instanceof Dataset || b instanceof Dataset ? o : o.getObject();
    }

    public static Object unwrap(Dataset o, Object ... a) {
        boolean isAnyDataset = false;
        Object[] objectArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof Dataset) {
                isAnyDataset = true;
                break;
            }
            ++n2;
        }
        return isAnyDataset ? o : o.getObject();
    }

    public static Dataset floorDivide(Object a, Object b) {
        return Maths.floorDivide(a, b, null);
    }

    public static Dataset floorDivide(Object a, Object b, Dataset o) {
        return Maths.divideTowardsFloor(a, b, o).ifloor();
    }

    public static Dataset floorRemainder(Object a, Object b) {
        return Maths.floorRemainder(a, b, null);
    }

    public static Dataset floorRemainder(Object a, Object b, Dataset o) {
        Dataset da = a instanceof Dataset ? (Dataset)a : DatasetFactory.createFromObject(a);
        Dataset db = b instanceof Dataset ? (Dataset)b : DatasetFactory.createFromObject(b);
        Dataset dq = Maths.floorDivide(da, db);
        dq.imultiply(db);
        return Maths.subtract(da, dq, o);
    }

    public static Dataset reciprocal(Object a) {
        return Maths.reciprocal(a, null);
    }

    public static Dataset reciprocal(Object a, Dataset o) {
        Dataset da = a instanceof Dataset ? (Dataset)a : DatasetFactory.createFromObject(a);
        return Maths.divide(1, da, o);
    }

    public static Dataset abs(Object a) {
        return Maths.abs(a, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset abs(Object a, Dataset o) {
        da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        it = new SingleInputBroadcastIterator(da, o, true, true, false);
        result = it.getOutput();
        is = result.getElementsPerItem();
        dt = result.getDType();
        as = da.getElementsPerItem();
        reset = result == o && is > 1;
        switch (dt) {
            case 1: {
                oi8data = ((ByteDataset)result).getData();
                it.setOutputDouble(false);
                while (it.hasNext()) {
                    oi8data[it.oIndex] = (byte)Math.abs(it.aLong);
                }
                break;
            }
            case 2: {
                oi16data = ((ShortDataset)result).getData();
                it.setOutputDouble(false);
                while (it.hasNext()) {
                    oi16data[it.oIndex] = (short)Math.abs(it.aLong);
                }
                break;
            }
            case 3: {
                oi32data = ((IntegerDataset)result).getData();
                it.setOutputDouble(false);
                while (it.hasNext()) {
                    oi32data[it.oIndex] = (int)Math.abs(it.aLong);
                }
                break;
            }
            case 4: {
                oi64data = ((LongDataset)result).getData();
                it.setOutputDouble(false);
                while (it.hasNext()) {
                    oi64data[it.oIndex] = Math.abs(it.aLong);
                }
                break;
            }
            case 100: {
                oai8data = ((CompoundByteDataset)result).getData();
                it.setOutputDouble(false);
                if (is == 1) {
                    while (it.hasNext()) {
                        oai8data[it.oIndex] = (byte)Math.abs(it.aLong);
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl61
                while (it.hasNext()) {
                    ox = (byte)Math.abs(it.aLong);
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    oai8data[it.oIndex] = (byte)Math.abs(it.aLong);
                    j = 1;
                    while (j < is) {
                        oai8data[it.oIndex + j] = (byte)Math.abs(da.getElementLongAbs(it.aIndex + j));
                        ++j;
                    }
lbl61:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl62:
                // 1 sources

                break;
            }
            case 200: {
                oai16data = ((CompoundShortDataset)result).getData();
                it.setOutputDouble(false);
                if (is == 1) {
                    while (it.hasNext()) {
                        oai16data[it.oIndex] = (short)Math.abs(it.aLong);
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl87
                while (it.hasNext()) {
                    ox = (short)Math.abs(it.aLong);
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    oai16data[it.oIndex] = (short)Math.abs(it.aLong);
                    j = 1;
                    while (j < is) {
                        oai16data[it.oIndex + j] = (short)Math.abs(da.getElementLongAbs(it.aIndex + j));
                        ++j;
                    }
lbl87:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl88:
                // 1 sources

                break;
            }
            case 300: {
                oai32data = ((CompoundIntegerDataset)result).getData();
                it.setOutputDouble(false);
                if (is == 1) {
                    while (it.hasNext()) {
                        oai32data[it.oIndex] = (int)Math.abs(it.aLong);
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl113
                while (it.hasNext()) {
                    ox = (int)Math.abs(it.aLong);
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    oai32data[it.oIndex] = (int)Math.abs(it.aLong);
                    j = 1;
                    while (j < is) {
                        oai32data[it.oIndex + j] = (int)Math.abs(da.getElementLongAbs(it.aIndex + j));
                        ++j;
                    }
lbl113:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl114:
                // 1 sources

                break;
            }
            case 400: {
                oai64data = ((CompoundLongDataset)result).getData();
                it.setOutputDouble(false);
                if (is == 1) {
                    while (it.hasNext()) {
                        oai64data[it.oIndex] = Math.abs(it.aLong);
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl139
                while (it.hasNext()) {
                    ox = Math.abs(it.aLong);
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    oai64data[it.oIndex] = Math.abs(it.aLong);
                    j = 1;
                    while (j < is) {
                        oai64data[it.oIndex + j] = Math.abs(da.getElementLongAbs(it.aIndex + j));
                        ++j;
                    }
lbl139:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl140:
                // 1 sources

                break;
            }
            case 5: {
                of32data = ((FloatDataset)result).getData();
                if (as != 1) ** GOTO lbl149
                while (it.hasNext()) {
                    of32data[it.oIndex] = (float)Math.abs(it.aDouble);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    of32data[it.oIndex] = (float)Math.hypot(it.aDouble, da.getElementDoubleAbs(it.aIndex + 1));
lbl149:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl150:
                // 1 sources

                break;
            }
            case 6: {
                of64data = ((DoubleDataset)result).getData();
                if (as != 1) ** GOTO lbl159
                while (it.hasNext()) {
                    of64data[it.oIndex] = Math.abs(it.aDouble);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    of64data[it.oIndex] = Math.hypot(it.aDouble, da.getElementDoubleAbs(it.aIndex + 1));
lbl159:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl160:
                // 1 sources

                break;
            }
            case 500: {
                oaf32data = ((CompoundFloatDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        oaf32data[it.oIndex] = (float)Math.abs(it.aDouble);
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl184
                while (it.hasNext()) {
                    ox = (float)Math.abs(it.aDouble);
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    oaf32data[it.oIndex] = (float)Math.abs(it.aDouble);
                    j = 1;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = (float)Math.abs(da.getElementDoubleAbs(it.aIndex + j));
                        ++j;
                    }
lbl184:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl185:
                // 1 sources

                break;
            }
            case 600: {
                oaf64data = ((CompoundDoubleDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        oaf64data[it.oIndex] = Math.abs(it.aDouble);
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl210
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = Math.abs(ix);
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    oaf64data[it.oIndex] = Math.abs(it.aDouble);
                    j = 1;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = Math.abs(da.getElementDoubleAbs(it.aIndex + j));
                        ++j;
                    }
lbl210:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl211:
                // 1 sources

                break;
            }
            case 7: {
                oc64data = ((ComplexFloatDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl224
                while (it.hasNext()) {
                    oc64data[it.oIndex] = (float)Math.abs(it.aDouble);
                    if (!reset) continue;
                    oc64data[it.oIndex + 1] = 0.0f;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    oc64data[it.oIndex] = (float)Math.hypot(it.aDouble, da.getElementDoubleAbs(it.aIndex + 1));
                    if (!reset) continue;
                    oc64data[it.oIndex + 1] = 0.0f;
lbl224:
                    // 3 sources

                    ** while (it.hasNext())
                }
lbl225:
                // 1 sources

                break;
            }
            case 8: {
                oc128data = ((ComplexDoubleDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl238
                while (it.hasNext()) {
                    oc128data[it.oIndex] = Math.abs(it.aDouble);
                    if (!reset) continue;
                    oc128data[it.oIndex + 1] = 0.0;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    oc128data[it.oIndex] = Math.hypot(it.aDouble, da.getElementDoubleAbs(it.aIndex + 1));
                    if (!reset) continue;
                    oc128data[it.oIndex + 1] = 0.0;
lbl238:
                    // 3 sources

                    ** while (it.hasNext())
                }
lbl239:
                // 1 sources

                break;
            }
            default: {
                throw new IllegalArgumentException("abs supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        Maths.addFunctionName(result, "abs");
        return result;
    }

    public static Dataset conjugate(Object a) {
        return Maths.conjugate(a, null);
    }

    public static Dataset conjugate(Object a, Dataset o) {
        Dataset da = a instanceof Dataset ? (Dataset)a : DatasetFactory.createFromObject(a);
        int at = da.getDType();
        IndexIterator it1 = da.getIterator();
        SingleInputBroadcastIterator it = new SingleInputBroadcastIterator(da, o, true, true, true);
        Dataset result = it.getOutput();
        switch (at) {
            case 7: {
                float[] c64data = ((ComplexFloatDataset)result).getData();
                int i = 0;
                while (it1.hasNext()) {
                    c64data[i++] = (float)da.getElementDoubleAbs(it1.index);
                    c64data[i++] = (float)(-da.getElementDoubleAbs(it1.index + 1));
                }
                result.setName(Operations.bracketIfNecessary(da.getName()).append("^*").toString());
                break;
            }
            case 8: {
                double[] c128data = ((ComplexDoubleDataset)result).getData();
                int i = 0;
                while (it1.hasNext()) {
                    c128data[i++] = da.getElementDoubleAbs(it1.index);
                    c128data[i++] = -da.getElementDoubleAbs(it1.index + 1);
                }
                result.setName(Operations.bracketIfNecessary(da.getName()).append("^*").toString());
                break;
            }
            default: {
                result = da;
            }
        }
        return result;
    }

    public static Dataset hypot(Object a, Object b) {
        return Maths.hypot(a, b, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset hypot(Object a, Object b, Dataset o) {
        da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        db = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b);
        it = BroadcastIterator.createIterator(da, db, o, true);
        it.setOutputDouble(true);
        result = it.getOutput();
        is = result.getElementsPerItem();
        as = da.getElementsPerItem();
        bs = db.getElementsPerItem();
        dt = result.getDType();
        switch (dt) {
            case 0: {
                bdata = ((BooleanDataset)result).getData();
                while (it.hasNext()) {
                    v0 = bdata[it.oIndex] = Math.hypot(it.aDouble, it.bDouble) != 0.0;
                }
                break;
            }
            case 1: {
                i8data = ((ByteDataset)result).getData();
                while (it.hasNext()) {
                    i8data[it.oIndex] = (byte)Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                }
                break;
            }
            case 2: {
                i16data = ((ShortDataset)result).getData();
                while (it.hasNext()) {
                    i16data[it.oIndex] = (short)Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                }
                break;
            }
            case 3: {
                i32data = ((IntegerDataset)result).getData();
                while (it.hasNext()) {
                    i32data[it.oIndex] = (int)Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                }
                break;
            }
            case 4: {
                i64data = ((LongDataset)result).getData();
                while (it.hasNext()) {
                    i64data[it.oIndex] = Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                }
                break;
            }
            case 5: {
                f32data = ((FloatDataset)result).getData();
                while (it.hasNext()) {
                    f32data[it.oIndex] = (float)Math.hypot(it.aDouble, it.bDouble);
                }
                break;
            }
            case 6: {
                f64data = ((DoubleDataset)result).getData();
                while (it.hasNext()) {
                    f64data[it.oIndex] = Math.hypot(it.aDouble, it.bDouble);
                }
                break;
            }
            case 100: {
                ai8data = ((CompoundByteDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        ai8data[it.oIndex] = (byte)Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                    }
                    break;
                }
                if (as == 1) {
                    while (it.hasNext()) {
                        ai8data[it.oIndex] = (byte)Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                        j = 1;
                        while (j < is) {
                            ai8data[it.oIndex + j] = (byte)Maths.toLong(Math.hypot(it.aDouble, db.getElementDoubleAbs(it.bIndex + j)));
                            ++j;
                        }
                    }
                    break;
                }
                if (bs != 1) ** GOTO lbl86
                while (it.hasNext()) {
                    ai8data[it.oIndex] = (byte)Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                    j = 1;
                    while (j < is) {
                        ai8data[it.oIndex + j] = (byte)Maths.toLong(Math.hypot(da.getElementDoubleAbs(it.aIndex + j), it.bDouble));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ai8data[it.oIndex] = (byte)Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                    j = 1;
                    while (j < is) {
                        ai8data[it.oIndex + j] = (byte)Maths.toLong(Math.hypot(da.getElementDoubleAbs(it.aIndex + j), db.getElementDoubleAbs(it.bIndex + j)));
                        ++j;
                    }
lbl86:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl87:
                // 1 sources

                break;
            }
            case 200: {
                ai16data = ((CompoundShortDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        ai16data[it.oIndex] = (short)Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                    }
                    break;
                }
                if (as == 1) {
                    while (it.hasNext()) {
                        ai16data[it.oIndex] = (short)Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                        j = 1;
                        while (j < is) {
                            ai16data[it.oIndex + j] = (short)Maths.toLong(Math.hypot(it.aDouble, db.getElementDoubleAbs(it.bIndex + j)));
                            ++j;
                        }
                    }
                    break;
                }
                if (bs != 1) ** GOTO lbl121
                while (it.hasNext()) {
                    ai16data[it.oIndex] = (short)Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                    j = 1;
                    while (j < is) {
                        ai16data[it.oIndex + j] = (short)Maths.toLong(Math.hypot(da.getElementDoubleAbs(it.aIndex + j), it.bDouble));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ai16data[it.oIndex] = (short)Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                    j = 1;
                    while (j < is) {
                        ai16data[it.oIndex + j] = (short)Maths.toLong(Math.hypot(da.getElementDoubleAbs(it.aIndex + j), db.getElementDoubleAbs(it.bIndex + j)));
                        ++j;
                    }
lbl121:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl122:
                // 1 sources

                break;
            }
            case 300: {
                ai32data = ((CompoundIntegerDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        ai32data[it.oIndex] = (int)Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                    }
                    break;
                }
                if (as == 1) {
                    while (it.hasNext()) {
                        ai32data[it.oIndex] = (int)Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                        j = 1;
                        while (j < is) {
                            ai32data[it.oIndex + j] = (int)Maths.toLong(Math.hypot(it.aDouble, db.getElementDoubleAbs(it.bIndex + j)));
                            ++j;
                        }
                    }
                    break;
                }
                if (bs != 1) ** GOTO lbl156
                while (it.hasNext()) {
                    ai32data[it.oIndex] = (int)Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                    j = 1;
                    while (j < is) {
                        ai32data[it.oIndex + j] = (int)Maths.toLong(Math.hypot(da.getElementDoubleAbs(it.aIndex + j), it.bDouble));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ai32data[it.oIndex] = (int)Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                    j = 1;
                    while (j < is) {
                        ai32data[it.oIndex + j] = (int)Maths.toLong(Math.hypot(da.getElementDoubleAbs(it.aIndex + j), db.getElementDoubleAbs(it.bIndex + j)));
                        ++j;
                    }
lbl156:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl157:
                // 1 sources

                break;
            }
            case 400: {
                ai64data = ((CompoundLongDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        ai64data[it.oIndex] = Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                    }
                    break;
                }
                if (as == 1) {
                    while (it.hasNext()) {
                        ai64data[it.oIndex] = Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                        j = 1;
                        while (j < is) {
                            ai64data[it.oIndex + j] = Maths.toLong(Math.hypot(it.aDouble, db.getElementDoubleAbs(it.bIndex + j)));
                            ++j;
                        }
                    }
                    break;
                }
                if (bs != 1) ** GOTO lbl191
                while (it.hasNext()) {
                    ai64data[it.oIndex] = Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                    j = 1;
                    while (j < is) {
                        ai64data[it.oIndex + j] = Maths.toLong(Math.hypot(da.getElementDoubleAbs(it.aIndex + j), it.bDouble));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ai64data[it.oIndex] = Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                    j = 1;
                    while (j < is) {
                        ai64data[it.oIndex + j] = Maths.toLong(Math.hypot(da.getElementDoubleAbs(it.aIndex + j), db.getElementDoubleAbs(it.bIndex + j)));
                        ++j;
                    }
lbl191:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl192:
                // 1 sources

                break;
            }
            case 500: {
                a32data = ((CompoundFloatDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        a32data[it.oIndex] = (float)Math.hypot(it.aDouble, it.bDouble);
                    }
                    break;
                }
                if (as == 1) {
                    while (it.hasNext()) {
                        a32data[it.oIndex] = (float)Math.hypot(it.aDouble, it.bDouble);
                        j = 1;
                        while (j < is) {
                            a32data[it.oIndex + j] = (float)Math.hypot(it.aDouble, db.getElementDoubleAbs(it.bIndex + j));
                            ++j;
                        }
                    }
                    break;
                }
                if (bs != 1) ** GOTO lbl226
                while (it.hasNext()) {
                    a32data[it.oIndex] = (float)Math.hypot(it.aDouble, it.bDouble);
                    j = 1;
                    while (j < is) {
                        a32data[it.oIndex + j] = (float)Math.hypot(da.getElementDoubleAbs(it.aIndex + j), it.bDouble);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    a32data[it.oIndex] = (float)Math.hypot(it.aDouble, it.bDouble);
                    j = 1;
                    while (j < is) {
                        a32data[it.oIndex + j] = (float)Math.hypot(da.getElementDoubleAbs(it.aIndex + j), db.getElementDoubleAbs(it.bIndex + j));
                        ++j;
                    }
lbl226:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl227:
                // 1 sources

                break;
            }
            case 600: {
                a64data = ((CompoundDoubleDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        a64data[it.oIndex] = Math.hypot(it.aDouble, it.bDouble);
                    }
                    break;
                }
                if (as == 1) {
                    while (it.hasNext()) {
                        a64data[it.oIndex] = Math.hypot(it.aDouble, it.bDouble);
                        j = 1;
                        while (j < is) {
                            a64data[it.oIndex + j] = Math.hypot(it.aDouble, db.getElementDoubleAbs(it.bIndex + j));
                            ++j;
                        }
                    }
                    break;
                }
                if (bs != 1) ** GOTO lbl261
                while (it.hasNext()) {
                    a64data[it.oIndex] = Math.hypot(it.aDouble, it.bDouble);
                    j = 1;
                    while (j < is) {
                        a64data[it.oIndex + j] = Math.hypot(da.getElementDoubleAbs(it.aIndex + j), it.bDouble);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    a64data[it.oIndex] = Math.hypot(it.aDouble, it.bDouble);
                    j = 1;
                    while (j < is) {
                        a64data[it.oIndex + j] = Math.hypot(da.getElementDoubleAbs(it.aIndex + j), db.getElementDoubleAbs(it.bIndex + j));
                        ++j;
                    }
lbl261:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl262:
                // 1 sources

                break;
            }
            default: {
                throw new UnsupportedOperationException("hypot does not support this dataset type");
            }
        }
        Maths.addFunctionName(da, db, result, "hypot");
        return result;
    }

    public static Dataset arctan2(Object a, Object b) {
        return Maths.arctan2(a, b, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset arctan2(Object a, Object b, Dataset o) {
        da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        db = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b);
        it = BroadcastIterator.createIterator(da, db, o, true);
        it.setOutputDouble(true);
        result = it.getOutput();
        is = result.getElementsPerItem();
        as = da.getElementsPerItem();
        bs = db.getElementsPerItem();
        dt = result.getDType();
        switch (dt) {
            case 0: {
                bdata = ((BooleanDataset)result).getData();
                while (it.hasNext()) {
                    v0 = bdata[it.oIndex] = Math.atan2(it.aDouble, it.bDouble) != 0.0;
                }
                break;
            }
            case 1: {
                i8data = ((ByteDataset)result).getData();
                while (it.hasNext()) {
                    i8data[it.oIndex] = (byte)Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                }
                break;
            }
            case 2: {
                i16data = ((ShortDataset)result).getData();
                while (it.hasNext()) {
                    i16data[it.oIndex] = (short)Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                }
                break;
            }
            case 3: {
                i32data = ((IntegerDataset)result).getData();
                while (it.hasNext()) {
                    i32data[it.oIndex] = (int)Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                }
                break;
            }
            case 4: {
                i64data = ((LongDataset)result).getData();
                while (it.hasNext()) {
                    i64data[it.oIndex] = Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                }
                break;
            }
            case 5: {
                f32data = ((FloatDataset)result).getData();
                while (it.hasNext()) {
                    f32data[it.oIndex] = (float)Math.atan2(it.aDouble, it.bDouble);
                }
                break;
            }
            case 6: {
                f64data = ((DoubleDataset)result).getData();
                while (it.hasNext()) {
                    f64data[it.oIndex] = Math.atan2(it.aDouble, it.bDouble);
                }
                break;
            }
            case 100: {
                ai8data = ((CompoundByteDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        ai8data[it.oIndex] = (byte)Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                    }
                    break;
                }
                if (as == 1) {
                    while (it.hasNext()) {
                        ai8data[it.oIndex] = (byte)Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                        j = 1;
                        while (j < is) {
                            ai8data[it.oIndex + j] = (byte)Maths.toLong(Math.atan2(it.aDouble, db.getElementDoubleAbs(it.bIndex + j)));
                            ++j;
                        }
                    }
                    break;
                }
                if (bs != 1) ** GOTO lbl86
                while (it.hasNext()) {
                    ai8data[it.oIndex] = (byte)Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                    j = 1;
                    while (j < is) {
                        ai8data[it.oIndex + j] = (byte)Maths.toLong(Math.atan2(da.getElementDoubleAbs(it.aIndex + j), it.bDouble));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ai8data[it.oIndex] = (byte)Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                    j = 1;
                    while (j < is) {
                        ai8data[it.oIndex + j] = (byte)Maths.toLong(Math.atan2(da.getElementDoubleAbs(it.aIndex + j), db.getElementDoubleAbs(it.bIndex + j)));
                        ++j;
                    }
lbl86:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl87:
                // 1 sources

                break;
            }
            case 200: {
                ai16data = ((CompoundShortDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        ai16data[it.oIndex] = (short)Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                    }
                    break;
                }
                if (as == 1) {
                    while (it.hasNext()) {
                        ai16data[it.oIndex] = (short)Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                        j = 1;
                        while (j < is) {
                            ai16data[it.oIndex + j] = (short)Maths.toLong(Math.atan2(it.aDouble, db.getElementDoubleAbs(it.bIndex + j)));
                            ++j;
                        }
                    }
                    break;
                }
                if (bs != 1) ** GOTO lbl121
                while (it.hasNext()) {
                    ai16data[it.oIndex] = (short)Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                    j = 1;
                    while (j < is) {
                        ai16data[it.oIndex + j] = (short)Maths.toLong(Math.atan2(da.getElementDoubleAbs(it.aIndex + j), it.bDouble));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ai16data[it.oIndex] = (short)Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                    j = 1;
                    while (j < is) {
                        ai16data[it.oIndex + j] = (short)Maths.toLong(Math.atan2(da.getElementDoubleAbs(it.aIndex + j), db.getElementDoubleAbs(it.bIndex + j)));
                        ++j;
                    }
lbl121:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl122:
                // 1 sources

                break;
            }
            case 300: {
                ai32data = ((CompoundIntegerDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        ai32data[it.oIndex] = (int)Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                    }
                    break;
                }
                if (as == 1) {
                    while (it.hasNext()) {
                        ai32data[it.oIndex] = (int)Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                        j = 1;
                        while (j < is) {
                            ai32data[it.oIndex + j] = (int)Maths.toLong(Math.atan2(it.aDouble, db.getElementDoubleAbs(it.bIndex + j)));
                            ++j;
                        }
                    }
                    break;
                }
                if (bs != 1) ** GOTO lbl156
                while (it.hasNext()) {
                    ai32data[it.oIndex] = (int)Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                    j = 1;
                    while (j < is) {
                        ai32data[it.oIndex + j] = (int)Maths.toLong(Math.atan2(da.getElementDoubleAbs(it.aIndex + j), it.bDouble));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ai32data[it.oIndex] = (int)Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                    j = 1;
                    while (j < is) {
                        ai32data[it.oIndex + j] = (int)Maths.toLong(Math.atan2(da.getElementDoubleAbs(it.aIndex + j), db.getElementDoubleAbs(it.bIndex + j)));
                        ++j;
                    }
lbl156:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl157:
                // 1 sources

                break;
            }
            case 400: {
                ai64data = ((CompoundLongDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        ai64data[it.oIndex] = Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                    }
                    break;
                }
                if (as == 1) {
                    while (it.hasNext()) {
                        ai64data[it.oIndex] = Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                        j = 1;
                        while (j < is) {
                            ai64data[it.oIndex + j] = Maths.toLong(Math.atan2(it.aDouble, db.getElementDoubleAbs(it.bIndex + j)));
                            ++j;
                        }
                    }
                    break;
                }
                if (bs != 1) ** GOTO lbl191
                while (it.hasNext()) {
                    ai64data[it.oIndex] = Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                    j = 1;
                    while (j < is) {
                        ai64data[it.oIndex + j] = Maths.toLong(Math.atan2(da.getElementDoubleAbs(it.aIndex + j), it.bDouble));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ai64data[it.oIndex] = Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                    j = 1;
                    while (j < is) {
                        ai64data[it.oIndex + j] = Maths.toLong(Math.atan2(da.getElementDoubleAbs(it.aIndex + j), db.getElementDoubleAbs(it.bIndex + j)));
                        ++j;
                    }
lbl191:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl192:
                // 1 sources

                break;
            }
            case 500: {
                a32data = ((CompoundFloatDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        a32data[it.oIndex] = (float)Math.atan2(it.aDouble, it.bDouble);
                    }
                    break;
                }
                if (as == 1) {
                    while (it.hasNext()) {
                        a32data[it.oIndex] = (float)Math.atan2(it.aDouble, it.bDouble);
                        j = 1;
                        while (j < is) {
                            a32data[it.oIndex + j] = (float)Math.atan2(it.aDouble, db.getElementDoubleAbs(it.bIndex + j));
                            ++j;
                        }
                    }
                    break;
                }
                if (bs != 1) ** GOTO lbl226
                while (it.hasNext()) {
                    a32data[it.oIndex] = (float)Math.atan2(it.aDouble, it.bDouble);
                    j = 1;
                    while (j < is) {
                        a32data[it.oIndex + j] = (float)Math.atan2(da.getElementDoubleAbs(it.aIndex + j), it.bDouble);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    a32data[it.oIndex] = (float)Math.atan2(it.aDouble, it.bDouble);
                    j = 1;
                    while (j < is) {
                        a32data[it.oIndex + j] = (float)Math.atan2(da.getElementDoubleAbs(it.aIndex + j), db.getElementDoubleAbs(it.bIndex + j));
                        ++j;
                    }
lbl226:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl227:
                // 1 sources

                break;
            }
            case 600: {
                a64data = ((CompoundDoubleDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        a64data[it.oIndex] = Math.atan2(it.aDouble, it.bDouble);
                    }
                    break;
                }
                if (as == 1) {
                    while (it.hasNext()) {
                        a64data[it.oIndex] = Math.atan2(it.aDouble, it.bDouble);
                        j = 1;
                        while (j < is) {
                            a64data[it.oIndex + j] = Math.atan2(it.aDouble, db.getElementDoubleAbs(it.bIndex + j));
                            ++j;
                        }
                    }
                    break;
                }
                if (bs != 1) ** GOTO lbl261
                while (it.hasNext()) {
                    a64data[it.oIndex] = Math.atan2(it.aDouble, it.bDouble);
                    j = 1;
                    while (j < is) {
                        a64data[it.oIndex + j] = Math.atan2(da.getElementDoubleAbs(it.aIndex + j), it.bDouble);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    a64data[it.oIndex] = Math.atan2(it.aDouble, it.bDouble);
                    j = 1;
                    while (j < is) {
                        a64data[it.oIndex + j] = Math.atan2(da.getElementDoubleAbs(it.aIndex + j), db.getElementDoubleAbs(it.bIndex + j));
                        ++j;
                    }
lbl261:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl262:
                // 1 sources

                break;
            }
            default: {
                throw new UnsupportedOperationException("atan2 does not support multiple-element dataset");
            }
        }
        Maths.addFunctionName(da, db, result, "atan2");
        return result;
    }

    public static Dataset angle(Object a) {
        return Maths.angle(a, false, null);
    }

    public static Dataset angle(Object a, boolean inDegrees) {
        return Maths.angle(a, inDegrees, null);
    }

    public static Dataset angle(Object a, Dataset o) {
        return Maths.angle(a, false, o);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset angle(Object a, boolean inDegrees, Dataset o) {
        v0 = da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        if (!da.isComplex()) {
            throw new UnsupportedOperationException("angle does not support this dataset type");
        }
        it = new SingleInputBroadcastIterator(da, o, true, false, false);
        result = it.getOutput();
        is = result.getElementsPerItem();
        dt = result.getDType();
        switch (dt) {
            case 1: {
                oi8data = ((ByteDataset)result).getData();
                it.setOutputDouble(false);
                if (!inDegrees) ** GOTO lbl18
                while (it.hasNext()) {
                    oi8data[it.oIndex] = (byte)Maths.toLong(Math.toDegrees(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble)));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    oi8data[it.oIndex] = (byte)Maths.toLong(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble));
lbl18:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl19:
                // 1 sources

                break;
            }
            case 2: {
                oi16data = ((ShortDataset)result).getData();
                it.setOutputDouble(false);
                if (!inDegrees) ** GOTO lbl29
                while (it.hasNext()) {
                    oi16data[it.oIndex] = (short)Maths.toLong(Math.toDegrees(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble)));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    oi16data[it.oIndex] = (short)Maths.toLong(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble));
lbl29:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl30:
                // 1 sources

                break;
            }
            case 3: {
                oi32data = ((IntegerDataset)result).getData();
                it.setOutputDouble(false);
                if (!inDegrees) ** GOTO lbl40
                while (it.hasNext()) {
                    oi32data[it.oIndex] = (int)Maths.toLong(Math.toDegrees(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble)));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    oi32data[it.oIndex] = (int)Maths.toLong(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble));
lbl40:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl41:
                // 1 sources

                break;
            }
            case 4: {
                oi64data = ((LongDataset)result).getData();
                it.setOutputDouble(false);
                if (!inDegrees) ** GOTO lbl51
                while (it.hasNext()) {
                    oi64data[it.oIndex] = Maths.toLong(Math.toDegrees(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble)));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    oi64data[it.oIndex] = Maths.toLong(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble));
lbl51:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl52:
                // 1 sources

                break;
            }
            case 100: {
                oai8data = ((CompoundByteDataset)result).getData();
                it.setOutputDouble(false);
                if (!inDegrees) ** GOTO lbl72
                while (it.hasNext()) {
                    ox = (byte)Maths.toLong(Math.toDegrees(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble)));
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ox = (byte)Maths.toLong(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble));
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl72:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl73:
                // 1 sources

                break;
            }
            case 200: {
                oai16data = ((CompoundShortDataset)result).getData();
                it.setOutputDouble(false);
                if (!inDegrees) ** GOTO lbl93
                while (it.hasNext()) {
                    ox = (short)Maths.toLong(Math.toDegrees(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble)));
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ox = (short)Maths.toLong(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble));
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl93:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl94:
                // 1 sources

                break;
            }
            case 300: {
                oai32data = ((CompoundIntegerDataset)result).getData();
                it.setOutputDouble(false);
                if (!inDegrees) ** GOTO lbl114
                while (it.hasNext()) {
                    ox = (int)Maths.toLong(Math.toDegrees(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble)));
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ox = (int)Maths.toLong(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble));
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl114:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl115:
                // 1 sources

                break;
            }
            case 400: {
                oai64data = ((CompoundLongDataset)result).getData();
                it.setOutputDouble(false);
                if (!inDegrees) ** GOTO lbl135
                while (it.hasNext()) {
                    ox = Maths.toLong(Math.toDegrees(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble)));
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ox = Maths.toLong(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble));
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl135:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl136:
                // 1 sources

                break;
            }
            case 5: {
                of32data = ((FloatDataset)result).getData();
                if (!inDegrees) ** GOTO lbl145
                while (it.hasNext()) {
                    of32data[it.oIndex] = (float)Math.toDegrees(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    of32data[it.oIndex] = (float)Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble);
lbl145:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl146:
                // 1 sources

                break;
            }
            case 6: {
                of64data = ((DoubleDataset)result).getData();
                if (!inDegrees) ** GOTO lbl155
                while (it.hasNext()) {
                    of64data[it.oIndex] = Math.toDegrees(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    of64data[it.oIndex] = Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble);
lbl155:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl156:
                // 1 sources

                break;
            }
            case 500: {
                oaf32data = ((CompoundFloatDataset)result).getData();
                if (!inDegrees) ** GOTO lbl175
                while (it.hasNext()) {
                    ox = (float)Math.toDegrees(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble));
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ox = (float)Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble);
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl175:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl176:
                // 1 sources

                break;
            }
            case 600: {
                oaf64data = ((CompoundDoubleDataset)result).getData();
                if (!inDegrees) ** GOTO lbl195
                while (it.hasNext()) {
                    ox = Math.toDegrees(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble));
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ox = Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble);
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl195:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl196:
                // 1 sources

                break;
            }
            case 7: {
                oc64data = ((ComplexFloatDataset)result).getData();
                if (!inDegrees) ** GOTO lbl207
                while (it.hasNext()) {
                    oc64data[it.oIndex] = (float)Math.toDegrees(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble));
                    oc64data[it.oIndex + 1] = 0.0f;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    oc64data[it.oIndex] = (float)Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble);
                    oc64data[it.oIndex + 1] = 0.0f;
lbl207:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl208:
                // 1 sources

                break;
            }
            case 8: {
                oc128data = ((ComplexDoubleDataset)result).getData();
                if (!inDegrees) ** GOTO lbl219
                while (it.hasNext()) {
                    oc128data[it.oIndex] = Math.toDegrees(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble));
                    oc128data[it.oIndex + 1] = 0.0;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    oc128data[it.oIndex] = Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble);
                    oc128data[it.oIndex + 1] = 0.0;
lbl219:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl220:
                // 1 sources

                break;
            }
            default: {
                throw new IllegalArgumentException("angle does not support this dataset type");
            }
        }
        Maths.addFunctionName(result, "angle");
        return result;
    }

    public static Dataset phaseAsComplexNumber(Object a, boolean keepZeros) {
        return Maths.phaseAsComplexNumber(a, null, keepZeros);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset phaseAsComplexNumber(Object a, Dataset o, boolean keepZeros) {
        v0 = da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        if (!da.isComplex()) {
            throw new IllegalArgumentException("Input dataset is not of complex type");
        }
        v1 = result = o == null ? DatasetFactory.zeros(da) : o;
        if (!result.isComplex()) {
            throw new IllegalArgumentException("Output dataset is not of complex type");
        }
        dt = result.getDType();
        it = new SingleInputBroadcastIterator(da, result);
        switch (dt) {
            case 7: {
                z64data = ((ComplexFloatDataset)result).getData();
                if (!keepZeros) ** GOTO lbl30
                while (it.hasNext()) {
                    rr = it.aDouble;
                    ri = da.getElementDoubleAbs(it.aIndex + 1);
                    am = Math.hypot(rr, ri);
                    if (am == 0.0) {
                        z64data[it.oIndex] = 0.0f;
                        z64data[it.oIndex + 1] = 0.0f;
                        continue;
                    }
                    z64data[it.oIndex] = (float)(rr / am);
                    z64data[it.oIndex + 1] = (float)(ri / am);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    rr = it.aDouble;
                    ri = da.getElementDoubleAbs(it.aIndex + 1);
                    am = Math.hypot(rr, ri);
                    z64data[it.oIndex] = (float)(rr / am);
                    z64data[it.oIndex + 1] = (float)(ri / am);
lbl30:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl31:
                // 1 sources

                break;
            }
            case 8: {
                z128data = ((ComplexDoubleDataset)result).getData();
                if (!keepZeros) ** GOTO lbl52
                while (it.hasNext()) {
                    rr = it.aDouble;
                    ri = da.getElementDoubleAbs(it.aIndex + 1);
                    am = Math.hypot(rr, ri);
                    if (am == 0.0) {
                        z128data[it.oIndex] = 0.0;
                        z128data[it.oIndex + 1] = 0.0;
                        continue;
                    }
                    z128data[it.oIndex] = rr / am;
                    z128data[it.oIndex + 1] = ri / am;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    rr = it.aDouble;
                    ri = da.getElementDoubleAbs(it.aIndex + 1);
                    am = Math.hypot(rr, ri);
                    z128data[it.oIndex] = rr / am;
                    z128data[it.oIndex + 1] = ri / am;
lbl52:
                    // 2 sources

                    ** while (it.hasNext())
                }
            }
        }
lbl53:
        // 5 sources

        Maths.addFunctionName(result, "phase");
        return result;
    }

    public static Dataset add(Collection<IDataset> sets, boolean requireClone) {
        if (sets.isEmpty()) {
            return null;
        }
        Iterator<IDataset> it = sets.iterator();
        if (sets.size() == 1) {
            return DatasetUtils.convertToDataset(it.next());
        }
        Dataset sum = requireClone ? ((Dataset)it.next()).clone() : (Dataset)it.next();
        while (it.hasNext()) {
            Maths.add(sum, it.next(), sum);
        }
        return sum;
    }

    public static Dataset multiply(Collection<IDataset> sets, boolean requireClone) {
        if (sets.isEmpty()) {
            return null;
        }
        Iterator<IDataset> it = sets.iterator();
        if (sets.size() == 1) {
            return DatasetUtils.convertToDataset(it.next());
        }
        Dataset product = requireClone ? ((Dataset)it.next()).clone() : (Dataset)it.next();
        while (it.hasNext()) {
            Maths.multiply(product, it.next(), product);
        }
        return product;
    }

    public static Dataset interpolate(Dataset x, Dataset d, IDataset x0, Number left, Number right) {
        boolean isReversed;
        assert (x.getRank() == 1);
        assert (d.getRank() == 1);
        Comparisons.Monotonicity mono = Comparisons.findMonotonicity(x);
        if (mono == Comparisons.Monotonicity.NOT_ORDERED) {
            throw new IllegalArgumentException("Dataset x must be ordered");
        }
        DoubleDataset dx = DatasetUtils.cast(DoubleDataset.class, (IDataset)x);
        Dataset dx0 = DatasetUtils.convertToDataset(x0);
        if (x == dx) {
            dx = (DoubleDataset)x.flatten();
        }
        double[] xa = dx.getData();
        int s = xa.length - 1;
        boolean bl = isReversed = mono == Comparisons.Monotonicity.STRICTLY_DECREASING || mono == Comparisons.Monotonicity.NONINCREASING;
        if (isReversed) {
            double[] txa = (double[])xa.clone();
            int i = 0;
            while (i <= s) {
                txa[s - i] = xa[i];
                ++i;
            }
            xa = txa;
        }
        DoubleDataset r = DatasetFactory.zeros(dx0, DoubleDataset.class);
        IndexIterator it = dx0.getIterator();
        int k = -1;
        while (it.hasNext()) {
            ++k;
            double v = dx0.getElementDoubleAbs(it.index);
            int i = Arrays.binarySearch(xa, v);
            if (i < 0) {
                double t;
                double d1;
                if (i == -1) {
                    if (left != null) {
                        r.setAbs(k, left.doubleValue());
                        continue;
                    }
                    double xa0 = xa[0];
                    d1 = xa0 - xa[1];
                    t = d1 - v + xa0;
                    if (t >= 0.0) continue;
                    r.setAbs(k, (t /= d1) * d.getDouble(isReversed ? s : 0));
                    continue;
                }
                if (i == -s - 2) {
                    if (right != null) {
                        r.setAbs(k, right.doubleValue());
                        continue;
                    }
                    double xas = xa[s];
                    d1 = xas - xa[s - 1];
                    t = d1 - v + xas;
                    if (t <= 0.0) continue;
                    r.setAbs(k, (t /= d1) * d.getDouble(isReversed ? 0 : s));
                    continue;
                }
                i = -i - 1;
                double xai = xa[i];
                double t2 = (xai - v) / (xai - xa[i - 1]);
                if (isReversed) {
                    i = s - i;
                    r.setAbs(k, t2 * d.getDouble(i + 1) + (1.0 - t2) * d.getDouble(i));
                    continue;
                }
                r.setAbs(k, (1.0 - t2) * d.getDouble(i) + t2 * d.getDouble(i - 1));
                continue;
            }
            r.setAbs(k, d.getDouble(isReversed ? s - i : i));
        }
        return r;
    }

    public static double interpolate(Dataset d, double x0) {
        double f1;
        assert (d.getRank() == 1);
        int i0 = (int)Math.floor(x0);
        int e0 = d.getSize() - 1;
        if (i0 < -1 || i0 > e0) {
            return 0.0;
        }
        double u0 = x0 - (double)i0;
        double r = 0.0;
        double d2 = f1 = i0 < 0 ? 0.0 : d.getDouble(i0);
        r = u0 > 0.0 ? (1.0 - u0) * f1 + (i0 == e0 ? 0.0 : u0 * d.getDouble(i0 + 1)) : f1;
        return r;
    }

    public static double interpolate(Dataset d, Dataset m, double x0) {
        double f1;
        assert (d.getRank() == 1);
        assert (m.getRank() == 1);
        int i0 = (int)Math.floor(x0);
        int e0 = d.getSize() - 1;
        if (i0 < -1 || i0 > e0) {
            return 0.0;
        }
        double u0 = x0 - (double)i0;
        double r = 0.0;
        double d2 = f1 = i0 < 0 ? 0.0 : d.getDouble(i0) * m.getDouble(i0);
        r = u0 > 0.0 ? (1.0 - u0) * f1 + (i0 == e0 ? 0.0 : u0 * d.getDouble(i0 + 1) * m.getDouble(i0 + 1)) : f1;
        return r;
    }

    public static void interpolate(double[] values, CompoundDataset d, double x0) {
        assert (d.getRank() == 1);
        int is = d.getElementsPerItem();
        if (is != values.length) {
            throw new IllegalArgumentException("Output array length must match elements in item");
        }
        int i0 = (int)Math.floor(x0);
        int e0 = d.getSize() - 1;
        if (i0 < -1 || i0 > e0) {
            Arrays.fill(values, 0.0);
            return;
        }
        double u0 = x0 - (double)i0;
        if (u0 > 0.0) {
            double[] f1 = new double[is];
            if (i0 >= 0) {
                d.getDoubleArray(f1, i0);
            }
            double t = 1.0 - u0;
            if (i0 == e0) {
                int j = 0;
                while (j < is) {
                    values[j] = t * f1[j];
                    ++j;
                }
            } else {
                double[] f2 = new double[is];
                d.getDoubleArray(f2, i0 + 1);
                int j = 0;
                while (j < is) {
                    values[j] = t * f1[j] + u0 * f2[j];
                    ++j;
                }
            }
        } else if (i0 >= 0) {
            d.getDoubleArray(values, i0);
        } else {
            Arrays.fill(values, 0.0);
        }
    }

    public static double interpolate(Dataset d, double x0, double x1) {
        double f1;
        int[] s = d.getShape();
        assert (s.length == 2);
        int e0 = s[0] - 1;
        int e1 = s[1] - 1;
        int i0 = (int)Math.floor(x0);
        int i1 = (int)Math.floor(x1);
        double u0 = x0 - (double)i0;
        double u1 = x1 - (double)i1;
        if (i0 < -1 || i0 > e0 || i1 < -1 || i1 > e1) {
            return 0.0;
        }
        double r = 0.0;
        double d2 = f1 = i0 < 0 || i1 < 0 ? 0.0 : d.getDouble(i0, i1);
        if (u1 > 0.0) {
            if (u0 > 0.0) {
                double f3;
                double f4;
                double f2;
                if (i0 == e0) {
                    f2 = 0.0;
                    f4 = 0.0;
                    f3 = i1 == e1 ? 0.0 : d.getDouble(i0, i1 + 1);
                } else {
                    double d3 = f2 = i1 < 0 ? 0.0 : d.getDouble(i0 + 1, i1);
                    if (i1 == e1) {
                        f4 = 0.0;
                        f3 = 0.0;
                    } else {
                        f4 = d.getDouble(i0 + 1, i1 + 1);
                        f3 = i0 < 0 ? 0.0 : d.getDouble(i0, i1 + 1);
                    }
                }
                r = (1.0 - u0) * (1.0 - u1) * f1 + u0 * (1.0 - u1) * f2 + (1.0 - u0) * u1 * f3 + u0 * u1 * f4;
            } else {
                double f3 = i0 < 0 || i1 == e1 ? 0.0 : d.getDouble(i0, i1 + 1);
                r = (1.0 - u1) * f1 + u1 * f3;
            }
        } else if (u0 > 0.0) {
            double f2 = i0 == e0 || i1 < 0 ? 0.0 : d.getDouble(i0 + 1, i1);
            r = (1.0 - u0) * f1 + u0 * f2;
        } else {
            r = f1;
        }
        return r;
    }

    public static double interpolate(Dataset d, Dataset m, double x0, double x1) {
        double f1;
        if (m == null) {
            return Maths.interpolate(d, x0, x1);
        }
        int[] s = d.getShapeRef();
        assert (s.length == 2);
        assert (m.getRank() == 2);
        int e0 = s[0] - 1;
        int e1 = s[1] - 1;
        int i0 = (int)Math.floor(x0);
        int i1 = (int)Math.floor(x1);
        double u0 = x0 - (double)i0;
        double u1 = x1 - (double)i1;
        if (i0 < -1 || i0 > e0 || i1 < -1 || i1 > e1) {
            return 0.0;
        }
        double r = 0.0;
        double d2 = f1 = i0 < 0 || i1 < 0 ? 0.0 : d.getDouble(i0, i1) * m.getDouble(i0, i1);
        if (u1 > 0.0) {
            double f3;
            double f4;
            double f2;
            if (i0 == e0) {
                f2 = 0.0;
                f4 = 0.0;
                f3 = i1 == e1 ? 0.0 : d.getDouble(i0, i1 + 1) * m.getDouble(i0, i1 + 1);
            } else {
                double d3 = f2 = i1 < 0 ? 0.0 : d.getDouble(i0 + 1, i1) * m.getDouble(i0 + 1, i1);
                if (i1 == e1) {
                    f4 = 0.0;
                    f3 = 0.0;
                } else {
                    f4 = d.getDouble(i0 + 1, i1 + 1) * m.getDouble(i0 + 1, i1 + 1);
                    f3 = i0 < 0 ? 0.0 : d.getDouble(i0, i1 + 1) * m.getDouble(i0, i1 + 1);
                }
            }
            r = (1.0 - u0) * (1.0 - u1) * f1 + u0 * (1.0 - u1) * f2 + (1.0 - u0) * u1 * f3 + u0 * u1 * f4;
        } else if (u0 > 0.0) {
            double f2 = i0 == e0 || i1 < 0 ? 0.0 : d.getDouble(i0 + 1, i1) * m.getDouble(i0 + 1, i1);
            r = (1.0 - u0) * f1 + u0 * f2;
        } else {
            r = f1;
        }
        return r;
    }

    public static void interpolate(double[] values, CompoundDataset d, double x0, double x1) {
        int[] s = d.getShapeRef();
        assert (s.length == 2);
        int is = d.getElementsPerItem();
        if (is != values.length) {
            throw new IllegalArgumentException("Output array length must match elements in item");
        }
        int e0 = s[0] - 1;
        int e1 = s[1] - 1;
        int i0 = (int)Math.floor(x0);
        int i1 = (int)Math.floor(x1);
        double u0 = x0 - (double)i0;
        double u1 = x1 - (double)i1;
        if (i0 < -1 || i0 > e0 || i1 < -1 || i1 > e1) {
            Arrays.fill(values, 0.0);
            return;
        }
        double[] f1 = new double[is];
        if (i0 >= 0 && i1 >= 0) {
            d.getDoubleArray(f1, i0, i1);
        }
        if (u1 > 0.0) {
            if (u0 > 0.0) {
                double[] f2 = new double[is];
                double[] f3 = new double[is];
                double[] f4 = new double[is];
                if (i0 != e0) {
                    if (i1 != e1) {
                        d.getDoubleArray(f3, i0 + 1, i1 + 1);
                    }
                    if (i1 >= 0) {
                        d.getDoubleArray(f4, i0 + 1, i1);
                    }
                }
                if (i0 >= 0 && i1 != e1) {
                    d.getDoubleArray(f2, i0, i1 + 1);
                }
                double t0 = 1.0 - u0;
                double t1 = 1.0 - u1;
                double w1 = t0 * t1;
                double w2 = t0 * u1;
                double w3 = u0 * u1;
                double w4 = u0 * t1;
                int j = 0;
                while (j < is) {
                    values[j] = w1 * f1[j] + w2 * f2[j] + w3 * f3[j] + w4 * f4[j];
                    ++j;
                }
            } else {
                double[] f2 = new double[is];
                if (i0 >= 0 && i1 != e1) {
                    d.getDoubleArray(f2, i0, i1 + 1);
                }
                double t1 = 1.0 - u1;
                int j = 0;
                while (j < is) {
                    values[j] = t1 * f1[j] + u1 * f2[j];
                    ++j;
                }
            }
        } else if (u0 > 0.0) {
            double[] f4 = new double[is];
            if (i0 != e0 && i1 >= 0) {
                d.getDoubleArray(f4, i0 + 1, i1);
            }
            double t0 = 1.0 - u0;
            int j = 0;
            while (j < is) {
                values[j] = t0 * f1[j] + u0 * f4[j];
                ++j;
            }
        } else if (i0 >= 0 && i1 >= 0) {
            d.getDoubleArray(values, i0, i1);
        } else {
            Arrays.fill(values, 0.0);
        }
    }

    public static double interpolate(Dataset d, double ... x) {
        return Maths.interpolate(d, null, x);
    }

    /*
     * Unable to fully structure code
     */
    public static double interpolate(Dataset d, Dataset m, double ... x) {
        block14: {
            r = d.getRank();
            if (r != x.length) {
                throw new IllegalArgumentException("Number of coordinates must be equal to rank of dataset");
            }
            switch (r) {
                case 1: {
                    return m == null ? Maths.interpolate(d, x[0]) : Maths.interpolate(d, m, x[0]);
                }
                case 2: {
                    return m == null ? Maths.interpolate(d, x[0], x[1]) : Maths.interpolate(d, m, x[0], x[1]);
                }
            }
            if (m != null && r != m.getRank()) {
                throw new IllegalArgumentException("Rank of mask dataset must be equal to rank of dataset");
            }
            l = new int[r];
            f = new double[r];
            i = 0;
            while (i < r) {
                xi = x[i];
                l[i] = (int)Math.floor(xi);
                f[i] = xi - (double)l[i];
                ++i;
            }
            s = d.getShape();
            n = 1 << r;
            results = new double[n];
            twos = new int[r];
            Arrays.fill(twos, 2);
            it = new PositionIterator(twos);
            ip = it.getPos();
            j = 0;
            if (m != null) ** GOTO lbl56
            while (it.hasNext()) {
                p = (int[])l.clone();
                omit = false;
                i = 0;
                while (i < r) {
                    pi = p[i] + ip[i];
                    if (pi < 0 || pi >= s[i]) {
                        omit = true;
                        break;
                    }
                    p[i] = pi;
                    ++i;
                }
                v0 = results[j++] = omit != false ? 0.0 : d.getDouble(p);
            }
            break block14;
lbl-1000:
            // 1 sources

            {
                p = (int[])l.clone();
                omit = false;
                i = 0;
                while (i < r) {
                    pi = p[i] + ip[i];
                    if (pi < 0 || pi >= s[i]) {
                        omit = true;
                        break;
                    }
                    p[i] = pi;
                    ++i;
                }
                v1 = results[j++] = omit != false ? 0.0 : d.getDouble(p) * m.getDouble(p);
lbl56:
                // 2 sources

                ** while (it.hasNext())
            }
        }
        i = r - 1;
        while (i >= 0) {
            results = Maths.combine(results, f[i], 1 << i);
            --i;
        }
        return results[0];
    }

    private static double[] combine(double[] values, double f, int n) {
        double g = 1.0 - f;
        double[] results = new double[n];
        int j = 0;
        while (j < n) {
            int tj = 2 * j;
            results[j] = g * values[tj] + f * values[tj + 1];
            ++j;
        }
        return results;
    }

    public static void interpolate(double[] values, CompoundDataset d, double ... x) {
        int r = d.getRank();
        if (r != x.length) {
            throw new IllegalArgumentException("Number of coordinates must be equal to rank of dataset");
        }
        switch (r) {
            case 1: {
                Maths.interpolate(values, d, x[0]);
                return;
            }
            case 2: {
                Maths.interpolate(values, d, x[0], x[1]);
                return;
            }
        }
        int is = d.getElementsPerItem();
        if (is != values.length) {
            throw new IllegalArgumentException("Output array length must match elements in item");
        }
        int[] l = new int[r];
        double[] f = new double[r];
        int i = 0;
        while (i < r) {
            double xi = x[i];
            l[i] = (int)Math.floor(xi);
            f[i] = xi - (double)l[i];
            ++i;
        }
        int[] s = d.getShape();
        int n = 1 << r;
        double[][] results = new double[n][is];
        int[] twos = new int[r];
        Arrays.fill(twos, 2);
        PositionIterator it = new PositionIterator(twos);
        int[] ip = it.getPos();
        int j = 0;
        while (it.hasNext()) {
            int[] p = (int[])l.clone();
            boolean omit = false;
            int i2 = 0;
            while (i2 < r) {
                int pi = p[i2] + ip[i2];
                if (pi < 0 || pi >= s[i2]) {
                    omit = true;
                    break;
                }
                p[i2] = pi;
                ++i2;
            }
            if (omit) continue;
            d.getDoubleArray(results[j++], p);
        }
        int i3 = r - 1;
        while (i3 >= 0) {
            results = Maths.combineArray(is, results, f[i3], 1 << i3);
            --i3;
        }
        int k = 0;
        while (k < is) {
            values[k] = results[0][k];
            ++k;
        }
    }

    private static double[][] combineArray(int is, double[][] values, double f, int n) {
        double g = 1.0 - f;
        double[][] results = new double[n][is];
        int j = 0;
        while (j < n) {
            int tj = 2 * j;
            int k = 0;
            while (k < is) {
                results[j][k] = g * values[tj][k] + f * values[tj + 1][k];
                ++k;
            }
            ++j;
        }
        return results;
    }

    @Deprecated
    public static double getLinear(IDataset d, double x0) {
        return Maths.interpolate(DatasetUtils.convertToDataset(d), x0);
    }

    @Deprecated
    public static void getLinear(double[] values, CompoundDataset d, double x0) {
        Maths.interpolate(values, d, x0);
    }

    @Deprecated
    public static double getBilinear(IDataset d, double x0, double x1) {
        return Maths.interpolate(DatasetUtils.convertToDataset(d), x0, x1);
    }

    @Deprecated
    public static double getBilinear(IDataset d, IDataset m, double x0, double x1) {
        return Maths.interpolate(DatasetUtils.convertToDataset(d), DatasetUtils.convertToDataset(m), x0, x1);
    }

    @Deprecated
    public static void getBilinear(double[] values, CompoundDataset d, double x0, double x1) {
        Maths.interpolate(values, d, x0, x1);
    }

    private static int[] bincoeff(int n) {
        int bc;
        int[] b = new int[n + 1];
        int hn = n / 2;
        b[0] = bc = 1;
        int i = 1;
        while (i <= hn) {
            b[i] = bc = -(bc * (n - i + 1)) / i;
            ++i;
        }
        if (n % 2 != 0) {
            i = hn + 1;
            while (i <= n) {
                b[i] = -b[n - i];
                ++i;
            }
        } else {
            i = hn + 1;
            while (i <= n) {
                b[i] = b[n - i];
                ++i;
            }
        }
        return b;
    }

    private static void difference(Dataset a, Dataset out) {
        int isize = a.getElementsPerItem();
        IndexIterator it = a.getIterator();
        if (!it.hasNext()) {
            return;
        }
        int oi = it.index;
        switch (a.getDType()) {
            case 1: {
                byte[] i8data = ((ByteDataset)a).getData();
                byte[] oi8data = ((ByteDataset)out).getData();
                int i = 0;
                while (it.hasNext()) {
                    oi8data[i++] = (byte)(i8data[it.index] - i8data[oi]);
                    oi = it.index;
                }
                break;
            }
            case 2: {
                short[] i16data = ((ShortDataset)a).getData();
                short[] oi16data = ((ShortDataset)out).getData();
                int i = 0;
                while (it.hasNext()) {
                    oi16data[i++] = (short)(i16data[it.index] - i16data[oi]);
                    oi = it.index;
                }
                break;
            }
            case 3: {
                int[] i32data = ((IntegerDataset)a).getData();
                int[] oi32data = ((IntegerDataset)out).getData();
                int i = 0;
                while (it.hasNext()) {
                    oi32data[i++] = i32data[it.index] - i32data[oi];
                    oi = it.index;
                }
                break;
            }
            case 4: {
                long[] i64data = ((LongDataset)a).getData();
                long[] oi64data = ((LongDataset)out).getData();
                int i = 0;
                while (it.hasNext()) {
                    oi64data[i++] = i64data[it.index] - i64data[oi];
                    oi = it.index;
                }
                break;
            }
            case 100: {
                byte[] ai8data = ((CompoundByteDataset)a).getData();
                byte[] oai8data = ((CompoundByteDataset)out).getData();
                int i = 0;
                while (it.hasNext()) {
                    int k = 0;
                    while (k < isize) {
                        oai8data[i++] = (byte)(ai8data[it.index + k] - ai8data[oi++]);
                        ++k;
                    }
                    oi = it.index;
                }
                break;
            }
            case 200: {
                short[] ai16data = ((CompoundShortDataset)a).getData();
                short[] oai16data = ((CompoundShortDataset)out).getData();
                int i = 0;
                while (it.hasNext()) {
                    int k = 0;
                    while (k < isize) {
                        oai16data[i++] = (short)(ai16data[it.index + k] - ai16data[oi++]);
                        ++k;
                    }
                    oi = it.index;
                }
                break;
            }
            case 300: {
                int[] ai32data = ((CompoundIntegerDataset)a).getData();
                int[] oai32data = ((CompoundIntegerDataset)out).getData();
                int i = 0;
                while (it.hasNext()) {
                    int k = 0;
                    while (k < isize) {
                        oai32data[i++] = ai32data[it.index + k] - ai32data[oi++];
                        ++k;
                    }
                    oi = it.index;
                }
                break;
            }
            case 400: {
                long[] ai64data = ((CompoundLongDataset)a).getData();
                long[] oai64data = ((CompoundLongDataset)out).getData();
                int i = 0;
                while (it.hasNext()) {
                    int k = 0;
                    while (k < isize) {
                        oai64data[i++] = ai64data[it.index + k] - ai64data[oi++];
                        ++k;
                    }
                    oi = it.index;
                }
                break;
            }
            case 5: {
                float[] f32data = ((FloatDataset)a).getData();
                float[] of32data = ((FloatDataset)out).getData();
                int i = 0;
                while (it.hasNext()) {
                    of32data[i++] = f32data[it.index] - f32data[oi];
                    oi = it.index;
                }
                break;
            }
            case 6: {
                double[] f64data = ((DoubleDataset)a).getData();
                double[] of64data = ((DoubleDataset)out).getData();
                int i = 0;
                while (it.hasNext()) {
                    of64data[i++] = f64data[it.index] - f64data[oi];
                    oi = it.index;
                }
                break;
            }
            case 7: {
                float[] c64data = ((ComplexFloatDataset)a).getData();
                float[] oc64data = ((ComplexFloatDataset)out).getData();
                int i = 0;
                while (it.hasNext()) {
                    oc64data[i++] = c64data[it.index] - c64data[oi];
                    oc64data[i++] = c64data[it.index + 1] - c64data[oi + 1];
                    oi = it.index;
                }
                break;
            }
            case 8: {
                double[] c128data = ((ComplexDoubleDataset)a).getData();
                double[] oc128data = ((ComplexDoubleDataset)out).getData();
                int i = 0;
                while (it.hasNext()) {
                    oc128data[i++] = c128data[it.index] - c128data[oi];
                    oc128data[i++] = c128data[it.index + 1] - c128data[oi + 1];
                    oi = it.index;
                }
                break;
            }
            case 500: {
                float[] af32data = ((CompoundFloatDataset)a).getData();
                float[] oaf32data = ((CompoundFloatDataset)out).getData();
                int i = 0;
                while (it.hasNext()) {
                    int k = 0;
                    while (k < isize) {
                        oaf32data[i++] = af32data[it.index + k] - af32data[oi++];
                        ++k;
                    }
                    oi = it.index;
                }
                break;
            }
            case 600: {
                double[] af64data = ((CompoundDoubleDataset)a).getData();
                double[] oaf64data = ((CompoundDoubleDataset)out).getData();
                int i = 0;
                while (it.hasNext()) {
                    int k = 0;
                    while (k < isize) {
                        oaf64data[i++] = af64data[it.index + k] - af64data[oi++];
                        ++k;
                    }
                    oi = it.index;
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("difference does not support this dataset type");
            }
        }
    }

    private static boolean nextIndexes(IndexIterator it, int[] indexes) {
        if (!it.hasNext()) {
            return false;
        }
        int m = indexes.length;
        int i = 0;
        i = 0;
        while (i < m - 1) {
            indexes[i] = indexes[i + 1];
            ++i;
        }
        indexes[i] = it.index;
        return true;
    }

    private static void difference(Dataset a, Dataset out, int n) {
        if (n == 1) {
            Maths.difference(a, out);
            return;
        }
        int isize = a.getElementsPerItem();
        int[] coeff = Maths.bincoeff(n);
        int m = n + 1;
        int[] indexes = new int[m];
        IndexIterator it = a.getIterator();
        int i = 0;
        while (i < n) {
            indexes[i] = it.index;
            it.hasNext();
            ++i;
        }
        indexes[n] = it.index;
        switch (a.getDType()) {
            case 1: {
                byte[] i8data = ((ByteDataset)a).getData();
                byte[] oi8data = ((ByteDataset)out).getData();
                int i2 = 0;
                while (Maths.nextIndexes(it, indexes)) {
                    int ox = 0;
                    int j = 0;
                    while (j < m) {
                        ox += i8data[indexes[j]] * coeff[j];
                        ++j;
                    }
                    oi8data[i2++] = (byte)ox;
                }
                break;
            }
            case 2: {
                short[] i16data = ((ShortDataset)a).getData();
                short[] oi16data = ((ShortDataset)out).getData();
                int i3 = 0;
                while (Maths.nextIndexes(it, indexes)) {
                    int ox = 0;
                    int j = 0;
                    while (j < m) {
                        ox += i16data[indexes[j]] * coeff[j];
                        ++j;
                    }
                    oi16data[i3++] = (short)ox;
                }
                break;
            }
            case 3: {
                int[] i32data = ((IntegerDataset)a).getData();
                int[] oi32data = ((IntegerDataset)out).getData();
                int i4 = 0;
                while (Maths.nextIndexes(it, indexes)) {
                    int ox = 0;
                    int j = 0;
                    while (j < m) {
                        ox += i32data[indexes[j]] * coeff[j];
                        ++j;
                    }
                    oi32data[i4++] = ox;
                }
                break;
            }
            case 4: {
                long[] i64data = ((LongDataset)a).getData();
                long[] oi64data = ((LongDataset)out).getData();
                int i5 = 0;
                while (Maths.nextIndexes(it, indexes)) {
                    long ox = 0L;
                    int j = 0;
                    while (j < m) {
                        ox += i64data[indexes[j]] * (long)coeff[j];
                        ++j;
                    }
                    oi64data[i5++] = ox;
                }
                break;
            }
            case 100: {
                byte[] ai8data = ((CompoundByteDataset)a).getData();
                byte[] oai8data = ((CompoundByteDataset)out).getData();
                int[] box = new int[isize];
                int i6 = 0;
                while (Maths.nextIndexes(it, indexes)) {
                    Arrays.fill(box, 0);
                    int j = 0;
                    while (j < m) {
                        double c = coeff[j];
                        int l = indexes[j];
                        int k = 0;
                        while (k < isize) {
                            int n2 = k++;
                            box[n2] = (int)((double)box[n2] + (double)ai8data[l++] * c);
                        }
                        ++j;
                    }
                    int k = 0;
                    while (k < isize) {
                        oai8data[i6++] = (byte)box[k];
                        ++k;
                    }
                }
                break;
            }
            case 200: {
                short[] ai16data = ((CompoundShortDataset)a).getData();
                short[] oai16data = ((CompoundShortDataset)out).getData();
                int[] sox = new int[isize];
                int i7 = 0;
                while (Maths.nextIndexes(it, indexes)) {
                    Arrays.fill(sox, 0);
                    int j = 0;
                    while (j < m) {
                        double c = coeff[j];
                        int l = indexes[j];
                        int k = 0;
                        while (k < isize) {
                            int n3 = k++;
                            sox[n3] = (int)((double)sox[n3] + (double)ai16data[l++] * c);
                        }
                        ++j;
                    }
                    int k = 0;
                    while (k < isize) {
                        oai16data[i7++] = (short)sox[k];
                        ++k;
                    }
                }
                break;
            }
            case 300: {
                int[] ai32data = ((CompoundIntegerDataset)a).getData();
                int[] oai32data = ((CompoundIntegerDataset)out).getData();
                int[] iox = new int[isize];
                int i8 = 0;
                while (Maths.nextIndexes(it, indexes)) {
                    Arrays.fill(iox, 0);
                    int j = 0;
                    while (j < m) {
                        double c = coeff[j];
                        int l = indexes[j];
                        int k = 0;
                        while (k < isize) {
                            int n4 = k++;
                            iox[n4] = (int)((double)iox[n4] + (double)ai32data[l++] * c);
                        }
                        ++j;
                    }
                    int k = 0;
                    while (k < isize) {
                        oai32data[i8++] = iox[k];
                        ++k;
                    }
                }
                break;
            }
            case 400: {
                long[] ai64data = ((CompoundLongDataset)a).getData();
                long[] oai64data = ((CompoundLongDataset)out).getData();
                long[] lox = new long[isize];
                int i9 = 0;
                while (Maths.nextIndexes(it, indexes)) {
                    Arrays.fill(lox, 0L);
                    int j = 0;
                    while (j < m) {
                        double c = coeff[j];
                        int l = indexes[j];
                        int k = 0;
                        while (k < isize) {
                            int n5 = k++;
                            lox[n5] = (long)((double)lox[n5] + (double)ai64data[l++] * c);
                        }
                        ++j;
                    }
                    int k = 0;
                    while (k < isize) {
                        oai64data[i9++] = lox[k];
                        ++k;
                    }
                }
                break;
            }
            case 5: {
                float[] f32data = ((FloatDataset)a).getData();
                float[] of32data = ((FloatDataset)out).getData();
                int i10 = 0;
                while (Maths.nextIndexes(it, indexes)) {
                    float ox = 0.0f;
                    int j = 0;
                    while (j < m) {
                        ox += f32data[indexes[j]] * (float)coeff[j];
                        ++j;
                    }
                    of32data[i10++] = ox;
                }
                break;
            }
            case 6: {
                double[] f64data = ((DoubleDataset)a).getData();
                double[] of64data = ((DoubleDataset)out).getData();
                int i11 = 0;
                while (Maths.nextIndexes(it, indexes)) {
                    double ox = 0.0;
                    int j = 0;
                    while (j < m) {
                        ox += f64data[indexes[j]] * (double)coeff[j];
                        ++j;
                    }
                    of64data[i11++] = ox;
                }
                break;
            }
            case 7: {
                float[] c64data = ((ComplexFloatDataset)a).getData();
                float[] oc64data = ((ComplexFloatDataset)out).getData();
                int i12 = 0;
                while (Maths.nextIndexes(it, indexes)) {
                    float ox = 0.0f;
                    float oy = 0.0f;
                    int j = 0;
                    while (j < m) {
                        int l = indexes[j];
                        ox += c64data[l++] * (float)coeff[j];
                        oy += c64data[l] * (float)coeff[j];
                        ++j;
                    }
                    oc64data[i12++] = ox;
                    oc64data[i12++] = oy;
                }
                break;
            }
            case 8: {
                double[] c128data = ((ComplexDoubleDataset)a).getData();
                double[] oc128data = ((ComplexDoubleDataset)out).getData();
                int i13 = 0;
                while (Maths.nextIndexes(it, indexes)) {
                    double ox = 0.0;
                    double oy = 0.0;
                    int j = 0;
                    while (j < m) {
                        int l = indexes[j];
                        ox += c128data[l++] * (double)coeff[j];
                        oy += c128data[l] * (double)coeff[j];
                        ++j;
                    }
                    oc128data[i13++] = ox;
                    oc128data[i13++] = oy;
                }
                break;
            }
            case 500: {
                float[] af32data = ((CompoundFloatDataset)a).getData();
                float[] oaf32data = ((CompoundFloatDataset)out).getData();
                float[] fox = new float[isize];
                int i14 = 0;
                while (Maths.nextIndexes(it, indexes)) {
                    Arrays.fill(fox, 0.0f);
                    int j = 0;
                    while (j < m) {
                        double c = coeff[j];
                        int l = indexes[j];
                        int k = 0;
                        while (k < isize) {
                            int n6 = k++;
                            fox[n6] = (float)((double)fox[n6] + (double)af32data[l++] * c);
                        }
                        ++j;
                    }
                    int k = 0;
                    while (k < isize) {
                        oaf32data[i14++] = fox[k];
                        ++k;
                    }
                }
                break;
            }
            case 600: {
                double[] af64data = ((CompoundDoubleDataset)a).getData();
                double[] oaf64data = ((CompoundDoubleDataset)out).getData();
                double[] dox = new double[isize];
                int i15 = 0;
                while (Maths.nextIndexes(it, indexes)) {
                    Arrays.fill(dox, 0.0);
                    int j = 0;
                    while (j < m) {
                        double c = coeff[j];
                        int l = indexes[j];
                        int k = 0;
                        while (k < isize) {
                            int n7 = k++;
                            dox[n7] = dox[n7] + af64data[l++] * c;
                        }
                        ++j;
                    }
                    int k = 0;
                    while (k < isize) {
                        oaf64data[i15++] = dox[k];
                        ++k;
                    }
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("difference does not support multiple-element dataset");
            }
        }
    }

    public static Dataset difference(Dataset a, int n, int axis) {
        Class<?> clazz = a.getClass();
        int rank = a.getRank();
        int is = a.getElementsPerItem();
        if (axis < 0) {
            axis += rank;
        }
        if (axis < 0 || axis >= rank) {
            throw new IllegalArgumentException("Axis is out of range");
        }
        int[] nshape = a.getShape();
        if (nshape[axis] <= n) {
            nshape[axis] = 0;
            return DatasetFactory.zeros(is, clazz, nshape);
        }
        int n2 = axis;
        nshape[n2] = nshape[n2] - n;
        Object ds = DatasetFactory.zeros(is, clazz, nshape);
        if (rank == 1) {
            Maths.difference(a, ds, n);
        } else {
            Object src = DatasetFactory.zeros(is, clazz, a.getShapeRef()[axis]);
            Object dest = DatasetFactory.zeros(is, clazz, nshape[axis]);
            PositionIterator pi = a.getPositionIterator(axis);
            int[] pos = pi.getPos();
            boolean[] hit = pi.getOmit();
            while (pi.hasNext()) {
                a.copyItemsFromAxes(pos, hit, (Dataset)src);
                Maths.difference(src, dest, n);
                ds.setItemsOnAxes(pos, hit, dest.getBuffer());
            }
        }
        return ds;
    }

    private static double selectedMean(Dataset data, int min, int max) {
        double result = 0.0;
        int i = min;
        int end = data.getSize() - 1;
        while (i <= max) {
            int pos = Math.min(Math.max(0, i), end);
            result += data.getDouble(pos);
            ++i;
        }
        return result /= (double)(max - min + 1);
    }

    private static void selectedMeanArray(double[] out, Dataset data, int min, int max) {
        Arrays.fill(out, 0.0);
        int isize = out.length;
        int i = min;
        int end = data.getSize() - 1;
        while (i <= max) {
            int off = data.get1DIndex(Math.min(Math.max(0, i), end));
            int j = 0;
            while (j < isize) {
                int n = j++;
                out[n] = out[n] + data.getElementDoubleAbs(off++);
            }
            ++i;
        }
        double norm = 1.0 / ((double)(max - min) + 1.0);
        int j = 0;
        while (j < isize) {
            int n = j++;
            out[n] = out[n] * norm;
        }
    }

    public static Dataset derivative(Dataset x, Dataset y, int n) {
        Dataset result;
        if (x.getRank() != 1 || y.getRank() != 1) {
            throw new IllegalArgumentException("Only one dimensional dataset supported");
        }
        if (y.getSize() > x.getSize()) {
            throw new IllegalArgumentException("Length of x dataset should be greater than or equal to y's");
        }
        int dtype = y.getDType();
        switch (dtype) {
            case 0: 
            case 1: 
            case 2: 
            case 100: 
            case 200: {
                result = DatasetFactory.zeros(y, FloatDataset.class);
                break;
            }
            case 3: 
            case 4: 
            case 300: 
            case 400: {
                result = DatasetFactory.zeros(y, DoubleDataset.class);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 500: 
            case 600: {
                result = DatasetFactory.zeros(y);
                break;
            }
            default: {
                throw new UnsupportedOperationException("derivative does not support multiple-element dataset");
            }
        }
        int isize = y.getElementsPerItem();
        if (isize == 1) {
            int i = 0;
            int imax = x.getSize();
            while (i < imax) {
                double LeftValue = Maths.selectedMean(y, i - n, i - 1);
                double RightValue = Maths.selectedMean(y, i + 1, i + n);
                double LeftPosition = Maths.selectedMean(x, i - n, i - 1);
                double RightPosition = Maths.selectedMean(x, i + 1, i + n);
                result.set((Object)((RightValue - LeftValue) / (RightPosition - LeftPosition)), i);
                ++i;
            }
        } else {
            double[] leftValues = new double[isize];
            double[] rightValues = new double[isize];
            int i = 0;
            int imax = x.getSize();
            while (i < imax) {
                Maths.selectedMeanArray(leftValues, y, i - n, i - 1);
                Maths.selectedMeanArray(rightValues, y, i + 1, i + n);
                double delta = Maths.selectedMean(x, i - n, i - 1);
                delta = 1.0 / (Maths.selectedMean(x, i + 1, i + n) - delta);
                int j = 0;
                while (j < isize) {
                    int n2 = j;
                    rightValues[n2] = rightValues[n2] - leftValues[j];
                    int n3 = j++;
                    rightValues[n3] = rightValues[n3] * delta;
                }
                result.set((Object)rightValues, i);
                ++i;
            }
        }
        result.setName(String.valueOf(y.getName()) + "'");
        return result;
    }

    public static Dataset centralDifference(Dataset a, int axis) {
        Class<?> clazz = a.getClass();
        int rank = a.getRank();
        int is = a.getElementsPerItem();
        if (axis < 0) {
            axis += rank;
        }
        if (axis < 0 || axis >= rank) {
            throw new IllegalArgumentException("Axis is out of range");
        }
        int len = a.getShapeRef()[axis];
        if (len < 2) {
            throw new IllegalArgumentException("Dataset should have a size > 1 along given axis");
        }
        Object ds = DatasetFactory.zeros(is, clazz, a.getShapeRef());
        if (rank == 1) {
            Maths.centralDifference(a, ds);
        } else {
            Object src = DatasetFactory.zeros(is, clazz, len);
            Object dest = DatasetFactory.zeros(is, clazz, len);
            PositionIterator pi = a.getPositionIterator(axis);
            int[] pos = pi.getPos();
            boolean[] hit = pi.getOmit();
            while (pi.hasNext()) {
                a.copyItemsFromAxes(pos, hit, (Dataset)src);
                Maths.centralDifference(src, dest);
                ds.setItemsOnAxes(pos, hit, dest.getBuffer());
            }
        }
        return ds;
    }

    private static void centralDifference(Dataset a, Dataset out) {
        int isize = a.getElementsPerItem();
        int dt = a.getDType();
        int nlen = (out.getShapeRef()[0] - 1) * isize;
        if (nlen < 1) {
            throw new IllegalArgumentException("Dataset should have a size > 1 along given axis");
        }
        IndexIterator it = a.getIterator();
        if (!it.hasNext()) {
            return;
        }
        int oi = it.index;
        if (!it.hasNext()) {
            return;
        }
        int pi = it.index;
        switch (dt) {
            case 1: {
                byte[] i8data = ((ByteDataset)a).getData();
                byte[] oi8data = ((ByteDataset)out).getData();
                oi8data[0] = (byte)(i8data[pi] - i8data[oi]);
                int i = 1;
                while (it.hasNext()) {
                    oi8data[i] = (byte)((i8data[it.index] - i8data[oi]) / 2);
                    oi = pi;
                    pi = it.index;
                    ++i;
                }
                oi8data[nlen] = (byte)(i8data[pi] - i8data[oi]);
                break;
            }
            case 2: {
                short[] i16data = ((ShortDataset)a).getData();
                short[] oi16data = ((ShortDataset)out).getData();
                oi16data[0] = (short)(i16data[pi] - i16data[oi]);
                int i = 1;
                while (it.hasNext()) {
                    oi16data[i] = (short)((i16data[it.index] - i16data[oi]) / 2);
                    oi = pi;
                    pi = it.index;
                    ++i;
                }
                oi16data[nlen] = (short)(i16data[pi] - i16data[oi]);
                break;
            }
            case 3: {
                int[] i32data = ((IntegerDataset)a).getData();
                int[] oi32data = ((IntegerDataset)out).getData();
                oi32data[0] = i32data[pi] - i32data[oi];
                int i = 1;
                while (it.hasNext()) {
                    oi32data[i] = (i32data[it.index] - i32data[oi]) / 2;
                    oi = pi;
                    pi = it.index;
                    ++i;
                }
                oi32data[nlen] = i32data[pi] - i32data[oi];
                break;
            }
            case 4: {
                long[] i64data = ((LongDataset)a).getData();
                long[] oi64data = ((LongDataset)out).getData();
                oi64data[0] = i64data[pi] - i64data[oi];
                int i = 1;
                while (it.hasNext()) {
                    oi64data[i] = (i64data[it.index] - i64data[oi]) / 2L;
                    oi = pi;
                    pi = it.index;
                    ++i;
                }
                oi64data[nlen] = i64data[pi] - i64data[oi];
                break;
            }
            case 100: {
                byte[] ai8data = ((CompoundByteDataset)a).getData();
                byte[] oai8data = ((CompoundByteDataset)out).getData();
                int k = 0;
                while (k < isize) {
                    oai8data[k] = (byte)(ai8data[pi + k] - ai8data[oi + k]);
                    ++k;
                }
                int i = isize;
                while (it.hasNext()) {
                    int l = it.index;
                    int k2 = 0;
                    while (k2 < isize) {
                        oai8data[i++] = (byte)((ai8data[l++] - ai8data[oi++]) / 2);
                        ++k2;
                    }
                    oi = pi;
                    pi = it.index;
                }
                k = 0;
                while (k < isize) {
                    oai8data[nlen + k] = (byte)(ai8data[pi + k] - ai8data[oi + k]);
                    ++k;
                }
                break;
            }
            case 200: {
                short[] ai16data = ((CompoundShortDataset)a).getData();
                short[] oai16data = ((CompoundShortDataset)out).getData();
                int k = 0;
                while (k < isize) {
                    oai16data[k] = (short)(ai16data[pi + k] - ai16data[oi + k]);
                    ++k;
                }
                int i = isize;
                while (it.hasNext()) {
                    int l = it.index;
                    int k3 = 0;
                    while (k3 < isize) {
                        oai16data[i++] = (short)((ai16data[l++] - ai16data[oi++]) / 2);
                        ++k3;
                    }
                    oi = pi;
                    pi = it.index;
                }
                k = 0;
                while (k < isize) {
                    oai16data[nlen + k] = (short)(ai16data[pi + k] - ai16data[oi + k]);
                    ++k;
                }
                break;
            }
            case 300: {
                int[] ai32data = ((CompoundIntegerDataset)a).getData();
                int[] oai32data = ((CompoundIntegerDataset)out).getData();
                int k = 0;
                while (k < isize) {
                    oai32data[k] = ai32data[pi + k] - ai32data[oi + k];
                    ++k;
                }
                int i = isize;
                while (it.hasNext()) {
                    int l = it.index;
                    int k4 = 0;
                    while (k4 < isize) {
                        oai32data[i++] = (ai32data[l++] - ai32data[oi++]) / 2;
                        ++k4;
                    }
                    oi = pi;
                    pi = it.index;
                }
                k = 0;
                while (k < isize) {
                    oai32data[nlen + k] = ai32data[pi + k] - ai32data[oi + k];
                    ++k;
                }
                break;
            }
            case 400: {
                long[] ai64data = ((CompoundLongDataset)a).getData();
                long[] oai64data = ((CompoundLongDataset)out).getData();
                int k = 0;
                while (k < isize) {
                    oai64data[k] = ai64data[pi + k] - ai64data[oi + k];
                    ++k;
                }
                int i = isize;
                while (it.hasNext()) {
                    int l = it.index;
                    int k5 = 0;
                    while (k5 < isize) {
                        oai64data[i++] = (ai64data[l++] - ai64data[oi++]) / 2L;
                        ++k5;
                    }
                    oi = pi;
                    pi = it.index;
                }
                k = 0;
                while (k < isize) {
                    oai64data[nlen + k] = ai64data[pi + k] - ai64data[oi + k];
                    ++k;
                }
                break;
            }
            case 5: {
                float[] f32data = ((FloatDataset)a).getData();
                float[] of32data = ((FloatDataset)out).getData();
                of32data[0] = f32data[pi] - f32data[oi];
                int i = 1;
                while (it.hasNext()) {
                    of32data[i] = (f32data[it.index] - f32data[oi]) * 0.5f;
                    oi = pi;
                    pi = it.index;
                    ++i;
                }
                of32data[nlen] = f32data[pi] - f32data[oi];
                break;
            }
            case 6: {
                double[] f64data = ((DoubleDataset)a).getData();
                double[] of64data = ((DoubleDataset)out).getData();
                of64data[0] = f64data[pi] - f64data[oi];
                int i = 1;
                while (it.hasNext()) {
                    of64data[i] = (f64data[it.index] - f64data[oi]) * 0.5;
                    oi = pi;
                    pi = it.index;
                    ++i;
                }
                of64data[nlen] = f64data[pi] - f64data[oi];
                break;
            }
            case 7: {
                float[] c64data = ((ComplexFloatDataset)a).getData();
                float[] oc64data = ((ComplexFloatDataset)out).getData();
                oc64data[0] = c64data[pi] - c64data[oi];
                oc64data[1] = c64data[pi + 1] - c64data[oi + 1];
                int i = 2;
                while (it.hasNext()) {
                    oc64data[i++] = (c64data[it.index] - c64data[oi++]) * 0.5f;
                    oc64data[i++] = (c64data[it.index + 1] - c64data[oi]) * 0.5f;
                    oi = pi;
                    pi = it.index;
                }
                oc64data[nlen] = c64data[pi] - c64data[oi];
                oc64data[nlen + 1] = c64data[pi + 1] - c64data[oi + 1];
                break;
            }
            case 8: {
                double[] c128data = ((ComplexDoubleDataset)a).getData();
                double[] oc128data = ((ComplexDoubleDataset)out).getData();
                oc128data[0] = c128data[pi] - c128data[oi];
                oc128data[1] = c128data[pi + 1] - c128data[oi + 1];
                int i = 2;
                while (it.hasNext()) {
                    oc128data[i++] = (c128data[it.index] - c128data[oi++]) * 0.5;
                    oc128data[i++] = (c128data[it.index + 1] - c128data[oi]) * 0.5;
                    oi = pi;
                    pi = it.index;
                }
                oc128data[nlen] = c128data[pi] - c128data[oi];
                oc128data[nlen + 1] = c128data[pi + 1] - c128data[oi + 1];
                break;
            }
            case 500: {
                float[] af32data = ((CompoundFloatDataset)a).getData();
                float[] oaf32data = ((CompoundFloatDataset)out).getData();
                int k = 0;
                while (k < isize) {
                    oaf32data[k] = af32data[pi + k] - af32data[oi + k];
                    ++k;
                }
                int i = isize;
                while (it.hasNext()) {
                    int l = it.index;
                    int k6 = 0;
                    while (k6 < isize) {
                        oaf32data[i++] = (af32data[l++] - af32data[oi++]) * 0.5f;
                        ++k6;
                    }
                    oi = pi;
                    pi = it.index;
                }
                k = 0;
                while (k < isize) {
                    oaf32data[nlen + k] = af32data[pi + k] - af32data[oi + k];
                    ++k;
                }
                break;
            }
            case 600: {
                double[] af64data = ((CompoundDoubleDataset)a).getData();
                double[] oaf64data = ((CompoundDoubleDataset)out).getData();
                int k = 0;
                while (k < isize) {
                    oaf64data[k] = af64data[pi + k] - af64data[oi + k];
                    ++k;
                }
                int i = isize;
                while (it.hasNext()) {
                    int l = it.index;
                    int k7 = 0;
                    while (k7 < isize) {
                        oaf64data[i++] = (af64data[l++] - af64data[oi++]) * 0.5;
                        ++k7;
                    }
                    oi = pi;
                    pi = it.index;
                }
                k = 0;
                while (k < isize) {
                    oaf64data[nlen + k] = af64data[pi + k] - af64data[oi + k];
                    ++k;
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("difference does not support this dataset type");
            }
        }
    }

    public static List<Dataset> gradient(Dataset y, Dataset ... x) {
        Dataset g;
        int rank = y.getRank();
        if (x.length > 0) {
            if (x.length != rank) {
                throw new IllegalArgumentException("Number of dependent datasets must be equal to rank of first argument");
            }
            int a = 0;
            while (a < rank) {
                int rx = x[a].getRank();
                if (rx != rank && rx != 1) {
                    throw new IllegalArgumentException("Dependent datasets must be 1-D or match rank of first argument");
                }
                if (rx == 1) {
                    if (y.getShapeRef()[a] != x[a].getShapeRef()[0]) {
                        throw new IllegalArgumentException("Length of dependent dataset must match axis length");
                    }
                } else {
                    y.checkCompatibility(x[a]);
                }
                ++a;
            }
        }
        ArrayList<Dataset> grad = new ArrayList<Dataset>(rank);
        int a = 0;
        while (a < rank) {
            g = Maths.centralDifference(y, a);
            grad.add(g);
            ++a;
        }
        if (x.length > 0) {
            a = 0;
            while (a < rank) {
                g = (Dataset)grad.get(a);
                Dataset dx = x[a];
                int r = dx.getRank();
                if (r == rank) {
                    g.idivide(Maths.centralDifference(dx, a));
                } else {
                    int is = dx.getElementsPerItem();
                    Object bdx = DatasetFactory.zeros(is, dx.getClass(), y.getShapeRef());
                    PositionIterator pi = y.getPositionIterator(a);
                    int[] pos = pi.getPos();
                    boolean[] hit = pi.getOmit();
                    dx = Maths.centralDifference(dx, 0);
                    while (pi.hasNext()) {
                        bdx.setItemsOnAxes(pos, hit, dx.getBuffer());
                    }
                    g.idivide(bdx);
                }
                ++a;
            }
        }
        return grad;
    }

    protected static void addFunctionName(Dataset a, Dataset b, Dataset dataset, String fname) {
        dataset.setName(Operations.createFunctionName(fname, a.getName(), b.getName()));
    }

    protected static void addFunctionName(Dataset dataset, String fname) {
        dataset.setName(Operations.createFunctionName(fname, dataset.getName()));
    }

    protected static void addBinaryOperatorName(Dataset a, Dataset b, Dataset dataset, String oname) {
        dataset.setName(Operations.createBinaryOperationName(oname, a.getName(), b.getName()));
    }

    protected static final long toLong(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return 0L;
        }
        return (long)d;
    }

    public static Dataset add(Object a, Object b) {
        return Maths.add(a, b, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset add(Object a, Object b, Dataset o) {
        da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        it = BroadcastIterator.createIterator(da, db = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b), o, true);
        result = it.getOutput();
        if (!result.isComplex()) {
            change = false;
            if (da.isComplex()) {
                da = da.getRealView();
                change = true;
            }
            if (db.isComplex()) {
                db = db.getRealView();
                change = true;
            }
            if (change) {
                it = BroadcastIterator.createIterator(da, db, result, true);
            }
        }
        is = result.getElementsPerItem();
        as = da.getElementsPerItem();
        bs = db.getElementsPerItem();
        dt = result.getDType();
        switch (dt) {
            case 1: {
                oi8data = ((ByteDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl31
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oi8data[it.oIndex] = ox = (byte)Maths.toLong(iax + ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi8data[it.oIndex] = ox = (byte)(iax + ibx);
lbl31:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl32:
                // 1 sources

                break;
            }
            case 2: {
                oi16data = ((ShortDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl45
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oi16data[it.oIndex] = ox = (short)Maths.toLong(iax + ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi16data[it.oIndex] = ox = (short)(iax + ibx);
lbl45:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl46:
                // 1 sources

                break;
            }
            case 4: {
                oi64data = ((LongDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl59
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oi64data[it.oIndex] = ox = Maths.toLong(iax + ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi64data[it.oIndex] = ox = iax + ibx;
lbl59:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl60:
                // 1 sources

                break;
            }
            case 3: {
                oi32data = ((IntegerDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl73
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oi32data[it.oIndex] = ox = (int)Maths.toLong(iax + ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi32data[it.oIndex] = ox = (int)(iax + ibx);
lbl73:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl74:
                // 1 sources

                break;
            }
            case 100: {
                oai8data = ((CompoundByteDataset)result).getData();
                if (is != 1) ** GOTO lbl90
                if (!it.isOutputDouble()) ** GOTO lbl88
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(iax + ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)(iax + ibx);
lbl88:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl89:
                // 1 sources

                break;
lbl90:
                // 1 sources

                if (as >= bs) ** GOTO lbl115
                if (!it.isOutputDouble()) ** GOTO lbl113
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(iax + ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(iax + ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)(iax + ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)(iax + ibx);
                        ++j;
                    }
lbl113:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl114:
                // 1 sources

                break;
lbl115:
                // 1 sources

                if (as <= bs) ** GOTO lbl140
                if (!it.isOutputDouble()) ** GOTO lbl138
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(iax + ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(iax + ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)(iax + ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)(iax + ibx);
                        ++j;
                    }
lbl138:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl139:
                // 1 sources

                break;
lbl140:
                // 1 sources

                if (as != 1) ** GOTO lbl163
                if (!it.isOutputDouble()) ** GOTO lbl161
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = (byte)Maths.toLong(iax + ibx);
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (byte)(iax + ibx);
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl161:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl162:
                // 1 sources

                break;
lbl163:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl187
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(iax + ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(iax + ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)(iax + ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)(iax + ibx);
                        ++j;
                    }
lbl187:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl188:
                // 1 sources

                break;
            }
            case 200: {
                oai16data = ((CompoundShortDataset)result).getData();
                if (is != 1) ** GOTO lbl204
                if (!it.isOutputDouble()) ** GOTO lbl202
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(iax + ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)(iax + ibx);
lbl202:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl203:
                // 1 sources

                break;
lbl204:
                // 1 sources

                if (as >= bs) ** GOTO lbl229
                if (!it.isOutputDouble()) ** GOTO lbl227
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(iax + ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(iax + ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)(iax + ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)(iax + ibx);
                        ++j;
                    }
lbl227:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl228:
                // 1 sources

                break;
lbl229:
                // 1 sources

                if (as <= bs) ** GOTO lbl254
                if (!it.isOutputDouble()) ** GOTO lbl252
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(iax + ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(iax + ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)(iax + ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)(iax + ibx);
                        ++j;
                    }
lbl252:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl253:
                // 1 sources

                break;
lbl254:
                // 1 sources

                if (as != 1) ** GOTO lbl277
                if (!it.isOutputDouble()) ** GOTO lbl275
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = (short)Maths.toLong(iax + ibx);
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (short)(iax + ibx);
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl275:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl276:
                // 1 sources

                break;
lbl277:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl301
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(iax + ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(iax + ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)(iax + ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)(iax + ibx);
                        ++j;
                    }
lbl301:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl302:
                // 1 sources

                break;
            }
            case 400: {
                oai64data = ((CompoundLongDataset)result).getData();
                if (is != 1) ** GOTO lbl318
                if (!it.isOutputDouble()) ** GOTO lbl316
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(iax + ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = iax + ibx;
lbl316:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl317:
                // 1 sources

                break;
lbl318:
                // 1 sources

                if (as >= bs) ** GOTO lbl343
                if (!it.isOutputDouble()) ** GOTO lbl341
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(iax + ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(iax + ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = iax + ibx;
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = iax + ibx;
                        ++j;
                    }
lbl341:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl342:
                // 1 sources

                break;
lbl343:
                // 1 sources

                if (as <= bs) ** GOTO lbl368
                if (!it.isOutputDouble()) ** GOTO lbl366
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(iax + ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(iax + ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = iax + ibx;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = iax + ibx;
                        ++j;
                    }
lbl366:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl367:
                // 1 sources

                break;
lbl368:
                // 1 sources

                if (as != 1) ** GOTO lbl391
                if (!it.isOutputDouble()) ** GOTO lbl389
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = Maths.toLong(iax + ibx);
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = iax + ibx;
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl389:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl390:
                // 1 sources

                break;
lbl391:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl415
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(iax + ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(iax + ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = iax + ibx;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = iax + ibx;
                        ++j;
                    }
lbl415:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl416:
                // 1 sources

                break;
            }
            case 300: {
                oai32data = ((CompoundIntegerDataset)result).getData();
                if (is != 1) ** GOTO lbl432
                if (!it.isOutputDouble()) ** GOTO lbl430
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(iax + ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)(iax + ibx);
lbl430:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl431:
                // 1 sources

                break;
lbl432:
                // 1 sources

                if (as >= bs) ** GOTO lbl457
                if (!it.isOutputDouble()) ** GOTO lbl455
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(iax + ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(iax + ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)(iax + ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)(iax + ibx);
                        ++j;
                    }
lbl455:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl456:
                // 1 sources

                break;
lbl457:
                // 1 sources

                if (as <= bs) ** GOTO lbl482
                if (!it.isOutputDouble()) ** GOTO lbl480
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(iax + ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(iax + ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)(iax + ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)(iax + ibx);
                        ++j;
                    }
lbl480:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl481:
                // 1 sources

                break;
lbl482:
                // 1 sources

                if (as != 1) ** GOTO lbl505
                if (!it.isOutputDouble()) ** GOTO lbl503
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = (int)Maths.toLong(iax + ibx);
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (int)(iax + ibx);
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl503:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl504:
                // 1 sources

                break;
lbl505:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl529
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(iax + ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(iax + ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)(iax + ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)(iax + ibx);
                        ++j;
                    }
lbl529:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl530:
                // 1 sources

                break;
            }
            case 5: {
                of32data = ((FloatDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl543
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    of32data[it.oIndex] = ox = (float)(iax + ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    of32data[it.oIndex] = ox = (float)(iax + ibx);
lbl543:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl544:
                // 1 sources

                break;
            }
            case 6: {
                of64data = ((DoubleDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl557
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    of64data[it.oIndex] = ox = iax + ibx;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    of64data[it.oIndex] = ox = (double)(iax + ibx);
lbl557:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl558:
                // 1 sources

                break;
            }
            case 500: {
                oaf32data = ((CompoundFloatDataset)result).getData();
                if (is != 1) ** GOTO lbl574
                if (!it.isOutputDouble()) ** GOTO lbl572
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)(iax + ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)(iax + ibx);
lbl572:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl573:
                // 1 sources

                break;
lbl574:
                // 1 sources

                if (as >= bs) ** GOTO lbl599
                if (!it.isOutputDouble()) ** GOTO lbl597
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)(iax + ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(iax + ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)(iax + ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(iax + ibx);
                        ++j;
                    }
lbl597:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl598:
                // 1 sources

                break;
lbl599:
                // 1 sources

                if (as <= bs) ** GOTO lbl624
                if (!it.isOutputDouble()) ** GOTO lbl622
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)(iax + ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(iax + ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)(iax + ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(iax + ibx);
                        ++j;
                    }
lbl622:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl623:
                // 1 sources

                break;
lbl624:
                // 1 sources

                if (as != 1) ** GOTO lbl647
                if (!it.isOutputDouble()) ** GOTO lbl645
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = (float)(iax + ibx);
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = iax + ibx;
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl645:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl646:
                // 1 sources

                break;
lbl647:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl671
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)(iax + ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(iax + ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)(iax + ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(iax + ibx);
                        ++j;
                    }
lbl671:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl672:
                // 1 sources

                break;
            }
            case 600: {
                oaf64data = ((CompoundDoubleDataset)result).getData();
                if (is != 1) ** GOTO lbl688
                if (!it.isOutputDouble()) ** GOTO lbl686
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = iax + ibx;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = (double)(iax + ibx);
lbl686:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl687:
                // 1 sources

                break;
lbl688:
                // 1 sources

                if (as >= bs) ** GOTO lbl713
                if (!it.isOutputDouble()) ** GOTO lbl711
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = iax + ibx;
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = iax + ibx;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = (double)(iax + ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = (double)(iax + ibx);
                        ++j;
                    }
lbl711:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl712:
                // 1 sources

                break;
lbl713:
                // 1 sources

                if (as <= bs) ** GOTO lbl738
                if (!it.isOutputDouble()) ** GOTO lbl736
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = iax + ibx;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = iax + ibx;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = (double)(iax + ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = (double)(iax + ibx);
                        ++j;
                    }
lbl736:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl737:
                // 1 sources

                break;
lbl738:
                // 1 sources

                if (as != 1) ** GOTO lbl761
                if (!it.isOutputDouble()) ** GOTO lbl759
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = iax + ibx;
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = iax + ibx;
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl759:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl760:
                // 1 sources

                break;
lbl761:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl785
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = iax + ibx;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = iax + ibx;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = (double)(iax + ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = (double)(iax + ibx);
                        ++j;
                    }
lbl785:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl786:
                // 1 sources

                break;
            }
            case 7: {
                oc64data = ((ComplexFloatDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl823
                if (!it.isOutputDouble()) ** GOTO lbl812
                iay = 0.0;
                if (!db.isComplex()) ** GOTO lbl810
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iby = db.getElementDoubleAbs(it.bIndex + 1);
                    ox = (float)(iax + ibx);
                    oy = (float)(0.0 + iby);
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iby = 0.0;
                    ox = (float)(iax + ibx);
                    oy = 0.0f;
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
lbl810:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl811:
                // 1 sources

                break;
lbl812:
                // 1 sources

                iay = 0L;
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    iby = 0L;
                    ox = iax + ibx;
                    oy = 0.0f;
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
                }
                break;
lbl823:
                // 1 sources

                if (db.isComplex()) ** GOTO lbl843
                iby = 0.0;
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iay = da.getElementDoubleAbs(it.aIndex + 1);
                    ox = (float)(iax + ibx);
                    oy = (float)(iay + 0.0);
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iay = da.getElementDoubleAbs(it.aIndex + 1);
                    iby = db.getElementDoubleAbs(it.bIndex + 1);
                    ox = (float)(iax + ibx);
                    oy = (float)(iay + iby);
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
lbl843:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl844:
                // 1 sources

                break;
            }
            case 8: {
                oc128data = ((ComplexDoubleDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl881
                if (!it.isOutputDouble()) ** GOTO lbl870
                iay = 0.0;
                if (!db.isComplex()) ** GOTO lbl868
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iby = db.getElementDoubleAbs(it.bIndex + 1);
                    ox = iax + ibx;
                    oy = 0.0 + iby;
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iby = 0.0;
                    ox = iax + ibx;
                    oy = 0.0;
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
lbl868:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl869:
                // 1 sources

                break;
lbl870:
                // 1 sources

                iay = 0L;
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    iby = 0L;
                    ox = iax + ibx;
                    oy = 0.0;
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
                }
                break;
lbl881:
                // 1 sources

                if (db.isComplex()) ** GOTO lbl901
                iby = 0.0;
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iay = da.getElementDoubleAbs(it.aIndex + 1);
                    ox = iax + ibx;
                    oy = iay + 0.0;
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iay = da.getElementDoubleAbs(it.aIndex + 1);
                    iby = db.getElementDoubleAbs(it.bIndex + 1);
                    ox = iax + ibx;
                    oy = iay + iby;
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
lbl901:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl902:
                // 1 sources

                break;
            }
            default: {
                throw new IllegalArgumentException("add supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        Maths.addBinaryOperatorName(da, db, result, "+");
        return result;
    }

    public static Dataset subtract(Object a, Object b) {
        return Maths.subtract(a, b, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset subtract(Object a, Object b, Dataset o) {
        da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        it = BroadcastIterator.createIterator(da, db = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b), o, true);
        result = it.getOutput();
        if (!result.isComplex()) {
            change = false;
            if (da.isComplex()) {
                da = da.getRealView();
                change = true;
            }
            if (db.isComplex()) {
                db = db.getRealView();
                change = true;
            }
            if (change) {
                it = BroadcastIterator.createIterator(da, db, result, true);
            }
        }
        is = result.getElementsPerItem();
        as = da.getElementsPerItem();
        bs = db.getElementsPerItem();
        dt = result.getDType();
        switch (dt) {
            case 1: {
                oi8data = ((ByteDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl31
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oi8data[it.oIndex] = ox = (byte)Maths.toLong(iax - ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi8data[it.oIndex] = ox = (byte)(iax - ibx);
lbl31:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl32:
                // 1 sources

                break;
            }
            case 2: {
                oi16data = ((ShortDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl45
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oi16data[it.oIndex] = ox = (short)Maths.toLong(iax - ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi16data[it.oIndex] = ox = (short)(iax - ibx);
lbl45:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl46:
                // 1 sources

                break;
            }
            case 4: {
                oi64data = ((LongDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl59
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oi64data[it.oIndex] = ox = Maths.toLong(iax - ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi64data[it.oIndex] = ox = iax - ibx;
lbl59:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl60:
                // 1 sources

                break;
            }
            case 3: {
                oi32data = ((IntegerDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl73
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oi32data[it.oIndex] = ox = (int)Maths.toLong(iax - ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi32data[it.oIndex] = ox = (int)(iax - ibx);
lbl73:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl74:
                // 1 sources

                break;
            }
            case 100: {
                oai8data = ((CompoundByteDataset)result).getData();
                if (is != 1) ** GOTO lbl90
                if (!it.isOutputDouble()) ** GOTO lbl88
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(iax - ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)(iax - ibx);
lbl88:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl89:
                // 1 sources

                break;
lbl90:
                // 1 sources

                if (as >= bs) ** GOTO lbl115
                if (!it.isOutputDouble()) ** GOTO lbl113
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(iax - ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(iax - ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)(iax - ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)(iax - ibx);
                        ++j;
                    }
lbl113:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl114:
                // 1 sources

                break;
lbl115:
                // 1 sources

                if (as <= bs) ** GOTO lbl140
                if (!it.isOutputDouble()) ** GOTO lbl138
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(iax - ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(iax - ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)(iax - ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)(iax - ibx);
                        ++j;
                    }
lbl138:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl139:
                // 1 sources

                break;
lbl140:
                // 1 sources

                if (as != 1) ** GOTO lbl163
                if (!it.isOutputDouble()) ** GOTO lbl161
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = (byte)Maths.toLong(iax - ibx);
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (byte)(iax - ibx);
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl161:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl162:
                // 1 sources

                break;
lbl163:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl187
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(iax - ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(iax - ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)(iax - ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)(iax - ibx);
                        ++j;
                    }
lbl187:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl188:
                // 1 sources

                break;
            }
            case 200: {
                oai16data = ((CompoundShortDataset)result).getData();
                if (is != 1) ** GOTO lbl204
                if (!it.isOutputDouble()) ** GOTO lbl202
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(iax - ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)(iax - ibx);
lbl202:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl203:
                // 1 sources

                break;
lbl204:
                // 1 sources

                if (as >= bs) ** GOTO lbl229
                if (!it.isOutputDouble()) ** GOTO lbl227
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(iax - ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(iax - ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)(iax - ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)(iax - ibx);
                        ++j;
                    }
lbl227:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl228:
                // 1 sources

                break;
lbl229:
                // 1 sources

                if (as <= bs) ** GOTO lbl254
                if (!it.isOutputDouble()) ** GOTO lbl252
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(iax - ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(iax - ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)(iax - ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)(iax - ibx);
                        ++j;
                    }
lbl252:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl253:
                // 1 sources

                break;
lbl254:
                // 1 sources

                if (as != 1) ** GOTO lbl277
                if (!it.isOutputDouble()) ** GOTO lbl275
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = (short)Maths.toLong(iax - ibx);
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (short)(iax - ibx);
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl275:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl276:
                // 1 sources

                break;
lbl277:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl301
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(iax - ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(iax - ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)(iax - ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)(iax - ibx);
                        ++j;
                    }
lbl301:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl302:
                // 1 sources

                break;
            }
            case 400: {
                oai64data = ((CompoundLongDataset)result).getData();
                if (is != 1) ** GOTO lbl318
                if (!it.isOutputDouble()) ** GOTO lbl316
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(iax - ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = iax - ibx;
lbl316:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl317:
                // 1 sources

                break;
lbl318:
                // 1 sources

                if (as >= bs) ** GOTO lbl343
                if (!it.isOutputDouble()) ** GOTO lbl341
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(iax - ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(iax - ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = iax - ibx;
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = iax - ibx;
                        ++j;
                    }
lbl341:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl342:
                // 1 sources

                break;
lbl343:
                // 1 sources

                if (as <= bs) ** GOTO lbl368
                if (!it.isOutputDouble()) ** GOTO lbl366
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(iax - ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(iax - ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = iax - ibx;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = iax - ibx;
                        ++j;
                    }
lbl366:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl367:
                // 1 sources

                break;
lbl368:
                // 1 sources

                if (as != 1) ** GOTO lbl391
                if (!it.isOutputDouble()) ** GOTO lbl389
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = Maths.toLong(iax - ibx);
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = iax - ibx;
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl389:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl390:
                // 1 sources

                break;
lbl391:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl415
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(iax - ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(iax - ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = iax - ibx;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = iax - ibx;
                        ++j;
                    }
lbl415:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl416:
                // 1 sources

                break;
            }
            case 300: {
                oai32data = ((CompoundIntegerDataset)result).getData();
                if (is != 1) ** GOTO lbl432
                if (!it.isOutputDouble()) ** GOTO lbl430
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(iax - ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)(iax - ibx);
lbl430:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl431:
                // 1 sources

                break;
lbl432:
                // 1 sources

                if (as >= bs) ** GOTO lbl457
                if (!it.isOutputDouble()) ** GOTO lbl455
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(iax - ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(iax - ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)(iax - ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)(iax - ibx);
                        ++j;
                    }
lbl455:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl456:
                // 1 sources

                break;
lbl457:
                // 1 sources

                if (as <= bs) ** GOTO lbl482
                if (!it.isOutputDouble()) ** GOTO lbl480
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(iax - ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(iax - ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)(iax - ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)(iax - ibx);
                        ++j;
                    }
lbl480:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl481:
                // 1 sources

                break;
lbl482:
                // 1 sources

                if (as != 1) ** GOTO lbl505
                if (!it.isOutputDouble()) ** GOTO lbl503
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = (int)Maths.toLong(iax - ibx);
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (int)(iax - ibx);
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl503:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl504:
                // 1 sources

                break;
lbl505:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl529
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(iax - ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(iax - ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)(iax - ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)(iax - ibx);
                        ++j;
                    }
lbl529:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl530:
                // 1 sources

                break;
            }
            case 5: {
                of32data = ((FloatDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl543
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    of32data[it.oIndex] = ox = (float)(iax - ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    of32data[it.oIndex] = ox = (float)(iax - ibx);
lbl543:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl544:
                // 1 sources

                break;
            }
            case 6: {
                of64data = ((DoubleDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl557
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    of64data[it.oIndex] = ox = iax - ibx;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    of64data[it.oIndex] = ox = (double)(iax - ibx);
lbl557:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl558:
                // 1 sources

                break;
            }
            case 500: {
                oaf32data = ((CompoundFloatDataset)result).getData();
                if (is != 1) ** GOTO lbl574
                if (!it.isOutputDouble()) ** GOTO lbl572
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)(iax - ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)(iax - ibx);
lbl572:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl573:
                // 1 sources

                break;
lbl574:
                // 1 sources

                if (as >= bs) ** GOTO lbl599
                if (!it.isOutputDouble()) ** GOTO lbl597
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)(iax - ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(iax - ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)(iax - ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(iax - ibx);
                        ++j;
                    }
lbl597:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl598:
                // 1 sources

                break;
lbl599:
                // 1 sources

                if (as <= bs) ** GOTO lbl624
                if (!it.isOutputDouble()) ** GOTO lbl622
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)(iax - ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(iax - ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)(iax - ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(iax - ibx);
                        ++j;
                    }
lbl622:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl623:
                // 1 sources

                break;
lbl624:
                // 1 sources

                if (as != 1) ** GOTO lbl647
                if (!it.isOutputDouble()) ** GOTO lbl645
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = (float)(iax - ibx);
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = iax - ibx;
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl645:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl646:
                // 1 sources

                break;
lbl647:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl671
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)(iax - ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(iax - ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)(iax - ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(iax - ibx);
                        ++j;
                    }
lbl671:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl672:
                // 1 sources

                break;
            }
            case 600: {
                oaf64data = ((CompoundDoubleDataset)result).getData();
                if (is != 1) ** GOTO lbl688
                if (!it.isOutputDouble()) ** GOTO lbl686
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = iax - ibx;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = (double)(iax - ibx);
lbl686:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl687:
                // 1 sources

                break;
lbl688:
                // 1 sources

                if (as >= bs) ** GOTO lbl713
                if (!it.isOutputDouble()) ** GOTO lbl711
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = iax - ibx;
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = iax - ibx;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = (double)(iax - ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = (double)(iax - ibx);
                        ++j;
                    }
lbl711:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl712:
                // 1 sources

                break;
lbl713:
                // 1 sources

                if (as <= bs) ** GOTO lbl738
                if (!it.isOutputDouble()) ** GOTO lbl736
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = iax - ibx;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = iax - ibx;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = (double)(iax - ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = (double)(iax - ibx);
                        ++j;
                    }
lbl736:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl737:
                // 1 sources

                break;
lbl738:
                // 1 sources

                if (as != 1) ** GOTO lbl761
                if (!it.isOutputDouble()) ** GOTO lbl759
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = iax - ibx;
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = iax - ibx;
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl759:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl760:
                // 1 sources

                break;
lbl761:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl785
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = iax - ibx;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = iax - ibx;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = (double)(iax - ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = (double)(iax - ibx);
                        ++j;
                    }
lbl785:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl786:
                // 1 sources

                break;
            }
            case 7: {
                oc64data = ((ComplexFloatDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl823
                if (!it.isOutputDouble()) ** GOTO lbl812
                iay = 0.0;
                if (!db.isComplex()) ** GOTO lbl810
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iby = db.getElementDoubleAbs(it.bIndex + 1);
                    ox = (float)(iax - ibx);
                    oy = (float)(0.0 - iby);
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iby = 0.0;
                    ox = (float)(iax - ibx);
                    oy = 0.0f;
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
lbl810:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl811:
                // 1 sources

                break;
lbl812:
                // 1 sources

                iay = 0L;
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    iby = 0L;
                    ox = iax - ibx;
                    oy = 0.0f;
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
                }
                break;
lbl823:
                // 1 sources

                if (db.isComplex()) ** GOTO lbl843
                iby = 0.0;
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iay = da.getElementDoubleAbs(it.aIndex + 1);
                    ox = (float)(iax - ibx);
                    oy = (float)(iay - 0.0);
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iay = da.getElementDoubleAbs(it.aIndex + 1);
                    iby = db.getElementDoubleAbs(it.bIndex + 1);
                    ox = (float)(iax - ibx);
                    oy = (float)(iay - iby);
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
lbl843:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl844:
                // 1 sources

                break;
            }
            case 8: {
                oc128data = ((ComplexDoubleDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl881
                if (!it.isOutputDouble()) ** GOTO lbl870
                iay = 0.0;
                if (!db.isComplex()) ** GOTO lbl868
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iby = db.getElementDoubleAbs(it.bIndex + 1);
                    ox = iax - ibx;
                    oy = 0.0 - iby;
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iby = 0.0;
                    ox = iax - ibx;
                    oy = 0.0;
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
lbl868:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl869:
                // 1 sources

                break;
lbl870:
                // 1 sources

                iay = 0L;
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    iby = 0L;
                    ox = iax - ibx;
                    oy = 0.0;
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
                }
                break;
lbl881:
                // 1 sources

                if (db.isComplex()) ** GOTO lbl901
                iby = 0.0;
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iay = da.getElementDoubleAbs(it.aIndex + 1);
                    ox = iax - ibx;
                    oy = iay - 0.0;
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iay = da.getElementDoubleAbs(it.aIndex + 1);
                    iby = db.getElementDoubleAbs(it.bIndex + 1);
                    ox = iax - ibx;
                    oy = iay - iby;
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
lbl901:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl902:
                // 1 sources

                break;
            }
            default: {
                throw new IllegalArgumentException("subtract supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        Maths.addBinaryOperatorName(da, db, result, "-");
        return result;
    }

    public static Dataset multiply(Object a, Object b) {
        return Maths.multiply(a, b, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset multiply(Object a, Object b, Dataset o) {
        da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        it = BroadcastIterator.createIterator(da, db = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b), o, true);
        result = it.getOutput();
        if (!result.isComplex()) {
            change = false;
            if (da.isComplex()) {
                da = da.getRealView();
                change = true;
            }
            if (db.isComplex()) {
                db = db.getRealView();
                change = true;
            }
            if (change) {
                it = BroadcastIterator.createIterator(da, db, result, true);
            }
        }
        is = result.getElementsPerItem();
        as = da.getElementsPerItem();
        bs = db.getElementsPerItem();
        dt = result.getDType();
        switch (dt) {
            case 1: {
                oi8data = ((ByteDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl31
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oi8data[it.oIndex] = ox = (byte)Maths.toLong(iax * ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi8data[it.oIndex] = ox = (byte)(iax * ibx);
lbl31:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl32:
                // 1 sources

                break;
            }
            case 2: {
                oi16data = ((ShortDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl45
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oi16data[it.oIndex] = ox = (short)Maths.toLong(iax * ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi16data[it.oIndex] = ox = (short)(iax * ibx);
lbl45:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl46:
                // 1 sources

                break;
            }
            case 4: {
                oi64data = ((LongDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl59
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oi64data[it.oIndex] = ox = Maths.toLong(iax * ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi64data[it.oIndex] = ox = iax * ibx;
lbl59:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl60:
                // 1 sources

                break;
            }
            case 3: {
                oi32data = ((IntegerDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl73
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oi32data[it.oIndex] = ox = (int)Maths.toLong(iax * ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi32data[it.oIndex] = ox = (int)(iax * ibx);
lbl73:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl74:
                // 1 sources

                break;
            }
            case 100: {
                oai8data = ((CompoundByteDataset)result).getData();
                if (is != 1) ** GOTO lbl90
                if (!it.isOutputDouble()) ** GOTO lbl88
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(iax * ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)(iax * ibx);
lbl88:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl89:
                // 1 sources

                break;
lbl90:
                // 1 sources

                if (as >= bs) ** GOTO lbl115
                if (!it.isOutputDouble()) ** GOTO lbl113
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(iax * ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(iax * ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)(iax * ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)(iax * ibx);
                        ++j;
                    }
lbl113:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl114:
                // 1 sources

                break;
lbl115:
                // 1 sources

                if (as <= bs) ** GOTO lbl140
                if (!it.isOutputDouble()) ** GOTO lbl138
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(iax * ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(iax * ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)(iax * ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)(iax * ibx);
                        ++j;
                    }
lbl138:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl139:
                // 1 sources

                break;
lbl140:
                // 1 sources

                if (as != 1) ** GOTO lbl163
                if (!it.isOutputDouble()) ** GOTO lbl161
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = (byte)Maths.toLong(iax * ibx);
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (byte)(iax * ibx);
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl161:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl162:
                // 1 sources

                break;
lbl163:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl187
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(iax * ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(iax * ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)(iax * ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)(iax * ibx);
                        ++j;
                    }
lbl187:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl188:
                // 1 sources

                break;
            }
            case 200: {
                oai16data = ((CompoundShortDataset)result).getData();
                if (is != 1) ** GOTO lbl204
                if (!it.isOutputDouble()) ** GOTO lbl202
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(iax * ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)(iax * ibx);
lbl202:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl203:
                // 1 sources

                break;
lbl204:
                // 1 sources

                if (as >= bs) ** GOTO lbl229
                if (!it.isOutputDouble()) ** GOTO lbl227
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(iax * ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(iax * ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)(iax * ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)(iax * ibx);
                        ++j;
                    }
lbl227:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl228:
                // 1 sources

                break;
lbl229:
                // 1 sources

                if (as <= bs) ** GOTO lbl254
                if (!it.isOutputDouble()) ** GOTO lbl252
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(iax * ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(iax * ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)(iax * ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)(iax * ibx);
                        ++j;
                    }
lbl252:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl253:
                // 1 sources

                break;
lbl254:
                // 1 sources

                if (as != 1) ** GOTO lbl277
                if (!it.isOutputDouble()) ** GOTO lbl275
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = (short)Maths.toLong(iax * ibx);
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (short)(iax * ibx);
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl275:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl276:
                // 1 sources

                break;
lbl277:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl301
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(iax * ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(iax * ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)(iax * ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)(iax * ibx);
                        ++j;
                    }
lbl301:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl302:
                // 1 sources

                break;
            }
            case 400: {
                oai64data = ((CompoundLongDataset)result).getData();
                if (is != 1) ** GOTO lbl318
                if (!it.isOutputDouble()) ** GOTO lbl316
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(iax * ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = iax * ibx;
lbl316:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl317:
                // 1 sources

                break;
lbl318:
                // 1 sources

                if (as >= bs) ** GOTO lbl343
                if (!it.isOutputDouble()) ** GOTO lbl341
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(iax * ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(iax * ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = iax * ibx;
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = iax * ibx;
                        ++j;
                    }
lbl341:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl342:
                // 1 sources

                break;
lbl343:
                // 1 sources

                if (as <= bs) ** GOTO lbl368
                if (!it.isOutputDouble()) ** GOTO lbl366
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(iax * ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(iax * ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = iax * ibx;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = iax * ibx;
                        ++j;
                    }
lbl366:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl367:
                // 1 sources

                break;
lbl368:
                // 1 sources

                if (as != 1) ** GOTO lbl391
                if (!it.isOutputDouble()) ** GOTO lbl389
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = Maths.toLong(iax * ibx);
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = iax * ibx;
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl389:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl390:
                // 1 sources

                break;
lbl391:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl415
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(iax * ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(iax * ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = iax * ibx;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = iax * ibx;
                        ++j;
                    }
lbl415:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl416:
                // 1 sources

                break;
            }
            case 300: {
                oai32data = ((CompoundIntegerDataset)result).getData();
                if (is != 1) ** GOTO lbl432
                if (!it.isOutputDouble()) ** GOTO lbl430
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(iax * ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)(iax * ibx);
lbl430:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl431:
                // 1 sources

                break;
lbl432:
                // 1 sources

                if (as >= bs) ** GOTO lbl457
                if (!it.isOutputDouble()) ** GOTO lbl455
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(iax * ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(iax * ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)(iax * ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)(iax * ibx);
                        ++j;
                    }
lbl455:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl456:
                // 1 sources

                break;
lbl457:
                // 1 sources

                if (as <= bs) ** GOTO lbl482
                if (!it.isOutputDouble()) ** GOTO lbl480
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(iax * ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(iax * ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)(iax * ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)(iax * ibx);
                        ++j;
                    }
lbl480:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl481:
                // 1 sources

                break;
lbl482:
                // 1 sources

                if (as != 1) ** GOTO lbl505
                if (!it.isOutputDouble()) ** GOTO lbl503
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = (int)Maths.toLong(iax * ibx);
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (int)(iax * ibx);
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl503:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl504:
                // 1 sources

                break;
lbl505:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl529
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(iax * ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(iax * ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)(iax * ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)(iax * ibx);
                        ++j;
                    }
lbl529:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl530:
                // 1 sources

                break;
            }
            case 5: {
                of32data = ((FloatDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl543
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    of32data[it.oIndex] = ox = (float)(iax * ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    of32data[it.oIndex] = ox = (float)(iax * ibx);
lbl543:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl544:
                // 1 sources

                break;
            }
            case 6: {
                of64data = ((DoubleDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl557
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    of64data[it.oIndex] = ox = iax * ibx;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    of64data[it.oIndex] = ox = (double)(iax * ibx);
lbl557:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl558:
                // 1 sources

                break;
            }
            case 500: {
                oaf32data = ((CompoundFloatDataset)result).getData();
                if (is != 1) ** GOTO lbl574
                if (!it.isOutputDouble()) ** GOTO lbl572
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)(iax * ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)(iax * ibx);
lbl572:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl573:
                // 1 sources

                break;
lbl574:
                // 1 sources

                if (as >= bs) ** GOTO lbl599
                if (!it.isOutputDouble()) ** GOTO lbl597
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)(iax * ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(iax * ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)(iax * ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(iax * ibx);
                        ++j;
                    }
lbl597:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl598:
                // 1 sources

                break;
lbl599:
                // 1 sources

                if (as <= bs) ** GOTO lbl624
                if (!it.isOutputDouble()) ** GOTO lbl622
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)(iax * ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(iax * ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)(iax * ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(iax * ibx);
                        ++j;
                    }
lbl622:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl623:
                // 1 sources

                break;
lbl624:
                // 1 sources

                if (as != 1) ** GOTO lbl647
                if (!it.isOutputDouble()) ** GOTO lbl645
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = (float)(iax * ibx);
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = iax * ibx;
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl645:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl646:
                // 1 sources

                break;
lbl647:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl671
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)(iax * ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(iax * ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)(iax * ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(iax * ibx);
                        ++j;
                    }
lbl671:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl672:
                // 1 sources

                break;
            }
            case 600: {
                oaf64data = ((CompoundDoubleDataset)result).getData();
                if (is != 1) ** GOTO lbl688
                if (!it.isOutputDouble()) ** GOTO lbl686
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = iax * ibx;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = (double)(iax * ibx);
lbl686:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl687:
                // 1 sources

                break;
lbl688:
                // 1 sources

                if (as >= bs) ** GOTO lbl713
                if (!it.isOutputDouble()) ** GOTO lbl711
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = iax * ibx;
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = iax * ibx;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = (double)(iax * ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = (double)(iax * ibx);
                        ++j;
                    }
lbl711:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl712:
                // 1 sources

                break;
lbl713:
                // 1 sources

                if (as <= bs) ** GOTO lbl738
                if (!it.isOutputDouble()) ** GOTO lbl736
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = iax * ibx;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = iax * ibx;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = (double)(iax * ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = (double)(iax * ibx);
                        ++j;
                    }
lbl736:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl737:
                // 1 sources

                break;
lbl738:
                // 1 sources

                if (as != 1) ** GOTO lbl761
                if (!it.isOutputDouble()) ** GOTO lbl759
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = iax * ibx;
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = iax * ibx;
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl759:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl760:
                // 1 sources

                break;
lbl761:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl785
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = iax * ibx;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = iax * ibx;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = (double)(iax * ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = (double)(iax * ibx);
                        ++j;
                    }
lbl785:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl786:
                // 1 sources

                break;
            }
            case 7: {
                oc64data = ((ComplexFloatDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl823
                if (!it.isOutputDouble()) ** GOTO lbl812
                iay = 0.0;
                if (!db.isComplex()) ** GOTO lbl810
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iby = db.getElementDoubleAbs(it.bIndex + 1);
                    ox = (float)(iax * ibx - 0.0 * iby);
                    oy = (float)(iax * iby + 0.0 * ibx);
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iby = 0.0;
                    ox = (float)(iax * ibx - 0.0);
                    oy = (float)(iax * 0.0 + 0.0 * ibx);
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
lbl810:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl811:
                // 1 sources

                break;
lbl812:
                // 1 sources

                iay = 0L;
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    iby = 0L;
                    ox = iax * ibx - 0L;
                    oy = iax * 0L + 0L * ibx;
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
                }
                break;
lbl823:
                // 1 sources

                if (db.isComplex()) ** GOTO lbl843
                iby = 0.0;
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iay = da.getElementDoubleAbs(it.aIndex + 1);
                    ox = (float)(iax * ibx - iay * 0.0);
                    oy = (float)(iax * 0.0 + iay * ibx);
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iay = da.getElementDoubleAbs(it.aIndex + 1);
                    iby = db.getElementDoubleAbs(it.bIndex + 1);
                    ox = (float)(iax * ibx - iay * iby);
                    oy = (float)(iax * iby + iay * ibx);
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
lbl843:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl844:
                // 1 sources

                break;
            }
            case 8: {
                oc128data = ((ComplexDoubleDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl881
                if (!it.isOutputDouble()) ** GOTO lbl870
                iay = 0.0;
                if (!db.isComplex()) ** GOTO lbl868
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iby = db.getElementDoubleAbs(it.bIndex + 1);
                    ox = iax * ibx - 0.0 * iby;
                    oy = iax * iby + 0.0 * ibx;
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iby = 0.0;
                    ox = iax * ibx - 0.0;
                    oy = iax * 0.0 + 0.0 * ibx;
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
lbl868:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl869:
                // 1 sources

                break;
lbl870:
                // 1 sources

                iay = 0L;
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    iby = 0L;
                    ox = iax * ibx - 0L;
                    oy = iax * 0L + 0L * ibx;
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
                }
                break;
lbl881:
                // 1 sources

                if (db.isComplex()) ** GOTO lbl901
                iby = 0.0;
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iay = da.getElementDoubleAbs(it.aIndex + 1);
                    ox = iax * ibx - iay * 0.0;
                    oy = iax * 0.0 + iay * ibx;
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iay = da.getElementDoubleAbs(it.aIndex + 1);
                    iby = db.getElementDoubleAbs(it.bIndex + 1);
                    ox = iax * ibx - iay * iby;
                    oy = iax * iby + iay * ibx;
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
lbl901:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl902:
                // 1 sources

                break;
            }
            default: {
                throw new IllegalArgumentException("multiply supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        Maths.addBinaryOperatorName(da, db, result, "*");
        return result;
    }

    public static Dataset divide(Object a, Object b) {
        return Maths.divide(a, b, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset divide(Object a, Object b, Dataset o) {
        da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        it = BroadcastIterator.createIterator(da, db = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b), o, true);
        result = it.getOutput();
        if (!result.isComplex()) {
            change = false;
            if (da.isComplex()) {
                da = da.getRealView();
                change = true;
            }
            if (db.isComplex()) {
                db = db.getRealView();
                change = true;
            }
            if (change) {
                it = BroadcastIterator.createIterator(da, db, result, true);
            }
        }
        is = result.getElementsPerItem();
        as = da.getElementsPerItem();
        bs = db.getElementsPerItem();
        dt = result.getDType();
        switch (dt) {
            case 1: {
                oi8data = ((ByteDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl31
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oi8data[it.oIndex] = ox = (byte)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi8data[it.oIndex] = ox = (byte)(ibx == 0L ? 0L : iax / ibx);
lbl31:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl32:
                // 1 sources

                break;
            }
            case 2: {
                oi16data = ((ShortDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl45
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oi16data[it.oIndex] = ox = (short)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi16data[it.oIndex] = ox = (short)(ibx == 0L ? 0L : iax / ibx);
lbl45:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl46:
                // 1 sources

                break;
            }
            case 4: {
                oi64data = ((LongDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl59
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oi64data[it.oIndex] = ox = Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi64data[it.oIndex] = ox = ibx == 0L ? 0L : iax / ibx;
lbl59:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl60:
                // 1 sources

                break;
            }
            case 3: {
                oi32data = ((IntegerDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl73
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oi32data[it.oIndex] = ox = (int)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi32data[it.oIndex] = ox = (int)(ibx == 0L ? 0L : iax / ibx);
lbl73:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl74:
                // 1 sources

                break;
            }
            case 100: {
                oai8data = ((CompoundByteDataset)result).getData();
                if (is != 1) ** GOTO lbl90
                if (!it.isOutputDouble()) ** GOTO lbl88
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)(ibx == 0L ? 0L : iax / ibx);
lbl88:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl89:
                // 1 sources

                break;
lbl90:
                // 1 sources

                if (as >= bs) ** GOTO lbl115
                if (!it.isOutputDouble()) ** GOTO lbl113
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)(ibx == 0L ? 0L : iax / ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)(ibx == 0L ? 0L : iax / ibx);
                        ++j;
                    }
lbl113:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl114:
                // 1 sources

                break;
lbl115:
                // 1 sources

                if (as <= bs) ** GOTO lbl140
                if (!it.isOutputDouble()) ** GOTO lbl138
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)(ibx == 0L ? 0L : iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)(ibx == 0L ? 0L : iax / ibx);
                        ++j;
                    }
lbl138:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl139:
                // 1 sources

                break;
lbl140:
                // 1 sources

                if (as != 1) ** GOTO lbl163
                if (!it.isOutputDouble()) ** GOTO lbl161
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = (byte)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (byte)(ibx == 0L ? 0L : iax / ibx);
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl161:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl162:
                // 1 sources

                break;
lbl163:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl187
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)(ibx == 0L ? 0L : iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)(ibx == 0L ? 0L : iax / ibx);
                        ++j;
                    }
lbl187:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl188:
                // 1 sources

                break;
            }
            case 200: {
                oai16data = ((CompoundShortDataset)result).getData();
                if (is != 1) ** GOTO lbl204
                if (!it.isOutputDouble()) ** GOTO lbl202
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)(ibx == 0L ? 0L : iax / ibx);
lbl202:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl203:
                // 1 sources

                break;
lbl204:
                // 1 sources

                if (as >= bs) ** GOTO lbl229
                if (!it.isOutputDouble()) ** GOTO lbl227
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)(ibx == 0L ? 0L : iax / ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)(ibx == 0L ? 0L : iax / ibx);
                        ++j;
                    }
lbl227:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl228:
                // 1 sources

                break;
lbl229:
                // 1 sources

                if (as <= bs) ** GOTO lbl254
                if (!it.isOutputDouble()) ** GOTO lbl252
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)(ibx == 0L ? 0L : iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)(ibx == 0L ? 0L : iax / ibx);
                        ++j;
                    }
lbl252:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl253:
                // 1 sources

                break;
lbl254:
                // 1 sources

                if (as != 1) ** GOTO lbl277
                if (!it.isOutputDouble()) ** GOTO lbl275
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = (short)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (short)(ibx == 0L ? 0L : iax / ibx);
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl275:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl276:
                // 1 sources

                break;
lbl277:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl301
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)(ibx == 0L ? 0L : iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)(ibx == 0L ? 0L : iax / ibx);
                        ++j;
                    }
lbl301:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl302:
                // 1 sources

                break;
            }
            case 400: {
                oai64data = ((CompoundLongDataset)result).getData();
                if (is != 1) ** GOTO lbl318
                if (!it.isOutputDouble()) ** GOTO lbl316
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = ibx == 0L ? 0L : iax / ibx;
lbl316:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl317:
                // 1 sources

                break;
lbl318:
                // 1 sources

                if (as >= bs) ** GOTO lbl343
                if (!it.isOutputDouble()) ** GOTO lbl341
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = ibx == 0L ? 0L : iax / ibx;
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = ibx == 0L ? 0L : iax / ibx;
                        ++j;
                    }
lbl341:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl342:
                // 1 sources

                break;
lbl343:
                // 1 sources

                if (as <= bs) ** GOTO lbl368
                if (!it.isOutputDouble()) ** GOTO lbl366
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = ibx == 0L ? 0L : iax / ibx;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = ibx == 0L ? 0L : iax / ibx;
                        ++j;
                    }
lbl366:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl367:
                // 1 sources

                break;
lbl368:
                // 1 sources

                if (as != 1) ** GOTO lbl391
                if (!it.isOutputDouble()) ** GOTO lbl389
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = ibx == 0L ? 0L : iax / ibx;
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl389:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl390:
                // 1 sources

                break;
lbl391:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl415
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = ibx == 0L ? 0L : iax / ibx;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = ibx == 0L ? 0L : iax / ibx;
                        ++j;
                    }
lbl415:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl416:
                // 1 sources

                break;
            }
            case 300: {
                oai32data = ((CompoundIntegerDataset)result).getData();
                if (is != 1) ** GOTO lbl432
                if (!it.isOutputDouble()) ** GOTO lbl430
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)(ibx == 0L ? 0L : iax / ibx);
lbl430:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl431:
                // 1 sources

                break;
lbl432:
                // 1 sources

                if (as >= bs) ** GOTO lbl457
                if (!it.isOutputDouble()) ** GOTO lbl455
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)(ibx == 0L ? 0L : iax / ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)(ibx == 0L ? 0L : iax / ibx);
                        ++j;
                    }
lbl455:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl456:
                // 1 sources

                break;
lbl457:
                // 1 sources

                if (as <= bs) ** GOTO lbl482
                if (!it.isOutputDouble()) ** GOTO lbl480
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)(ibx == 0L ? 0L : iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)(ibx == 0L ? 0L : iax / ibx);
                        ++j;
                    }
lbl480:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl481:
                // 1 sources

                break;
lbl482:
                // 1 sources

                if (as != 1) ** GOTO lbl505
                if (!it.isOutputDouble()) ** GOTO lbl503
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = (int)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (int)(ibx == 0L ? 0L : iax / ibx);
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl503:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl504:
                // 1 sources

                break;
lbl505:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl529
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)(ibx == 0L ? 0L : iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)(ibx == 0L ? 0L : iax / ibx);
                        ++j;
                    }
lbl529:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl530:
                // 1 sources

                break;
            }
            case 5: {
                of32data = ((FloatDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl543
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    of32data[it.oIndex] = ox = (float)(iax / ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    of32data[it.oIndex] = ox = (float)(iax / ibx);
lbl543:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl544:
                // 1 sources

                break;
            }
            case 6: {
                of64data = ((DoubleDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl557
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    of64data[it.oIndex] = ox = iax / ibx;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    of64data[it.oIndex] = ox = (double)(iax / ibx);
lbl557:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl558:
                // 1 sources

                break;
            }
            case 500: {
                oaf32data = ((CompoundFloatDataset)result).getData();
                if (is != 1) ** GOTO lbl574
                if (!it.isOutputDouble()) ** GOTO lbl572
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)(iax / ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)(iax / ibx);
lbl572:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl573:
                // 1 sources

                break;
lbl574:
                // 1 sources

                if (as >= bs) ** GOTO lbl599
                if (!it.isOutputDouble()) ** GOTO lbl597
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)(iax / ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(iax / ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)(iax / ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(iax / ibx);
                        ++j;
                    }
lbl597:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl598:
                // 1 sources

                break;
lbl599:
                // 1 sources

                if (as <= bs) ** GOTO lbl624
                if (!it.isOutputDouble()) ** GOTO lbl622
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)(iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(iax / ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)(iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(iax / ibx);
                        ++j;
                    }
lbl622:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl623:
                // 1 sources

                break;
lbl624:
                // 1 sources

                if (as != 1) ** GOTO lbl647
                if (!it.isOutputDouble()) ** GOTO lbl645
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = (float)(iax / ibx);
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = iax / ibx;
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl645:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl646:
                // 1 sources

                break;
lbl647:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl671
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)(iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(iax / ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)(iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(iax / ibx);
                        ++j;
                    }
lbl671:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl672:
                // 1 sources

                break;
            }
            case 600: {
                oaf64data = ((CompoundDoubleDataset)result).getData();
                if (is != 1) ** GOTO lbl688
                if (!it.isOutputDouble()) ** GOTO lbl686
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = iax / ibx;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = (double)(iax / ibx);
lbl686:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl687:
                // 1 sources

                break;
lbl688:
                // 1 sources

                if (as >= bs) ** GOTO lbl713
                if (!it.isOutputDouble()) ** GOTO lbl711
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = iax / ibx;
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = iax / ibx;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = (double)(iax / ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = (double)(iax / ibx);
                        ++j;
                    }
lbl711:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl712:
                // 1 sources

                break;
lbl713:
                // 1 sources

                if (as <= bs) ** GOTO lbl738
                if (!it.isOutputDouble()) ** GOTO lbl736
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = iax / ibx;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = iax / ibx;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = (double)(iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = (double)(iax / ibx);
                        ++j;
                    }
lbl736:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl737:
                // 1 sources

                break;
lbl738:
                // 1 sources

                if (as != 1) ** GOTO lbl761
                if (!it.isOutputDouble()) ** GOTO lbl759
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = iax / ibx;
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = iax / ibx;
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl759:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl760:
                // 1 sources

                break;
lbl761:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl785
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = iax / ibx;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = iax / ibx;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = (double)(iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = (double)(iax / ibx);
                        ++j;
                    }
lbl785:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl786:
                // 1 sources

                break;
            }
            case 7: {
                oc64data = ((ComplexFloatDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl837
                if (!it.isOutputDouble()) ** GOTO lbl827
                iay = 0.0;
                if (!db.isComplex()) ** GOTO lbl825
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iby = db.getElementDoubleAbs(it.bIndex + 1);
                    if (iby == 0.0) {
                        ox = (float)(iax / ibx);
                        oy = (float)(0.0 / ibx);
                    } else if (ibx == 0.0) {
                        ox = (float)(0.0 / iby);
                        oy = (float)(-iax / iby);
                    } else if (Math.abs(ibx) < Math.abs(iby)) {
                        q = (float)(ibx / iby);
                        den = (float)(ibx * (double)q + iby);
                        ox = (float)((iax * (double)q + 0.0) / (double)den);
                        oy = (float)((0.0 * (double)q - iax) / (double)den);
                    } else {
                        q = (float)(iby / ibx);
                        den = (float)(iby * (double)q + ibx);
                        ox = (float)((0.0 * (double)q + iax) / (double)den);
                        oy = (float)((0.0 - iax * (double)q) / (double)den);
                    }
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = (float)(iax / ibx);
                    oy = (float)(0.0 / ibx);
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
lbl825:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl826:
                // 1 sources

                break;
lbl827:
                // 1 sources

                iay = 0L;
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = iax / ibx;
                    oy = 0L / ibx;
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
                }
                break;
lbl837:
                // 1 sources

                if (db.isComplex()) ** GOTO lbl872
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iay = da.getElementDoubleAbs(it.aIndex + 1);
                    ox = (float)(iax / ibx);
                    oy = (float)(iay / ibx);
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iay = da.getElementDoubleAbs(it.aIndex + 1);
                    iby = db.getElementDoubleAbs(it.bIndex + 1);
                    if (iby == 0.0) {
                        ox = (float)(iax / ibx);
                        oy = (float)(iay / ibx);
                    } else if (ibx == 0.0) {
                        ox = (float)(iay / iby);
                        oy = (float)(-iax / iby);
                    } else if (Math.abs(ibx) < Math.abs(iby)) {
                        q = (float)(ibx / iby);
                        den = (float)(ibx * (double)q + iby);
                        ox = (float)((iax * (double)q + iay) / (double)den);
                        oy = (float)((iay * (double)q - iax) / (double)den);
                    } else {
                        q = (float)(iby / ibx);
                        den = (float)(iby * (double)q + ibx);
                        ox = (float)((iay * (double)q + iax) / (double)den);
                        oy = (float)((iay - iax * (double)q) / (double)den);
                    }
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
lbl872:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl873:
                // 1 sources

                break;
            }
            case 8: {
                oc128data = ((ComplexDoubleDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl924
                if (!it.isOutputDouble()) ** GOTO lbl914
                iay = 0.0;
                if (!db.isComplex()) ** GOTO lbl912
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iby = db.getElementDoubleAbs(it.bIndex + 1);
                    if (iby == 0.0) {
                        ox = iax / ibx;
                        oy = 0.0 / ibx;
                    } else if (ibx == 0.0) {
                        ox = 0.0 / iby;
                        oy = -iax / iby;
                    } else if (Math.abs(ibx) < Math.abs(iby)) {
                        q = ibx / iby;
                        den = ibx * q + iby;
                        ox = (iax * q + 0.0) / den;
                        oy = (0.0 * q - iax) / den;
                    } else {
                        q = iby / ibx;
                        den = iby * q + ibx;
                        ox = (0.0 * q + iax) / den;
                        oy = (0.0 - iax * q) / den;
                    }
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = iax / ibx;
                    oy = 0.0 / ibx;
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
lbl912:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl913:
                // 1 sources

                break;
lbl914:
                // 1 sources

                iay = 0L;
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = iax / ibx;
                    oy = 0L / ibx;
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
                }
                break;
lbl924:
                // 1 sources

                if (db.isComplex()) ** GOTO lbl959
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iay = da.getElementDoubleAbs(it.aIndex + 1);
                    ox = iax / ibx;
                    oy = iay / ibx;
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iay = da.getElementDoubleAbs(it.aIndex + 1);
                    iby = db.getElementDoubleAbs(it.bIndex + 1);
                    if (iby == 0.0) {
                        ox = iax / ibx;
                        oy = iay / ibx;
                    } else if (ibx == 0.0) {
                        ox = iay / iby;
                        oy = -iax / iby;
                    } else if (Math.abs(ibx) < Math.abs(iby)) {
                        q = ibx / iby;
                        den = ibx * q + iby;
                        ox = (iax * q + iay) / den;
                        oy = (iay * q - iax) / den;
                    } else {
                        q = iby / ibx;
                        den = iby * q + ibx;
                        ox = (iay * q + iax) / den;
                        oy = (iay - iax * q) / den;
                    }
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
lbl959:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl960:
                // 1 sources

                break;
            }
            default: {
                throw new IllegalArgumentException("divide supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        Maths.addBinaryOperatorName(da, db, result, "/");
        return result;
    }

    public static Dataset dividez(Object a, Object b) {
        return Maths.dividez(a, b, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset dividez(Object a, Object b, Dataset o) {
        da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        it = BroadcastIterator.createIterator(da, db = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b), o, true);
        result = it.getOutput();
        if (!result.isComplex()) {
            change = false;
            if (da.isComplex()) {
                da = da.getRealView();
                change = true;
            }
            if (db.isComplex()) {
                db = db.getRealView();
                change = true;
            }
            if (change) {
                it = BroadcastIterator.createIterator(da, db, result, true);
            }
        }
        is = result.getElementsPerItem();
        as = da.getElementsPerItem();
        bs = db.getElementsPerItem();
        dt = result.getDType();
        switch (dt) {
            case 1: {
                oi8data = ((ByteDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl31
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oi8data[it.oIndex] = ox = (byte)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi8data[it.oIndex] = ox = (byte)(ibx == 0L ? 0L : iax / ibx);
lbl31:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl32:
                // 1 sources

                break;
            }
            case 2: {
                oi16data = ((ShortDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl45
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oi16data[it.oIndex] = ox = (short)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi16data[it.oIndex] = ox = (short)(ibx == 0L ? 0L : iax / ibx);
lbl45:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl46:
                // 1 sources

                break;
            }
            case 4: {
                oi64data = ((LongDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl59
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oi64data[it.oIndex] = ox = Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi64data[it.oIndex] = ox = ibx == 0L ? 0L : iax / ibx;
lbl59:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl60:
                // 1 sources

                break;
            }
            case 3: {
                oi32data = ((IntegerDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl73
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oi32data[it.oIndex] = ox = (int)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi32data[it.oIndex] = ox = (int)(ibx == 0L ? 0L : iax / ibx);
lbl73:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl74:
                // 1 sources

                break;
            }
            case 100: {
                oai8data = ((CompoundByteDataset)result).getData();
                if (is != 1) ** GOTO lbl90
                if (!it.isOutputDouble()) ** GOTO lbl88
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)(ibx == 0L ? 0L : iax / ibx);
lbl88:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl89:
                // 1 sources

                break;
lbl90:
                // 1 sources

                if (as >= bs) ** GOTO lbl115
                if (!it.isOutputDouble()) ** GOTO lbl113
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)(ibx == 0L ? 0L : iax / ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)(ibx == 0L ? 0L : iax / ibx);
                        ++j;
                    }
lbl113:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl114:
                // 1 sources

                break;
lbl115:
                // 1 sources

                if (as <= bs) ** GOTO lbl140
                if (!it.isOutputDouble()) ** GOTO lbl138
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)(ibx == 0L ? 0L : iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)(ibx == 0L ? 0L : iax / ibx);
                        ++j;
                    }
lbl138:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl139:
                // 1 sources

                break;
lbl140:
                // 1 sources

                if (as != 1) ** GOTO lbl163
                if (!it.isOutputDouble()) ** GOTO lbl161
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = (byte)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (byte)(ibx == 0L ? 0L : iax / ibx);
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl161:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl162:
                // 1 sources

                break;
lbl163:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl187
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)(ibx == 0L ? 0L : iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)(ibx == 0L ? 0L : iax / ibx);
                        ++j;
                    }
lbl187:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl188:
                // 1 sources

                break;
            }
            case 200: {
                oai16data = ((CompoundShortDataset)result).getData();
                if (is != 1) ** GOTO lbl204
                if (!it.isOutputDouble()) ** GOTO lbl202
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)(ibx == 0L ? 0L : iax / ibx);
lbl202:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl203:
                // 1 sources

                break;
lbl204:
                // 1 sources

                if (as >= bs) ** GOTO lbl229
                if (!it.isOutputDouble()) ** GOTO lbl227
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)(ibx == 0L ? 0L : iax / ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)(ibx == 0L ? 0L : iax / ibx);
                        ++j;
                    }
lbl227:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl228:
                // 1 sources

                break;
lbl229:
                // 1 sources

                if (as <= bs) ** GOTO lbl254
                if (!it.isOutputDouble()) ** GOTO lbl252
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)(ibx == 0L ? 0L : iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)(ibx == 0L ? 0L : iax / ibx);
                        ++j;
                    }
lbl252:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl253:
                // 1 sources

                break;
lbl254:
                // 1 sources

                if (as != 1) ** GOTO lbl277
                if (!it.isOutputDouble()) ** GOTO lbl275
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = (short)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (short)(ibx == 0L ? 0L : iax / ibx);
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl275:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl276:
                // 1 sources

                break;
lbl277:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl301
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)(ibx == 0L ? 0L : iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)(ibx == 0L ? 0L : iax / ibx);
                        ++j;
                    }
lbl301:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl302:
                // 1 sources

                break;
            }
            case 400: {
                oai64data = ((CompoundLongDataset)result).getData();
                if (is != 1) ** GOTO lbl318
                if (!it.isOutputDouble()) ** GOTO lbl316
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = ibx == 0L ? 0L : iax / ibx;
lbl316:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl317:
                // 1 sources

                break;
lbl318:
                // 1 sources

                if (as >= bs) ** GOTO lbl343
                if (!it.isOutputDouble()) ** GOTO lbl341
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = ibx == 0L ? 0L : iax / ibx;
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = ibx == 0L ? 0L : iax / ibx;
                        ++j;
                    }
lbl341:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl342:
                // 1 sources

                break;
lbl343:
                // 1 sources

                if (as <= bs) ** GOTO lbl368
                if (!it.isOutputDouble()) ** GOTO lbl366
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = ibx == 0L ? 0L : iax / ibx;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = ibx == 0L ? 0L : iax / ibx;
                        ++j;
                    }
lbl366:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl367:
                // 1 sources

                break;
lbl368:
                // 1 sources

                if (as != 1) ** GOTO lbl391
                if (!it.isOutputDouble()) ** GOTO lbl389
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = ibx == 0L ? 0L : iax / ibx;
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl389:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl390:
                // 1 sources

                break;
lbl391:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl415
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = ibx == 0L ? 0L : iax / ibx;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = ibx == 0L ? 0L : iax / ibx;
                        ++j;
                    }
lbl415:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl416:
                // 1 sources

                break;
            }
            case 300: {
                oai32data = ((CompoundIntegerDataset)result).getData();
                if (is != 1) ** GOTO lbl432
                if (!it.isOutputDouble()) ** GOTO lbl430
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)(ibx == 0L ? 0L : iax / ibx);
lbl430:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl431:
                // 1 sources

                break;
lbl432:
                // 1 sources

                if (as >= bs) ** GOTO lbl457
                if (!it.isOutputDouble()) ** GOTO lbl455
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)(ibx == 0L ? 0L : iax / ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)(ibx == 0L ? 0L : iax / ibx);
                        ++j;
                    }
lbl455:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl456:
                // 1 sources

                break;
lbl457:
                // 1 sources

                if (as <= bs) ** GOTO lbl482
                if (!it.isOutputDouble()) ** GOTO lbl480
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)(ibx == 0L ? 0L : iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)(ibx == 0L ? 0L : iax / ibx);
                        ++j;
                    }
lbl480:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl481:
                // 1 sources

                break;
lbl482:
                // 1 sources

                if (as != 1) ** GOTO lbl505
                if (!it.isOutputDouble()) ** GOTO lbl503
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = (int)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (int)(ibx == 0L ? 0L : iax / ibx);
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl503:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl504:
                // 1 sources

                break;
lbl505:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl529
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(ibx == 0.0 ? 0.0 : iax / ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)(ibx == 0L ? 0L : iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)(ibx == 0L ? 0L : iax / ibx);
                        ++j;
                    }
lbl529:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl530:
                // 1 sources

                break;
            }
            case 5: {
                of32data = ((FloatDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl543
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    of32data[it.oIndex] = ox = (float)(ibx == 0.0 ? 0.0 : iax / ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    of32data[it.oIndex] = ox = (float)(ibx == 0L ? 0L : iax / ibx);
lbl543:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl544:
                // 1 sources

                break;
            }
            case 6: {
                of64data = ((DoubleDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl557
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    of64data[it.oIndex] = ox = ibx == 0.0 ? 0.0 : iax / ibx;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    of64data[it.oIndex] = ox = (double)(ibx == 0L ? 0L : iax / ibx);
lbl557:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl558:
                // 1 sources

                break;
            }
            case 500: {
                oaf32data = ((CompoundFloatDataset)result).getData();
                if (is != 1) ** GOTO lbl574
                if (!it.isOutputDouble()) ** GOTO lbl572
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)(ibx == 0.0 ? 0.0 : iax / ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)(ibx == 0L ? 0L : iax / ibx);
lbl572:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl573:
                // 1 sources

                break;
lbl574:
                // 1 sources

                if (as >= bs) ** GOTO lbl599
                if (!it.isOutputDouble()) ** GOTO lbl597
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)(ibx == 0.0 ? 0.0 : iax / ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(ibx == 0.0 ? 0.0 : iax / ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)(ibx == 0L ? 0L : iax / ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(ibx == 0L ? 0L : iax / ibx);
                        ++j;
                    }
lbl597:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl598:
                // 1 sources

                break;
lbl599:
                // 1 sources

                if (as <= bs) ** GOTO lbl624
                if (!it.isOutputDouble()) ** GOTO lbl622
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)(ibx == 0.0 ? 0.0 : iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(ibx == 0.0 ? 0.0 : iax / ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)(ibx == 0L ? 0L : iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(ibx == 0L ? 0L : iax / ibx);
                        ++j;
                    }
lbl622:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl623:
                // 1 sources

                break;
lbl624:
                // 1 sources

                if (as != 1) ** GOTO lbl647
                if (!it.isOutputDouble()) ** GOTO lbl645
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = (float)(ibx == 0.0 ? 0.0 : iax / ibx);
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = ibx == 0L ? 0L : iax / ibx;
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl645:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl646:
                // 1 sources

                break;
lbl647:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl671
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)(ibx == 0.0 ? 0.0 : iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(ibx == 0.0 ? 0.0 : iax / ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)(ibx == 0L ? 0L : iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(ibx == 0L ? 0L : iax / ibx);
                        ++j;
                    }
lbl671:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl672:
                // 1 sources

                break;
            }
            case 600: {
                oaf64data = ((CompoundDoubleDataset)result).getData();
                if (is != 1) ** GOTO lbl688
                if (!it.isOutputDouble()) ** GOTO lbl686
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = ibx == 0.0 ? 0.0 : iax / ibx;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = (double)(ibx == 0L ? 0L : iax / ibx);
lbl686:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl687:
                // 1 sources

                break;
lbl688:
                // 1 sources

                if (as >= bs) ** GOTO lbl713
                if (!it.isOutputDouble()) ** GOTO lbl711
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = ibx == 0.0 ? 0.0 : iax / ibx;
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = ibx == 0.0 ? 0.0 : iax / ibx;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = (double)(ibx == 0L ? 0L : iax / ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = (double)(ibx == 0L ? 0L : iax / ibx);
                        ++j;
                    }
lbl711:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl712:
                // 1 sources

                break;
lbl713:
                // 1 sources

                if (as <= bs) ** GOTO lbl738
                if (!it.isOutputDouble()) ** GOTO lbl736
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = ibx == 0.0 ? 0.0 : iax / ibx;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = ibx == 0.0 ? 0.0 : iax / ibx;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = (double)(ibx == 0L ? 0L : iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = (double)(ibx == 0L ? 0L : iax / ibx);
                        ++j;
                    }
lbl736:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl737:
                // 1 sources

                break;
lbl738:
                // 1 sources

                if (as != 1) ** GOTO lbl761
                if (!it.isOutputDouble()) ** GOTO lbl759
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = ibx == 0.0 ? 0.0 : iax / ibx;
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = ibx == 0L ? 0L : iax / ibx;
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl759:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl760:
                // 1 sources

                break;
lbl761:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl785
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = ibx == 0.0 ? 0.0 : iax / ibx;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = ibx == 0.0 ? 0.0 : iax / ibx;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = (double)(ibx == 0L ? 0L : iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = (double)(ibx == 0L ? 0L : iax / ibx);
                        ++j;
                    }
lbl785:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl786:
                // 1 sources

                break;
            }
            case 7: {
                oc64data = ((ComplexFloatDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl841
                if (!it.isOutputDouble()) ** GOTO lbl827
                iay = 0.0;
                if (!db.isComplex()) ** GOTO lbl825
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iby = db.getElementDoubleAbs(it.bIndex + 1);
                    if (ibx == 0.0 && iby == 0.0) {
                        ox = 0.0f;
                        oy = 0.0f;
                    } else if (Math.abs(ibx) < Math.abs(iby)) {
                        q = (float)(ibx / iby);
                        den = (float)(ibx * (double)q + iby);
                        ox = (float)((iax * (double)q + 0.0) / (double)den);
                        oy = (float)((0.0 * (double)q - iax) / (double)den);
                    } else {
                        q = (float)(iby / ibx);
                        den = (float)(iby * (double)q + ibx);
                        ox = (float)((0.0 * (double)q + iax) / (double)den);
                        oy = (float)((0.0 - iax * (double)q) / (double)den);
                    }
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    if (ibx == 0.0) {
                        ox = 0.0f;
                        oy = 0.0f;
                    } else {
                        ox = (float)(iax / ibx);
                        oy = (float)(0.0 / ibx);
                    }
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
lbl825:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl826:
                // 1 sources

                break;
lbl827:
                // 1 sources

                iay = 0L;
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    if (ibx == 0L) {
                        ox = 0.0f;
                        oy = 0.0f;
                    } else {
                        ox = iax / ibx;
                        oy = 0L / ibx;
                    }
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
                }
                break;
lbl841:
                // 1 sources

                if (db.isComplex()) ** GOTO lbl876
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iay = da.getElementDoubleAbs(it.aIndex + 1);
                    if (ibx == 0.0) {
                        ox = 0.0f;
                        oy = 0.0f;
                    } else {
                        ox = (float)(iax / ibx);
                        oy = (float)(iay / ibx);
                    }
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iay = da.getElementDoubleAbs(it.aIndex + 1);
                    iby = db.getElementDoubleAbs(it.bIndex + 1);
                    if (ibx == 0.0 && iby == 0.0) {
                        ox = 0.0f;
                        oy = 0.0f;
                    } else if (Math.abs(ibx) < Math.abs(iby)) {
                        q = (float)(ibx / iby);
                        den = (float)(ibx * (double)q + iby);
                        ox = (float)((iax * (double)q + iay) / (double)den);
                        oy = (float)((iay * (double)q - iax) / (double)den);
                    } else {
                        q = (float)(iby / ibx);
                        den = (float)(iby * (double)q + ibx);
                        ox = (float)((iay * (double)q + iax) / (double)den);
                        oy = (float)((iay - iax * (double)q) / (double)den);
                    }
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
lbl876:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl877:
                // 1 sources

                break;
            }
            case 8: {
                oc128data = ((ComplexDoubleDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl932
                if (!it.isOutputDouble()) ** GOTO lbl918
                iay = 0.0;
                if (!db.isComplex()) ** GOTO lbl916
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iby = db.getElementDoubleAbs(it.bIndex + 1);
                    if (ibx == 0.0 && iby == 0.0) {
                        ox = 0.0;
                        oy = 0.0;
                    } else if (Math.abs(ibx) < Math.abs(iby)) {
                        q = ibx / iby;
                        den = ibx * q + iby;
                        ox = (iax * q + 0.0) / den;
                        oy = (0.0 * q - iax) / den;
                    } else {
                        q = iby / ibx;
                        den = iby * q + ibx;
                        ox = (0.0 * q + iax) / den;
                        oy = (0.0 - iax * q) / den;
                    }
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    if (ibx == 0.0) {
                        ox = 0.0;
                        oy = 0.0;
                    } else {
                        ox = iax / ibx;
                        oy = 0.0 / ibx;
                    }
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
lbl916:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl917:
                // 1 sources

                break;
lbl918:
                // 1 sources

                iay = 0L;
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    if (ibx == 0L) {
                        ox = 0.0;
                        oy = 0.0;
                    } else {
                        ox = iax / ibx;
                        oy = 0L / ibx;
                    }
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
                }
                break;
lbl932:
                // 1 sources

                if (db.isComplex()) ** GOTO lbl967
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iay = da.getElementDoubleAbs(it.aIndex + 1);
                    if (ibx == 0.0) {
                        ox = 0.0;
                        oy = 0.0;
                    } else {
                        ox = iax / ibx;
                        oy = iay / ibx;
                    }
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iay = da.getElementDoubleAbs(it.aIndex + 1);
                    iby = db.getElementDoubleAbs(it.bIndex + 1);
                    if (ibx == 0.0 && iby == 0.0) {
                        ox = 0.0;
                        oy = 0.0;
                    } else if (Math.abs(ibx) < Math.abs(iby)) {
                        q = ibx / iby;
                        den = ibx * q + iby;
                        ox = (iax * q + iay) / den;
                        oy = (iay * q - iax) / den;
                    } else {
                        q = iby / ibx;
                        den = iby * q + ibx;
                        ox = (iay * q + iax) / den;
                        oy = (iay - iax * q) / den;
                    }
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
lbl967:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl968:
                // 1 sources

                break;
            }
            default: {
                throw new IllegalArgumentException("dividez supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        Maths.addBinaryOperatorName(da, db, result, "/");
        return result;
    }

    public static Dataset divideTowardsFloor(Object a, Object b) {
        return Maths.divideTowardsFloor(a, b, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset divideTowardsFloor(Object a, Object b, Dataset o) {
        da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        it = BroadcastIterator.createIterator(da, db = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b), o, true);
        result = it.getOutput();
        if (!result.isComplex()) {
            change = false;
            if (da.isComplex()) {
                da = da.getRealView();
                change = true;
            }
            if (db.isComplex()) {
                db = db.getRealView();
                change = true;
            }
            if (change) {
                it = BroadcastIterator.createIterator(da, db, result, true);
            }
        }
        is = result.getElementsPerItem();
        as = da.getElementsPerItem();
        bs = db.getElementsPerItem();
        dt = result.getDType();
        switch (dt) {
            case 1: {
                oi8data = ((ByteDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl43
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    if (ibx == 0.0) {
                        ox = 0;
                    } else {
                        ox = (byte)Maths.toLong(iax / ibx);
                        if (iax != (double)ox * ibx && iax < 0.0 ^ ibx < 0.0) {
                            ox = (byte)(ox - 1);
                        }
                    }
                    oi8data[it.oIndex] = ox;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    if (ibx == 0L) {
                        ox = 0;
                    } else {
                        ox = (byte)(iax / ibx);
                        if (iax != (long)ox * ibx && iax < 0L ^ ibx < 0L) {
                            ox = (byte)(ox - 1);
                        }
                    }
                    oi8data[it.oIndex] = ox;
lbl43:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl44:
                // 1 sources

                break;
            }
            case 2: {
                oi16data = ((ShortDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl69
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    if (ibx == 0.0) {
                        ox = 0;
                    } else {
                        ox = (short)Maths.toLong(iax / ibx);
                        if (iax != (double)ox * ibx && iax < 0.0 ^ ibx < 0.0) {
                            ox = (short)(ox - 1);
                        }
                    }
                    oi16data[it.oIndex] = ox;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    if (ibx == 0L) {
                        ox = 0;
                    } else {
                        ox = (short)(iax / ibx);
                        if (iax != (long)ox * ibx && iax < 0L ^ ibx < 0L) {
                            ox = (short)(ox - 1);
                        }
                    }
                    oi16data[it.oIndex] = ox;
lbl69:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl70:
                // 1 sources

                break;
            }
            case 4: {
                oi64data = ((LongDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl95
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    if (ibx == 0.0) {
                        ox = 0L;
                    } else {
                        ox = Maths.toLong(iax / ibx);
                        if (iax == (double)ox * ibx || iax < 0.0 ^ ibx < 0.0) {
                            // empty if block
                        }
                    }
                    oi64data[it.oIndex] = --ox;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    if (ibx == 0L) {
                        ox = 0L;
                    } else {
                        ox = iax / ibx;
                        if (iax == ox * ibx || iax < 0L ^ ibx < 0L) {
                            // empty if block
                        }
                    }
                    oi64data[it.oIndex] = --ox;
lbl95:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl96:
                // 1 sources

                break;
            }
            case 3: {
                oi32data = ((IntegerDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl121
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    if (ibx == 0.0) {
                        ox = 0;
                    } else {
                        ox = (int)Maths.toLong(iax / ibx);
                        if (iax == (double)ox * ibx || iax < 0.0 ^ ibx < 0.0) {
                            // empty if block
                        }
                    }
                    oi32data[it.oIndex] = --ox;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    if (ibx == 0L) {
                        ox = 0;
                    } else {
                        ox = (int)(iax / ibx);
                        if (iax == (long)ox * ibx || iax < 0L ^ ibx < 0L) {
                            // empty if block
                        }
                    }
                    oi32data[it.oIndex] = --ox;
lbl121:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl122:
                // 1 sources

                break;
            }
            case 100: {
                oai8data = ((CompoundByteDataset)result).getData();
                if (is != 1) ** GOTO lbl150
                if (!it.isOutputDouble()) ** GOTO lbl148
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    if (ibx == 0.0) {
                        ox = 0;
                    } else {
                        ox = (byte)Maths.toLong(iax / ibx);
                        if (iax != (double)ox * ibx && iax < 0.0 ^ ibx < 0.0) {
                            ox = (byte)(ox - 1);
                        }
                    }
                    oai8data[it.oIndex] = ox;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    if (ibx == 0L) {
                        ox = 0;
                    } else {
                        ox = (byte)(iax / ibx);
                        if (iax != (long)ox * ibx && iax < 0L ^ ibx < 0L) {
                            ox = (byte)(ox - 1);
                        }
                    }
                    oai8data[it.oIndex] = ox;
lbl148:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl149:
                // 1 sources

                break;
lbl150:
                // 1 sources

                if (as >= bs) ** GOTO lbl199
                if (!it.isOutputDouble()) ** GOTO lbl197
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    if (ibx == 0.0) {
                        ox = 0;
                    } else {
                        ox = (byte)Maths.toLong(iax / ibx);
                        if (iax != (double)ox * ibx && iax < 0.0 ^ ibx < 0.0) {
                            ox = (byte)(ox - 1);
                        }
                    }
                    oai8data[it.oIndex] = ox;
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        if (ibx == 0.0) {
                            ox = 0;
                        } else {
                            ox = (byte)Maths.toLong(iax / ibx);
                            if (iax != (double)ox * ibx && iax < 0.0 ^ ibx < 0.0) {
                                ox = (byte)(ox - 1);
                            }
                        }
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    if (ibx == 0L) {
                        ox = 0;
                    } else {
                        ox = (byte)(iax / ibx);
                        if (iax != (long)ox * ibx && iax < 0L ^ ibx < 0L) {
                            ox = (byte)(ox - 1);
                        }
                    }
                    oai8data[it.oIndex] = ox;
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        if (ibx == 0L) {
                            ox = 0;
                        } else {
                            ox = (byte)(iax / ibx);
                            if (iax != (long)ox * ibx && iax < 0L ^ ibx < 0L) {
                                ox = (byte)(ox - 1);
                            }
                        }
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl197:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl198:
                // 1 sources

                break;
lbl199:
                // 1 sources

                if (as <= bs) ** GOTO lbl248
                if (!it.isOutputDouble()) ** GOTO lbl246
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    if (ibx == 0.0) {
                        ox = 0;
                    } else {
                        ox = (byte)Maths.toLong(iax / ibx);
                        if (iax != (double)ox * ibx && iax < 0.0 ^ ibx < 0.0) {
                            ox = (byte)(ox - 1);
                        }
                    }
                    oai8data[it.oIndex] = ox;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        if (ibx == 0.0) {
                            ox = 0;
                        } else {
                            ox = (byte)Maths.toLong(iax / ibx);
                            if (iax != (double)ox * ibx && iax < 0.0 ^ ibx < 0.0) {
                                ox = (byte)(ox - 1);
                            }
                        }
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    if (ibx == 0L) {
                        ox = 0;
                    } else {
                        ox = (byte)(iax / ibx);
                        if (iax != (long)ox * ibx && iax < 0L ^ ibx < 0L) {
                            ox = (byte)(ox - 1);
                        }
                    }
                    oai8data[it.oIndex] = ox;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        if (ibx == 0L) {
                            ox = 0;
                        } else {
                            ox = (byte)(iax / ibx);
                            if (iax != (long)ox * ibx && iax < 0L ^ ibx < 0L) {
                                ox = (byte)(ox - 1);
                            }
                        }
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl246:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl247:
                // 1 sources

                break;
lbl248:
                // 1 sources

                if (as != 1) ** GOTO lbl281
                if (!it.isOutputDouble()) ** GOTO lbl279
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    if (ibx == 0.0) {
                        ox = 0;
                    } else {
                        ox = (byte)Maths.toLong(iax / ibx);
                        if (iax != (double)ox * ibx && iax < 0.0 ^ ibx < 0.0) {
                            ox = (byte)(ox - 1);
                        }
                    }
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    if (ibx == 0L) {
                        ox = 0;
                    } else {
                        ox = (byte)(iax / ibx);
                        if (iax != (long)ox * ibx && iax < 0L ^ ibx < 0L) {
                            ox = (byte)(ox - 1);
                        }
                    }
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl279:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl280:
                // 1 sources

                break;
lbl281:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl329
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    if (ibx == 0.0) {
                        ox = 0;
                    } else {
                        ox = (byte)Maths.toLong(iax / ibx);
                        if (iax != (double)ox * ibx && iax < 0.0 ^ ibx < 0.0) {
                            ox = (byte)(ox - 1);
                        }
                    }
                    oai8data[it.oIndex] = ox;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        if (ibx == 0.0) {
                            ox = 0;
                        } else {
                            ox = (byte)Maths.toLong(iax / ibx);
                            if (iax != (double)ox * ibx && iax < 0.0 ^ ibx < 0.0) {
                                ox = (byte)(ox - 1);
                            }
                        }
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    if (ibx == 0L) {
                        ox = 0;
                    } else {
                        ox = (byte)(iax / ibx);
                        if (iax != (long)ox * ibx && iax < 0L ^ ibx < 0L) {
                            ox = (byte)(ox - 1);
                        }
                    }
                    oai8data[it.oIndex] = ox;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        if (ibx == 0L) {
                            ox = 0;
                        } else {
                            ox = (byte)(iax / ibx);
                            if (iax != (long)ox * ibx && iax < 0L ^ ibx < 0L) {
                                ox = (byte)(ox - 1);
                            }
                        }
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl329:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl330:
                // 1 sources

                break;
            }
            case 200: {
                oai16data = ((CompoundShortDataset)result).getData();
                if (is != 1) ** GOTO lbl358
                if (!it.isOutputDouble()) ** GOTO lbl356
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    if (ibx == 0.0) {
                        ox = 0;
                    } else {
                        ox = (short)Maths.toLong(iax / ibx);
                        if (iax != (double)ox * ibx && iax < 0.0 ^ ibx < 0.0) {
                            ox = (short)(ox - 1);
                        }
                    }
                    oai16data[it.oIndex] = ox;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    if (ibx == 0L) {
                        ox = 0;
                    } else {
                        ox = (short)(iax / ibx);
                        if (iax != (long)ox * ibx && iax < 0L ^ ibx < 0L) {
                            ox = (short)(ox - 1);
                        }
                    }
                    oai16data[it.oIndex] = ox;
lbl356:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl357:
                // 1 sources

                break;
lbl358:
                // 1 sources

                if (as >= bs) ** GOTO lbl407
                if (!it.isOutputDouble()) ** GOTO lbl405
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    if (ibx == 0.0) {
                        ox = 0;
                    } else {
                        ox = (short)Maths.toLong(iax / ibx);
                        if (iax != (double)ox * ibx && iax < 0.0 ^ ibx < 0.0) {
                            ox = (short)(ox - 1);
                        }
                    }
                    oai16data[it.oIndex] = ox;
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        if (ibx == 0.0) {
                            ox = 0;
                        } else {
                            ox = (short)Maths.toLong(iax / ibx);
                            if (iax != (double)ox * ibx && iax < 0.0 ^ ibx < 0.0) {
                                ox = (short)(ox - 1);
                            }
                        }
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    if (ibx == 0L) {
                        ox = 0;
                    } else {
                        ox = (short)(iax / ibx);
                        if (iax != (long)ox * ibx && iax < 0L ^ ibx < 0L) {
                            ox = (short)(ox - 1);
                        }
                    }
                    oai16data[it.oIndex] = ox;
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        if (ibx == 0L) {
                            ox = 0;
                        } else {
                            ox = (short)(iax / ibx);
                            if (iax != (long)ox * ibx && iax < 0L ^ ibx < 0L) {
                                ox = (short)(ox - 1);
                            }
                        }
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl405:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl406:
                // 1 sources

                break;
lbl407:
                // 1 sources

                if (as <= bs) ** GOTO lbl456
                if (!it.isOutputDouble()) ** GOTO lbl454
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    if (ibx == 0.0) {
                        ox = 0;
                    } else {
                        ox = (short)Maths.toLong(iax / ibx);
                        if (iax != (double)ox * ibx && iax < 0.0 ^ ibx < 0.0) {
                            ox = (short)(ox - 1);
                        }
                    }
                    oai16data[it.oIndex] = ox;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        if (ibx == 0.0) {
                            ox = 0;
                        } else {
                            ox = (short)Maths.toLong(iax / ibx);
                            if (iax != (double)ox * ibx && iax < 0.0 ^ ibx < 0.0) {
                                ox = (short)(ox - 1);
                            }
                        }
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    if (ibx == 0L) {
                        ox = 0;
                    } else {
                        ox = (short)(iax / ibx);
                        if (iax != (long)ox * ibx && iax < 0L ^ ibx < 0L) {
                            ox = (short)(ox - 1);
                        }
                    }
                    oai16data[it.oIndex] = ox;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        if (ibx == 0L) {
                            ox = 0;
                        } else {
                            ox = (short)(iax / ibx);
                            if (iax != (long)ox * ibx && iax < 0L ^ ibx < 0L) {
                                ox = (short)(ox - 1);
                            }
                        }
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl454:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl455:
                // 1 sources

                break;
lbl456:
                // 1 sources

                if (as != 1) ** GOTO lbl489
                if (!it.isOutputDouble()) ** GOTO lbl487
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    if (ibx == 0.0) {
                        ox = 0;
                    } else {
                        ox = (short)Maths.toLong(iax / ibx);
                        if (iax != (double)ox * ibx && iax < 0.0 ^ ibx < 0.0) {
                            ox = (short)(ox - 1);
                        }
                    }
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    if (ibx == 0L) {
                        ox = 0;
                    } else {
                        ox = (short)(iax / ibx);
                        if (iax != (long)ox * ibx && iax < 0L ^ ibx < 0L) {
                            ox = (short)(ox - 1);
                        }
                    }
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl487:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl488:
                // 1 sources

                break;
lbl489:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl537
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    if (ibx == 0.0) {
                        ox = 0;
                    } else {
                        ox = (short)Maths.toLong(iax / ibx);
                        if (iax != (double)ox * ibx && iax < 0.0 ^ ibx < 0.0) {
                            ox = (short)(ox - 1);
                        }
                    }
                    oai16data[it.oIndex] = ox;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        if (ibx == 0.0) {
                            ox = 0;
                        } else {
                            ox = (short)Maths.toLong(iax / ibx);
                            if (iax != (double)ox * ibx && iax < 0.0 ^ ibx < 0.0) {
                                ox = (short)(ox - 1);
                            }
                        }
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    if (ibx == 0L) {
                        ox = 0;
                    } else {
                        ox = (short)(iax / ibx);
                        if (iax != (long)ox * ibx && iax < 0L ^ ibx < 0L) {
                            ox = (short)(ox - 1);
                        }
                    }
                    oai16data[it.oIndex] = ox;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        if (ibx == 0L) {
                            ox = 0;
                        } else {
                            ox = (short)(iax / ibx);
                            if (iax != (long)ox * ibx && iax < 0L ^ ibx < 0L) {
                                ox = (short)(ox - 1);
                            }
                        }
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl537:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl538:
                // 1 sources

                break;
            }
            case 400: {
                oai64data = ((CompoundLongDataset)result).getData();
                if (is != 1) ** GOTO lbl566
                if (!it.isOutputDouble()) ** GOTO lbl564
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    if (ibx == 0.0) {
                        ox = 0L;
                    } else {
                        ox = Maths.toLong(iax / ibx);
                        if (iax == (double)ox * ibx || iax < 0.0 ^ ibx < 0.0) {
                            // empty if block
                        }
                    }
                    oai64data[it.oIndex] = --ox;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    if (ibx == 0L) {
                        ox = 0L;
                    } else {
                        ox = iax / ibx;
                        if (iax == ox * ibx || iax < 0L ^ ibx < 0L) {
                            // empty if block
                        }
                    }
                    oai64data[it.oIndex] = --ox;
lbl564:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl565:
                // 1 sources

                break;
lbl566:
                // 1 sources

                if (as >= bs) ** GOTO lbl615
                if (!it.isOutputDouble()) ** GOTO lbl613
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    if (ibx == 0.0) {
                        ox = 0L;
                    } else {
                        ox = Maths.toLong(iax / ibx);
                        if (iax == (double)ox * ibx || iax < 0.0 ^ ibx < 0.0) {
                            // empty if block
                        }
                    }
                    oai64data[it.oIndex] = --ox;
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        if (ibx == 0.0) {
                            ox = 0L;
                        } else {
                            ox = Maths.toLong(iax / ibx);
                            if (iax == (double)ox * ibx || iax < 0.0 ^ ibx < 0.0) {
                                // empty if block
                            }
                        }
                        oai64data[it.oIndex + j] = --ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    if (ibx == 0L) {
                        ox = 0L;
                    } else {
                        ox = iax / ibx;
                        if (iax == ox * ibx || iax < 0L ^ ibx < 0L) {
                            // empty if block
                        }
                    }
                    oai64data[it.oIndex] = --ox;
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        if (ibx == 0L) {
                            ox = 0L;
                        } else {
                            ox = iax / ibx;
                            if (iax == ox * ibx || iax < 0L ^ ibx < 0L) {
                                // empty if block
                            }
                        }
                        oai64data[it.oIndex + j] = --ox;
                        ++j;
                    }
lbl613:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl614:
                // 1 sources

                break;
lbl615:
                // 1 sources

                if (as <= bs) ** GOTO lbl664
                if (!it.isOutputDouble()) ** GOTO lbl662
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    if (ibx == 0.0) {
                        ox = 0L;
                    } else {
                        ox = Maths.toLong(iax / ibx);
                        if (iax == (double)ox * ibx || iax < 0.0 ^ ibx < 0.0) {
                            // empty if block
                        }
                    }
                    oai64data[it.oIndex] = --ox;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        if (ibx == 0.0) {
                            ox = 0L;
                        } else {
                            ox = Maths.toLong(iax / ibx);
                            if (iax == (double)ox * ibx || iax < 0.0 ^ ibx < 0.0) {
                                // empty if block
                            }
                        }
                        oai64data[it.oIndex + j] = --ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    if (ibx == 0L) {
                        ox = 0L;
                    } else {
                        ox = iax / ibx;
                        if (iax == ox * ibx || iax < 0L ^ ibx < 0L) {
                            // empty if block
                        }
                    }
                    oai64data[it.oIndex] = --ox;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        if (ibx == 0L) {
                            ox = 0L;
                        } else {
                            ox = iax / ibx;
                            if (iax == ox * ibx || iax < 0L ^ ibx < 0L) {
                                // empty if block
                            }
                        }
                        oai64data[it.oIndex + j] = --ox;
                        ++j;
                    }
lbl662:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl663:
                // 1 sources

                break;
lbl664:
                // 1 sources

                if (as != 1) ** GOTO lbl697
                if (!it.isOutputDouble()) ** GOTO lbl695
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    if (ibx == 0.0) {
                        ox = 0L;
                    } else {
                        ox = Maths.toLong(iax / ibx);
                        if (iax != (double)ox * ibx && iax < 0.0 ^ ibx < 0.0) {
                            --ox;
                        }
                    }
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    if (ibx == 0L) {
                        ox = 0L;
                    } else {
                        ox = iax / ibx;
                        if (iax != ox * ibx && iax < 0L ^ ibx < 0L) {
                            --ox;
                        }
                    }
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl695:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl696:
                // 1 sources

                break;
lbl697:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl745
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    if (ibx == 0.0) {
                        ox = 0L;
                    } else {
                        ox = Maths.toLong(iax / ibx);
                        if (iax == (double)ox * ibx || iax < 0.0 ^ ibx < 0.0) {
                            // empty if block
                        }
                    }
                    oai64data[it.oIndex] = --ox;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        if (ibx == 0.0) {
                            ox = 0L;
                        } else {
                            ox = Maths.toLong(iax / ibx);
                            if (iax == (double)ox * ibx || iax < 0.0 ^ ibx < 0.0) {
                                // empty if block
                            }
                        }
                        oai64data[it.oIndex + j] = --ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    if (ibx == 0L) {
                        ox = 0L;
                    } else {
                        ox = iax / ibx;
                        if (iax == ox * ibx || iax < 0L ^ ibx < 0L) {
                            // empty if block
                        }
                    }
                    oai64data[it.oIndex] = --ox;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        if (ibx == 0L) {
                            ox = 0L;
                        } else {
                            ox = iax / ibx;
                            if (iax == ox * ibx || iax < 0L ^ ibx < 0L) {
                                // empty if block
                            }
                        }
                        oai64data[it.oIndex + j] = --ox;
                        ++j;
                    }
lbl745:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl746:
                // 1 sources

                break;
            }
            case 300: {
                oai32data = ((CompoundIntegerDataset)result).getData();
                if (is != 1) ** GOTO lbl774
                if (!it.isOutputDouble()) ** GOTO lbl772
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    if (ibx == 0.0) {
                        ox = 0;
                    } else {
                        ox = (int)Maths.toLong(iax / ibx);
                        if (iax == (double)ox * ibx || iax < 0.0 ^ ibx < 0.0) {
                            // empty if block
                        }
                    }
                    oai32data[it.oIndex] = --ox;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    if (ibx == 0L) {
                        ox = 0;
                    } else {
                        ox = (int)(iax / ibx);
                        if (iax == (long)ox * ibx || iax < 0L ^ ibx < 0L) {
                            // empty if block
                        }
                    }
                    oai32data[it.oIndex] = --ox;
lbl772:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl773:
                // 1 sources

                break;
lbl774:
                // 1 sources

                if (as >= bs) ** GOTO lbl823
                if (!it.isOutputDouble()) ** GOTO lbl821
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    if (ibx == 0.0) {
                        ox = 0;
                    } else {
                        ox = (int)Maths.toLong(iax / ibx);
                        if (iax == (double)ox * ibx || iax < 0.0 ^ ibx < 0.0) {
                            // empty if block
                        }
                    }
                    oai32data[it.oIndex] = --ox;
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        if (ibx == 0.0) {
                            ox = 0;
                        } else {
                            ox = (int)Maths.toLong(iax / ibx);
                            if (iax == (double)ox * ibx || iax < 0.0 ^ ibx < 0.0) {
                                // empty if block
                            }
                        }
                        oai32data[it.oIndex + j] = --ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    if (ibx == 0L) {
                        ox = 0;
                    } else {
                        ox = (int)(iax / ibx);
                        if (iax == (long)ox * ibx || iax < 0L ^ ibx < 0L) {
                            // empty if block
                        }
                    }
                    oai32data[it.oIndex] = --ox;
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        if (ibx == 0L) {
                            ox = 0;
                        } else {
                            ox = (int)(iax / ibx);
                            if (iax == (long)ox * ibx || iax < 0L ^ ibx < 0L) {
                                // empty if block
                            }
                        }
                        oai32data[it.oIndex + j] = --ox;
                        ++j;
                    }
lbl821:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl822:
                // 1 sources

                break;
lbl823:
                // 1 sources

                if (as <= bs) ** GOTO lbl872
                if (!it.isOutputDouble()) ** GOTO lbl870
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    if (ibx == 0.0) {
                        ox = 0;
                    } else {
                        ox = (int)Maths.toLong(iax / ibx);
                        if (iax == (double)ox * ibx || iax < 0.0 ^ ibx < 0.0) {
                            // empty if block
                        }
                    }
                    oai32data[it.oIndex] = --ox;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        if (ibx == 0.0) {
                            ox = 0;
                        } else {
                            ox = (int)Maths.toLong(iax / ibx);
                            if (iax == (double)ox * ibx || iax < 0.0 ^ ibx < 0.0) {
                                // empty if block
                            }
                        }
                        oai32data[it.oIndex + j] = --ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    if (ibx == 0L) {
                        ox = 0;
                    } else {
                        ox = (int)(iax / ibx);
                        if (iax == (long)ox * ibx || iax < 0L ^ ibx < 0L) {
                            // empty if block
                        }
                    }
                    oai32data[it.oIndex] = --ox;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        if (ibx == 0L) {
                            ox = 0;
                        } else {
                            ox = (int)(iax / ibx);
                            if (iax == (long)ox * ibx || iax < 0L ^ ibx < 0L) {
                                // empty if block
                            }
                        }
                        oai32data[it.oIndex + j] = --ox;
                        ++j;
                    }
lbl870:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl871:
                // 1 sources

                break;
lbl872:
                // 1 sources

                if (as != 1) ** GOTO lbl905
                if (!it.isOutputDouble()) ** GOTO lbl903
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    if (ibx == 0.0) {
                        ox = 0;
                    } else {
                        ox = (int)Maths.toLong(iax / ibx);
                        if (iax != (double)ox * ibx && iax < 0.0 ^ ibx < 0.0) {
                            --ox;
                        }
                    }
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    if (ibx == 0L) {
                        ox = 0;
                    } else {
                        ox = (int)(iax / ibx);
                        if (iax != (long)ox * ibx && iax < 0L ^ ibx < 0L) {
                            --ox;
                        }
                    }
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl903:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl904:
                // 1 sources

                break;
lbl905:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl953
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    if (ibx == 0.0) {
                        ox = 0;
                    } else {
                        ox = (int)Maths.toLong(iax / ibx);
                        if (iax == (double)ox * ibx || iax < 0.0 ^ ibx < 0.0) {
                            // empty if block
                        }
                    }
                    oai32data[it.oIndex] = --ox;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        if (ibx == 0.0) {
                            ox = 0;
                        } else {
                            ox = (int)Maths.toLong(iax / ibx);
                            if (iax == (double)ox * ibx || iax < 0.0 ^ ibx < 0.0) {
                                // empty if block
                            }
                        }
                        oai32data[it.oIndex + j] = --ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    if (ibx == 0L) {
                        ox = 0;
                    } else {
                        ox = (int)(iax / ibx);
                        if (iax == (long)ox * ibx || iax < 0L ^ ibx < 0L) {
                            // empty if block
                        }
                    }
                    oai32data[it.oIndex] = --ox;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        if (ibx == 0L) {
                            ox = 0;
                        } else {
                            ox = (int)(iax / ibx);
                            if (iax == (long)ox * ibx || iax < 0L ^ ibx < 0L) {
                                // empty if block
                            }
                        }
                        oai32data[it.oIndex + j] = --ox;
                        ++j;
                    }
lbl953:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl954:
                // 1 sources

                break;
            }
            case 5: {
                of32data = ((FloatDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl967
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    of32data[it.oIndex] = ox = (float)(iax / ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    of32data[it.oIndex] = ox = (float)(iax / ibx);
lbl967:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl968:
                // 1 sources

                break;
            }
            case 6: {
                of64data = ((DoubleDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl981
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    of64data[it.oIndex] = ox = iax / ibx;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    of64data[it.oIndex] = ox = (double)(iax / ibx);
lbl981:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl982:
                // 1 sources

                break;
            }
            case 500: {
                oaf32data = ((CompoundFloatDataset)result).getData();
                if (is != 1) ** GOTO lbl998
                if (!it.isOutputDouble()) ** GOTO lbl996
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)(iax / ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)(iax / ibx);
lbl996:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl997:
                // 1 sources

                break;
lbl998:
                // 1 sources

                if (as >= bs) ** GOTO lbl1023
                if (!it.isOutputDouble()) ** GOTO lbl1021
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)(iax / ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(iax / ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)(iax / ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(iax / ibx);
                        ++j;
                    }
lbl1021:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl1022:
                // 1 sources

                break;
lbl1023:
                // 1 sources

                if (as <= bs) ** GOTO lbl1048
                if (!it.isOutputDouble()) ** GOTO lbl1046
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)(iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(iax / ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)(iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(iax / ibx);
                        ++j;
                    }
lbl1046:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl1047:
                // 1 sources

                break;
lbl1048:
                // 1 sources

                if (as != 1) ** GOTO lbl1071
                if (!it.isOutputDouble()) ** GOTO lbl1069
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = (float)(iax / ibx);
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = iax / ibx;
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl1069:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl1070:
                // 1 sources

                break;
lbl1071:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl1095
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)(iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(iax / ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)(iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(iax / ibx);
                        ++j;
                    }
lbl1095:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl1096:
                // 1 sources

                break;
            }
            case 600: {
                oaf64data = ((CompoundDoubleDataset)result).getData();
                if (is != 1) ** GOTO lbl1112
                if (!it.isOutputDouble()) ** GOTO lbl1110
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = iax / ibx;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = (double)(iax / ibx);
lbl1110:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl1111:
                // 1 sources

                break;
lbl1112:
                // 1 sources

                if (as >= bs) ** GOTO lbl1137
                if (!it.isOutputDouble()) ** GOTO lbl1135
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = iax / ibx;
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = iax / ibx;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = (double)(iax / ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = (double)(iax / ibx);
                        ++j;
                    }
lbl1135:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl1136:
                // 1 sources

                break;
lbl1137:
                // 1 sources

                if (as <= bs) ** GOTO lbl1162
                if (!it.isOutputDouble()) ** GOTO lbl1160
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = iax / ibx;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = iax / ibx;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = (double)(iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = (double)(iax / ibx);
                        ++j;
                    }
lbl1160:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl1161:
                // 1 sources

                break;
lbl1162:
                // 1 sources

                if (as != 1) ** GOTO lbl1185
                if (!it.isOutputDouble()) ** GOTO lbl1183
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = iax / ibx;
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = iax / ibx;
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl1183:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl1184:
                // 1 sources

                break;
lbl1185:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl1209
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = iax / ibx;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = iax / ibx;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = (double)(iax / ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = (double)(iax / ibx);
                        ++j;
                    }
lbl1209:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl1210:
                // 1 sources

                break;
            }
            case 7: {
                oc64data = ((ComplexFloatDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl1261
                if (!it.isOutputDouble()) ** GOTO lbl1251
                iay = 0.0;
                if (!db.isComplex()) ** GOTO lbl1249
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iby = db.getElementDoubleAbs(it.bIndex + 1);
                    if (iby == 0.0) {
                        ox = (float)(iax / ibx);
                        oy = (float)(0.0 / ibx);
                    } else if (ibx == 0.0) {
                        ox = (float)(0.0 / iby);
                        oy = (float)(-iax / iby);
                    } else if (Math.abs(ibx) < Math.abs(iby)) {
                        q = (float)(ibx / iby);
                        den = (float)(ibx * (double)q + iby);
                        ox = (float)((iax * (double)q + 0.0) / (double)den);
                        oy = (float)((0.0 * (double)q - iax) / (double)den);
                    } else {
                        q = (float)(iby / ibx);
                        den = (float)(iby * (double)q + ibx);
                        ox = (float)((0.0 * (double)q + iax) / (double)den);
                        oy = (float)((0.0 - iax * (double)q) / (double)den);
                    }
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = (float)(iax / ibx);
                    oy = (float)(0.0 / ibx);
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
lbl1249:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl1250:
                // 1 sources

                break;
lbl1251:
                // 1 sources

                iay = 0L;
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = iax / ibx;
                    oy = 0L / ibx;
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
                }
                break;
lbl1261:
                // 1 sources

                if (db.isComplex()) ** GOTO lbl1296
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iay = da.getElementDoubleAbs(it.aIndex + 1);
                    ox = (float)(iax / ibx);
                    oy = (float)(iay / ibx);
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iay = da.getElementDoubleAbs(it.aIndex + 1);
                    iby = db.getElementDoubleAbs(it.bIndex + 1);
                    if (iby == 0.0) {
                        ox = (float)(iax / ibx);
                        oy = (float)(iay / ibx);
                    } else if (ibx == 0.0) {
                        ox = (float)(iay / iby);
                        oy = (float)(-iax / iby);
                    } else if (Math.abs(ibx) < Math.abs(iby)) {
                        q = (float)(ibx / iby);
                        den = (float)(ibx * (double)q + iby);
                        ox = (float)((iax * (double)q + iay) / (double)den);
                        oy = (float)((iay * (double)q - iax) / (double)den);
                    } else {
                        q = (float)(iby / ibx);
                        den = (float)(iby * (double)q + ibx);
                        ox = (float)((iay * (double)q + iax) / (double)den);
                        oy = (float)((iay - iax * (double)q) / (double)den);
                    }
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
lbl1296:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl1297:
                // 1 sources

                break;
            }
            case 8: {
                oc128data = ((ComplexDoubleDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl1348
                if (!it.isOutputDouble()) ** GOTO lbl1338
                iay = 0.0;
                if (!db.isComplex()) ** GOTO lbl1336
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iby = db.getElementDoubleAbs(it.bIndex + 1);
                    if (iby == 0.0) {
                        ox = iax / ibx;
                        oy = 0.0 / ibx;
                    } else if (ibx == 0.0) {
                        ox = 0.0 / iby;
                        oy = -iax / iby;
                    } else if (Math.abs(ibx) < Math.abs(iby)) {
                        q = ibx / iby;
                        den = ibx * q + iby;
                        ox = (iax * q + 0.0) / den;
                        oy = (0.0 * q - iax) / den;
                    } else {
                        q = iby / ibx;
                        den = iby * q + ibx;
                        ox = (0.0 * q + iax) / den;
                        oy = (0.0 - iax * q) / den;
                    }
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = iax / ibx;
                    oy = 0.0 / ibx;
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
lbl1336:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl1337:
                // 1 sources

                break;
lbl1338:
                // 1 sources

                iay = 0L;
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = iax / ibx;
                    oy = 0L / ibx;
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
                }
                break;
lbl1348:
                // 1 sources

                if (db.isComplex()) ** GOTO lbl1383
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iay = da.getElementDoubleAbs(it.aIndex + 1);
                    ox = iax / ibx;
                    oy = iay / ibx;
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iay = da.getElementDoubleAbs(it.aIndex + 1);
                    iby = db.getElementDoubleAbs(it.bIndex + 1);
                    if (iby == 0.0) {
                        ox = iax / ibx;
                        oy = iay / ibx;
                    } else if (ibx == 0.0) {
                        ox = iay / iby;
                        oy = -iax / iby;
                    } else if (Math.abs(ibx) < Math.abs(iby)) {
                        q = ibx / iby;
                        den = ibx * q + iby;
                        ox = (iax * q + iay) / den;
                        oy = (iay * q - iax) / den;
                    } else {
                        q = iby / ibx;
                        den = iby * q + ibx;
                        ox = (iay * q + iax) / den;
                        oy = (iay - iax * q) / den;
                    }
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
lbl1383:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl1384:
                // 1 sources

                break;
            }
            default: {
                throw new IllegalArgumentException("divideTowardsFloor supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        Maths.addBinaryOperatorName(da, db, result, "/");
        return result;
    }

    public static Dataset power(Object a, Object b) {
        return Maths.power(a, b, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset power(Object a, Object b, Dataset o) {
        da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        it = BroadcastIterator.createIterator(da, db = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b), o, true);
        result = it.getOutput();
        if (!result.isComplex()) {
            change = false;
            if (da.isComplex()) {
                da = da.getRealView();
                change = true;
            }
            if (db.isComplex()) {
                db = db.getRealView();
                change = true;
            }
            if (change) {
                it = BroadcastIterator.createIterator(da, db, result, true);
            }
        }
        is = result.getElementsPerItem();
        as = da.getElementsPerItem();
        bs = db.getElementsPerItem();
        dt = result.getDType();
        switch (dt) {
            case 1: {
                oi8data = ((ByteDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl31
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oi8data[it.oIndex] = ox = (byte)Maths.toLong(Math.pow(iax, ibx));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi8data[it.oIndex] = ox = (byte)Maths.toLong(Math.pow(iax, ibx));
lbl31:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl32:
                // 1 sources

                break;
            }
            case 2: {
                oi16data = ((ShortDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl45
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oi16data[it.oIndex] = ox = (short)Maths.toLong(Math.pow(iax, ibx));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi16data[it.oIndex] = ox = (short)Maths.toLong(Math.pow(iax, ibx));
lbl45:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl46:
                // 1 sources

                break;
            }
            case 4: {
                oi64data = ((LongDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl59
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oi64data[it.oIndex] = ox = Maths.toLong(Math.pow(iax, ibx));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi64data[it.oIndex] = ox = Maths.toLong(Math.pow(iax, ibx));
lbl59:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl60:
                // 1 sources

                break;
            }
            case 3: {
                oi32data = ((IntegerDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl73
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oi32data[it.oIndex] = ox = (int)Maths.toLong(Math.pow(iax, ibx));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi32data[it.oIndex] = ox = (int)Maths.toLong(Math.pow(iax, ibx));
lbl73:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl74:
                // 1 sources

                break;
            }
            case 100: {
                oai8data = ((CompoundByteDataset)result).getData();
                if (is != 1) ** GOTO lbl90
                if (!it.isOutputDouble()) ** GOTO lbl88
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.pow(iax, ibx));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.pow(iax, ibx));
lbl88:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl89:
                // 1 sources

                break;
lbl90:
                // 1 sources

                if (as >= bs) ** GOTO lbl115
                if (!it.isOutputDouble()) ** GOTO lbl113
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.pow(iax, ibx));
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.pow(iax, ibx));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.pow(iax, ibx));
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.pow(iax, ibx));
                        ++j;
                    }
lbl113:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl114:
                // 1 sources

                break;
lbl115:
                // 1 sources

                if (as <= bs) ** GOTO lbl140
                if (!it.isOutputDouble()) ** GOTO lbl138
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.pow(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.pow(iax, ibx));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.pow(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.pow(iax, ibx));
                        ++j;
                    }
lbl138:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl139:
                // 1 sources

                break;
lbl140:
                // 1 sources

                if (as != 1) ** GOTO lbl163
                if (!it.isOutputDouble()) ** GOTO lbl161
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = (byte)Maths.toLong(Math.pow(iax, ibx));
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (byte)Maths.toLong(Math.pow(iax, ibx));
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl161:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl162:
                // 1 sources

                break;
lbl163:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl187
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.pow(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.pow(iax, ibx));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.pow(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.pow(iax, ibx));
                        ++j;
                    }
lbl187:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl188:
                // 1 sources

                break;
            }
            case 200: {
                oai16data = ((CompoundShortDataset)result).getData();
                if (is != 1) ** GOTO lbl204
                if (!it.isOutputDouble()) ** GOTO lbl202
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.pow(iax, ibx));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.pow(iax, ibx));
lbl202:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl203:
                // 1 sources

                break;
lbl204:
                // 1 sources

                if (as >= bs) ** GOTO lbl229
                if (!it.isOutputDouble()) ** GOTO lbl227
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.pow(iax, ibx));
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.pow(iax, ibx));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.pow(iax, ibx));
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.pow(iax, ibx));
                        ++j;
                    }
lbl227:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl228:
                // 1 sources

                break;
lbl229:
                // 1 sources

                if (as <= bs) ** GOTO lbl254
                if (!it.isOutputDouble()) ** GOTO lbl252
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.pow(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.pow(iax, ibx));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.pow(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.pow(iax, ibx));
                        ++j;
                    }
lbl252:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl253:
                // 1 sources

                break;
lbl254:
                // 1 sources

                if (as != 1) ** GOTO lbl277
                if (!it.isOutputDouble()) ** GOTO lbl275
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = (short)Maths.toLong(Math.pow(iax, ibx));
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (short)Maths.toLong(Math.pow(iax, ibx));
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl275:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl276:
                // 1 sources

                break;
lbl277:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl301
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.pow(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.pow(iax, ibx));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.pow(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.pow(iax, ibx));
                        ++j;
                    }
lbl301:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl302:
                // 1 sources

                break;
            }
            case 400: {
                oai64data = ((CompoundLongDataset)result).getData();
                if (is != 1) ** GOTO lbl318
                if (!it.isOutputDouble()) ** GOTO lbl316
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.pow(iax, ibx));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.pow(iax, ibx));
lbl316:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl317:
                // 1 sources

                break;
lbl318:
                // 1 sources

                if (as >= bs) ** GOTO lbl343
                if (!it.isOutputDouble()) ** GOTO lbl341
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.pow(iax, ibx));
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.pow(iax, ibx));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.pow(iax, ibx));
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.pow(iax, ibx));
                        ++j;
                    }
lbl341:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl342:
                // 1 sources

                break;
lbl343:
                // 1 sources

                if (as <= bs) ** GOTO lbl368
                if (!it.isOutputDouble()) ** GOTO lbl366
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.pow(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.pow(iax, ibx));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.pow(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.pow(iax, ibx));
                        ++j;
                    }
lbl366:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl367:
                // 1 sources

                break;
lbl368:
                // 1 sources

                if (as != 1) ** GOTO lbl391
                if (!it.isOutputDouble()) ** GOTO lbl389
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = Maths.toLong(Math.pow(iax, ibx));
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = Maths.toLong(Math.pow(iax, ibx));
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl389:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl390:
                // 1 sources

                break;
lbl391:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl415
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.pow(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.pow(iax, ibx));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.pow(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.pow(iax, ibx));
                        ++j;
                    }
lbl415:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl416:
                // 1 sources

                break;
            }
            case 300: {
                oai32data = ((CompoundIntegerDataset)result).getData();
                if (is != 1) ** GOTO lbl432
                if (!it.isOutputDouble()) ** GOTO lbl430
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.pow(iax, ibx));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.pow(iax, ibx));
lbl430:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl431:
                // 1 sources

                break;
lbl432:
                // 1 sources

                if (as >= bs) ** GOTO lbl457
                if (!it.isOutputDouble()) ** GOTO lbl455
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.pow(iax, ibx));
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.pow(iax, ibx));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.pow(iax, ibx));
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.pow(iax, ibx));
                        ++j;
                    }
lbl455:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl456:
                // 1 sources

                break;
lbl457:
                // 1 sources

                if (as <= bs) ** GOTO lbl482
                if (!it.isOutputDouble()) ** GOTO lbl480
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.pow(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.pow(iax, ibx));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.pow(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.pow(iax, ibx));
                        ++j;
                    }
lbl480:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl481:
                // 1 sources

                break;
lbl482:
                // 1 sources

                if (as != 1) ** GOTO lbl505
                if (!it.isOutputDouble()) ** GOTO lbl503
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = (int)Maths.toLong(Math.pow(iax, ibx));
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (int)Maths.toLong(Math.pow(iax, ibx));
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl503:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl504:
                // 1 sources

                break;
lbl505:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl529
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.pow(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.pow(iax, ibx));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.pow(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.pow(iax, ibx));
                        ++j;
                    }
lbl529:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl530:
                // 1 sources

                break;
            }
            case 5: {
                of32data = ((FloatDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl543
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    of32data[it.oIndex] = ox = (float)Math.pow(iax, ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    of32data[it.oIndex] = ox = (float)Math.pow(iax, ibx);
lbl543:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl544:
                // 1 sources

                break;
            }
            case 6: {
                of64data = ((DoubleDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl557
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    of64data[it.oIndex] = ox = Math.pow(iax, ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    of64data[it.oIndex] = ox = Math.pow(iax, ibx);
lbl557:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl558:
                // 1 sources

                break;
            }
            case 500: {
                oaf32data = ((CompoundFloatDataset)result).getData();
                if (is != 1) ** GOTO lbl574
                if (!it.isOutputDouble()) ** GOTO lbl572
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)Math.pow(iax, ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)Math.pow(iax, ibx);
lbl572:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl573:
                // 1 sources

                break;
lbl574:
                // 1 sources

                if (as >= bs) ** GOTO lbl599
                if (!it.isOutputDouble()) ** GOTO lbl597
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)Math.pow(iax, ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.pow(iax, ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)Math.pow(iax, ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.pow(iax, ibx);
                        ++j;
                    }
lbl597:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl598:
                // 1 sources

                break;
lbl599:
                // 1 sources

                if (as <= bs) ** GOTO lbl624
                if (!it.isOutputDouble()) ** GOTO lbl622
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)Math.pow(iax, ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.pow(iax, ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)Math.pow(iax, ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.pow(iax, ibx);
                        ++j;
                    }
lbl622:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl623:
                // 1 sources

                break;
lbl624:
                // 1 sources

                if (as != 1) ** GOTO lbl647
                if (!it.isOutputDouble()) ** GOTO lbl645
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = (float)Math.pow(iax, ibx);
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (float)Math.pow(iax, ibx);
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl645:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl646:
                // 1 sources

                break;
lbl647:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl671
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)Math.pow(iax, ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.pow(iax, ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)Math.pow(iax, ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.pow(iax, ibx);
                        ++j;
                    }
lbl671:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl672:
                // 1 sources

                break;
            }
            case 600: {
                oaf64data = ((CompoundDoubleDataset)result).getData();
                if (is != 1) ** GOTO lbl688
                if (!it.isOutputDouble()) ** GOTO lbl686
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = Math.pow(iax, ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = Math.pow(iax, ibx);
lbl686:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl687:
                // 1 sources

                break;
lbl688:
                // 1 sources

                if (as >= bs) ** GOTO lbl713
                if (!it.isOutputDouble()) ** GOTO lbl711
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = Math.pow(iax, ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = Math.pow(iax, ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = Math.pow(iax, ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = Math.pow(iax, ibx);
                        ++j;
                    }
lbl711:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl712:
                // 1 sources

                break;
lbl713:
                // 1 sources

                if (as <= bs) ** GOTO lbl738
                if (!it.isOutputDouble()) ** GOTO lbl736
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = Math.pow(iax, ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = Math.pow(iax, ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = Math.pow(iax, ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = Math.pow(iax, ibx);
                        ++j;
                    }
lbl736:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl737:
                // 1 sources

                break;
lbl738:
                // 1 sources

                if (as != 1) ** GOTO lbl761
                if (!it.isOutputDouble()) ** GOTO lbl759
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = Math.pow(iax, ibx);
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = Math.pow(iax, ibx);
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl759:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl760:
                // 1 sources

                break;
lbl761:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl785
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = Math.pow(iax, ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = Math.pow(iax, ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = Math.pow(iax, ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = Math.pow(iax, ibx);
                        ++j;
                    }
lbl785:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl786:
                // 1 sources

                break;
            }
            case 7: {
                oc64data = ((ComplexFloatDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl826
                if (!it.isOutputDouble()) ** GOTO lbl814
                iay = 0.0;
                if (!db.isComplex()) ** GOTO lbl812
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iby = db.getElementDoubleAbs(it.bIndex + 1);
                    tz = new Complex(iax, 0.0).pow(new Complex(ibx, iby));
                    ox = (float)tz.getReal();
                    oy = (float)tz.getImaginary();
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iby = 0.0;
                    tz = new Complex(iax, 0.0).pow(new Complex(ibx, 0.0));
                    ox = (float)tz.getReal();
                    oy = (float)tz.getImaginary();
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
lbl812:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl813:
                // 1 sources

                break;
lbl814:
                // 1 sources

                iay = 0L;
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    iby = 0L;
                    tz = new Complex((double)iax, 0.0).pow(new Complex((double)ibx, 0.0));
                    ox = (float)tz.getReal();
                    oy = (float)tz.getImaginary();
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
                }
                break;
lbl826:
                // 1 sources

                if (db.isComplex()) ** GOTO lbl848
                iby = 0.0;
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iay = da.getElementDoubleAbs(it.aIndex + 1);
                    tz = new Complex(iax, iay).pow(new Complex(ibx, 0.0));
                    ox = (float)tz.getReal();
                    oy = (float)tz.getImaginary();
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iay = da.getElementDoubleAbs(it.aIndex + 1);
                    iby = db.getElementDoubleAbs(it.bIndex + 1);
                    tz = new Complex(iax, iay).pow(new Complex(ibx, iby));
                    ox = (float)tz.getReal();
                    oy = (float)tz.getImaginary();
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
lbl848:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl849:
                // 1 sources

                break;
            }
            case 8: {
                oc128data = ((ComplexDoubleDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl889
                if (!it.isOutputDouble()) ** GOTO lbl877
                iay = 0.0;
                if (!db.isComplex()) ** GOTO lbl875
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iby = db.getElementDoubleAbs(it.bIndex + 1);
                    tz = new Complex(iax, 0.0).pow(new Complex(ibx, iby));
                    ox = tz.getReal();
                    oy = tz.getImaginary();
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iby = 0.0;
                    tz = new Complex(iax, 0.0).pow(new Complex(ibx, 0.0));
                    ox = tz.getReal();
                    oy = tz.getImaginary();
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
lbl875:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl876:
                // 1 sources

                break;
lbl877:
                // 1 sources

                iay = 0L;
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    iby = 0L;
                    tz = new Complex((double)iax, 0.0).pow(new Complex((double)ibx, 0.0));
                    ox = tz.getReal();
                    oy = tz.getImaginary();
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
                }
                break;
lbl889:
                // 1 sources

                if (db.isComplex()) ** GOTO lbl911
                iby = 0.0;
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iay = da.getElementDoubleAbs(it.aIndex + 1);
                    tz = new Complex(iax, iay).pow(new Complex(ibx, 0.0));
                    ox = tz.getReal();
                    oy = tz.getImaginary();
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iay = da.getElementDoubleAbs(it.aIndex + 1);
                    iby = db.getElementDoubleAbs(it.bIndex + 1);
                    tz = new Complex(iax, iay).pow(new Complex(ibx, iby));
                    ox = tz.getReal();
                    oy = tz.getImaginary();
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
lbl911:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl912:
                // 1 sources

                break;
            }
            default: {
                throw new IllegalArgumentException("power supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        Maths.addBinaryOperatorName(da, db, result, "**");
        return result;
    }

    public static Dataset remainder(Object a, Object b) {
        return Maths.remainder(a, b, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset remainder(Object a, Object b, Dataset o) {
        da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        it = BroadcastIterator.createIterator(da, db = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b), o, true);
        result = it.getOutput();
        if (!result.isComplex()) {
            change = false;
            if (da.isComplex()) {
                da = da.getRealView();
                change = true;
            }
            if (db.isComplex()) {
                db = db.getRealView();
                change = true;
            }
            if (change) {
                it = BroadcastIterator.createIterator(da, db, result, true);
            }
        }
        is = result.getElementsPerItem();
        as = da.getElementsPerItem();
        bs = db.getElementsPerItem();
        dt = result.getDType();
        switch (dt) {
            case 1: {
                oi8data = ((ByteDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl31
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oi8data[it.oIndex] = ox = (byte)Maths.toLong(ibx == 0.0 ? 0.0 : iax % ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi8data[it.oIndex] = ox = (byte)(ibx == 0L ? 0L : iax % ibx);
lbl31:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl32:
                // 1 sources

                break;
            }
            case 2: {
                oi16data = ((ShortDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl45
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oi16data[it.oIndex] = ox = (short)Maths.toLong(ibx == 0.0 ? 0.0 : iax % ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi16data[it.oIndex] = ox = (short)(ibx == 0L ? 0L : iax % ibx);
lbl45:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl46:
                // 1 sources

                break;
            }
            case 4: {
                oi64data = ((LongDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl59
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oi64data[it.oIndex] = ox = Maths.toLong(ibx == 0.0 ? 0.0 : iax % ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi64data[it.oIndex] = ox = ibx == 0L ? 0L : iax % ibx;
lbl59:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl60:
                // 1 sources

                break;
            }
            case 3: {
                oi32data = ((IntegerDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl73
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oi32data[it.oIndex] = ox = (int)Maths.toLong(ibx == 0.0 ? 0.0 : iax % ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi32data[it.oIndex] = ox = (int)(ibx == 0L ? 0L : iax % ibx);
lbl73:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl74:
                // 1 sources

                break;
            }
            case 100: {
                oai8data = ((CompoundByteDataset)result).getData();
                if (is != 1) ** GOTO lbl90
                if (!it.isOutputDouble()) ** GOTO lbl88
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(ibx == 0.0 ? 0.0 : iax % ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)(ibx == 0L ? 0L : iax % ibx);
lbl88:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl89:
                // 1 sources

                break;
lbl90:
                // 1 sources

                if (as >= bs) ** GOTO lbl115
                if (!it.isOutputDouble()) ** GOTO lbl113
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(ibx == 0.0 ? 0.0 : iax % ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(ibx == 0.0 ? 0.0 : iax % ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)(ibx == 0L ? 0L : iax % ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)(ibx == 0L ? 0L : iax % ibx);
                        ++j;
                    }
lbl113:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl114:
                // 1 sources

                break;
lbl115:
                // 1 sources

                if (as <= bs) ** GOTO lbl140
                if (!it.isOutputDouble()) ** GOTO lbl138
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(ibx == 0.0 ? 0.0 : iax % ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(ibx == 0.0 ? 0.0 : iax % ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)(ibx == 0L ? 0L : iax % ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)(ibx == 0L ? 0L : iax % ibx);
                        ++j;
                    }
lbl138:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl139:
                // 1 sources

                break;
lbl140:
                // 1 sources

                if (as != 1) ** GOTO lbl163
                if (!it.isOutputDouble()) ** GOTO lbl161
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = (byte)Maths.toLong(ibx == 0.0 ? 0.0 : iax % ibx);
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (byte)(ibx == 0L ? 0L : iax % ibx);
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl161:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl162:
                // 1 sources

                break;
lbl163:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl187
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(ibx == 0.0 ? 0.0 : iax % ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(ibx == 0.0 ? 0.0 : iax % ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)(ibx == 0L ? 0L : iax % ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)(ibx == 0L ? 0L : iax % ibx);
                        ++j;
                    }
lbl187:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl188:
                // 1 sources

                break;
            }
            case 200: {
                oai16data = ((CompoundShortDataset)result).getData();
                if (is != 1) ** GOTO lbl204
                if (!it.isOutputDouble()) ** GOTO lbl202
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(ibx == 0.0 ? 0.0 : iax % ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)(ibx == 0L ? 0L : iax % ibx);
lbl202:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl203:
                // 1 sources

                break;
lbl204:
                // 1 sources

                if (as >= bs) ** GOTO lbl229
                if (!it.isOutputDouble()) ** GOTO lbl227
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(ibx == 0.0 ? 0.0 : iax % ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(ibx == 0.0 ? 0.0 : iax % ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)(ibx == 0L ? 0L : iax % ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)(ibx == 0L ? 0L : iax % ibx);
                        ++j;
                    }
lbl227:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl228:
                // 1 sources

                break;
lbl229:
                // 1 sources

                if (as <= bs) ** GOTO lbl254
                if (!it.isOutputDouble()) ** GOTO lbl252
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(ibx == 0.0 ? 0.0 : iax % ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(ibx == 0.0 ? 0.0 : iax % ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)(ibx == 0L ? 0L : iax % ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)(ibx == 0L ? 0L : iax % ibx);
                        ++j;
                    }
lbl252:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl253:
                // 1 sources

                break;
lbl254:
                // 1 sources

                if (as != 1) ** GOTO lbl277
                if (!it.isOutputDouble()) ** GOTO lbl275
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = (short)Maths.toLong(ibx == 0.0 ? 0.0 : iax % ibx);
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (short)(ibx == 0L ? 0L : iax % ibx);
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl275:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl276:
                // 1 sources

                break;
lbl277:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl301
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(ibx == 0.0 ? 0.0 : iax % ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(ibx == 0.0 ? 0.0 : iax % ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)(ibx == 0L ? 0L : iax % ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)(ibx == 0L ? 0L : iax % ibx);
                        ++j;
                    }
lbl301:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl302:
                // 1 sources

                break;
            }
            case 400: {
                oai64data = ((CompoundLongDataset)result).getData();
                if (is != 1) ** GOTO lbl318
                if (!it.isOutputDouble()) ** GOTO lbl316
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(ibx == 0.0 ? 0.0 : iax % ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = ibx == 0L ? 0L : iax % ibx;
lbl316:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl317:
                // 1 sources

                break;
lbl318:
                // 1 sources

                if (as >= bs) ** GOTO lbl343
                if (!it.isOutputDouble()) ** GOTO lbl341
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(ibx == 0.0 ? 0.0 : iax % ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(ibx == 0.0 ? 0.0 : iax % ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = ibx == 0L ? 0L : iax % ibx;
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = ibx == 0L ? 0L : iax % ibx;
                        ++j;
                    }
lbl341:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl342:
                // 1 sources

                break;
lbl343:
                // 1 sources

                if (as <= bs) ** GOTO lbl368
                if (!it.isOutputDouble()) ** GOTO lbl366
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(ibx == 0.0 ? 0.0 : iax % ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(ibx == 0.0 ? 0.0 : iax % ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = ibx == 0L ? 0L : iax % ibx;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = ibx == 0L ? 0L : iax % ibx;
                        ++j;
                    }
lbl366:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl367:
                // 1 sources

                break;
lbl368:
                // 1 sources

                if (as != 1) ** GOTO lbl391
                if (!it.isOutputDouble()) ** GOTO lbl389
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = Maths.toLong(ibx == 0.0 ? 0.0 : iax % ibx);
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = ibx == 0L ? 0L : iax % ibx;
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl389:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl390:
                // 1 sources

                break;
lbl391:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl415
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(ibx == 0.0 ? 0.0 : iax % ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(ibx == 0.0 ? 0.0 : iax % ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = ibx == 0L ? 0L : iax % ibx;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = ibx == 0L ? 0L : iax % ibx;
                        ++j;
                    }
lbl415:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl416:
                // 1 sources

                break;
            }
            case 300: {
                oai32data = ((CompoundIntegerDataset)result).getData();
                if (is != 1) ** GOTO lbl432
                if (!it.isOutputDouble()) ** GOTO lbl430
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(ibx == 0.0 ? 0.0 : iax % ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)(ibx == 0L ? 0L : iax % ibx);
lbl430:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl431:
                // 1 sources

                break;
lbl432:
                // 1 sources

                if (as >= bs) ** GOTO lbl457
                if (!it.isOutputDouble()) ** GOTO lbl455
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(ibx == 0.0 ? 0.0 : iax % ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(ibx == 0.0 ? 0.0 : iax % ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)(ibx == 0L ? 0L : iax % ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)(ibx == 0L ? 0L : iax % ibx);
                        ++j;
                    }
lbl455:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl456:
                // 1 sources

                break;
lbl457:
                // 1 sources

                if (as <= bs) ** GOTO lbl482
                if (!it.isOutputDouble()) ** GOTO lbl480
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(ibx == 0.0 ? 0.0 : iax % ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(ibx == 0.0 ? 0.0 : iax % ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)(ibx == 0L ? 0L : iax % ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)(ibx == 0L ? 0L : iax % ibx);
                        ++j;
                    }
lbl480:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl481:
                // 1 sources

                break;
lbl482:
                // 1 sources

                if (as != 1) ** GOTO lbl505
                if (!it.isOutputDouble()) ** GOTO lbl503
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = (int)Maths.toLong(ibx == 0.0 ? 0.0 : iax % ibx);
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (int)(ibx == 0L ? 0L : iax % ibx);
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl503:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl504:
                // 1 sources

                break;
lbl505:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl529
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(ibx == 0.0 ? 0.0 : iax % ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(ibx == 0.0 ? 0.0 : iax % ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)(ibx == 0L ? 0L : iax % ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)(ibx == 0L ? 0L : iax % ibx);
                        ++j;
                    }
lbl529:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl530:
                // 1 sources

                break;
            }
            case 5: {
                of32data = ((FloatDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl543
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    of32data[it.oIndex] = ox = (float)(iax % ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    of32data[it.oIndex] = ox = (float)(iax % ibx);
lbl543:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl544:
                // 1 sources

                break;
            }
            case 6: {
                of64data = ((DoubleDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl557
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    of64data[it.oIndex] = ox = iax % ibx;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    of64data[it.oIndex] = ox = (double)(iax % ibx);
lbl557:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl558:
                // 1 sources

                break;
            }
            case 500: {
                oaf32data = ((CompoundFloatDataset)result).getData();
                if (is != 1) ** GOTO lbl574
                if (!it.isOutputDouble()) ** GOTO lbl572
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)(iax % ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)(iax % ibx);
lbl572:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl573:
                // 1 sources

                break;
lbl574:
                // 1 sources

                if (as >= bs) ** GOTO lbl599
                if (!it.isOutputDouble()) ** GOTO lbl597
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)(iax % ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(iax % ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)(iax % ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(iax % ibx);
                        ++j;
                    }
lbl597:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl598:
                // 1 sources

                break;
lbl599:
                // 1 sources

                if (as <= bs) ** GOTO lbl624
                if (!it.isOutputDouble()) ** GOTO lbl622
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)(iax % ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(iax % ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)(iax % ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(iax % ibx);
                        ++j;
                    }
lbl622:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl623:
                // 1 sources

                break;
lbl624:
                // 1 sources

                if (as != 1) ** GOTO lbl647
                if (!it.isOutputDouble()) ** GOTO lbl645
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = (float)(iax % ibx);
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = iax % ibx;
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl645:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl646:
                // 1 sources

                break;
lbl647:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl671
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)(iax % ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(iax % ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)(iax % ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(iax % ibx);
                        ++j;
                    }
lbl671:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl672:
                // 1 sources

                break;
            }
            case 600: {
                oaf64data = ((CompoundDoubleDataset)result).getData();
                if (is != 1) ** GOTO lbl688
                if (!it.isOutputDouble()) ** GOTO lbl686
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = iax % ibx;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = (double)(iax % ibx);
lbl686:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl687:
                // 1 sources

                break;
lbl688:
                // 1 sources

                if (as >= bs) ** GOTO lbl713
                if (!it.isOutputDouble()) ** GOTO lbl711
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = iax % ibx;
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = iax % ibx;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = (double)(iax % ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = (double)(iax % ibx);
                        ++j;
                    }
lbl711:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl712:
                // 1 sources

                break;
lbl713:
                // 1 sources

                if (as <= bs) ** GOTO lbl738
                if (!it.isOutputDouble()) ** GOTO lbl736
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = iax % ibx;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = iax % ibx;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = (double)(iax % ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = (double)(iax % ibx);
                        ++j;
                    }
lbl736:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl737:
                // 1 sources

                break;
lbl738:
                // 1 sources

                if (as != 1) ** GOTO lbl761
                if (!it.isOutputDouble()) ** GOTO lbl759
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = iax % ibx;
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = iax % ibx;
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl759:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl760:
                // 1 sources

                break;
lbl761:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl785
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = iax % ibx;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = iax % ibx;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = (double)(iax % ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = (double)(iax % ibx);
                        ++j;
                    }
lbl785:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl786:
                // 1 sources

                break;
            }
            default: {
                throw new IllegalArgumentException("remainder supports integer, compound integer, real, compound real datasets only");
            }
        }
        Maths.addBinaryOperatorName(da, db, result, "%");
        return result;
    }

    public static Dataset maximum(Object a, Object b) {
        return Maths.maximum(a, b, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset maximum(Object a, Object b, Dataset o) {
        da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        it = BroadcastIterator.createIterator(da, db = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b), o, true);
        result = it.getOutput();
        if (!result.isComplex()) {
            change = false;
            if (da.isComplex()) {
                da = da.getRealView();
                change = true;
            }
            if (db.isComplex()) {
                db = db.getRealView();
                change = true;
            }
            if (change) {
                it = BroadcastIterator.createIterator(da, db, result, true);
            }
        }
        is = result.getElementsPerItem();
        as = da.getElementsPerItem();
        bs = db.getElementsPerItem();
        dt = result.getDType();
        switch (dt) {
            case 1: {
                oi8data = ((ByteDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl31
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oi8data[it.oIndex] = ox = (byte)Maths.toLong(Math.max(iax, ibx));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi8data[it.oIndex] = ox = (byte)Maths.toLong(Math.max(iax, ibx));
lbl31:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl32:
                // 1 sources

                break;
            }
            case 2: {
                oi16data = ((ShortDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl45
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oi16data[it.oIndex] = ox = (short)Maths.toLong(Math.max(iax, ibx));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi16data[it.oIndex] = ox = (short)Maths.toLong(Math.max(iax, ibx));
lbl45:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl46:
                // 1 sources

                break;
            }
            case 4: {
                oi64data = ((LongDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl59
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oi64data[it.oIndex] = ox = Maths.toLong(Math.max(iax, ibx));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi64data[it.oIndex] = ox = Maths.toLong(Math.max(iax, ibx));
lbl59:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl60:
                // 1 sources

                break;
            }
            case 3: {
                oi32data = ((IntegerDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl73
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oi32data[it.oIndex] = ox = (int)Maths.toLong(Math.max(iax, ibx));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi32data[it.oIndex] = ox = (int)Maths.toLong(Math.max(iax, ibx));
lbl73:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl74:
                // 1 sources

                break;
            }
            case 100: {
                oai8data = ((CompoundByteDataset)result).getData();
                if (is != 1) ** GOTO lbl90
                if (!it.isOutputDouble()) ** GOTO lbl88
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.max(iax, ibx));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.max(iax, ibx));
lbl88:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl89:
                // 1 sources

                break;
lbl90:
                // 1 sources

                if (as >= bs) ** GOTO lbl115
                if (!it.isOutputDouble()) ** GOTO lbl113
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.max(iax, ibx));
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.max(iax, ibx));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.max(iax, ibx));
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.max(iax, ibx));
                        ++j;
                    }
lbl113:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl114:
                // 1 sources

                break;
lbl115:
                // 1 sources

                if (as <= bs) ** GOTO lbl140
                if (!it.isOutputDouble()) ** GOTO lbl138
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.max(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.max(iax, ibx));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.max(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.max(iax, ibx));
                        ++j;
                    }
lbl138:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl139:
                // 1 sources

                break;
lbl140:
                // 1 sources

                if (as != 1) ** GOTO lbl163
                if (!it.isOutputDouble()) ** GOTO lbl161
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = (byte)Maths.toLong(Math.max(iax, ibx));
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (byte)Maths.toLong(Math.max(iax, ibx));
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl161:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl162:
                // 1 sources

                break;
lbl163:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl187
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.max(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.max(iax, ibx));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.max(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.max(iax, ibx));
                        ++j;
                    }
lbl187:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl188:
                // 1 sources

                break;
            }
            case 200: {
                oai16data = ((CompoundShortDataset)result).getData();
                if (is != 1) ** GOTO lbl204
                if (!it.isOutputDouble()) ** GOTO lbl202
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.max(iax, ibx));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.max(iax, ibx));
lbl202:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl203:
                // 1 sources

                break;
lbl204:
                // 1 sources

                if (as >= bs) ** GOTO lbl229
                if (!it.isOutputDouble()) ** GOTO lbl227
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.max(iax, ibx));
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.max(iax, ibx));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.max(iax, ibx));
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.max(iax, ibx));
                        ++j;
                    }
lbl227:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl228:
                // 1 sources

                break;
lbl229:
                // 1 sources

                if (as <= bs) ** GOTO lbl254
                if (!it.isOutputDouble()) ** GOTO lbl252
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.max(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.max(iax, ibx));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.max(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.max(iax, ibx));
                        ++j;
                    }
lbl252:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl253:
                // 1 sources

                break;
lbl254:
                // 1 sources

                if (as != 1) ** GOTO lbl277
                if (!it.isOutputDouble()) ** GOTO lbl275
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = (short)Maths.toLong(Math.max(iax, ibx));
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (short)Maths.toLong(Math.max(iax, ibx));
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl275:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl276:
                // 1 sources

                break;
lbl277:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl301
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.max(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.max(iax, ibx));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.max(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.max(iax, ibx));
                        ++j;
                    }
lbl301:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl302:
                // 1 sources

                break;
            }
            case 400: {
                oai64data = ((CompoundLongDataset)result).getData();
                if (is != 1) ** GOTO lbl318
                if (!it.isOutputDouble()) ** GOTO lbl316
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.max(iax, ibx));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.max(iax, ibx));
lbl316:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl317:
                // 1 sources

                break;
lbl318:
                // 1 sources

                if (as >= bs) ** GOTO lbl343
                if (!it.isOutputDouble()) ** GOTO lbl341
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.max(iax, ibx));
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.max(iax, ibx));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.max(iax, ibx));
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.max(iax, ibx));
                        ++j;
                    }
lbl341:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl342:
                // 1 sources

                break;
lbl343:
                // 1 sources

                if (as <= bs) ** GOTO lbl368
                if (!it.isOutputDouble()) ** GOTO lbl366
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.max(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.max(iax, ibx));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.max(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.max(iax, ibx));
                        ++j;
                    }
lbl366:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl367:
                // 1 sources

                break;
lbl368:
                // 1 sources

                if (as != 1) ** GOTO lbl391
                if (!it.isOutputDouble()) ** GOTO lbl389
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = Maths.toLong(Math.max(iax, ibx));
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = Maths.toLong(Math.max(iax, ibx));
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl389:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl390:
                // 1 sources

                break;
lbl391:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl415
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.max(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.max(iax, ibx));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.max(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.max(iax, ibx));
                        ++j;
                    }
lbl415:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl416:
                // 1 sources

                break;
            }
            case 300: {
                oai32data = ((CompoundIntegerDataset)result).getData();
                if (is != 1) ** GOTO lbl432
                if (!it.isOutputDouble()) ** GOTO lbl430
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.max(iax, ibx));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.max(iax, ibx));
lbl430:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl431:
                // 1 sources

                break;
lbl432:
                // 1 sources

                if (as >= bs) ** GOTO lbl457
                if (!it.isOutputDouble()) ** GOTO lbl455
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.max(iax, ibx));
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.max(iax, ibx));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.max(iax, ibx));
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.max(iax, ibx));
                        ++j;
                    }
lbl455:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl456:
                // 1 sources

                break;
lbl457:
                // 1 sources

                if (as <= bs) ** GOTO lbl482
                if (!it.isOutputDouble()) ** GOTO lbl480
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.max(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.max(iax, ibx));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.max(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.max(iax, ibx));
                        ++j;
                    }
lbl480:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl481:
                // 1 sources

                break;
lbl482:
                // 1 sources

                if (as != 1) ** GOTO lbl505
                if (!it.isOutputDouble()) ** GOTO lbl503
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = (int)Maths.toLong(Math.max(iax, ibx));
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (int)Maths.toLong(Math.max(iax, ibx));
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl503:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl504:
                // 1 sources

                break;
lbl505:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl529
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.max(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.max(iax, ibx));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.max(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.max(iax, ibx));
                        ++j;
                    }
lbl529:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl530:
                // 1 sources

                break;
            }
            case 5: {
                of32data = ((FloatDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl543
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    of32data[it.oIndex] = ox = (float)Math.max(iax, ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    of32data[it.oIndex] = ox = (float)Math.max(iax, ibx);
lbl543:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl544:
                // 1 sources

                break;
            }
            case 6: {
                of64data = ((DoubleDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl557
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    of64data[it.oIndex] = ox = Math.max(iax, ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    of64data[it.oIndex] = ox = (double)Math.max(iax, ibx);
lbl557:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl558:
                // 1 sources

                break;
            }
            case 500: {
                oaf32data = ((CompoundFloatDataset)result).getData();
                if (is != 1) ** GOTO lbl574
                if (!it.isOutputDouble()) ** GOTO lbl572
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)Math.max(iax, ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)Math.max(iax, ibx);
lbl572:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl573:
                // 1 sources

                break;
lbl574:
                // 1 sources

                if (as >= bs) ** GOTO lbl599
                if (!it.isOutputDouble()) ** GOTO lbl597
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)Math.max(iax, ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.max(iax, ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)Math.max(iax, ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.max(iax, ibx);
                        ++j;
                    }
lbl597:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl598:
                // 1 sources

                break;
lbl599:
                // 1 sources

                if (as <= bs) ** GOTO lbl624
                if (!it.isOutputDouble()) ** GOTO lbl622
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)Math.max(iax, ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.max(iax, ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)Math.max(iax, ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.max(iax, ibx);
                        ++j;
                    }
lbl622:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl623:
                // 1 sources

                break;
lbl624:
                // 1 sources

                if (as != 1) ** GOTO lbl647
                if (!it.isOutputDouble()) ** GOTO lbl645
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = (float)Math.max(iax, ibx);
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = Math.max(iax, ibx);
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl645:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl646:
                // 1 sources

                break;
lbl647:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl671
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)Math.max(iax, ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.max(iax, ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)Math.max(iax, ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.max(iax, ibx);
                        ++j;
                    }
lbl671:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl672:
                // 1 sources

                break;
            }
            case 600: {
                oaf64data = ((CompoundDoubleDataset)result).getData();
                if (is != 1) ** GOTO lbl688
                if (!it.isOutputDouble()) ** GOTO lbl686
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = Math.max(iax, ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = (double)Math.max(iax, ibx);
lbl686:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl687:
                // 1 sources

                break;
lbl688:
                // 1 sources

                if (as >= bs) ** GOTO lbl713
                if (!it.isOutputDouble()) ** GOTO lbl711
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = Math.max(iax, ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = Math.max(iax, ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = (double)Math.max(iax, ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = (double)Math.max(iax, ibx);
                        ++j;
                    }
lbl711:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl712:
                // 1 sources

                break;
lbl713:
                // 1 sources

                if (as <= bs) ** GOTO lbl738
                if (!it.isOutputDouble()) ** GOTO lbl736
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = Math.max(iax, ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = Math.max(iax, ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = (double)Math.max(iax, ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = (double)Math.max(iax, ibx);
                        ++j;
                    }
lbl736:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl737:
                // 1 sources

                break;
lbl738:
                // 1 sources

                if (as != 1) ** GOTO lbl761
                if (!it.isOutputDouble()) ** GOTO lbl759
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = Math.max(iax, ibx);
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = Math.max(iax, ibx);
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl759:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl760:
                // 1 sources

                break;
lbl761:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl785
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = Math.max(iax, ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = Math.max(iax, ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = (double)Math.max(iax, ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = (double)Math.max(iax, ibx);
                        ++j;
                    }
lbl785:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl786:
                // 1 sources

                break;
            }
            case 7: {
                oc64data = ((ComplexFloatDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl847
                if (!it.isOutputDouble()) ** GOTO lbl828
                iay = 0.0;
                if (!db.isComplex()) ** GOTO lbl826
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iby = db.getElementDoubleAbs(it.bIndex + 1);
                    if (Double.isNaN(iax) || Double.isNaN(0.0)) {
                        ox = (float)iax;
                        oy = 0.0f;
                    } else if (Double.isNaN(ibx) || Double.isNaN(iby)) {
                        ox = (float)ibx;
                        oy = (float)iby;
                    } else {
                        ox = (float)Math.max(iax, ibx);
                        oy = (float)Math.max(0.0, iby);
                    }
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iby = 0.0;
                    if (Double.isNaN(iax) || Double.isNaN(0.0)) {
                        ox = (float)iax;
                        oy = 0.0f;
                    } else if (Double.isNaN(ibx) || Double.isNaN(0.0)) {
                        ox = (float)ibx;
                        oy = 0.0f;
                    } else {
                        ox = (float)Math.max(iax, ibx);
                        oy = (float)Math.max(0.0, 0.0);
                    }
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
lbl826:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl827:
                // 1 sources

                break;
lbl828:
                // 1 sources

                iay = 0L;
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    iby = 0L;
                    if (Double.isNaN(iax) || Double.isNaN(0.0)) {
                        ox = iax;
                        oy = 0.0f;
                    } else if (Double.isNaN(ibx) || Double.isNaN(0.0)) {
                        ox = ibx;
                        oy = 0.0f;
                    } else {
                        ox = Math.max(iax, ibx);
                        oy = Math.max(0L, 0L);
                    }
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
                }
                break;
lbl847:
                // 1 sources

                if (db.isComplex()) ** GOTO lbl883
                iby = 0.0;
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iay = da.getElementDoubleAbs(it.aIndex + 1);
                    if (Double.isNaN(iax) || Double.isNaN(iay)) {
                        ox = (float)iax;
                        oy = (float)iay;
                    } else if (Double.isNaN(ibx) || Double.isNaN(0.0)) {
                        ox = (float)ibx;
                        oy = 0.0f;
                    } else {
                        ox = (float)Math.max(iax, ibx);
                        oy = (float)Math.max(iay, 0.0);
                    }
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iay = da.getElementDoubleAbs(it.aIndex + 1);
                    iby = db.getElementDoubleAbs(it.bIndex + 1);
                    if (Double.isNaN(iax) || Double.isNaN(iay)) {
                        ox = (float)iax;
                        oy = (float)iay;
                    } else if (Double.isNaN(ibx) || Double.isNaN(iby)) {
                        ox = (float)ibx;
                        oy = (float)iby;
                    } else {
                        ox = (float)Math.max(iax, ibx);
                        oy = (float)Math.max(iay, iby);
                    }
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
lbl883:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl884:
                // 1 sources

                break;
            }
            case 8: {
                oc128data = ((ComplexDoubleDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl945
                if (!it.isOutputDouble()) ** GOTO lbl926
                iay = 0.0;
                if (!db.isComplex()) ** GOTO lbl924
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iby = db.getElementDoubleAbs(it.bIndex + 1);
                    if (Double.isNaN(iax) || Double.isNaN(0.0)) {
                        ox = iax;
                        oy = 0.0;
                    } else if (Double.isNaN(ibx) || Double.isNaN(iby)) {
                        ox = ibx;
                        oy = iby;
                    } else {
                        ox = Math.max(iax, ibx);
                        oy = Math.max(0.0, iby);
                    }
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iby = 0.0;
                    if (Double.isNaN(iax) || Double.isNaN(0.0)) {
                        ox = iax;
                        oy = 0.0;
                    } else if (Double.isNaN(ibx) || Double.isNaN(0.0)) {
                        ox = ibx;
                        oy = 0.0;
                    } else {
                        ox = Math.max(iax, ibx);
                        oy = Math.max(0.0, 0.0);
                    }
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
lbl924:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl925:
                // 1 sources

                break;
lbl926:
                // 1 sources

                iay = 0L;
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    iby = 0L;
                    if (Double.isNaN(iax) || Double.isNaN(0.0)) {
                        ox = iax;
                        oy = 0.0;
                    } else if (Double.isNaN(ibx) || Double.isNaN(0.0)) {
                        ox = ibx;
                        oy = 0.0;
                    } else {
                        ox = Math.max(iax, ibx);
                        oy = Math.max(0L, 0L);
                    }
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
                }
                break;
lbl945:
                // 1 sources

                if (db.isComplex()) ** GOTO lbl981
                iby = 0.0;
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iay = da.getElementDoubleAbs(it.aIndex + 1);
                    if (Double.isNaN(iax) || Double.isNaN(iay)) {
                        ox = iax;
                        oy = iay;
                    } else if (Double.isNaN(ibx) || Double.isNaN(0.0)) {
                        ox = ibx;
                        oy = 0.0;
                    } else {
                        ox = Math.max(iax, ibx);
                        oy = Math.max(iay, 0.0);
                    }
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iay = da.getElementDoubleAbs(it.aIndex + 1);
                    iby = db.getElementDoubleAbs(it.bIndex + 1);
                    if (Double.isNaN(iax) || Double.isNaN(iay)) {
                        ox = iax;
                        oy = iay;
                    } else if (Double.isNaN(ibx) || Double.isNaN(iby)) {
                        ox = ibx;
                        oy = iby;
                    } else {
                        ox = Math.max(iax, ibx);
                        oy = Math.max(iay, iby);
                    }
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
lbl981:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl982:
                // 1 sources

                break;
            }
            default: {
                throw new IllegalArgumentException("maximum supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        Maths.addBinaryOperatorName(da, db, result, "maximum");
        return result;
    }

    public static Dataset minimum(Object a, Object b) {
        return Maths.minimum(a, b, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset minimum(Object a, Object b, Dataset o) {
        da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        it = BroadcastIterator.createIterator(da, db = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b), o, true);
        result = it.getOutput();
        if (!result.isComplex()) {
            change = false;
            if (da.isComplex()) {
                da = da.getRealView();
                change = true;
            }
            if (db.isComplex()) {
                db = db.getRealView();
                change = true;
            }
            if (change) {
                it = BroadcastIterator.createIterator(da, db, result, true);
            }
        }
        is = result.getElementsPerItem();
        as = da.getElementsPerItem();
        bs = db.getElementsPerItem();
        dt = result.getDType();
        switch (dt) {
            case 1: {
                oi8data = ((ByteDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl31
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oi8data[it.oIndex] = ox = (byte)Maths.toLong(Math.min(iax, ibx));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi8data[it.oIndex] = ox = (byte)Maths.toLong(Math.min(iax, ibx));
lbl31:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl32:
                // 1 sources

                break;
            }
            case 2: {
                oi16data = ((ShortDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl45
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oi16data[it.oIndex] = ox = (short)Maths.toLong(Math.min(iax, ibx));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi16data[it.oIndex] = ox = (short)Maths.toLong(Math.min(iax, ibx));
lbl45:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl46:
                // 1 sources

                break;
            }
            case 4: {
                oi64data = ((LongDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl59
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oi64data[it.oIndex] = ox = Maths.toLong(Math.min(iax, ibx));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi64data[it.oIndex] = ox = Maths.toLong(Math.min(iax, ibx));
lbl59:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl60:
                // 1 sources

                break;
            }
            case 3: {
                oi32data = ((IntegerDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl73
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oi32data[it.oIndex] = ox = (int)Maths.toLong(Math.min(iax, ibx));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi32data[it.oIndex] = ox = (int)Maths.toLong(Math.min(iax, ibx));
lbl73:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl74:
                // 1 sources

                break;
            }
            case 100: {
                oai8data = ((CompoundByteDataset)result).getData();
                if (is != 1) ** GOTO lbl90
                if (!it.isOutputDouble()) ** GOTO lbl88
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.min(iax, ibx));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.min(iax, ibx));
lbl88:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl89:
                // 1 sources

                break;
lbl90:
                // 1 sources

                if (as >= bs) ** GOTO lbl115
                if (!it.isOutputDouble()) ** GOTO lbl113
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.min(iax, ibx));
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.min(iax, ibx));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.min(iax, ibx));
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.min(iax, ibx));
                        ++j;
                    }
lbl113:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl114:
                // 1 sources

                break;
lbl115:
                // 1 sources

                if (as <= bs) ** GOTO lbl140
                if (!it.isOutputDouble()) ** GOTO lbl138
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.min(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.min(iax, ibx));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.min(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.min(iax, ibx));
                        ++j;
                    }
lbl138:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl139:
                // 1 sources

                break;
lbl140:
                // 1 sources

                if (as != 1) ** GOTO lbl163
                if (!it.isOutputDouble()) ** GOTO lbl161
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = (byte)Maths.toLong(Math.min(iax, ibx));
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (byte)Maths.toLong(Math.min(iax, ibx));
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl161:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl162:
                // 1 sources

                break;
lbl163:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl187
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.min(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.min(iax, ibx));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.min(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.min(iax, ibx));
                        ++j;
                    }
lbl187:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl188:
                // 1 sources

                break;
            }
            case 200: {
                oai16data = ((CompoundShortDataset)result).getData();
                if (is != 1) ** GOTO lbl204
                if (!it.isOutputDouble()) ** GOTO lbl202
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.min(iax, ibx));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.min(iax, ibx));
lbl202:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl203:
                // 1 sources

                break;
lbl204:
                // 1 sources

                if (as >= bs) ** GOTO lbl229
                if (!it.isOutputDouble()) ** GOTO lbl227
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.min(iax, ibx));
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.min(iax, ibx));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.min(iax, ibx));
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.min(iax, ibx));
                        ++j;
                    }
lbl227:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl228:
                // 1 sources

                break;
lbl229:
                // 1 sources

                if (as <= bs) ** GOTO lbl254
                if (!it.isOutputDouble()) ** GOTO lbl252
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.min(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.min(iax, ibx));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.min(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.min(iax, ibx));
                        ++j;
                    }
lbl252:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl253:
                // 1 sources

                break;
lbl254:
                // 1 sources

                if (as != 1) ** GOTO lbl277
                if (!it.isOutputDouble()) ** GOTO lbl275
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = (short)Maths.toLong(Math.min(iax, ibx));
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (short)Maths.toLong(Math.min(iax, ibx));
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl275:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl276:
                // 1 sources

                break;
lbl277:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl301
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.min(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.min(iax, ibx));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.min(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.min(iax, ibx));
                        ++j;
                    }
lbl301:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl302:
                // 1 sources

                break;
            }
            case 400: {
                oai64data = ((CompoundLongDataset)result).getData();
                if (is != 1) ** GOTO lbl318
                if (!it.isOutputDouble()) ** GOTO lbl316
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.min(iax, ibx));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.min(iax, ibx));
lbl316:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl317:
                // 1 sources

                break;
lbl318:
                // 1 sources

                if (as >= bs) ** GOTO lbl343
                if (!it.isOutputDouble()) ** GOTO lbl341
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.min(iax, ibx));
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.min(iax, ibx));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.min(iax, ibx));
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.min(iax, ibx));
                        ++j;
                    }
lbl341:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl342:
                // 1 sources

                break;
lbl343:
                // 1 sources

                if (as <= bs) ** GOTO lbl368
                if (!it.isOutputDouble()) ** GOTO lbl366
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.min(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.min(iax, ibx));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.min(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.min(iax, ibx));
                        ++j;
                    }
lbl366:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl367:
                // 1 sources

                break;
lbl368:
                // 1 sources

                if (as != 1) ** GOTO lbl391
                if (!it.isOutputDouble()) ** GOTO lbl389
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = Maths.toLong(Math.min(iax, ibx));
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = Maths.toLong(Math.min(iax, ibx));
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl389:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl390:
                // 1 sources

                break;
lbl391:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl415
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.min(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.min(iax, ibx));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.min(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.min(iax, ibx));
                        ++j;
                    }
lbl415:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl416:
                // 1 sources

                break;
            }
            case 300: {
                oai32data = ((CompoundIntegerDataset)result).getData();
                if (is != 1) ** GOTO lbl432
                if (!it.isOutputDouble()) ** GOTO lbl430
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.min(iax, ibx));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.min(iax, ibx));
lbl430:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl431:
                // 1 sources

                break;
lbl432:
                // 1 sources

                if (as >= bs) ** GOTO lbl457
                if (!it.isOutputDouble()) ** GOTO lbl455
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.min(iax, ibx));
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.min(iax, ibx));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.min(iax, ibx));
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.min(iax, ibx));
                        ++j;
                    }
lbl455:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl456:
                // 1 sources

                break;
lbl457:
                // 1 sources

                if (as <= bs) ** GOTO lbl482
                if (!it.isOutputDouble()) ** GOTO lbl480
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.min(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.min(iax, ibx));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.min(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.min(iax, ibx));
                        ++j;
                    }
lbl480:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl481:
                // 1 sources

                break;
lbl482:
                // 1 sources

                if (as != 1) ** GOTO lbl505
                if (!it.isOutputDouble()) ** GOTO lbl503
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = (int)Maths.toLong(Math.min(iax, ibx));
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (int)Maths.toLong(Math.min(iax, ibx));
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl503:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl504:
                // 1 sources

                break;
lbl505:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl529
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.min(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.min(iax, ibx));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.min(iax, ibx));
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.min(iax, ibx));
                        ++j;
                    }
lbl529:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl530:
                // 1 sources

                break;
            }
            case 5: {
                of32data = ((FloatDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl543
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    of32data[it.oIndex] = ox = (float)Math.min(iax, ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    of32data[it.oIndex] = ox = (float)Math.min(iax, ibx);
lbl543:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl544:
                // 1 sources

                break;
            }
            case 6: {
                of64data = ((DoubleDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl557
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    of64data[it.oIndex] = ox = Math.min(iax, ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    of64data[it.oIndex] = ox = (double)Math.min(iax, ibx);
lbl557:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl558:
                // 1 sources

                break;
            }
            case 500: {
                oaf32data = ((CompoundFloatDataset)result).getData();
                if (is != 1) ** GOTO lbl574
                if (!it.isOutputDouble()) ** GOTO lbl572
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)Math.min(iax, ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)Math.min(iax, ibx);
lbl572:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl573:
                // 1 sources

                break;
lbl574:
                // 1 sources

                if (as >= bs) ** GOTO lbl599
                if (!it.isOutputDouble()) ** GOTO lbl597
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)Math.min(iax, ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.min(iax, ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)Math.min(iax, ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.min(iax, ibx);
                        ++j;
                    }
lbl597:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl598:
                // 1 sources

                break;
lbl599:
                // 1 sources

                if (as <= bs) ** GOTO lbl624
                if (!it.isOutputDouble()) ** GOTO lbl622
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)Math.min(iax, ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.min(iax, ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)Math.min(iax, ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.min(iax, ibx);
                        ++j;
                    }
lbl622:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl623:
                // 1 sources

                break;
lbl624:
                // 1 sources

                if (as != 1) ** GOTO lbl647
                if (!it.isOutputDouble()) ** GOTO lbl645
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = (float)Math.min(iax, ibx);
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = Math.min(iax, ibx);
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl645:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl646:
                // 1 sources

                break;
lbl647:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl671
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf32data[it.oIndex] = ox = (float)Math.min(iax, ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.min(iax, ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf32data[it.oIndex] = ox = (float)Math.min(iax, ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.min(iax, ibx);
                        ++j;
                    }
lbl671:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl672:
                // 1 sources

                break;
            }
            case 600: {
                oaf64data = ((CompoundDoubleDataset)result).getData();
                if (is != 1) ** GOTO lbl688
                if (!it.isOutputDouble()) ** GOTO lbl686
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = Math.min(iax, ibx);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = (double)Math.min(iax, ibx);
lbl686:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl687:
                // 1 sources

                break;
lbl688:
                // 1 sources

                if (as >= bs) ** GOTO lbl713
                if (!it.isOutputDouble()) ** GOTO lbl711
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = Math.min(iax, ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = Math.min(iax, ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = (double)Math.min(iax, ibx);
                    j = 1;
                    while (j < is) {
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = (double)Math.min(iax, ibx);
                        ++j;
                    }
lbl711:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl712:
                // 1 sources

                break;
lbl713:
                // 1 sources

                if (as <= bs) ** GOTO lbl738
                if (!it.isOutputDouble()) ** GOTO lbl736
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = Math.min(iax, ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = Math.min(iax, ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = (double)Math.min(iax, ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = (double)Math.min(iax, ibx);
                        ++j;
                    }
lbl736:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl737:
                // 1 sources

                break;
lbl738:
                // 1 sources

                if (as != 1) ** GOTO lbl761
                if (!it.isOutputDouble()) ** GOTO lbl759
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    ox = Math.min(iax, ibx);
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = Math.min(iax, ibx);
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl759:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl760:
                // 1 sources

                break;
lbl761:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl785
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    oaf64data[it.oIndex] = ox = Math.min(iax, ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementDoubleAbs(it.aIndex + j);
                        ibx = db.getElementDoubleAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = Math.min(iax, ibx);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oaf64data[it.oIndex] = ox = (double)Math.min(iax, ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oaf64data[it.oIndex + j] = ox = (double)Math.min(iax, ibx);
                        ++j;
                    }
lbl785:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl786:
                // 1 sources

                break;
            }
            case 7: {
                oc64data = ((ComplexFloatDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl847
                if (!it.isOutputDouble()) ** GOTO lbl828
                iay = 0.0;
                if (!db.isComplex()) ** GOTO lbl826
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iby = db.getElementDoubleAbs(it.bIndex + 1);
                    if (Double.isNaN(iax) || Double.isNaN(0.0)) {
                        ox = (float)iax;
                        oy = 0.0f;
                    } else if (Double.isNaN(ibx) || Double.isNaN(iby)) {
                        ox = (float)ibx;
                        oy = (float)iby;
                    } else {
                        ox = (float)Math.min(iax, ibx);
                        oy = (float)Math.min(0.0, iby);
                    }
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iby = 0.0;
                    if (Double.isNaN(iax) || Double.isNaN(0.0)) {
                        ox = (float)iax;
                        oy = 0.0f;
                    } else if (Double.isNaN(ibx) || Double.isNaN(0.0)) {
                        ox = (float)ibx;
                        oy = 0.0f;
                    } else {
                        ox = (float)Math.min(iax, ibx);
                        oy = (float)Math.min(0.0, 0.0);
                    }
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
lbl826:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl827:
                // 1 sources

                break;
lbl828:
                // 1 sources

                iay = 0L;
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    iby = 0L;
                    if (Double.isNaN(iax) || Double.isNaN(0.0)) {
                        ox = iax;
                        oy = 0.0f;
                    } else if (Double.isNaN(ibx) || Double.isNaN(0.0)) {
                        ox = ibx;
                        oy = 0.0f;
                    } else {
                        ox = Math.min(iax, ibx);
                        oy = Math.min(0L, 0L);
                    }
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
                }
                break;
lbl847:
                // 1 sources

                if (db.isComplex()) ** GOTO lbl883
                iby = 0.0;
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iay = da.getElementDoubleAbs(it.aIndex + 1);
                    if (Double.isNaN(iax) || Double.isNaN(iay)) {
                        ox = (float)iax;
                        oy = (float)iay;
                    } else if (Double.isNaN(ibx) || Double.isNaN(0.0)) {
                        ox = (float)ibx;
                        oy = 0.0f;
                    } else {
                        ox = (float)Math.min(iax, ibx);
                        oy = (float)Math.min(iay, 0.0);
                    }
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iay = da.getElementDoubleAbs(it.aIndex + 1);
                    iby = db.getElementDoubleAbs(it.bIndex + 1);
                    if (Double.isNaN(iax) || Double.isNaN(iay)) {
                        ox = (float)iax;
                        oy = (float)iay;
                    } else if (Double.isNaN(ibx) || Double.isNaN(iby)) {
                        ox = (float)ibx;
                        oy = (float)iby;
                    } else {
                        ox = (float)Math.min(iax, ibx);
                        oy = (float)Math.min(iay, iby);
                    }
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
lbl883:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl884:
                // 1 sources

                break;
            }
            case 8: {
                oc128data = ((ComplexDoubleDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl945
                if (!it.isOutputDouble()) ** GOTO lbl926
                iay = 0.0;
                if (!db.isComplex()) ** GOTO lbl924
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iby = db.getElementDoubleAbs(it.bIndex + 1);
                    if (Double.isNaN(iax) || Double.isNaN(0.0)) {
                        ox = iax;
                        oy = 0.0;
                    } else if (Double.isNaN(ibx) || Double.isNaN(iby)) {
                        ox = ibx;
                        oy = iby;
                    } else {
                        ox = Math.min(iax, ibx);
                        oy = Math.min(0.0, iby);
                    }
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iby = 0.0;
                    if (Double.isNaN(iax) || Double.isNaN(0.0)) {
                        ox = iax;
                        oy = 0.0;
                    } else if (Double.isNaN(ibx) || Double.isNaN(0.0)) {
                        ox = ibx;
                        oy = 0.0;
                    } else {
                        ox = Math.min(iax, ibx);
                        oy = Math.min(0.0, 0.0);
                    }
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
lbl924:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl925:
                // 1 sources

                break;
lbl926:
                // 1 sources

                iay = 0L;
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    iby = 0L;
                    if (Double.isNaN(iax) || Double.isNaN(0.0)) {
                        ox = iax;
                        oy = 0.0;
                    } else if (Double.isNaN(ibx) || Double.isNaN(0.0)) {
                        ox = ibx;
                        oy = 0.0;
                    } else {
                        ox = Math.min(iax, ibx);
                        oy = Math.min(0L, 0L);
                    }
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
                }
                break;
lbl945:
                // 1 sources

                if (db.isComplex()) ** GOTO lbl981
                iby = 0.0;
                while (it.hasNext()) {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iay = da.getElementDoubleAbs(it.aIndex + 1);
                    if (Double.isNaN(iax) || Double.isNaN(iay)) {
                        ox = iax;
                        oy = iay;
                    } else if (Double.isNaN(ibx) || Double.isNaN(0.0)) {
                        ox = ibx;
                        oy = 0.0;
                    } else {
                        ox = Math.min(iax, ibx);
                        oy = Math.min(iay, 0.0);
                    }
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aDouble;
                    ibx = it.bDouble;
                    iay = da.getElementDoubleAbs(it.aIndex + 1);
                    iby = db.getElementDoubleAbs(it.bIndex + 1);
                    if (Double.isNaN(iax) || Double.isNaN(iay)) {
                        ox = iax;
                        oy = iay;
                    } else if (Double.isNaN(ibx) || Double.isNaN(iby)) {
                        ox = ibx;
                        oy = iby;
                    } else {
                        ox = Math.min(iax, ibx);
                        oy = Math.min(iay, iby);
                    }
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
lbl981:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl982:
                // 1 sources

                break;
            }
            default: {
                throw new IllegalArgumentException("minimum supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        Maths.addBinaryOperatorName(da, db, result, "minimum");
        return result;
    }

    public static Dataset bitwiseAnd(Object a, Object b) {
        return Maths.bitwiseAnd(a, b, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset bitwiseAnd(Object a, Object b, Dataset o) {
        da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        db = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b);
        it = BroadcastIterator.createIterator(da, db, o, true);
        it.setOutputDouble(false);
        result = it.getOutput();
        if (!result.isComplex()) {
            change = false;
            if (da.isComplex()) {
                da = da.getRealView();
                change = true;
            }
            if (db.isComplex()) {
                db = db.getRealView();
                change = true;
            }
            if (change) {
                it = BroadcastIterator.createIterator(da, db, result, true);
                it.setOutputDouble(false);
            }
        }
        is = result.getElementsPerItem();
        as = da.getElementsPerItem();
        bs = db.getElementsPerItem();
        dt = result.getDType();
        switch (dt) {
            case 1: {
                oi8data = ((ByteDataset)result).getData();
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi8data[it.oIndex] = ox = (byte)(iax & ibx);
                }
                break;
            }
            case 2: {
                oi16data = ((ShortDataset)result).getData();
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi16data[it.oIndex] = ox = (short)(iax & ibx);
                }
                break;
            }
            case 4: {
                oi64data = ((LongDataset)result).getData();
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi64data[it.oIndex] = ox = iax & ibx;
                }
                break;
            }
            case 3: {
                oi32data = ((IntegerDataset)result).getData();
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi32data[it.oIndex] = ox = (int)(iax & ibx);
                }
                break;
            }
            case 100: {
                oai8data = ((CompoundByteDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai8data[it.oIndex] = ox = (byte)(iax & ibx);
                    }
                    break;
                }
                if (as < bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai8data[it.oIndex] = ox = (byte)(iax & ibx);
                        j = 1;
                        while (j < is) {
                            ibx = db.getElementLongAbs(it.bIndex + j);
                            oai8data[it.oIndex + j] = ox = (byte)(iax & ibx);
                            ++j;
                        }
                    }
                    break;
                }
                if (as > bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai8data[it.oIndex] = ox = (byte)(iax & ibx);
                        j = 1;
                        while (j < is) {
                            iax = da.getElementLongAbs(it.aIndex + j);
                            oai8data[it.oIndex + j] = ox = (byte)(iax & ibx);
                            ++j;
                        }
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl111
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (byte)(iax & ibx);
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)(iax & ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)(iax & ibx);
                        ++j;
                    }
lbl111:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl112:
                // 1 sources

                break;
            }
            case 200: {
                oai16data = ((CompoundShortDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai16data[it.oIndex] = ox = (short)(iax & ibx);
                    }
                    break;
                }
                if (as < bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai16data[it.oIndex] = ox = (short)(iax & ibx);
                        j = 1;
                        while (j < is) {
                            ibx = db.getElementLongAbs(it.bIndex + j);
                            oai16data[it.oIndex + j] = ox = (short)(iax & ibx);
                            ++j;
                        }
                    }
                    break;
                }
                if (as > bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai16data[it.oIndex] = ox = (short)(iax & ibx);
                        j = 1;
                        while (j < is) {
                            iax = da.getElementLongAbs(it.aIndex + j);
                            oai16data[it.oIndex + j] = ox = (short)(iax & ibx);
                            ++j;
                        }
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl170
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (short)(iax & ibx);
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)(iax & ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)(iax & ibx);
                        ++j;
                    }
lbl170:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl171:
                // 1 sources

                break;
            }
            case 400: {
                oai64data = ((CompoundLongDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai64data[it.oIndex] = ox = iax & ibx;
                    }
                    break;
                }
                if (as < bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai64data[it.oIndex] = ox = iax & ibx;
                        j = 1;
                        while (j < is) {
                            ibx = db.getElementLongAbs(it.bIndex + j);
                            oai64data[it.oIndex + j] = ox = iax & ibx;
                            ++j;
                        }
                    }
                    break;
                }
                if (as > bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai64data[it.oIndex] = ox = iax & ibx;
                        j = 1;
                        while (j < is) {
                            iax = da.getElementLongAbs(it.aIndex + j);
                            oai64data[it.oIndex + j] = ox = iax & ibx;
                            ++j;
                        }
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl229
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = iax & ibx;
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = iax & ibx;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = iax & ibx;
                        ++j;
                    }
lbl229:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl230:
                // 1 sources

                break;
            }
            case 300: {
                oai32data = ((CompoundIntegerDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai32data[it.oIndex] = ox = (int)(iax & ibx);
                    }
                    break;
                }
                if (as < bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai32data[it.oIndex] = ox = (int)(iax & ibx);
                        j = 1;
                        while (j < is) {
                            ibx = db.getElementLongAbs(it.bIndex + j);
                            oai32data[it.oIndex + j] = ox = (int)(iax & ibx);
                            ++j;
                        }
                    }
                    break;
                }
                if (as > bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai32data[it.oIndex] = ox = (int)(iax & ibx);
                        j = 1;
                        while (j < is) {
                            iax = da.getElementLongAbs(it.aIndex + j);
                            oai32data[it.oIndex + j] = ox = (int)(iax & ibx);
                            ++j;
                        }
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl288
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (int)(iax & ibx);
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)(iax & ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)(iax & ibx);
                        ++j;
                    }
lbl288:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl289:
                // 1 sources

                break;
            }
            default: {
                throw new IllegalArgumentException("bitwiseAnd supports integer, compound integer datasets only");
            }
        }
        Maths.addBinaryOperatorName(da, db, result, "&");
        return result;
    }

    public static Dataset bitwiseOr(Object a, Object b) {
        return Maths.bitwiseOr(a, b, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset bitwiseOr(Object a, Object b, Dataset o) {
        da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        db = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b);
        it = BroadcastIterator.createIterator(da, db, o, true);
        it.setOutputDouble(false);
        result = it.getOutput();
        if (!result.isComplex()) {
            change = false;
            if (da.isComplex()) {
                da = da.getRealView();
                change = true;
            }
            if (db.isComplex()) {
                db = db.getRealView();
                change = true;
            }
            if (change) {
                it = BroadcastIterator.createIterator(da, db, result, true);
                it.setOutputDouble(false);
            }
        }
        is = result.getElementsPerItem();
        as = da.getElementsPerItem();
        bs = db.getElementsPerItem();
        dt = result.getDType();
        switch (dt) {
            case 1: {
                oi8data = ((ByteDataset)result).getData();
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi8data[it.oIndex] = ox = (byte)(iax | ibx);
                }
                break;
            }
            case 2: {
                oi16data = ((ShortDataset)result).getData();
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi16data[it.oIndex] = ox = (short)(iax | ibx);
                }
                break;
            }
            case 4: {
                oi64data = ((LongDataset)result).getData();
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi64data[it.oIndex] = ox = iax | ibx;
                }
                break;
            }
            case 3: {
                oi32data = ((IntegerDataset)result).getData();
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi32data[it.oIndex] = ox = (int)(iax | ibx);
                }
                break;
            }
            case 100: {
                oai8data = ((CompoundByteDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai8data[it.oIndex] = ox = (byte)(iax | ibx);
                    }
                    break;
                }
                if (as < bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai8data[it.oIndex] = ox = (byte)(iax | ibx);
                        j = 1;
                        while (j < is) {
                            ibx = db.getElementLongAbs(it.bIndex + j);
                            oai8data[it.oIndex + j] = ox = (byte)(iax | ibx);
                            ++j;
                        }
                    }
                    break;
                }
                if (as > bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai8data[it.oIndex] = ox = (byte)(iax | ibx);
                        j = 1;
                        while (j < is) {
                            iax = da.getElementLongAbs(it.aIndex + j);
                            oai8data[it.oIndex + j] = ox = (byte)(iax | ibx);
                            ++j;
                        }
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl111
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (byte)(iax | ibx);
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)(iax | ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)(iax | ibx);
                        ++j;
                    }
lbl111:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl112:
                // 1 sources

                break;
            }
            case 200: {
                oai16data = ((CompoundShortDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai16data[it.oIndex] = ox = (short)(iax | ibx);
                    }
                    break;
                }
                if (as < bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai16data[it.oIndex] = ox = (short)(iax | ibx);
                        j = 1;
                        while (j < is) {
                            ibx = db.getElementLongAbs(it.bIndex + j);
                            oai16data[it.oIndex + j] = ox = (short)(iax | ibx);
                            ++j;
                        }
                    }
                    break;
                }
                if (as > bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai16data[it.oIndex] = ox = (short)(iax | ibx);
                        j = 1;
                        while (j < is) {
                            iax = da.getElementLongAbs(it.aIndex + j);
                            oai16data[it.oIndex + j] = ox = (short)(iax | ibx);
                            ++j;
                        }
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl170
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (short)(iax | ibx);
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)(iax | ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)(iax | ibx);
                        ++j;
                    }
lbl170:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl171:
                // 1 sources

                break;
            }
            case 400: {
                oai64data = ((CompoundLongDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai64data[it.oIndex] = ox = iax | ibx;
                    }
                    break;
                }
                if (as < bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai64data[it.oIndex] = ox = iax | ibx;
                        j = 1;
                        while (j < is) {
                            ibx = db.getElementLongAbs(it.bIndex + j);
                            oai64data[it.oIndex + j] = ox = iax | ibx;
                            ++j;
                        }
                    }
                    break;
                }
                if (as > bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai64data[it.oIndex] = ox = iax | ibx;
                        j = 1;
                        while (j < is) {
                            iax = da.getElementLongAbs(it.aIndex + j);
                            oai64data[it.oIndex + j] = ox = iax | ibx;
                            ++j;
                        }
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl229
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = iax | ibx;
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = iax | ibx;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = iax | ibx;
                        ++j;
                    }
lbl229:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl230:
                // 1 sources

                break;
            }
            case 300: {
                oai32data = ((CompoundIntegerDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai32data[it.oIndex] = ox = (int)(iax | ibx);
                    }
                    break;
                }
                if (as < bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai32data[it.oIndex] = ox = (int)(iax | ibx);
                        j = 1;
                        while (j < is) {
                            ibx = db.getElementLongAbs(it.bIndex + j);
                            oai32data[it.oIndex + j] = ox = (int)(iax | ibx);
                            ++j;
                        }
                    }
                    break;
                }
                if (as > bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai32data[it.oIndex] = ox = (int)(iax | ibx);
                        j = 1;
                        while (j < is) {
                            iax = da.getElementLongAbs(it.aIndex + j);
                            oai32data[it.oIndex + j] = ox = (int)(iax | ibx);
                            ++j;
                        }
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl288
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (int)(iax | ibx);
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)(iax | ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)(iax | ibx);
                        ++j;
                    }
lbl288:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl289:
                // 1 sources

                break;
            }
            default: {
                throw new IllegalArgumentException("bitwiseOr supports integer, compound integer datasets only");
            }
        }
        Maths.addBinaryOperatorName(da, db, result, "|");
        return result;
    }

    public static Dataset bitwiseXor(Object a, Object b) {
        return Maths.bitwiseXor(a, b, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset bitwiseXor(Object a, Object b, Dataset o) {
        da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        db = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b);
        it = BroadcastIterator.createIterator(da, db, o, true);
        it.setOutputDouble(false);
        result = it.getOutput();
        if (!result.isComplex()) {
            change = false;
            if (da.isComplex()) {
                da = da.getRealView();
                change = true;
            }
            if (db.isComplex()) {
                db = db.getRealView();
                change = true;
            }
            if (change) {
                it = BroadcastIterator.createIterator(da, db, result, true);
                it.setOutputDouble(false);
            }
        }
        is = result.getElementsPerItem();
        as = da.getElementsPerItem();
        bs = db.getElementsPerItem();
        dt = result.getDType();
        switch (dt) {
            case 1: {
                oi8data = ((ByteDataset)result).getData();
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi8data[it.oIndex] = ox = (byte)(iax ^ ibx);
                }
                break;
            }
            case 2: {
                oi16data = ((ShortDataset)result).getData();
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi16data[it.oIndex] = ox = (short)(iax ^ ibx);
                }
                break;
            }
            case 4: {
                oi64data = ((LongDataset)result).getData();
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi64data[it.oIndex] = ox = iax ^ ibx;
                }
                break;
            }
            case 3: {
                oi32data = ((IntegerDataset)result).getData();
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi32data[it.oIndex] = ox = (int)(iax ^ ibx);
                }
                break;
            }
            case 100: {
                oai8data = ((CompoundByteDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai8data[it.oIndex] = ox = (byte)(iax ^ ibx);
                    }
                    break;
                }
                if (as < bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai8data[it.oIndex] = ox = (byte)(iax ^ ibx);
                        j = 1;
                        while (j < is) {
                            ibx = db.getElementLongAbs(it.bIndex + j);
                            oai8data[it.oIndex + j] = ox = (byte)(iax ^ ibx);
                            ++j;
                        }
                    }
                    break;
                }
                if (as > bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai8data[it.oIndex] = ox = (byte)(iax ^ ibx);
                        j = 1;
                        while (j < is) {
                            iax = da.getElementLongAbs(it.aIndex + j);
                            oai8data[it.oIndex + j] = ox = (byte)(iax ^ ibx);
                            ++j;
                        }
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl111
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (byte)(iax ^ ibx);
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)(iax ^ ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)(iax ^ ibx);
                        ++j;
                    }
lbl111:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl112:
                // 1 sources

                break;
            }
            case 200: {
                oai16data = ((CompoundShortDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai16data[it.oIndex] = ox = (short)(iax ^ ibx);
                    }
                    break;
                }
                if (as < bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai16data[it.oIndex] = ox = (short)(iax ^ ibx);
                        j = 1;
                        while (j < is) {
                            ibx = db.getElementLongAbs(it.bIndex + j);
                            oai16data[it.oIndex + j] = ox = (short)(iax ^ ibx);
                            ++j;
                        }
                    }
                    break;
                }
                if (as > bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai16data[it.oIndex] = ox = (short)(iax ^ ibx);
                        j = 1;
                        while (j < is) {
                            iax = da.getElementLongAbs(it.aIndex + j);
                            oai16data[it.oIndex + j] = ox = (short)(iax ^ ibx);
                            ++j;
                        }
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl170
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (short)(iax ^ ibx);
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)(iax ^ ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)(iax ^ ibx);
                        ++j;
                    }
lbl170:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl171:
                // 1 sources

                break;
            }
            case 400: {
                oai64data = ((CompoundLongDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai64data[it.oIndex] = ox = iax ^ ibx;
                    }
                    break;
                }
                if (as < bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai64data[it.oIndex] = ox = iax ^ ibx;
                        j = 1;
                        while (j < is) {
                            ibx = db.getElementLongAbs(it.bIndex + j);
                            oai64data[it.oIndex + j] = ox = iax ^ ibx;
                            ++j;
                        }
                    }
                    break;
                }
                if (as > bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai64data[it.oIndex] = ox = iax ^ ibx;
                        j = 1;
                        while (j < is) {
                            iax = da.getElementLongAbs(it.aIndex + j);
                            oai64data[it.oIndex + j] = ox = iax ^ ibx;
                            ++j;
                        }
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl229
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = iax ^ ibx;
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = iax ^ ibx;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = iax ^ ibx;
                        ++j;
                    }
lbl229:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl230:
                // 1 sources

                break;
            }
            case 300: {
                oai32data = ((CompoundIntegerDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai32data[it.oIndex] = ox = (int)(iax ^ ibx);
                    }
                    break;
                }
                if (as < bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai32data[it.oIndex] = ox = (int)(iax ^ ibx);
                        j = 1;
                        while (j < is) {
                            ibx = db.getElementLongAbs(it.bIndex + j);
                            oai32data[it.oIndex + j] = ox = (int)(iax ^ ibx);
                            ++j;
                        }
                    }
                    break;
                }
                if (as > bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai32data[it.oIndex] = ox = (int)(iax ^ ibx);
                        j = 1;
                        while (j < is) {
                            iax = da.getElementLongAbs(it.aIndex + j);
                            oai32data[it.oIndex + j] = ox = (int)(iax ^ ibx);
                            ++j;
                        }
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl288
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (int)(iax ^ ibx);
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)(iax ^ ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)(iax ^ ibx);
                        ++j;
                    }
lbl288:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl289:
                // 1 sources

                break;
            }
            default: {
                throw new IllegalArgumentException("bitwiseXor supports integer, compound integer datasets only");
            }
        }
        Maths.addBinaryOperatorName(da, db, result, "^");
        return result;
    }

    public static Dataset leftShift(Object a, Object b) {
        return Maths.leftShift(a, b, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset leftShift(Object a, Object b, Dataset o) {
        da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        db = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b);
        it = BroadcastIterator.createIterator(da, db, o, true);
        it.setOutputDouble(false);
        result = it.getOutput();
        if (!result.isComplex()) {
            change = false;
            if (da.isComplex()) {
                da = da.getRealView();
                change = true;
            }
            if (db.isComplex()) {
                db = db.getRealView();
                change = true;
            }
            if (change) {
                it = BroadcastIterator.createIterator(da, db, result, true);
                it.setOutputDouble(false);
            }
        }
        is = result.getElementsPerItem();
        as = da.getElementsPerItem();
        bs = db.getElementsPerItem();
        dt = result.getDType();
        switch (dt) {
            case 1: {
                oi8data = ((ByteDataset)result).getData();
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi8data[it.oIndex] = ox = (byte)(iax << (int)ibx);
                }
                break;
            }
            case 2: {
                oi16data = ((ShortDataset)result).getData();
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi16data[it.oIndex] = ox = (short)(iax << (int)ibx);
                }
                break;
            }
            case 4: {
                oi64data = ((LongDataset)result).getData();
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi64data[it.oIndex] = ox = iax << (int)ibx;
                }
                break;
            }
            case 3: {
                oi32data = ((IntegerDataset)result).getData();
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi32data[it.oIndex] = ox = (int)(iax << (int)ibx);
                }
                break;
            }
            case 100: {
                oai8data = ((CompoundByteDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai8data[it.oIndex] = ox = (byte)(iax << (int)ibx);
                    }
                    break;
                }
                if (as < bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai8data[it.oIndex] = ox = (byte)(iax << (int)ibx);
                        j = 1;
                        while (j < is) {
                            ibx = db.getElementLongAbs(it.bIndex + j);
                            oai8data[it.oIndex + j] = ox = (byte)(iax << (int)ibx);
                            ++j;
                        }
                    }
                    break;
                }
                if (as > bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai8data[it.oIndex] = ox = (byte)(iax << (int)ibx);
                        j = 1;
                        while (j < is) {
                            iax = da.getElementLongAbs(it.aIndex + j);
                            oai8data[it.oIndex + j] = ox = (byte)(iax << (int)ibx);
                            ++j;
                        }
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl111
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (byte)(iax << (int)ibx);
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)(iax << (int)ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)(iax << (int)ibx);
                        ++j;
                    }
lbl111:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl112:
                // 1 sources

                break;
            }
            case 200: {
                oai16data = ((CompoundShortDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai16data[it.oIndex] = ox = (short)(iax << (int)ibx);
                    }
                    break;
                }
                if (as < bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai16data[it.oIndex] = ox = (short)(iax << (int)ibx);
                        j = 1;
                        while (j < is) {
                            ibx = db.getElementLongAbs(it.bIndex + j);
                            oai16data[it.oIndex + j] = ox = (short)(iax << (int)ibx);
                            ++j;
                        }
                    }
                    break;
                }
                if (as > bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai16data[it.oIndex] = ox = (short)(iax << (int)ibx);
                        j = 1;
                        while (j < is) {
                            iax = da.getElementLongAbs(it.aIndex + j);
                            oai16data[it.oIndex + j] = ox = (short)(iax << (int)ibx);
                            ++j;
                        }
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl170
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (short)(iax << (int)ibx);
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)(iax << (int)ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)(iax << (int)ibx);
                        ++j;
                    }
lbl170:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl171:
                // 1 sources

                break;
            }
            case 400: {
                oai64data = ((CompoundLongDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai64data[it.oIndex] = ox = iax << (int)ibx;
                    }
                    break;
                }
                if (as < bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai64data[it.oIndex] = ox = iax << (int)ibx;
                        j = 1;
                        while (j < is) {
                            ibx = db.getElementLongAbs(it.bIndex + j);
                            oai64data[it.oIndex + j] = ox = iax << (int)ibx;
                            ++j;
                        }
                    }
                    break;
                }
                if (as > bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai64data[it.oIndex] = ox = iax << (int)ibx;
                        j = 1;
                        while (j < is) {
                            iax = da.getElementLongAbs(it.aIndex + j);
                            oai64data[it.oIndex + j] = ox = iax << (int)ibx;
                            ++j;
                        }
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl229
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = iax << (int)ibx;
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = iax << (int)ibx;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = iax << (int)ibx;
                        ++j;
                    }
lbl229:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl230:
                // 1 sources

                break;
            }
            case 300: {
                oai32data = ((CompoundIntegerDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai32data[it.oIndex] = ox = (int)(iax << (int)ibx);
                    }
                    break;
                }
                if (as < bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai32data[it.oIndex] = ox = (int)(iax << (int)ibx);
                        j = 1;
                        while (j < is) {
                            ibx = db.getElementLongAbs(it.bIndex + j);
                            oai32data[it.oIndex + j] = ox = (int)(iax << (int)ibx);
                            ++j;
                        }
                    }
                    break;
                }
                if (as > bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai32data[it.oIndex] = ox = (int)(iax << (int)ibx);
                        j = 1;
                        while (j < is) {
                            iax = da.getElementLongAbs(it.aIndex + j);
                            oai32data[it.oIndex + j] = ox = (int)(iax << (int)ibx);
                            ++j;
                        }
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl288
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (int)(iax << (int)ibx);
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)(iax << (int)ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)(iax << (int)ibx);
                        ++j;
                    }
lbl288:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl289:
                // 1 sources

                break;
            }
            default: {
                throw new IllegalArgumentException("leftShift supports integer, compound integer datasets only");
            }
        }
        Maths.addBinaryOperatorName(da, db, result, "<<");
        return result;
    }

    public static Dataset rightShift(Object a, Object b) {
        return Maths.rightShift(a, b, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset rightShift(Object a, Object b, Dataset o) {
        da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        db = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b);
        it = BroadcastIterator.createIterator(da, db, o, true);
        it.setOutputDouble(false);
        result = it.getOutput();
        if (!result.isComplex()) {
            change = false;
            if (da.isComplex()) {
                da = da.getRealView();
                change = true;
            }
            if (db.isComplex()) {
                db = db.getRealView();
                change = true;
            }
            if (change) {
                it = BroadcastIterator.createIterator(da, db, result, true);
                it.setOutputDouble(false);
            }
        }
        is = result.getElementsPerItem();
        as = da.getElementsPerItem();
        bs = db.getElementsPerItem();
        dt = result.getDType();
        switch (dt) {
            case 1: {
                oi8data = ((ByteDataset)result).getData();
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi8data[it.oIndex] = ox = (byte)(iax >> (int)ibx);
                }
                break;
            }
            case 2: {
                oi16data = ((ShortDataset)result).getData();
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi16data[it.oIndex] = ox = (short)(iax >> (int)ibx);
                }
                break;
            }
            case 4: {
                oi64data = ((LongDataset)result).getData();
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi64data[it.oIndex] = ox = iax >> (int)ibx;
                }
                break;
            }
            case 3: {
                oi32data = ((IntegerDataset)result).getData();
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi32data[it.oIndex] = ox = (int)(iax >> (int)ibx);
                }
                break;
            }
            case 100: {
                oai8data = ((CompoundByteDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai8data[it.oIndex] = ox = (byte)(iax >> (int)ibx);
                    }
                    break;
                }
                if (as < bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai8data[it.oIndex] = ox = (byte)(iax >> (int)ibx);
                        j = 1;
                        while (j < is) {
                            ibx = db.getElementLongAbs(it.bIndex + j);
                            oai8data[it.oIndex + j] = ox = (byte)(iax >> (int)ibx);
                            ++j;
                        }
                    }
                    break;
                }
                if (as > bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai8data[it.oIndex] = ox = (byte)(iax >> (int)ibx);
                        j = 1;
                        while (j < is) {
                            iax = da.getElementLongAbs(it.aIndex + j);
                            oai8data[it.oIndex + j] = ox = (byte)(iax >> (int)ibx);
                            ++j;
                        }
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl111
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (byte)(iax >> (int)ibx);
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)(iax >> (int)ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)(iax >> (int)ibx);
                        ++j;
                    }
lbl111:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl112:
                // 1 sources

                break;
            }
            case 200: {
                oai16data = ((CompoundShortDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai16data[it.oIndex] = ox = (short)(iax >> (int)ibx);
                    }
                    break;
                }
                if (as < bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai16data[it.oIndex] = ox = (short)(iax >> (int)ibx);
                        j = 1;
                        while (j < is) {
                            ibx = db.getElementLongAbs(it.bIndex + j);
                            oai16data[it.oIndex + j] = ox = (short)(iax >> (int)ibx);
                            ++j;
                        }
                    }
                    break;
                }
                if (as > bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai16data[it.oIndex] = ox = (short)(iax >> (int)ibx);
                        j = 1;
                        while (j < is) {
                            iax = da.getElementLongAbs(it.aIndex + j);
                            oai16data[it.oIndex + j] = ox = (short)(iax >> (int)ibx);
                            ++j;
                        }
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl170
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (short)(iax >> (int)ibx);
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)(iax >> (int)ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)(iax >> (int)ibx);
                        ++j;
                    }
lbl170:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl171:
                // 1 sources

                break;
            }
            case 400: {
                oai64data = ((CompoundLongDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai64data[it.oIndex] = ox = iax >> (int)ibx;
                    }
                    break;
                }
                if (as < bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai64data[it.oIndex] = ox = iax >> (int)ibx;
                        j = 1;
                        while (j < is) {
                            ibx = db.getElementLongAbs(it.bIndex + j);
                            oai64data[it.oIndex + j] = ox = iax >> (int)ibx;
                            ++j;
                        }
                    }
                    break;
                }
                if (as > bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai64data[it.oIndex] = ox = iax >> (int)ibx;
                        j = 1;
                        while (j < is) {
                            iax = da.getElementLongAbs(it.aIndex + j);
                            oai64data[it.oIndex + j] = ox = iax >> (int)ibx;
                            ++j;
                        }
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl229
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = iax >> (int)ibx;
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = iax >> (int)ibx;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = iax >> (int)ibx;
                        ++j;
                    }
lbl229:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl230:
                // 1 sources

                break;
            }
            case 300: {
                oai32data = ((CompoundIntegerDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai32data[it.oIndex] = ox = (int)(iax >> (int)ibx);
                    }
                    break;
                }
                if (as < bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai32data[it.oIndex] = ox = (int)(iax >> (int)ibx);
                        j = 1;
                        while (j < is) {
                            ibx = db.getElementLongAbs(it.bIndex + j);
                            oai32data[it.oIndex + j] = ox = (int)(iax >> (int)ibx);
                            ++j;
                        }
                    }
                    break;
                }
                if (as > bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai32data[it.oIndex] = ox = (int)(iax >> (int)ibx);
                        j = 1;
                        while (j < is) {
                            iax = da.getElementLongAbs(it.aIndex + j);
                            oai32data[it.oIndex + j] = ox = (int)(iax >> (int)ibx);
                            ++j;
                        }
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl288
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (int)(iax >> (int)ibx);
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)(iax >> (int)ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)(iax >> (int)ibx);
                        ++j;
                    }
lbl288:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl289:
                // 1 sources

                break;
            }
            default: {
                throw new IllegalArgumentException("rightShift supports integer, compound integer datasets only");
            }
        }
        Maths.addBinaryOperatorName(da, db, result, ">>");
        return result;
    }

    public static Dataset unsignedRightShift(Object a, Object b) {
        return Maths.unsignedRightShift(a, b, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset unsignedRightShift(Object a, Object b, Dataset o) {
        da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        db = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b);
        it = BroadcastIterator.createIterator(da, db, o, true);
        it.setOutputDouble(false);
        result = it.getOutput();
        if (!result.isComplex()) {
            change = false;
            if (da.isComplex()) {
                da = da.getRealView();
                change = true;
            }
            if (db.isComplex()) {
                db = db.getRealView();
                change = true;
            }
            if (change) {
                it = BroadcastIterator.createIterator(da, db, result, true);
                it.setOutputDouble(false);
            }
        }
        is = result.getElementsPerItem();
        as = da.getElementsPerItem();
        bs = db.getElementsPerItem();
        dt = result.getDType();
        switch (dt) {
            case 1: {
                oi8data = ((ByteDataset)result).getData();
                unsignedMask = 255L;
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi8data[it.oIndex] = ox = (byte)((unsignedMask & iax) >>> (int)ibx);
                }
                break;
            }
            case 2: {
                oi16data = ((ShortDataset)result).getData();
                unsignedMask = 65535L;
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi16data[it.oIndex] = ox = (short)((unsignedMask & iax) >>> (int)ibx);
                }
                break;
            }
            case 4: {
                oi64data = ((LongDataset)result).getData();
                unsignedMask = -1L;
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi64data[it.oIndex] = ox = (unsignedMask & iax) >>> (int)ibx;
                }
                break;
            }
            case 3: {
                oi32data = ((IntegerDataset)result).getData();
                unsignedMask = 0xFFFFFFFFL;
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oi32data[it.oIndex] = ox = (int)((unsignedMask & iax) >>> (int)ibx);
                }
                break;
            }
            case 100: {
                oai8data = ((CompoundByteDataset)result).getData();
                unsignedMask = 255L;
                if (is == 1) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai8data[it.oIndex] = ox = (byte)((unsignedMask & iax) >>> (int)ibx);
                    }
                    break;
                }
                if (as < bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai8data[it.oIndex] = ox = (byte)((unsignedMask & iax) >>> (int)ibx);
                        j = 1;
                        while (j < is) {
                            ibx = db.getElementLongAbs(it.bIndex + j);
                            oai8data[it.oIndex + j] = ox = (byte)((unsignedMask & iax) >>> (int)ibx);
                            ++j;
                        }
                    }
                    break;
                }
                if (as > bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai8data[it.oIndex] = ox = (byte)((unsignedMask & iax) >>> (int)ibx);
                        j = 1;
                        while (j < is) {
                            iax = da.getElementLongAbs(it.aIndex + j);
                            oai8data[it.oIndex + j] = ox = (byte)((unsignedMask & iax) >>> (int)ibx);
                            ++j;
                        }
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl116
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (byte)((unsignedMask & iax) >>> (int)ibx);
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai8data[it.oIndex] = ox = (byte)((unsignedMask & iax) >>> (int)ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)((unsignedMask & iax) >>> (int)ibx);
                        ++j;
                    }
lbl116:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl117:
                // 1 sources

                break;
            }
            case 200: {
                oai16data = ((CompoundShortDataset)result).getData();
                unsignedMask = 65535L;
                if (is == 1) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai16data[it.oIndex] = ox = (short)((unsignedMask & iax) >>> (int)ibx);
                    }
                    break;
                }
                if (as < bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai16data[it.oIndex] = ox = (short)((unsignedMask & iax) >>> (int)ibx);
                        j = 1;
                        while (j < is) {
                            ibx = db.getElementLongAbs(it.bIndex + j);
                            oai16data[it.oIndex + j] = ox = (short)((unsignedMask & iax) >>> (int)ibx);
                            ++j;
                        }
                    }
                    break;
                }
                if (as > bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai16data[it.oIndex] = ox = (short)((unsignedMask & iax) >>> (int)ibx);
                        j = 1;
                        while (j < is) {
                            iax = da.getElementLongAbs(it.aIndex + j);
                            oai16data[it.oIndex + j] = ox = (short)((unsignedMask & iax) >>> (int)ibx);
                            ++j;
                        }
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl176
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (short)((unsignedMask & iax) >>> (int)ibx);
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai16data[it.oIndex] = ox = (short)((unsignedMask & iax) >>> (int)ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)((unsignedMask & iax) >>> (int)ibx);
                        ++j;
                    }
lbl176:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl177:
                // 1 sources

                break;
            }
            case 400: {
                oai64data = ((CompoundLongDataset)result).getData();
                unsignedMask = -1L;
                if (is == 1) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai64data[it.oIndex] = ox = (unsignedMask & iax) >>> (int)ibx;
                    }
                    break;
                }
                if (as < bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai64data[it.oIndex] = ox = (unsignedMask & iax) >>> (int)ibx;
                        j = 1;
                        while (j < is) {
                            ibx = db.getElementLongAbs(it.bIndex + j);
                            oai64data[it.oIndex + j] = ox = (unsignedMask & iax) >>> (int)ibx;
                            ++j;
                        }
                    }
                    break;
                }
                if (as > bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai64data[it.oIndex] = ox = (unsignedMask & iax) >>> (int)ibx;
                        j = 1;
                        while (j < is) {
                            iax = da.getElementLongAbs(it.aIndex + j);
                            oai64data[it.oIndex + j] = ox = (unsignedMask & iax) >>> (int)ibx;
                            ++j;
                        }
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl236
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (unsignedMask & iax) >>> (int)ibx;
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai64data[it.oIndex] = ox = (unsignedMask & iax) >>> (int)ibx;
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai64data[it.oIndex + j] = ox = (unsignedMask & iax) >>> (int)ibx;
                        ++j;
                    }
lbl236:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl237:
                // 1 sources

                break;
            }
            case 300: {
                oai32data = ((CompoundIntegerDataset)result).getData();
                unsignedMask = 0xFFFFFFFFL;
                if (is == 1) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai32data[it.oIndex] = ox = (int)((unsignedMask & iax) >>> (int)ibx);
                    }
                    break;
                }
                if (as < bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai32data[it.oIndex] = ox = (int)((unsignedMask & iax) >>> (int)ibx);
                        j = 1;
                        while (j < is) {
                            ibx = db.getElementLongAbs(it.bIndex + j);
                            oai32data[it.oIndex + j] = ox = (int)((unsignedMask & iax) >>> (int)ibx);
                            ++j;
                        }
                    }
                    break;
                }
                if (as > bs) {
                    while (it.hasNext()) {
                        iax = it.aLong;
                        ibx = it.bLong;
                        oai32data[it.oIndex] = ox = (int)((unsignedMask & iax) >>> (int)ibx);
                        j = 1;
                        while (j < is) {
                            iax = da.getElementLongAbs(it.aIndex + j);
                            oai32data[it.oIndex + j] = ox = (int)((unsignedMask & iax) >>> (int)ibx);
                            ++j;
                        }
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl296
                while (it.hasNext()) {
                    iax = it.aLong;
                    ibx = it.bLong;
                    ox = (int)((unsignedMask & iax) >>> (int)ibx);
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    iax = it.aLong;
                    ibx = it.bLong;
                    oai32data[it.oIndex] = ox = (int)((unsignedMask & iax) >>> (int)ibx);
                    j = 1;
                    while (j < is) {
                        iax = da.getElementLongAbs(it.aIndex + j);
                        ibx = db.getElementLongAbs(it.bIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)((unsignedMask & iax) >>> (int)ibx);
                        ++j;
                    }
lbl296:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl297:
                // 1 sources

                break;
            }
            default: {
                throw new IllegalArgumentException("unsignedRightShift supports integer, compound integer datasets only");
            }
        }
        Maths.addBinaryOperatorName(da, db, result, ">>>");
        return result;
    }

    public static Dataset bitwiseInvert(Object a) {
        return Maths.bitwiseInvert(a, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset bitwiseInvert(Object a, Dataset o) {
        da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        it = new SingleInputBroadcastIterator(da, o, true, true, true);
        result = it.getOutput();
        if (!result.isComplex() && da.isComplex()) {
            da = da.getRealView();
            it = new SingleInputBroadcastIterator(da, result, true, true, true);
        }
        is = result.getElementsPerItem();
        as = da.getElementsPerItem();
        dt = result.getDType();
        switch (dt) {
            case 1: {
                oi8data = ((ByteDataset)result).getData();
                while (it.hasNext()) {
                    ix = it.aLong;
                    oi8data[it.oIndex] = ox = (byte)Maths.toLong(ix ^ -1L);
                }
                break;
            }
            case 2: {
                oi16data = ((ShortDataset)result).getData();
                while (it.hasNext()) {
                    ix = it.aLong;
                    oi16data[it.oIndex] = ox = (short)Maths.toLong(ix ^ -1L);
                }
                break;
            }
            case 4: {
                oi64data = ((LongDataset)result).getData();
                while (it.hasNext()) {
                    ix = it.aLong;
                    oi64data[it.oIndex] = ox = Maths.toLong(ix ^ -1L);
                }
                break;
            }
            case 3: {
                oi32data = ((IntegerDataset)result).getData();
                while (it.hasNext()) {
                    ix = it.aLong;
                    oi32data[it.oIndex] = ox = (int)Maths.toLong(ix ^ -1L);
                }
                break;
            }
            case 100: {
                oai8data = ((CompoundByteDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        ix = it.aLong;
                        oai8data[it.oIndex] = ox = (byte)Maths.toLong(ix ^ -1L);
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl64
                while (it.hasNext()) {
                    ix = it.aLong;
                    ox = (byte)Maths.toLong(ix ^ -1L);
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(ix ^ -1L);
                        ++j;
                    }
lbl64:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl65:
                // 1 sources

                break;
            }
            case 200: {
                oai16data = ((CompoundShortDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        ix = it.aLong;
                        oai16data[it.oIndex] = ox = (short)Maths.toLong(ix ^ -1L);
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl91
                while (it.hasNext()) {
                    ix = it.aLong;
                    ox = (short)Maths.toLong(ix ^ -1L);
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(ix ^ -1L);
                        ++j;
                    }
lbl91:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl92:
                // 1 sources

                break;
            }
            case 400: {
                oai64data = ((CompoundLongDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        ix = it.aLong;
                        oai64data[it.oIndex] = ox = Maths.toLong(ix ^ -1L);
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl118
                while (it.hasNext()) {
                    ix = it.aLong;
                    ox = Maths.toLong(ix ^ -1L);
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(ix ^ -1L);
                        ++j;
                    }
lbl118:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl119:
                // 1 sources

                break;
            }
            case 300: {
                oai32data = ((CompoundIntegerDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        ix = it.aLong;
                        oai32data[it.oIndex] = ox = (int)Maths.toLong(ix ^ -1L);
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl145
                while (it.hasNext()) {
                    ix = it.aLong;
                    ox = (int)Maths.toLong(ix ^ -1L);
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(ix ^ -1L);
                        ++j;
                    }
lbl145:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl146:
                // 1 sources

                break;
            }
            default: {
                throw new IllegalArgumentException("bitwiseInvert supports integer, compound integer datasets only");
            }
        }
        Maths.addFunctionName(result, "bitwiseInvert");
        return result;
    }

    public static Dataset sin(Object a) {
        return Maths.sin(a, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset sin(Object a, Dataset o) {
        da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        it = new SingleInputBroadcastIterator(da, o, true);
        result = it.getOutput();
        if (!result.isComplex() && da.isComplex()) {
            da = da.getRealView();
            it = new SingleInputBroadcastIterator(da, result, true);
        }
        is = result.getElementsPerItem();
        as = da.getElementsPerItem();
        dt = result.getDType();
        switch (dt) {
            case 1: {
                oi8data = ((ByteDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl21
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi8data[it.oIndex] = ox = (byte)Maths.toLong(Math.sin(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi8data[it.oIndex] = ox = (byte)Maths.toLong(Math.sin(ix));
lbl21:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl22:
                // 1 sources

                break;
            }
            case 2: {
                oi16data = ((ShortDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl33
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi16data[it.oIndex] = ox = (short)Maths.toLong(Math.sin(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi16data[it.oIndex] = ox = (short)Maths.toLong(Math.sin(ix));
lbl33:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl34:
                // 1 sources

                break;
            }
            case 4: {
                oi64data = ((LongDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl45
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi64data[it.oIndex] = ox = Maths.toLong(Math.sin(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi64data[it.oIndex] = ox = Maths.toLong(Math.sin(ix));
lbl45:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl46:
                // 1 sources

                break;
            }
            case 3: {
                oi32data = ((IntegerDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl57
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi32data[it.oIndex] = ox = (int)Maths.toLong(Math.sin(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi32data[it.oIndex] = ox = (int)Maths.toLong(Math.sin(ix));
lbl57:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl58:
                // 1 sources

                break;
            }
            case 100: {
                oai8data = ((CompoundByteDataset)result).getData();
                if (is != 1) ** GOTO lbl72
                if (!it.isOutputDouble()) ** GOTO lbl70
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.sin(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.sin(ix));
lbl70:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl71:
                // 1 sources

                break;
lbl72:
                // 1 sources

                if (as != 1) ** GOTO lbl93
                if (!it.isOutputDouble()) ** GOTO lbl91
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (byte)Maths.toLong(Math.sin(ix));
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (byte)Maths.toLong(Math.sin(ix));
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl91:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl92:
                // 1 sources

                break;
lbl93:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl109
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.sin(ix));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.sin(ix));
                        ++j;
                    }
lbl109:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl110:
                // 1 sources

                break;
            }
            case 200: {
                oai16data = ((CompoundShortDataset)result).getData();
                if (is != 1) ** GOTO lbl124
                if (!it.isOutputDouble()) ** GOTO lbl122
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.sin(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.sin(ix));
lbl122:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl123:
                // 1 sources

                break;
lbl124:
                // 1 sources

                if (as != 1) ** GOTO lbl145
                if (!it.isOutputDouble()) ** GOTO lbl143
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (short)Maths.toLong(Math.sin(ix));
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (short)Maths.toLong(Math.sin(ix));
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl143:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl144:
                // 1 sources

                break;
lbl145:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl161
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.sin(ix));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.sin(ix));
                        ++j;
                    }
lbl161:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl162:
                // 1 sources

                break;
            }
            case 400: {
                oai64data = ((CompoundLongDataset)result).getData();
                if (is != 1) ** GOTO lbl176
                if (!it.isOutputDouble()) ** GOTO lbl174
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.sin(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.sin(ix));
lbl174:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl175:
                // 1 sources

                break;
lbl176:
                // 1 sources

                if (as != 1) ** GOTO lbl197
                if (!it.isOutputDouble()) ** GOTO lbl195
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = Maths.toLong(Math.sin(ix));
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = Maths.toLong(Math.sin(ix));
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl195:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl196:
                // 1 sources

                break;
lbl197:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl213
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.sin(ix));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.sin(ix));
                        ++j;
                    }
lbl213:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl214:
                // 1 sources

                break;
            }
            case 300: {
                oai32data = ((CompoundIntegerDataset)result).getData();
                if (is != 1) ** GOTO lbl228
                if (!it.isOutputDouble()) ** GOTO lbl226
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.sin(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.sin(ix));
lbl226:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl227:
                // 1 sources

                break;
lbl228:
                // 1 sources

                if (as != 1) ** GOTO lbl249
                if (!it.isOutputDouble()) ** GOTO lbl247
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (int)Maths.toLong(Math.sin(ix));
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (int)Maths.toLong(Math.sin(ix));
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl247:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl248:
                // 1 sources

                break;
lbl249:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl265
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.sin(ix));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.sin(ix));
                        ++j;
                    }
lbl265:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl266:
                // 1 sources

                break;
            }
            case 5: {
                of32data = ((FloatDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl277
                while (it.hasNext()) {
                    ix = it.aDouble;
                    of32data[it.oIndex] = ox = (float)Math.sin(ix);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    of32data[it.oIndex] = ox = (float)Math.sin(ix);
lbl277:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl278:
                // 1 sources

                break;
            }
            case 6: {
                of64data = ((DoubleDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl289
                while (it.hasNext()) {
                    ix = it.aDouble;
                    of64data[it.oIndex] = ox = Math.sin(ix);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    of64data[it.oIndex] = ox = Math.sin(ix);
lbl289:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl290:
                // 1 sources

                break;
            }
            case 500: {
                oaf32data = ((CompoundFloatDataset)result).getData();
                if (is != 1) ** GOTO lbl304
                if (!it.isOutputDouble()) ** GOTO lbl302
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oaf32data[it.oIndex] = ox = (float)Math.sin(ix);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oaf32data[it.oIndex] = ox = (float)Math.sin(ix);
lbl302:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl303:
                // 1 sources

                break;
lbl304:
                // 1 sources

                if (as != 1) ** GOTO lbl325
                if (!it.isOutputDouble()) ** GOTO lbl323
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (float)Math.sin(ix);
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (float)Math.sin(ix);
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl323:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl324:
                // 1 sources

                break;
lbl325:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl341
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.sin(ix);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.sin(ix);
                        ++j;
                    }
lbl341:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl342:
                // 1 sources

                break;
            }
            case 600: {
                oaf64data = ((CompoundDoubleDataset)result).getData();
                if (is != 1) ** GOTO lbl356
                if (!it.isOutputDouble()) ** GOTO lbl354
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oaf64data[it.oIndex] = ox = Math.sin(ix);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oaf64data[it.oIndex] = ox = Math.sin(ix);
lbl354:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl355:
                // 1 sources

                break;
lbl356:
                // 1 sources

                if (as != 1) ** GOTO lbl377
                if (!it.isOutputDouble()) ** GOTO lbl375
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = Math.sin(ix);
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = Math.sin(ix);
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl375:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl376:
                // 1 sources

                break;
lbl377:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl393
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = Math.sin(ix);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = Math.sin(ix);
                        ++j;
                    }
lbl393:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl394:
                // 1 sources

                break;
            }
            case 7: {
                oc64data = ((ComplexFloatDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl423
                if (it.isOutputDouble()) {
                    iy = 0.0;
                    while (it.hasNext()) {
                        ix = it.aDouble;
                        ox = (float)(Math.sin(ix) * Math.cosh(0.0));
                        oy = (float)(Math.cos(ix) * Math.sinh(0.0));
                        oc64data[it.oIndex] = ox;
                        oc64data[it.oIndex + 1] = oy;
                    }
                } else {
                    iy = 0L;
                    while (it.hasNext()) {
                        ix = it.aLong;
                        ox = Maths.toLong(Math.sin(ix) * Math.cosh(0.0));
                        oy = Maths.toLong(Math.cos(ix) * Math.sinh(0.0));
                        oc64data[it.oIndex] = ox;
                        oc64data[it.oIndex + 1] = oy;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aDouble;
                    iy = da.getElementDoubleAbs(it.aIndex + 1);
                    ox = (float)(Math.sin(ix) * Math.cosh(iy));
                    oy = (float)(Math.cos(ix) * Math.sinh(iy));
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
lbl423:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl424:
                // 1 sources

                break;
            }
            case 8: {
                oc128data = ((ComplexDoubleDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl453
                if (it.isOutputDouble()) {
                    iy = 0.0;
                    while (it.hasNext()) {
                        ix = it.aDouble;
                        ox = Math.sin(ix) * Math.cosh(0.0);
                        oy = Math.cos(ix) * Math.sinh(0.0);
                        oc128data[it.oIndex] = ox;
                        oc128data[it.oIndex + 1] = oy;
                    }
                } else {
                    iy = 0L;
                    while (it.hasNext()) {
                        ix = it.aLong;
                        ox = Math.sin(ix) * Math.cosh(0.0);
                        oy = Math.cos(ix) * Math.sinh(0.0);
                        oc128data[it.oIndex] = ox;
                        oc128data[it.oIndex + 1] = oy;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aDouble;
                    iy = da.getElementDoubleAbs(it.aIndex + 1);
                    ox = Math.sin(ix) * Math.cosh(iy);
                    oy = Math.cos(ix) * Math.sinh(iy);
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
lbl453:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl454:
                // 1 sources

                break;
            }
            default: {
                throw new IllegalArgumentException("sin supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        Maths.addFunctionName(result, "sin");
        return result;
    }

    public static Dataset cos(Object a) {
        return Maths.cos(a, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset cos(Object a, Dataset o) {
        da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        it = new SingleInputBroadcastIterator(da, o, true);
        result = it.getOutput();
        if (!result.isComplex() && da.isComplex()) {
            da = da.getRealView();
            it = new SingleInputBroadcastIterator(da, result, true);
        }
        is = result.getElementsPerItem();
        as = da.getElementsPerItem();
        dt = result.getDType();
        switch (dt) {
            case 1: {
                oi8data = ((ByteDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl21
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi8data[it.oIndex] = ox = (byte)Maths.toLong(Math.cos(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi8data[it.oIndex] = ox = (byte)Maths.toLong(Math.cos(ix));
lbl21:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl22:
                // 1 sources

                break;
            }
            case 2: {
                oi16data = ((ShortDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl33
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi16data[it.oIndex] = ox = (short)Maths.toLong(Math.cos(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi16data[it.oIndex] = ox = (short)Maths.toLong(Math.cos(ix));
lbl33:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl34:
                // 1 sources

                break;
            }
            case 4: {
                oi64data = ((LongDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl45
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi64data[it.oIndex] = ox = Maths.toLong(Math.cos(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi64data[it.oIndex] = ox = Maths.toLong(Math.cos(ix));
lbl45:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl46:
                // 1 sources

                break;
            }
            case 3: {
                oi32data = ((IntegerDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl57
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi32data[it.oIndex] = ox = (int)Maths.toLong(Math.cos(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi32data[it.oIndex] = ox = (int)Maths.toLong(Math.cos(ix));
lbl57:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl58:
                // 1 sources

                break;
            }
            case 100: {
                oai8data = ((CompoundByteDataset)result).getData();
                if (is != 1) ** GOTO lbl72
                if (!it.isOutputDouble()) ** GOTO lbl70
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.cos(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.cos(ix));
lbl70:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl71:
                // 1 sources

                break;
lbl72:
                // 1 sources

                if (as != 1) ** GOTO lbl93
                if (!it.isOutputDouble()) ** GOTO lbl91
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (byte)Maths.toLong(Math.cos(ix));
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (byte)Maths.toLong(Math.cos(ix));
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl91:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl92:
                // 1 sources

                break;
lbl93:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl109
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.cos(ix));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.cos(ix));
                        ++j;
                    }
lbl109:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl110:
                // 1 sources

                break;
            }
            case 200: {
                oai16data = ((CompoundShortDataset)result).getData();
                if (is != 1) ** GOTO lbl124
                if (!it.isOutputDouble()) ** GOTO lbl122
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.cos(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.cos(ix));
lbl122:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl123:
                // 1 sources

                break;
lbl124:
                // 1 sources

                if (as != 1) ** GOTO lbl145
                if (!it.isOutputDouble()) ** GOTO lbl143
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (short)Maths.toLong(Math.cos(ix));
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (short)Maths.toLong(Math.cos(ix));
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl143:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl144:
                // 1 sources

                break;
lbl145:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl161
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.cos(ix));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.cos(ix));
                        ++j;
                    }
lbl161:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl162:
                // 1 sources

                break;
            }
            case 400: {
                oai64data = ((CompoundLongDataset)result).getData();
                if (is != 1) ** GOTO lbl176
                if (!it.isOutputDouble()) ** GOTO lbl174
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.cos(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.cos(ix));
lbl174:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl175:
                // 1 sources

                break;
lbl176:
                // 1 sources

                if (as != 1) ** GOTO lbl197
                if (!it.isOutputDouble()) ** GOTO lbl195
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = Maths.toLong(Math.cos(ix));
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = Maths.toLong(Math.cos(ix));
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl195:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl196:
                // 1 sources

                break;
lbl197:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl213
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.cos(ix));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.cos(ix));
                        ++j;
                    }
lbl213:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl214:
                // 1 sources

                break;
            }
            case 300: {
                oai32data = ((CompoundIntegerDataset)result).getData();
                if (is != 1) ** GOTO lbl228
                if (!it.isOutputDouble()) ** GOTO lbl226
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.cos(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.cos(ix));
lbl226:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl227:
                // 1 sources

                break;
lbl228:
                // 1 sources

                if (as != 1) ** GOTO lbl249
                if (!it.isOutputDouble()) ** GOTO lbl247
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (int)Maths.toLong(Math.cos(ix));
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (int)Maths.toLong(Math.cos(ix));
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl247:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl248:
                // 1 sources

                break;
lbl249:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl265
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.cos(ix));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.cos(ix));
                        ++j;
                    }
lbl265:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl266:
                // 1 sources

                break;
            }
            case 5: {
                of32data = ((FloatDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl277
                while (it.hasNext()) {
                    ix = it.aDouble;
                    of32data[it.oIndex] = ox = (float)Math.cos(ix);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    of32data[it.oIndex] = ox = (float)Math.cos(ix);
lbl277:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl278:
                // 1 sources

                break;
            }
            case 6: {
                of64data = ((DoubleDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl289
                while (it.hasNext()) {
                    ix = it.aDouble;
                    of64data[it.oIndex] = ox = Math.cos(ix);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    of64data[it.oIndex] = ox = Math.cos(ix);
lbl289:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl290:
                // 1 sources

                break;
            }
            case 500: {
                oaf32data = ((CompoundFloatDataset)result).getData();
                if (is != 1) ** GOTO lbl304
                if (!it.isOutputDouble()) ** GOTO lbl302
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oaf32data[it.oIndex] = ox = (float)Math.cos(ix);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oaf32data[it.oIndex] = ox = (float)Math.cos(ix);
lbl302:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl303:
                // 1 sources

                break;
lbl304:
                // 1 sources

                if (as != 1) ** GOTO lbl325
                if (!it.isOutputDouble()) ** GOTO lbl323
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (float)Math.cos(ix);
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (float)Math.cos(ix);
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl323:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl324:
                // 1 sources

                break;
lbl325:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl341
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.cos(ix);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.cos(ix);
                        ++j;
                    }
lbl341:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl342:
                // 1 sources

                break;
            }
            case 600: {
                oaf64data = ((CompoundDoubleDataset)result).getData();
                if (is != 1) ** GOTO lbl356
                if (!it.isOutputDouble()) ** GOTO lbl354
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oaf64data[it.oIndex] = ox = Math.cos(ix);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oaf64data[it.oIndex] = ox = Math.cos(ix);
lbl354:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl355:
                // 1 sources

                break;
lbl356:
                // 1 sources

                if (as != 1) ** GOTO lbl377
                if (!it.isOutputDouble()) ** GOTO lbl375
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = Math.cos(ix);
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = Math.cos(ix);
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl375:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl376:
                // 1 sources

                break;
lbl377:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl393
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = Math.cos(ix);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = Math.cos(ix);
                        ++j;
                    }
lbl393:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl394:
                // 1 sources

                break;
            }
            case 7: {
                oc64data = ((ComplexFloatDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl423
                if (it.isOutputDouble()) {
                    iy = 0.0;
                    while (it.hasNext()) {
                        ix = it.aDouble;
                        ox = (float)(Math.cos(ix) * Math.cosh(0.0));
                        oy = (float)(-Math.sin(ix) * Math.sinh(0.0));
                        oc64data[it.oIndex] = ox;
                        oc64data[it.oIndex + 1] = oy;
                    }
                } else {
                    iy = 0L;
                    while (it.hasNext()) {
                        ix = it.aLong;
                        ox = Maths.toLong(Math.cos(ix) * Math.cosh(0.0));
                        oy = Maths.toLong(-Math.sin(ix) * Math.sinh(0.0));
                        oc64data[it.oIndex] = ox;
                        oc64data[it.oIndex + 1] = oy;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aDouble;
                    iy = da.getElementDoubleAbs(it.aIndex + 1);
                    ox = (float)(Math.cos(ix) * Math.cosh(iy));
                    oy = (float)(-Math.sin(ix) * Math.sinh(iy));
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
lbl423:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl424:
                // 1 sources

                break;
            }
            case 8: {
                oc128data = ((ComplexDoubleDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl453
                if (it.isOutputDouble()) {
                    iy = 0.0;
                    while (it.hasNext()) {
                        ix = it.aDouble;
                        ox = Math.cos(ix) * Math.cosh(0.0);
                        oy = -Math.sin(ix) * Math.sinh(0.0);
                        oc128data[it.oIndex] = ox;
                        oc128data[it.oIndex + 1] = oy;
                    }
                } else {
                    iy = 0L;
                    while (it.hasNext()) {
                        ix = it.aLong;
                        ox = Math.cos(ix) * Math.cosh(0.0);
                        oy = -Math.sin(ix) * Math.sinh(0.0);
                        oc128data[it.oIndex] = ox;
                        oc128data[it.oIndex + 1] = oy;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aDouble;
                    iy = da.getElementDoubleAbs(it.aIndex + 1);
                    ox = Math.cos(ix) * Math.cosh(iy);
                    oy = -Math.sin(ix) * Math.sinh(iy);
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
lbl453:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl454:
                // 1 sources

                break;
            }
            default: {
                throw new IllegalArgumentException("cos supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        Maths.addFunctionName(result, "cos");
        return result;
    }

    public static Dataset tan(Object a) {
        return Maths.tan(a, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset tan(Object a, Dataset o) {
        da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        it = new SingleInputBroadcastIterator(da, o, true);
        result = it.getOutput();
        if (!result.isComplex() && da.isComplex()) {
            da = da.getRealView();
            it = new SingleInputBroadcastIterator(da, result, true);
        }
        is = result.getElementsPerItem();
        as = da.getElementsPerItem();
        dt = result.getDType();
        switch (dt) {
            case 1: {
                oi8data = ((ByteDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl21
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi8data[it.oIndex] = ox = (byte)Maths.toLong(Math.tan(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi8data[it.oIndex] = ox = (byte)Maths.toLong(Math.tan(ix));
lbl21:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl22:
                // 1 sources

                break;
            }
            case 2: {
                oi16data = ((ShortDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl33
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi16data[it.oIndex] = ox = (short)Maths.toLong(Math.tan(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi16data[it.oIndex] = ox = (short)Maths.toLong(Math.tan(ix));
lbl33:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl34:
                // 1 sources

                break;
            }
            case 4: {
                oi64data = ((LongDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl45
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi64data[it.oIndex] = ox = Maths.toLong(Math.tan(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi64data[it.oIndex] = ox = Maths.toLong(Math.tan(ix));
lbl45:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl46:
                // 1 sources

                break;
            }
            case 3: {
                oi32data = ((IntegerDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl57
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi32data[it.oIndex] = ox = (int)Maths.toLong(Math.tan(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi32data[it.oIndex] = ox = (int)Maths.toLong(Math.tan(ix));
lbl57:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl58:
                // 1 sources

                break;
            }
            case 100: {
                oai8data = ((CompoundByteDataset)result).getData();
                if (is != 1) ** GOTO lbl72
                if (!it.isOutputDouble()) ** GOTO lbl70
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.tan(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.tan(ix));
lbl70:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl71:
                // 1 sources

                break;
lbl72:
                // 1 sources

                if (as != 1) ** GOTO lbl93
                if (!it.isOutputDouble()) ** GOTO lbl91
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (byte)Maths.toLong(Math.tan(ix));
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (byte)Maths.toLong(Math.tan(ix));
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl91:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl92:
                // 1 sources

                break;
lbl93:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl109
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.tan(ix));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.tan(ix));
                        ++j;
                    }
lbl109:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl110:
                // 1 sources

                break;
            }
            case 200: {
                oai16data = ((CompoundShortDataset)result).getData();
                if (is != 1) ** GOTO lbl124
                if (!it.isOutputDouble()) ** GOTO lbl122
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.tan(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.tan(ix));
lbl122:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl123:
                // 1 sources

                break;
lbl124:
                // 1 sources

                if (as != 1) ** GOTO lbl145
                if (!it.isOutputDouble()) ** GOTO lbl143
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (short)Maths.toLong(Math.tan(ix));
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (short)Maths.toLong(Math.tan(ix));
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl143:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl144:
                // 1 sources

                break;
lbl145:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl161
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.tan(ix));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.tan(ix));
                        ++j;
                    }
lbl161:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl162:
                // 1 sources

                break;
            }
            case 400: {
                oai64data = ((CompoundLongDataset)result).getData();
                if (is != 1) ** GOTO lbl176
                if (!it.isOutputDouble()) ** GOTO lbl174
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.tan(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.tan(ix));
lbl174:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl175:
                // 1 sources

                break;
lbl176:
                // 1 sources

                if (as != 1) ** GOTO lbl197
                if (!it.isOutputDouble()) ** GOTO lbl195
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = Maths.toLong(Math.tan(ix));
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = Maths.toLong(Math.tan(ix));
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl195:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl196:
                // 1 sources

                break;
lbl197:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl213
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.tan(ix));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.tan(ix));
                        ++j;
                    }
lbl213:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl214:
                // 1 sources

                break;
            }
            case 300: {
                oai32data = ((CompoundIntegerDataset)result).getData();
                if (is != 1) ** GOTO lbl228
                if (!it.isOutputDouble()) ** GOTO lbl226
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.tan(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.tan(ix));
lbl226:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl227:
                // 1 sources

                break;
lbl228:
                // 1 sources

                if (as != 1) ** GOTO lbl249
                if (!it.isOutputDouble()) ** GOTO lbl247
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (int)Maths.toLong(Math.tan(ix));
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (int)Maths.toLong(Math.tan(ix));
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl247:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl248:
                // 1 sources

                break;
lbl249:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl265
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.tan(ix));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.tan(ix));
                        ++j;
                    }
lbl265:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl266:
                // 1 sources

                break;
            }
            case 5: {
                of32data = ((FloatDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl277
                while (it.hasNext()) {
                    ix = it.aDouble;
                    of32data[it.oIndex] = ox = (float)Math.tan(ix);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    of32data[it.oIndex] = ox = (float)Math.tan(ix);
lbl277:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl278:
                // 1 sources

                break;
            }
            case 6: {
                of64data = ((DoubleDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl289
                while (it.hasNext()) {
                    ix = it.aDouble;
                    of64data[it.oIndex] = ox = Math.tan(ix);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    of64data[it.oIndex] = ox = Math.tan(ix);
lbl289:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl290:
                // 1 sources

                break;
            }
            case 500: {
                oaf32data = ((CompoundFloatDataset)result).getData();
                if (is != 1) ** GOTO lbl304
                if (!it.isOutputDouble()) ** GOTO lbl302
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oaf32data[it.oIndex] = ox = (float)Math.tan(ix);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oaf32data[it.oIndex] = ox = (float)Math.tan(ix);
lbl302:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl303:
                // 1 sources

                break;
lbl304:
                // 1 sources

                if (as != 1) ** GOTO lbl325
                if (!it.isOutputDouble()) ** GOTO lbl323
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (float)Math.tan(ix);
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (float)Math.tan(ix);
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl323:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl324:
                // 1 sources

                break;
lbl325:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl341
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.tan(ix);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.tan(ix);
                        ++j;
                    }
lbl341:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl342:
                // 1 sources

                break;
            }
            case 600: {
                oaf64data = ((CompoundDoubleDataset)result).getData();
                if (is != 1) ** GOTO lbl356
                if (!it.isOutputDouble()) ** GOTO lbl354
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oaf64data[it.oIndex] = ox = Math.tan(ix);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oaf64data[it.oIndex] = ox = Math.tan(ix);
lbl354:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl355:
                // 1 sources

                break;
lbl356:
                // 1 sources

                if (as != 1) ** GOTO lbl377
                if (!it.isOutputDouble()) ** GOTO lbl375
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = Math.tan(ix);
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = Math.tan(ix);
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl375:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl376:
                // 1 sources

                break;
lbl377:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl393
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = Math.tan(ix);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = Math.tan(ix);
                        ++j;
                    }
lbl393:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl394:
                // 1 sources

                break;
            }
            case 7: {
                oc64data = ((ComplexFloatDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl432
                if (it.isOutputDouble()) {
                    iy = 0.0;
                    while (it.hasNext()) {
                        ix = it.aDouble;
                        x = (float)(2.0 * ix);
                        y = 0.0f;
                        tf = (float)(1.0 / (Math.cos(x) + Math.cosh(y)));
                        ox = (float)((double)tf * Math.sin(x));
                        oy = (float)((double)tf * Math.sinh(y));
                        oc64data[it.oIndex] = ox;
                        oc64data[it.oIndex + 1] = oy;
                    }
                } else {
                    iy = 0L;
                    while (it.hasNext()) {
                        ix = it.aLong;
                        x = Maths.toLong(2.0 * (double)ix);
                        y = Maths.toLong(0.0);
                        tf = Maths.toLong(1.0 / (Math.cos(x) + Math.cosh(y)));
                        ox = Maths.toLong((double)tf * Math.sin(x));
                        oy = Maths.toLong((double)tf * Math.sinh(y));
                        oc64data[it.oIndex] = ox;
                        oc64data[it.oIndex + 1] = oy;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aDouble;
                    iy = da.getElementDoubleAbs(it.aIndex + 1);
                    x = (float)(2.0 * ix);
                    y = (float)(2.0 * iy);
                    tf = (float)(1.0 / (Math.cos(x) + Math.cosh(y)));
                    ox = (float)((double)tf * Math.sin(x));
                    oy = (float)((double)tf * Math.sinh(y));
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
lbl432:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl433:
                // 1 sources

                break;
            }
            case 8: {
                oc128data = ((ComplexDoubleDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl471
                if (it.isOutputDouble()) {
                    iy = 0.0;
                    while (it.hasNext()) {
                        ix = it.aDouble;
                        x = 2.0 * ix;
                        y = 0.0;
                        tf = 1.0 / (Math.cos(x) + Math.cosh(y));
                        ox = tf * Math.sin(x);
                        oy = tf * Math.sinh(y);
                        oc128data[it.oIndex] = ox;
                        oc128data[it.oIndex + 1] = oy;
                    }
                } else {
                    iy = 0L;
                    while (it.hasNext()) {
                        ix = it.aLong;
                        x = 2.0 * (double)ix;
                        y = 0.0;
                        tf = 1.0 / (Math.cos(x) + Math.cosh(y));
                        ox = tf * Math.sin(x);
                        oy = tf * Math.sinh(y);
                        oc128data[it.oIndex] = ox;
                        oc128data[it.oIndex + 1] = oy;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aDouble;
                    iy = da.getElementDoubleAbs(it.aIndex + 1);
                    x = 2.0 * ix;
                    y = 2.0 * iy;
                    tf = 1.0 / (Math.cos(x) + Math.cosh(y));
                    ox = tf * Math.sin(x);
                    oy = tf * Math.sinh(y);
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
lbl471:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl472:
                // 1 sources

                break;
            }
            default: {
                throw new IllegalArgumentException("tan supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        Maths.addFunctionName(result, "tan");
        return result;
    }

    public static Dataset arcsin(Object a) {
        return Maths.arcsin(a, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset arcsin(Object a, Dataset o) {
        da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        it = new SingleInputBroadcastIterator(da, o, true);
        result = it.getOutput();
        if (!result.isComplex() && da.isComplex()) {
            da = da.getRealView();
            it = new SingleInputBroadcastIterator(da, result, true);
        }
        is = result.getElementsPerItem();
        as = da.getElementsPerItem();
        dt = result.getDType();
        switch (dt) {
            case 1: {
                oi8data = ((ByteDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl21
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi8data[it.oIndex] = ox = (byte)Maths.toLong(Math.asin(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi8data[it.oIndex] = ox = (byte)Maths.toLong(Math.asin(ix));
lbl21:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl22:
                // 1 sources

                break;
            }
            case 2: {
                oi16data = ((ShortDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl33
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi16data[it.oIndex] = ox = (short)Maths.toLong(Math.asin(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi16data[it.oIndex] = ox = (short)Maths.toLong(Math.asin(ix));
lbl33:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl34:
                // 1 sources

                break;
            }
            case 4: {
                oi64data = ((LongDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl45
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi64data[it.oIndex] = ox = Maths.toLong(Math.asin(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi64data[it.oIndex] = ox = Maths.toLong(Math.asin(ix));
lbl45:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl46:
                // 1 sources

                break;
            }
            case 3: {
                oi32data = ((IntegerDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl57
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi32data[it.oIndex] = ox = (int)Maths.toLong(Math.asin(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi32data[it.oIndex] = ox = (int)Maths.toLong(Math.asin(ix));
lbl57:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl58:
                // 1 sources

                break;
            }
            case 100: {
                oai8data = ((CompoundByteDataset)result).getData();
                if (is != 1) ** GOTO lbl72
                if (!it.isOutputDouble()) ** GOTO lbl70
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.asin(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.asin(ix));
lbl70:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl71:
                // 1 sources

                break;
lbl72:
                // 1 sources

                if (as != 1) ** GOTO lbl93
                if (!it.isOutputDouble()) ** GOTO lbl91
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (byte)Maths.toLong(Math.asin(ix));
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (byte)Maths.toLong(Math.asin(ix));
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl91:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl92:
                // 1 sources

                break;
lbl93:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl109
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.asin(ix));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.asin(ix));
                        ++j;
                    }
lbl109:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl110:
                // 1 sources

                break;
            }
            case 200: {
                oai16data = ((CompoundShortDataset)result).getData();
                if (is != 1) ** GOTO lbl124
                if (!it.isOutputDouble()) ** GOTO lbl122
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.asin(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.asin(ix));
lbl122:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl123:
                // 1 sources

                break;
lbl124:
                // 1 sources

                if (as != 1) ** GOTO lbl145
                if (!it.isOutputDouble()) ** GOTO lbl143
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (short)Maths.toLong(Math.asin(ix));
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (short)Maths.toLong(Math.asin(ix));
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl143:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl144:
                // 1 sources

                break;
lbl145:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl161
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.asin(ix));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.asin(ix));
                        ++j;
                    }
lbl161:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl162:
                // 1 sources

                break;
            }
            case 400: {
                oai64data = ((CompoundLongDataset)result).getData();
                if (is != 1) ** GOTO lbl176
                if (!it.isOutputDouble()) ** GOTO lbl174
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.asin(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.asin(ix));
lbl174:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl175:
                // 1 sources

                break;
lbl176:
                // 1 sources

                if (as != 1) ** GOTO lbl197
                if (!it.isOutputDouble()) ** GOTO lbl195
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = Maths.toLong(Math.asin(ix));
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = Maths.toLong(Math.asin(ix));
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl195:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl196:
                // 1 sources

                break;
lbl197:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl213
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.asin(ix));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.asin(ix));
                        ++j;
                    }
lbl213:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl214:
                // 1 sources

                break;
            }
            case 300: {
                oai32data = ((CompoundIntegerDataset)result).getData();
                if (is != 1) ** GOTO lbl228
                if (!it.isOutputDouble()) ** GOTO lbl226
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.asin(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.asin(ix));
lbl226:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl227:
                // 1 sources

                break;
lbl228:
                // 1 sources

                if (as != 1) ** GOTO lbl249
                if (!it.isOutputDouble()) ** GOTO lbl247
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (int)Maths.toLong(Math.asin(ix));
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (int)Maths.toLong(Math.asin(ix));
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl247:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl248:
                // 1 sources

                break;
lbl249:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl265
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.asin(ix));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.asin(ix));
                        ++j;
                    }
lbl265:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl266:
                // 1 sources

                break;
            }
            case 5: {
                of32data = ((FloatDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl277
                while (it.hasNext()) {
                    ix = it.aDouble;
                    of32data[it.oIndex] = ox = (float)Math.asin(ix);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    of32data[it.oIndex] = ox = (float)Math.asin(ix);
lbl277:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl278:
                // 1 sources

                break;
            }
            case 6: {
                of64data = ((DoubleDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl289
                while (it.hasNext()) {
                    ix = it.aDouble;
                    of64data[it.oIndex] = ox = Math.asin(ix);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    of64data[it.oIndex] = ox = Math.asin(ix);
lbl289:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl290:
                // 1 sources

                break;
            }
            case 500: {
                oaf32data = ((CompoundFloatDataset)result).getData();
                if (is != 1) ** GOTO lbl304
                if (!it.isOutputDouble()) ** GOTO lbl302
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oaf32data[it.oIndex] = ox = (float)Math.asin(ix);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oaf32data[it.oIndex] = ox = (float)Math.asin(ix);
lbl302:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl303:
                // 1 sources

                break;
lbl304:
                // 1 sources

                if (as != 1) ** GOTO lbl325
                if (!it.isOutputDouble()) ** GOTO lbl323
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (float)Math.asin(ix);
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (float)Math.asin(ix);
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl323:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl324:
                // 1 sources

                break;
lbl325:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl341
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.asin(ix);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.asin(ix);
                        ++j;
                    }
lbl341:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl342:
                // 1 sources

                break;
            }
            case 600: {
                oaf64data = ((CompoundDoubleDataset)result).getData();
                if (is != 1) ** GOTO lbl356
                if (!it.isOutputDouble()) ** GOTO lbl354
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oaf64data[it.oIndex] = ox = Math.asin(ix);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oaf64data[it.oIndex] = ox = Math.asin(ix);
lbl354:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl355:
                // 1 sources

                break;
lbl356:
                // 1 sources

                if (as != 1) ** GOTO lbl377
                if (!it.isOutputDouble()) ** GOTO lbl375
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = Math.asin(ix);
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = Math.asin(ix);
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl375:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl376:
                // 1 sources

                break;
lbl377:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl393
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = Math.asin(ix);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = Math.asin(ix);
                        ++j;
                    }
lbl393:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl394:
                // 1 sources

                break;
            }
            case 7: {
                oc64data = ((ComplexFloatDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl426
                if (it.isOutputDouble()) {
                    iy = 0.0;
                    while (it.hasNext()) {
                        ix = it.aDouble;
                        tz = new Complex(ix, 0.0).asin();
                        ox = (float)tz.getReal();
                        oy = (float)tz.getImaginary();
                        oc64data[it.oIndex] = ox;
                        oc64data[it.oIndex + 1] = oy;
                    }
                } else {
                    iy = 0L;
                    while (it.hasNext()) {
                        ix = it.aLong;
                        tz = new Complex((double)ix, 0.0).asin();
                        ox = Maths.toLong(tz.getReal());
                        oy = Maths.toLong(tz.getImaginary());
                        oc64data[it.oIndex] = ox;
                        oc64data[it.oIndex + 1] = oy;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aDouble;
                    iy = da.getElementDoubleAbs(it.aIndex + 1);
                    tz = new Complex(ix, iy).asin();
                    ox = (float)tz.getReal();
                    oy = (float)tz.getImaginary();
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
lbl426:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl427:
                // 1 sources

                break;
            }
            case 8: {
                oc128data = ((ComplexDoubleDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl459
                if (it.isOutputDouble()) {
                    iy = 0.0;
                    while (it.hasNext()) {
                        ix = it.aDouble;
                        tz = new Complex(ix, 0.0).asin();
                        ox = tz.getReal();
                        oy = tz.getImaginary();
                        oc128data[it.oIndex] = ox;
                        oc128data[it.oIndex + 1] = oy;
                    }
                } else {
                    iy = 0L;
                    while (it.hasNext()) {
                        ix = it.aLong;
                        tz = new Complex((double)ix, 0.0).asin();
                        ox = tz.getReal();
                        oy = tz.getImaginary();
                        oc128data[it.oIndex] = ox;
                        oc128data[it.oIndex + 1] = oy;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aDouble;
                    iy = da.getElementDoubleAbs(it.aIndex + 1);
                    tz = new Complex(ix, iy).asin();
                    ox = tz.getReal();
                    oy = tz.getImaginary();
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
lbl459:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl460:
                // 1 sources

                break;
            }
            default: {
                throw new IllegalArgumentException("arcsin supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        Maths.addFunctionName(result, "arcsin");
        return result;
    }

    public static Dataset arccos(Object a) {
        return Maths.arccos(a, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset arccos(Object a, Dataset o) {
        da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        it = new SingleInputBroadcastIterator(da, o, true);
        result = it.getOutput();
        if (!result.isComplex() && da.isComplex()) {
            da = da.getRealView();
            it = new SingleInputBroadcastIterator(da, result, true);
        }
        is = result.getElementsPerItem();
        as = da.getElementsPerItem();
        dt = result.getDType();
        switch (dt) {
            case 1: {
                oi8data = ((ByteDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl21
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi8data[it.oIndex] = ox = (byte)Maths.toLong(Math.acos(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi8data[it.oIndex] = ox = (byte)Maths.toLong(Math.acos(ix));
lbl21:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl22:
                // 1 sources

                break;
            }
            case 2: {
                oi16data = ((ShortDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl33
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi16data[it.oIndex] = ox = (short)Maths.toLong(Math.acos(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi16data[it.oIndex] = ox = (short)Maths.toLong(Math.acos(ix));
lbl33:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl34:
                // 1 sources

                break;
            }
            case 4: {
                oi64data = ((LongDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl45
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi64data[it.oIndex] = ox = Maths.toLong(Math.acos(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi64data[it.oIndex] = ox = Maths.toLong(Math.acos(ix));
lbl45:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl46:
                // 1 sources

                break;
            }
            case 3: {
                oi32data = ((IntegerDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl57
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi32data[it.oIndex] = ox = (int)Maths.toLong(Math.acos(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi32data[it.oIndex] = ox = (int)Maths.toLong(Math.acos(ix));
lbl57:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl58:
                // 1 sources

                break;
            }
            case 100: {
                oai8data = ((CompoundByteDataset)result).getData();
                if (is != 1) ** GOTO lbl72
                if (!it.isOutputDouble()) ** GOTO lbl70
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.acos(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.acos(ix));
lbl70:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl71:
                // 1 sources

                break;
lbl72:
                // 1 sources

                if (as != 1) ** GOTO lbl93
                if (!it.isOutputDouble()) ** GOTO lbl91
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (byte)Maths.toLong(Math.acos(ix));
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (byte)Maths.toLong(Math.acos(ix));
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl91:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl92:
                // 1 sources

                break;
lbl93:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl109
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.acos(ix));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.acos(ix));
                        ++j;
                    }
lbl109:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl110:
                // 1 sources

                break;
            }
            case 200: {
                oai16data = ((CompoundShortDataset)result).getData();
                if (is != 1) ** GOTO lbl124
                if (!it.isOutputDouble()) ** GOTO lbl122
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.acos(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.acos(ix));
lbl122:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl123:
                // 1 sources

                break;
lbl124:
                // 1 sources

                if (as != 1) ** GOTO lbl145
                if (!it.isOutputDouble()) ** GOTO lbl143
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (short)Maths.toLong(Math.acos(ix));
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (short)Maths.toLong(Math.acos(ix));
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl143:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl144:
                // 1 sources

                break;
lbl145:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl161
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.acos(ix));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.acos(ix));
                        ++j;
                    }
lbl161:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl162:
                // 1 sources

                break;
            }
            case 400: {
                oai64data = ((CompoundLongDataset)result).getData();
                if (is != 1) ** GOTO lbl176
                if (!it.isOutputDouble()) ** GOTO lbl174
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.acos(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.acos(ix));
lbl174:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl175:
                // 1 sources

                break;
lbl176:
                // 1 sources

                if (as != 1) ** GOTO lbl197
                if (!it.isOutputDouble()) ** GOTO lbl195
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = Maths.toLong(Math.acos(ix));
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = Maths.toLong(Math.acos(ix));
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl195:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl196:
                // 1 sources

                break;
lbl197:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl213
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.acos(ix));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.acos(ix));
                        ++j;
                    }
lbl213:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl214:
                // 1 sources

                break;
            }
            case 300: {
                oai32data = ((CompoundIntegerDataset)result).getData();
                if (is != 1) ** GOTO lbl228
                if (!it.isOutputDouble()) ** GOTO lbl226
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.acos(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.acos(ix));
lbl226:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl227:
                // 1 sources

                break;
lbl228:
                // 1 sources

                if (as != 1) ** GOTO lbl249
                if (!it.isOutputDouble()) ** GOTO lbl247
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (int)Maths.toLong(Math.acos(ix));
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (int)Maths.toLong(Math.acos(ix));
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl247:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl248:
                // 1 sources

                break;
lbl249:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl265
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.acos(ix));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.acos(ix));
                        ++j;
                    }
lbl265:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl266:
                // 1 sources

                break;
            }
            case 5: {
                of32data = ((FloatDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl277
                while (it.hasNext()) {
                    ix = it.aDouble;
                    of32data[it.oIndex] = ox = (float)Math.acos(ix);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    of32data[it.oIndex] = ox = (float)Math.acos(ix);
lbl277:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl278:
                // 1 sources

                break;
            }
            case 6: {
                of64data = ((DoubleDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl289
                while (it.hasNext()) {
                    ix = it.aDouble;
                    of64data[it.oIndex] = ox = Math.acos(ix);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    of64data[it.oIndex] = ox = Math.acos(ix);
lbl289:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl290:
                // 1 sources

                break;
            }
            case 500: {
                oaf32data = ((CompoundFloatDataset)result).getData();
                if (is != 1) ** GOTO lbl304
                if (!it.isOutputDouble()) ** GOTO lbl302
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oaf32data[it.oIndex] = ox = (float)Math.acos(ix);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oaf32data[it.oIndex] = ox = (float)Math.acos(ix);
lbl302:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl303:
                // 1 sources

                break;
lbl304:
                // 1 sources

                if (as != 1) ** GOTO lbl325
                if (!it.isOutputDouble()) ** GOTO lbl323
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (float)Math.acos(ix);
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (float)Math.acos(ix);
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl323:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl324:
                // 1 sources

                break;
lbl325:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl341
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.acos(ix);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.acos(ix);
                        ++j;
                    }
lbl341:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl342:
                // 1 sources

                break;
            }
            case 600: {
                oaf64data = ((CompoundDoubleDataset)result).getData();
                if (is != 1) ** GOTO lbl356
                if (!it.isOutputDouble()) ** GOTO lbl354
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oaf64data[it.oIndex] = ox = Math.acos(ix);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oaf64data[it.oIndex] = ox = Math.acos(ix);
lbl354:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl355:
                // 1 sources

                break;
lbl356:
                // 1 sources

                if (as != 1) ** GOTO lbl377
                if (!it.isOutputDouble()) ** GOTO lbl375
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = Math.acos(ix);
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = Math.acos(ix);
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl375:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl376:
                // 1 sources

                break;
lbl377:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl393
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = Math.acos(ix);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = Math.acos(ix);
                        ++j;
                    }
lbl393:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl394:
                // 1 sources

                break;
            }
            case 7: {
                oc64data = ((ComplexFloatDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl426
                if (it.isOutputDouble()) {
                    iy = 0.0;
                    while (it.hasNext()) {
                        ix = it.aDouble;
                        tz = new Complex(ix, 0.0).acos();
                        ox = (float)tz.getReal();
                        oy = (float)tz.getImaginary();
                        oc64data[it.oIndex] = ox;
                        oc64data[it.oIndex + 1] = oy;
                    }
                } else {
                    iy = 0L;
                    while (it.hasNext()) {
                        ix = it.aLong;
                        tz = new Complex((double)ix, 0.0).acos();
                        ox = Maths.toLong(tz.getReal());
                        oy = Maths.toLong(tz.getImaginary());
                        oc64data[it.oIndex] = ox;
                        oc64data[it.oIndex + 1] = oy;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aDouble;
                    iy = da.getElementDoubleAbs(it.aIndex + 1);
                    tz = new Complex(ix, iy).acos();
                    ox = (float)tz.getReal();
                    oy = (float)tz.getImaginary();
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
lbl426:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl427:
                // 1 sources

                break;
            }
            case 8: {
                oc128data = ((ComplexDoubleDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl459
                if (it.isOutputDouble()) {
                    iy = 0.0;
                    while (it.hasNext()) {
                        ix = it.aDouble;
                        tz = new Complex(ix, 0.0).acos();
                        ox = tz.getReal();
                        oy = tz.getImaginary();
                        oc128data[it.oIndex] = ox;
                        oc128data[it.oIndex + 1] = oy;
                    }
                } else {
                    iy = 0L;
                    while (it.hasNext()) {
                        ix = it.aLong;
                        tz = new Complex((double)ix, 0.0).acos();
                        ox = tz.getReal();
                        oy = tz.getImaginary();
                        oc128data[it.oIndex] = ox;
                        oc128data[it.oIndex + 1] = oy;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aDouble;
                    iy = da.getElementDoubleAbs(it.aIndex + 1);
                    tz = new Complex(ix, iy).acos();
                    ox = tz.getReal();
                    oy = tz.getImaginary();
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
lbl459:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl460:
                // 1 sources

                break;
            }
            default: {
                throw new IllegalArgumentException("arccos supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        Maths.addFunctionName(result, "arccos");
        return result;
    }

    public static Dataset arctan(Object a) {
        return Maths.arctan(a, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset arctan(Object a, Dataset o) {
        da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        it = new SingleInputBroadcastIterator(da, o, true);
        result = it.getOutput();
        if (!result.isComplex() && da.isComplex()) {
            da = da.getRealView();
            it = new SingleInputBroadcastIterator(da, result, true);
        }
        is = result.getElementsPerItem();
        as = da.getElementsPerItem();
        dt = result.getDType();
        switch (dt) {
            case 1: {
                oi8data = ((ByteDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl21
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi8data[it.oIndex] = ox = (byte)Maths.toLong(Math.atan(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi8data[it.oIndex] = ox = (byte)Maths.toLong(Math.atan(ix));
lbl21:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl22:
                // 1 sources

                break;
            }
            case 2: {
                oi16data = ((ShortDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl33
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi16data[it.oIndex] = ox = (short)Maths.toLong(Math.atan(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi16data[it.oIndex] = ox = (short)Maths.toLong(Math.atan(ix));
lbl33:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl34:
                // 1 sources

                break;
            }
            case 4: {
                oi64data = ((LongDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl45
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi64data[it.oIndex] = ox = Maths.toLong(Math.atan(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi64data[it.oIndex] = ox = Maths.toLong(Math.atan(ix));
lbl45:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl46:
                // 1 sources

                break;
            }
            case 3: {
                oi32data = ((IntegerDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl57
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi32data[it.oIndex] = ox = (int)Maths.toLong(Math.atan(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi32data[it.oIndex] = ox = (int)Maths.toLong(Math.atan(ix));
lbl57:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl58:
                // 1 sources

                break;
            }
            case 100: {
                oai8data = ((CompoundByteDataset)result).getData();
                if (is != 1) ** GOTO lbl72
                if (!it.isOutputDouble()) ** GOTO lbl70
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.atan(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.atan(ix));
lbl70:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl71:
                // 1 sources

                break;
lbl72:
                // 1 sources

                if (as != 1) ** GOTO lbl93
                if (!it.isOutputDouble()) ** GOTO lbl91
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (byte)Maths.toLong(Math.atan(ix));
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (byte)Maths.toLong(Math.atan(ix));
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl91:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl92:
                // 1 sources

                break;
lbl93:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl109
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.atan(ix));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.atan(ix));
                        ++j;
                    }
lbl109:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl110:
                // 1 sources

                break;
            }
            case 200: {
                oai16data = ((CompoundShortDataset)result).getData();
                if (is != 1) ** GOTO lbl124
                if (!it.isOutputDouble()) ** GOTO lbl122
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.atan(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.atan(ix));
lbl122:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl123:
                // 1 sources

                break;
lbl124:
                // 1 sources

                if (as != 1) ** GOTO lbl145
                if (!it.isOutputDouble()) ** GOTO lbl143
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (short)Maths.toLong(Math.atan(ix));
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (short)Maths.toLong(Math.atan(ix));
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl143:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl144:
                // 1 sources

                break;
lbl145:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl161
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.atan(ix));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.atan(ix));
                        ++j;
                    }
lbl161:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl162:
                // 1 sources

                break;
            }
            case 400: {
                oai64data = ((CompoundLongDataset)result).getData();
                if (is != 1) ** GOTO lbl176
                if (!it.isOutputDouble()) ** GOTO lbl174
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.atan(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.atan(ix));
lbl174:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl175:
                // 1 sources

                break;
lbl176:
                // 1 sources

                if (as != 1) ** GOTO lbl197
                if (!it.isOutputDouble()) ** GOTO lbl195
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = Maths.toLong(Math.atan(ix));
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = Maths.toLong(Math.atan(ix));
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl195:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl196:
                // 1 sources

                break;
lbl197:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl213
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.atan(ix));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.atan(ix));
                        ++j;
                    }
lbl213:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl214:
                // 1 sources

                break;
            }
            case 300: {
                oai32data = ((CompoundIntegerDataset)result).getData();
                if (is != 1) ** GOTO lbl228
                if (!it.isOutputDouble()) ** GOTO lbl226
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.atan(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.atan(ix));
lbl226:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl227:
                // 1 sources

                break;
lbl228:
                // 1 sources

                if (as != 1) ** GOTO lbl249
                if (!it.isOutputDouble()) ** GOTO lbl247
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (int)Maths.toLong(Math.atan(ix));
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (int)Maths.toLong(Math.atan(ix));
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl247:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl248:
                // 1 sources

                break;
lbl249:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl265
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.atan(ix));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.atan(ix));
                        ++j;
                    }
lbl265:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl266:
                // 1 sources

                break;
            }
            case 5: {
                of32data = ((FloatDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl277
                while (it.hasNext()) {
                    ix = it.aDouble;
                    of32data[it.oIndex] = ox = (float)Math.atan(ix);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    of32data[it.oIndex] = ox = (float)Math.atan(ix);
lbl277:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl278:
                // 1 sources

                break;
            }
            case 6: {
                of64data = ((DoubleDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl289
                while (it.hasNext()) {
                    ix = it.aDouble;
                    of64data[it.oIndex] = ox = Math.atan(ix);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    of64data[it.oIndex] = ox = Math.atan(ix);
lbl289:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl290:
                // 1 sources

                break;
            }
            case 500: {
                oaf32data = ((CompoundFloatDataset)result).getData();
                if (is != 1) ** GOTO lbl304
                if (!it.isOutputDouble()) ** GOTO lbl302
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oaf32data[it.oIndex] = ox = (float)Math.atan(ix);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oaf32data[it.oIndex] = ox = (float)Math.atan(ix);
lbl302:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl303:
                // 1 sources

                break;
lbl304:
                // 1 sources

                if (as != 1) ** GOTO lbl325
                if (!it.isOutputDouble()) ** GOTO lbl323
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (float)Math.atan(ix);
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (float)Math.atan(ix);
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl323:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl324:
                // 1 sources

                break;
lbl325:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl341
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.atan(ix);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.atan(ix);
                        ++j;
                    }
lbl341:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl342:
                // 1 sources

                break;
            }
            case 600: {
                oaf64data = ((CompoundDoubleDataset)result).getData();
                if (is != 1) ** GOTO lbl356
                if (!it.isOutputDouble()) ** GOTO lbl354
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oaf64data[it.oIndex] = ox = Math.atan(ix);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oaf64data[it.oIndex] = ox = Math.atan(ix);
lbl354:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl355:
                // 1 sources

                break;
lbl356:
                // 1 sources

                if (as != 1) ** GOTO lbl377
                if (!it.isOutputDouble()) ** GOTO lbl375
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = Math.atan(ix);
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = Math.atan(ix);
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl375:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl376:
                // 1 sources

                break;
lbl377:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl393
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = Math.atan(ix);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = Math.atan(ix);
                        ++j;
                    }
lbl393:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl394:
                // 1 sources

                break;
            }
            case 7: {
                oc64data = ((ComplexFloatDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl426
                if (it.isOutputDouble()) {
                    iy = 0.0;
                    while (it.hasNext()) {
                        ix = it.aDouble;
                        tz = new Complex(ix, 0.0).atan();
                        ox = (float)tz.getReal();
                        oy = (float)tz.getImaginary();
                        oc64data[it.oIndex] = ox;
                        oc64data[it.oIndex + 1] = oy;
                    }
                } else {
                    iy = 0L;
                    while (it.hasNext()) {
                        ix = it.aLong;
                        tz = new Complex((double)ix, 0.0).atan();
                        ox = Maths.toLong(tz.getReal());
                        oy = Maths.toLong(tz.getImaginary());
                        oc64data[it.oIndex] = ox;
                        oc64data[it.oIndex + 1] = oy;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aDouble;
                    iy = da.getElementDoubleAbs(it.aIndex + 1);
                    tz = new Complex(ix, iy).atan();
                    ox = (float)tz.getReal();
                    oy = (float)tz.getImaginary();
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
lbl426:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl427:
                // 1 sources

                break;
            }
            case 8: {
                oc128data = ((ComplexDoubleDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl459
                if (it.isOutputDouble()) {
                    iy = 0.0;
                    while (it.hasNext()) {
                        ix = it.aDouble;
                        tz = new Complex(ix, 0.0).atan();
                        ox = tz.getReal();
                        oy = tz.getImaginary();
                        oc128data[it.oIndex] = ox;
                        oc128data[it.oIndex + 1] = oy;
                    }
                } else {
                    iy = 0L;
                    while (it.hasNext()) {
                        ix = it.aLong;
                        tz = new Complex((double)ix, 0.0).atan();
                        ox = tz.getReal();
                        oy = tz.getImaginary();
                        oc128data[it.oIndex] = ox;
                        oc128data[it.oIndex + 1] = oy;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aDouble;
                    iy = da.getElementDoubleAbs(it.aIndex + 1);
                    tz = new Complex(ix, iy).atan();
                    ox = tz.getReal();
                    oy = tz.getImaginary();
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
lbl459:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl460:
                // 1 sources

                break;
            }
            default: {
                throw new IllegalArgumentException("arctan supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        Maths.addFunctionName(result, "arctan");
        return result;
    }

    public static Dataset sinh(Object a) {
        return Maths.sinh(a, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset sinh(Object a, Dataset o) {
        da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        it = new SingleInputBroadcastIterator(da, o, true);
        result = it.getOutput();
        if (!result.isComplex() && da.isComplex()) {
            da = da.getRealView();
            it = new SingleInputBroadcastIterator(da, result, true);
        }
        is = result.getElementsPerItem();
        as = da.getElementsPerItem();
        dt = result.getDType();
        switch (dt) {
            case 1: {
                oi8data = ((ByteDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl21
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi8data[it.oIndex] = ox = (byte)Maths.toLong(Math.sinh(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi8data[it.oIndex] = ox = (byte)Maths.toLong(Math.sinh(ix));
lbl21:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl22:
                // 1 sources

                break;
            }
            case 2: {
                oi16data = ((ShortDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl33
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi16data[it.oIndex] = ox = (short)Maths.toLong(Math.sinh(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi16data[it.oIndex] = ox = (short)Maths.toLong(Math.sinh(ix));
lbl33:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl34:
                // 1 sources

                break;
            }
            case 4: {
                oi64data = ((LongDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl45
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi64data[it.oIndex] = ox = Maths.toLong(Math.sinh(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi64data[it.oIndex] = ox = Maths.toLong(Math.sinh(ix));
lbl45:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl46:
                // 1 sources

                break;
            }
            case 3: {
                oi32data = ((IntegerDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl57
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi32data[it.oIndex] = ox = (int)Maths.toLong(Math.sinh(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi32data[it.oIndex] = ox = (int)Maths.toLong(Math.sinh(ix));
lbl57:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl58:
                // 1 sources

                break;
            }
            case 100: {
                oai8data = ((CompoundByteDataset)result).getData();
                if (is != 1) ** GOTO lbl72
                if (!it.isOutputDouble()) ** GOTO lbl70
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.sinh(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.sinh(ix));
lbl70:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl71:
                // 1 sources

                break;
lbl72:
                // 1 sources

                if (as != 1) ** GOTO lbl93
                if (!it.isOutputDouble()) ** GOTO lbl91
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (byte)Maths.toLong(Math.sinh(ix));
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (byte)Maths.toLong(Math.sinh(ix));
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl91:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl92:
                // 1 sources

                break;
lbl93:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl109
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.sinh(ix));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.sinh(ix));
                        ++j;
                    }
lbl109:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl110:
                // 1 sources

                break;
            }
            case 200: {
                oai16data = ((CompoundShortDataset)result).getData();
                if (is != 1) ** GOTO lbl124
                if (!it.isOutputDouble()) ** GOTO lbl122
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.sinh(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.sinh(ix));
lbl122:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl123:
                // 1 sources

                break;
lbl124:
                // 1 sources

                if (as != 1) ** GOTO lbl145
                if (!it.isOutputDouble()) ** GOTO lbl143
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (short)Maths.toLong(Math.sinh(ix));
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (short)Maths.toLong(Math.sinh(ix));
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl143:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl144:
                // 1 sources

                break;
lbl145:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl161
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.sinh(ix));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.sinh(ix));
                        ++j;
                    }
lbl161:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl162:
                // 1 sources

                break;
            }
            case 400: {
                oai64data = ((CompoundLongDataset)result).getData();
                if (is != 1) ** GOTO lbl176
                if (!it.isOutputDouble()) ** GOTO lbl174
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.sinh(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.sinh(ix));
lbl174:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl175:
                // 1 sources

                break;
lbl176:
                // 1 sources

                if (as != 1) ** GOTO lbl197
                if (!it.isOutputDouble()) ** GOTO lbl195
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = Maths.toLong(Math.sinh(ix));
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = Maths.toLong(Math.sinh(ix));
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl195:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl196:
                // 1 sources

                break;
lbl197:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl213
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.sinh(ix));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.sinh(ix));
                        ++j;
                    }
lbl213:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl214:
                // 1 sources

                break;
            }
            case 300: {
                oai32data = ((CompoundIntegerDataset)result).getData();
                if (is != 1) ** GOTO lbl228
                if (!it.isOutputDouble()) ** GOTO lbl226
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.sinh(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.sinh(ix));
lbl226:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl227:
                // 1 sources

                break;
lbl228:
                // 1 sources

                if (as != 1) ** GOTO lbl249
                if (!it.isOutputDouble()) ** GOTO lbl247
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (int)Maths.toLong(Math.sinh(ix));
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (int)Maths.toLong(Math.sinh(ix));
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl247:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl248:
                // 1 sources

                break;
lbl249:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl265
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.sinh(ix));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.sinh(ix));
                        ++j;
                    }
lbl265:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl266:
                // 1 sources

                break;
            }
            case 5: {
                of32data = ((FloatDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl277
                while (it.hasNext()) {
                    ix = it.aDouble;
                    of32data[it.oIndex] = ox = (float)Math.sinh(ix);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    of32data[it.oIndex] = ox = (float)Math.sinh(ix);
lbl277:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl278:
                // 1 sources

                break;
            }
            case 6: {
                of64data = ((DoubleDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl289
                while (it.hasNext()) {
                    ix = it.aDouble;
                    of64data[it.oIndex] = ox = Math.sinh(ix);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    of64data[it.oIndex] = ox = Math.sinh(ix);
lbl289:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl290:
                // 1 sources

                break;
            }
            case 500: {
                oaf32data = ((CompoundFloatDataset)result).getData();
                if (is != 1) ** GOTO lbl304
                if (!it.isOutputDouble()) ** GOTO lbl302
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oaf32data[it.oIndex] = ox = (float)Math.sinh(ix);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oaf32data[it.oIndex] = ox = (float)Math.sinh(ix);
lbl302:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl303:
                // 1 sources

                break;
lbl304:
                // 1 sources

                if (as != 1) ** GOTO lbl325
                if (!it.isOutputDouble()) ** GOTO lbl323
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (float)Math.sinh(ix);
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (float)Math.sinh(ix);
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl323:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl324:
                // 1 sources

                break;
lbl325:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl341
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.sinh(ix);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.sinh(ix);
                        ++j;
                    }
lbl341:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl342:
                // 1 sources

                break;
            }
            case 600: {
                oaf64data = ((CompoundDoubleDataset)result).getData();
                if (is != 1) ** GOTO lbl356
                if (!it.isOutputDouble()) ** GOTO lbl354
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oaf64data[it.oIndex] = ox = Math.sinh(ix);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oaf64data[it.oIndex] = ox = Math.sinh(ix);
lbl354:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl355:
                // 1 sources

                break;
lbl356:
                // 1 sources

                if (as != 1) ** GOTO lbl377
                if (!it.isOutputDouble()) ** GOTO lbl375
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = Math.sinh(ix);
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = Math.sinh(ix);
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl375:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl376:
                // 1 sources

                break;
lbl377:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl393
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = Math.sinh(ix);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = Math.sinh(ix);
                        ++j;
                    }
lbl393:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl394:
                // 1 sources

                break;
            }
            case 7: {
                oc64data = ((ComplexFloatDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl423
                if (it.isOutputDouble()) {
                    iy = 0.0;
                    while (it.hasNext()) {
                        ix = it.aDouble;
                        ox = (float)(Math.sinh(ix) * Math.cos(0.0));
                        oy = (float)(Math.cosh(ix) * Math.sin(0.0));
                        oc64data[it.oIndex] = ox;
                        oc64data[it.oIndex + 1] = oy;
                    }
                } else {
                    iy = 0L;
                    while (it.hasNext()) {
                        ix = it.aLong;
                        ox = Maths.toLong(Math.sinh(ix) * Math.cos(0.0));
                        oy = Maths.toLong(Math.cosh(ix) * Math.sin(0.0));
                        oc64data[it.oIndex] = ox;
                        oc64data[it.oIndex + 1] = oy;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aDouble;
                    iy = da.getElementDoubleAbs(it.aIndex + 1);
                    ox = (float)(Math.sinh(ix) * Math.cos(iy));
                    oy = (float)(Math.cosh(ix) * Math.sin(iy));
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
lbl423:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl424:
                // 1 sources

                break;
            }
            case 8: {
                oc128data = ((ComplexDoubleDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl453
                if (it.isOutputDouble()) {
                    iy = 0.0;
                    while (it.hasNext()) {
                        ix = it.aDouble;
                        ox = Math.sinh(ix) * Math.cos(0.0);
                        oy = Math.cosh(ix) * Math.sin(0.0);
                        oc128data[it.oIndex] = ox;
                        oc128data[it.oIndex + 1] = oy;
                    }
                } else {
                    iy = 0L;
                    while (it.hasNext()) {
                        ix = it.aLong;
                        ox = Math.sinh(ix) * Math.cos(0.0);
                        oy = Math.cosh(ix) * Math.sin(0.0);
                        oc128data[it.oIndex] = ox;
                        oc128data[it.oIndex + 1] = oy;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aDouble;
                    iy = da.getElementDoubleAbs(it.aIndex + 1);
                    ox = Math.sinh(ix) * Math.cos(iy);
                    oy = Math.cosh(ix) * Math.sin(iy);
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
lbl453:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl454:
                // 1 sources

                break;
            }
            default: {
                throw new IllegalArgumentException("sinh supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        Maths.addFunctionName(result, "sinh");
        return result;
    }

    public static Dataset cosh(Object a) {
        return Maths.cosh(a, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset cosh(Object a, Dataset o) {
        da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        it = new SingleInputBroadcastIterator(da, o, true);
        result = it.getOutput();
        if (!result.isComplex() && da.isComplex()) {
            da = da.getRealView();
            it = new SingleInputBroadcastIterator(da, result, true);
        }
        is = result.getElementsPerItem();
        as = da.getElementsPerItem();
        dt = result.getDType();
        switch (dt) {
            case 1: {
                oi8data = ((ByteDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl21
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi8data[it.oIndex] = ox = (byte)Maths.toLong(Math.cosh(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi8data[it.oIndex] = ox = (byte)Maths.toLong(Math.cosh(ix));
lbl21:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl22:
                // 1 sources

                break;
            }
            case 2: {
                oi16data = ((ShortDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl33
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi16data[it.oIndex] = ox = (short)Maths.toLong(Math.cosh(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi16data[it.oIndex] = ox = (short)Maths.toLong(Math.cosh(ix));
lbl33:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl34:
                // 1 sources

                break;
            }
            case 4: {
                oi64data = ((LongDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl45
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi64data[it.oIndex] = ox = Maths.toLong(Math.cosh(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi64data[it.oIndex] = ox = Maths.toLong(Math.cosh(ix));
lbl45:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl46:
                // 1 sources

                break;
            }
            case 3: {
                oi32data = ((IntegerDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl57
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi32data[it.oIndex] = ox = (int)Maths.toLong(Math.cosh(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi32data[it.oIndex] = ox = (int)Maths.toLong(Math.cosh(ix));
lbl57:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl58:
                // 1 sources

                break;
            }
            case 100: {
                oai8data = ((CompoundByteDataset)result).getData();
                if (is != 1) ** GOTO lbl72
                if (!it.isOutputDouble()) ** GOTO lbl70
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.cosh(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.cosh(ix));
lbl70:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl71:
                // 1 sources

                break;
lbl72:
                // 1 sources

                if (as != 1) ** GOTO lbl93
                if (!it.isOutputDouble()) ** GOTO lbl91
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (byte)Maths.toLong(Math.cosh(ix));
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (byte)Maths.toLong(Math.cosh(ix));
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl91:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl92:
                // 1 sources

                break;
lbl93:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl109
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.cosh(ix));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.cosh(ix));
                        ++j;
                    }
lbl109:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl110:
                // 1 sources

                break;
            }
            case 200: {
                oai16data = ((CompoundShortDataset)result).getData();
                if (is != 1) ** GOTO lbl124
                if (!it.isOutputDouble()) ** GOTO lbl122
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.cosh(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.cosh(ix));
lbl122:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl123:
                // 1 sources

                break;
lbl124:
                // 1 sources

                if (as != 1) ** GOTO lbl145
                if (!it.isOutputDouble()) ** GOTO lbl143
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (short)Maths.toLong(Math.cosh(ix));
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (short)Maths.toLong(Math.cosh(ix));
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl143:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl144:
                // 1 sources

                break;
lbl145:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl161
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.cosh(ix));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.cosh(ix));
                        ++j;
                    }
lbl161:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl162:
                // 1 sources

                break;
            }
            case 400: {
                oai64data = ((CompoundLongDataset)result).getData();
                if (is != 1) ** GOTO lbl176
                if (!it.isOutputDouble()) ** GOTO lbl174
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.cosh(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.cosh(ix));
lbl174:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl175:
                // 1 sources

                break;
lbl176:
                // 1 sources

                if (as != 1) ** GOTO lbl197
                if (!it.isOutputDouble()) ** GOTO lbl195
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = Maths.toLong(Math.cosh(ix));
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = Maths.toLong(Math.cosh(ix));
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl195:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl196:
                // 1 sources

                break;
lbl197:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl213
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.cosh(ix));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.cosh(ix));
                        ++j;
                    }
lbl213:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl214:
                // 1 sources

                break;
            }
            case 300: {
                oai32data = ((CompoundIntegerDataset)result).getData();
                if (is != 1) ** GOTO lbl228
                if (!it.isOutputDouble()) ** GOTO lbl226
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.cosh(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.cosh(ix));
lbl226:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl227:
                // 1 sources

                break;
lbl228:
                // 1 sources

                if (as != 1) ** GOTO lbl249
                if (!it.isOutputDouble()) ** GOTO lbl247
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (int)Maths.toLong(Math.cosh(ix));
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (int)Maths.toLong(Math.cosh(ix));
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl247:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl248:
                // 1 sources

                break;
lbl249:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl265
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.cosh(ix));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.cosh(ix));
                        ++j;
                    }
lbl265:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl266:
                // 1 sources

                break;
            }
            case 5: {
                of32data = ((FloatDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl277
                while (it.hasNext()) {
                    ix = it.aDouble;
                    of32data[it.oIndex] = ox = (float)Math.cosh(ix);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    of32data[it.oIndex] = ox = (float)Math.cosh(ix);
lbl277:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl278:
                // 1 sources

                break;
            }
            case 6: {
                of64data = ((DoubleDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl289
                while (it.hasNext()) {
                    ix = it.aDouble;
                    of64data[it.oIndex] = ox = Math.cosh(ix);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    of64data[it.oIndex] = ox = Math.cosh(ix);
lbl289:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl290:
                // 1 sources

                break;
            }
            case 500: {
                oaf32data = ((CompoundFloatDataset)result).getData();
                if (is != 1) ** GOTO lbl304
                if (!it.isOutputDouble()) ** GOTO lbl302
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oaf32data[it.oIndex] = ox = (float)Math.cosh(ix);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oaf32data[it.oIndex] = ox = (float)Math.cosh(ix);
lbl302:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl303:
                // 1 sources

                break;
lbl304:
                // 1 sources

                if (as != 1) ** GOTO lbl325
                if (!it.isOutputDouble()) ** GOTO lbl323
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (float)Math.cosh(ix);
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (float)Math.cosh(ix);
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl323:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl324:
                // 1 sources

                break;
lbl325:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl341
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.cosh(ix);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.cosh(ix);
                        ++j;
                    }
lbl341:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl342:
                // 1 sources

                break;
            }
            case 600: {
                oaf64data = ((CompoundDoubleDataset)result).getData();
                if (is != 1) ** GOTO lbl356
                if (!it.isOutputDouble()) ** GOTO lbl354
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oaf64data[it.oIndex] = ox = Math.cosh(ix);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oaf64data[it.oIndex] = ox = Math.cosh(ix);
lbl354:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl355:
                // 1 sources

                break;
lbl356:
                // 1 sources

                if (as != 1) ** GOTO lbl377
                if (!it.isOutputDouble()) ** GOTO lbl375
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = Math.cosh(ix);
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = Math.cosh(ix);
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl375:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl376:
                // 1 sources

                break;
lbl377:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl393
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = Math.cosh(ix);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = Math.cosh(ix);
                        ++j;
                    }
lbl393:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl394:
                // 1 sources

                break;
            }
            case 7: {
                oc64data = ((ComplexFloatDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl423
                if (it.isOutputDouble()) {
                    iy = 0.0;
                    while (it.hasNext()) {
                        ix = it.aDouble;
                        ox = (float)(Math.cosh(ix) * Math.cos(0.0));
                        oy = (float)(Math.sinh(ix) * Math.sin(0.0));
                        oc64data[it.oIndex] = ox;
                        oc64data[it.oIndex + 1] = oy;
                    }
                } else {
                    iy = 0L;
                    while (it.hasNext()) {
                        ix = it.aLong;
                        ox = Maths.toLong(Math.cosh(ix) * Math.cos(0.0));
                        oy = Maths.toLong(Math.sinh(ix) * Math.sin(0.0));
                        oc64data[it.oIndex] = ox;
                        oc64data[it.oIndex + 1] = oy;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aDouble;
                    iy = da.getElementDoubleAbs(it.aIndex + 1);
                    ox = (float)(Math.cosh(ix) * Math.cos(iy));
                    oy = (float)(Math.sinh(ix) * Math.sin(iy));
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
lbl423:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl424:
                // 1 sources

                break;
            }
            case 8: {
                oc128data = ((ComplexDoubleDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl453
                if (it.isOutputDouble()) {
                    iy = 0.0;
                    while (it.hasNext()) {
                        ix = it.aDouble;
                        ox = Math.cosh(ix) * Math.cos(0.0);
                        oy = Math.sinh(ix) * Math.sin(0.0);
                        oc128data[it.oIndex] = ox;
                        oc128data[it.oIndex + 1] = oy;
                    }
                } else {
                    iy = 0L;
                    while (it.hasNext()) {
                        ix = it.aLong;
                        ox = Math.cosh(ix) * Math.cos(0.0);
                        oy = Math.sinh(ix) * Math.sin(0.0);
                        oc128data[it.oIndex] = ox;
                        oc128data[it.oIndex + 1] = oy;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aDouble;
                    iy = da.getElementDoubleAbs(it.aIndex + 1);
                    ox = Math.cosh(ix) * Math.cos(iy);
                    oy = Math.sinh(ix) * Math.sin(iy);
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
lbl453:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl454:
                // 1 sources

                break;
            }
            default: {
                throw new IllegalArgumentException("cosh supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        Maths.addFunctionName(result, "cosh");
        return result;
    }

    public static Dataset tanh(Object a) {
        return Maths.tanh(a, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset tanh(Object a, Dataset o) {
        da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        it = new SingleInputBroadcastIterator(da, o, true);
        result = it.getOutput();
        if (!result.isComplex() && da.isComplex()) {
            da = da.getRealView();
            it = new SingleInputBroadcastIterator(da, result, true);
        }
        is = result.getElementsPerItem();
        as = da.getElementsPerItem();
        dt = result.getDType();
        switch (dt) {
            case 1: {
                oi8data = ((ByteDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl21
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi8data[it.oIndex] = ox = (byte)Maths.toLong(Math.tanh(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi8data[it.oIndex] = ox = (byte)Maths.toLong(Math.tanh(ix));
lbl21:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl22:
                // 1 sources

                break;
            }
            case 2: {
                oi16data = ((ShortDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl33
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi16data[it.oIndex] = ox = (short)Maths.toLong(Math.tanh(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi16data[it.oIndex] = ox = (short)Maths.toLong(Math.tanh(ix));
lbl33:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl34:
                // 1 sources

                break;
            }
            case 4: {
                oi64data = ((LongDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl45
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi64data[it.oIndex] = ox = Maths.toLong(Math.tanh(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi64data[it.oIndex] = ox = Maths.toLong(Math.tanh(ix));
lbl45:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl46:
                // 1 sources

                break;
            }
            case 3: {
                oi32data = ((IntegerDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl57
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi32data[it.oIndex] = ox = (int)Maths.toLong(Math.tanh(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi32data[it.oIndex] = ox = (int)Maths.toLong(Math.tanh(ix));
lbl57:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl58:
                // 1 sources

                break;
            }
            case 100: {
                oai8data = ((CompoundByteDataset)result).getData();
                if (is != 1) ** GOTO lbl72
                if (!it.isOutputDouble()) ** GOTO lbl70
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.tanh(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.tanh(ix));
lbl70:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl71:
                // 1 sources

                break;
lbl72:
                // 1 sources

                if (as != 1) ** GOTO lbl93
                if (!it.isOutputDouble()) ** GOTO lbl91
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (byte)Maths.toLong(Math.tanh(ix));
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (byte)Maths.toLong(Math.tanh(ix));
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl91:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl92:
                // 1 sources

                break;
lbl93:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl109
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.tanh(ix));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.tanh(ix));
                        ++j;
                    }
lbl109:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl110:
                // 1 sources

                break;
            }
            case 200: {
                oai16data = ((CompoundShortDataset)result).getData();
                if (is != 1) ** GOTO lbl124
                if (!it.isOutputDouble()) ** GOTO lbl122
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.tanh(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.tanh(ix));
lbl122:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl123:
                // 1 sources

                break;
lbl124:
                // 1 sources

                if (as != 1) ** GOTO lbl145
                if (!it.isOutputDouble()) ** GOTO lbl143
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (short)Maths.toLong(Math.tanh(ix));
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (short)Maths.toLong(Math.tanh(ix));
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl143:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl144:
                // 1 sources

                break;
lbl145:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl161
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.tanh(ix));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.tanh(ix));
                        ++j;
                    }
lbl161:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl162:
                // 1 sources

                break;
            }
            case 400: {
                oai64data = ((CompoundLongDataset)result).getData();
                if (is != 1) ** GOTO lbl176
                if (!it.isOutputDouble()) ** GOTO lbl174
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.tanh(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.tanh(ix));
lbl174:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl175:
                // 1 sources

                break;
lbl176:
                // 1 sources

                if (as != 1) ** GOTO lbl197
                if (!it.isOutputDouble()) ** GOTO lbl195
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = Maths.toLong(Math.tanh(ix));
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = Maths.toLong(Math.tanh(ix));
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl195:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl196:
                // 1 sources

                break;
lbl197:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl213
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.tanh(ix));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.tanh(ix));
                        ++j;
                    }
lbl213:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl214:
                // 1 sources

                break;
            }
            case 300: {
                oai32data = ((CompoundIntegerDataset)result).getData();
                if (is != 1) ** GOTO lbl228
                if (!it.isOutputDouble()) ** GOTO lbl226
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.tanh(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.tanh(ix));
lbl226:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl227:
                // 1 sources

                break;
lbl228:
                // 1 sources

                if (as != 1) ** GOTO lbl249
                if (!it.isOutputDouble()) ** GOTO lbl247
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (int)Maths.toLong(Math.tanh(ix));
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (int)Maths.toLong(Math.tanh(ix));
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl247:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl248:
                // 1 sources

                break;
lbl249:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl265
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.tanh(ix));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.tanh(ix));
                        ++j;
                    }
lbl265:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl266:
                // 1 sources

                break;
            }
            case 5: {
                of32data = ((FloatDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl277
                while (it.hasNext()) {
                    ix = it.aDouble;
                    of32data[it.oIndex] = ox = (float)Math.tanh(ix);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    of32data[it.oIndex] = ox = (float)Math.tanh(ix);
lbl277:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl278:
                // 1 sources

                break;
            }
            case 6: {
                of64data = ((DoubleDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl289
                while (it.hasNext()) {
                    ix = it.aDouble;
                    of64data[it.oIndex] = ox = Math.tanh(ix);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    of64data[it.oIndex] = ox = Math.tanh(ix);
lbl289:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl290:
                // 1 sources

                break;
            }
            case 500: {
                oaf32data = ((CompoundFloatDataset)result).getData();
                if (is != 1) ** GOTO lbl304
                if (!it.isOutputDouble()) ** GOTO lbl302
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oaf32data[it.oIndex] = ox = (float)Math.tanh(ix);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oaf32data[it.oIndex] = ox = (float)Math.tanh(ix);
lbl302:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl303:
                // 1 sources

                break;
lbl304:
                // 1 sources

                if (as != 1) ** GOTO lbl325
                if (!it.isOutputDouble()) ** GOTO lbl323
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (float)Math.tanh(ix);
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (float)Math.tanh(ix);
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl323:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl324:
                // 1 sources

                break;
lbl325:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl341
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.tanh(ix);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.tanh(ix);
                        ++j;
                    }
lbl341:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl342:
                // 1 sources

                break;
            }
            case 600: {
                oaf64data = ((CompoundDoubleDataset)result).getData();
                if (is != 1) ** GOTO lbl356
                if (!it.isOutputDouble()) ** GOTO lbl354
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oaf64data[it.oIndex] = ox = Math.tanh(ix);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oaf64data[it.oIndex] = ox = Math.tanh(ix);
lbl354:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl355:
                // 1 sources

                break;
lbl356:
                // 1 sources

                if (as != 1) ** GOTO lbl377
                if (!it.isOutputDouble()) ** GOTO lbl375
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = Math.tanh(ix);
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = Math.tanh(ix);
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl375:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl376:
                // 1 sources

                break;
lbl377:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl393
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = Math.tanh(ix);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = Math.tanh(ix);
                        ++j;
                    }
lbl393:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl394:
                // 1 sources

                break;
            }
            case 7: {
                oc64data = ((ComplexFloatDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl432
                if (it.isOutputDouble()) {
                    iy = 0.0;
                    while (it.hasNext()) {
                        ix = it.aDouble;
                        tx = (float)(2.0 * ix);
                        ty = 0.0f;
                        tf = (float)(1.0 / (Math.cos(tx) + Math.cosh(ty)));
                        ox = (float)((double)tf * Math.sinh(tx));
                        oy = (float)((double)tf * Math.sin(ty));
                        oc64data[it.oIndex] = ox;
                        oc64data[it.oIndex + 1] = oy;
                    }
                } else {
                    iy = 0L;
                    while (it.hasNext()) {
                        ix = it.aLong;
                        tx = Maths.toLong(2.0 * (double)ix);
                        ty = Maths.toLong(0.0);
                        tf = Maths.toLong(1.0 / (Math.cos(tx) + Math.cosh(ty)));
                        ox = Maths.toLong((double)tf * Math.sinh(tx));
                        oy = Maths.toLong((double)tf * Math.sin(ty));
                        oc64data[it.oIndex] = ox;
                        oc64data[it.oIndex + 1] = oy;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aDouble;
                    iy = da.getElementDoubleAbs(it.aIndex + 1);
                    tx = (float)(2.0 * ix);
                    ty = (float)(2.0 * iy);
                    tf = (float)(1.0 / (Math.cos(tx) + Math.cosh(ty)));
                    ox = (float)((double)tf * Math.sinh(tx));
                    oy = (float)((double)tf * Math.sin(ty));
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
lbl432:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl433:
                // 1 sources

                break;
            }
            case 8: {
                oc128data = ((ComplexDoubleDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl471
                if (it.isOutputDouble()) {
                    iy = 0.0;
                    while (it.hasNext()) {
                        ix = it.aDouble;
                        tx = 2.0 * ix;
                        ty = 0.0;
                        tf = 1.0 / (Math.cos(tx) + Math.cosh(ty));
                        ox = tf * Math.sinh(tx);
                        oy = tf * Math.sin(ty);
                        oc128data[it.oIndex] = ox;
                        oc128data[it.oIndex + 1] = oy;
                    }
                } else {
                    iy = 0L;
                    while (it.hasNext()) {
                        ix = it.aLong;
                        tx = 2.0 * (double)ix;
                        ty = 0.0;
                        tf = 1.0 / (Math.cos(tx) + Math.cosh(ty));
                        ox = tf * Math.sinh(tx);
                        oy = tf * Math.sin(ty);
                        oc128data[it.oIndex] = ox;
                        oc128data[it.oIndex + 1] = oy;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aDouble;
                    iy = da.getElementDoubleAbs(it.aIndex + 1);
                    tx = 2.0 * ix;
                    ty = 2.0 * iy;
                    tf = 1.0 / (Math.cos(tx) + Math.cosh(ty));
                    ox = tf * Math.sinh(tx);
                    oy = tf * Math.sin(ty);
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
lbl471:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl472:
                // 1 sources

                break;
            }
            default: {
                throw new IllegalArgumentException("tanh supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        Maths.addFunctionName(result, "tanh");
        return result;
    }

    public static Dataset arcsinh(Object a) {
        return Maths.arcsinh(a, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset arcsinh(Object a, Dataset o) {
        da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        it = new SingleInputBroadcastIterator(da, o, true);
        result = it.getOutput();
        if (!result.isComplex() && da.isComplex()) {
            da = da.getRealView();
            it = new SingleInputBroadcastIterator(da, result, true);
        }
        is = result.getElementsPerItem();
        as = da.getElementsPerItem();
        dt = result.getDType();
        switch (dt) {
            case 1: {
                oi8data = ((ByteDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl21
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi8data[it.oIndex] = ox = (byte)Maths.toLong(Math.log(ix + Math.sqrt(ix * ix + 1.0)));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi8data[it.oIndex] = ox = (byte)Maths.toLong(Math.log((double)ix + Math.sqrt(ix * ix + 1L)));
lbl21:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl22:
                // 1 sources

                break;
            }
            case 2: {
                oi16data = ((ShortDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl33
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi16data[it.oIndex] = ox = (short)Maths.toLong(Math.log(ix + Math.sqrt(ix * ix + 1.0)));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi16data[it.oIndex] = ox = (short)Maths.toLong(Math.log((double)ix + Math.sqrt(ix * ix + 1L)));
lbl33:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl34:
                // 1 sources

                break;
            }
            case 4: {
                oi64data = ((LongDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl45
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi64data[it.oIndex] = ox = Maths.toLong(Math.log(ix + Math.sqrt(ix * ix + 1.0)));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi64data[it.oIndex] = ox = Maths.toLong(Math.log((double)ix + Math.sqrt(ix * ix + 1L)));
lbl45:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl46:
                // 1 sources

                break;
            }
            case 3: {
                oi32data = ((IntegerDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl57
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi32data[it.oIndex] = ox = (int)Maths.toLong(Math.log(ix + Math.sqrt(ix * ix + 1.0)));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi32data[it.oIndex] = ox = (int)Maths.toLong(Math.log((double)ix + Math.sqrt(ix * ix + 1L)));
lbl57:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl58:
                // 1 sources

                break;
            }
            case 100: {
                oai8data = ((CompoundByteDataset)result).getData();
                if (is != 1) ** GOTO lbl72
                if (!it.isOutputDouble()) ** GOTO lbl70
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.log(ix + Math.sqrt(ix * ix + 1.0)));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.log((double)ix + Math.sqrt(ix * ix + 1L)));
lbl70:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl71:
                // 1 sources

                break;
lbl72:
                // 1 sources

                if (as != 1) ** GOTO lbl93
                if (!it.isOutputDouble()) ** GOTO lbl91
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (byte)Maths.toLong(Math.log(ix + Math.sqrt(ix * ix + 1.0)));
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (byte)Maths.toLong(Math.log((double)ix + Math.sqrt(ix * ix + 1L)));
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl91:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl92:
                // 1 sources

                break;
lbl93:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl109
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.log(ix + Math.sqrt(ix * ix + 1.0)));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.log((double)ix + Math.sqrt(ix * ix + 1L)));
                        ++j;
                    }
lbl109:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl110:
                // 1 sources

                break;
            }
            case 200: {
                oai16data = ((CompoundShortDataset)result).getData();
                if (is != 1) ** GOTO lbl124
                if (!it.isOutputDouble()) ** GOTO lbl122
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.log(ix + Math.sqrt(ix * ix + 1.0)));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.log((double)ix + Math.sqrt(ix * ix + 1L)));
lbl122:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl123:
                // 1 sources

                break;
lbl124:
                // 1 sources

                if (as != 1) ** GOTO lbl145
                if (!it.isOutputDouble()) ** GOTO lbl143
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (short)Maths.toLong(Math.log(ix + Math.sqrt(ix * ix + 1.0)));
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (short)Maths.toLong(Math.log((double)ix + Math.sqrt(ix * ix + 1L)));
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl143:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl144:
                // 1 sources

                break;
lbl145:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl161
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.log(ix + Math.sqrt(ix * ix + 1.0)));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.log((double)ix + Math.sqrt(ix * ix + 1L)));
                        ++j;
                    }
lbl161:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl162:
                // 1 sources

                break;
            }
            case 400: {
                oai64data = ((CompoundLongDataset)result).getData();
                if (is != 1) ** GOTO lbl176
                if (!it.isOutputDouble()) ** GOTO lbl174
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.log(ix + Math.sqrt(ix * ix + 1.0)));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.log((double)ix + Math.sqrt(ix * ix + 1L)));
lbl174:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl175:
                // 1 sources

                break;
lbl176:
                // 1 sources

                if (as != 1) ** GOTO lbl197
                if (!it.isOutputDouble()) ** GOTO lbl195
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = Maths.toLong(Math.log(ix + Math.sqrt(ix * ix + 1.0)));
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = Maths.toLong(Math.log((double)ix + Math.sqrt(ix * ix + 1L)));
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl195:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl196:
                // 1 sources

                break;
lbl197:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl213
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.log(ix + Math.sqrt(ix * ix + 1.0)));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.log((double)ix + Math.sqrt(ix * ix + 1L)));
                        ++j;
                    }
lbl213:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl214:
                // 1 sources

                break;
            }
            case 300: {
                oai32data = ((CompoundIntegerDataset)result).getData();
                if (is != 1) ** GOTO lbl228
                if (!it.isOutputDouble()) ** GOTO lbl226
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.log(ix + Math.sqrt(ix * ix + 1.0)));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.log((double)ix + Math.sqrt(ix * ix + 1L)));
lbl226:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl227:
                // 1 sources

                break;
lbl228:
                // 1 sources

                if (as != 1) ** GOTO lbl249
                if (!it.isOutputDouble()) ** GOTO lbl247
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (int)Maths.toLong(Math.log(ix + Math.sqrt(ix * ix + 1.0)));
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (int)Maths.toLong(Math.log((double)ix + Math.sqrt(ix * ix + 1L)));
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl247:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl248:
                // 1 sources

                break;
lbl249:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl265
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.log(ix + Math.sqrt(ix * ix + 1.0)));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.log((double)ix + Math.sqrt(ix * ix + 1L)));
                        ++j;
                    }
lbl265:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl266:
                // 1 sources

                break;
            }
            case 5: {
                of32data = ((FloatDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl277
                while (it.hasNext()) {
                    ix = it.aDouble;
                    of32data[it.oIndex] = ox = (float)Math.log(ix + Math.sqrt(ix * ix + 1.0));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    of32data[it.oIndex] = ox = (float)Math.log((double)ix + Math.sqrt(ix * ix + 1L));
lbl277:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl278:
                // 1 sources

                break;
            }
            case 6: {
                of64data = ((DoubleDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl289
                while (it.hasNext()) {
                    ix = it.aDouble;
                    of64data[it.oIndex] = ox = Math.log(ix + Math.sqrt(ix * ix + 1.0));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    of64data[it.oIndex] = ox = Math.log((double)ix + Math.sqrt(ix * ix + 1L));
lbl289:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl290:
                // 1 sources

                break;
            }
            case 500: {
                oaf32data = ((CompoundFloatDataset)result).getData();
                if (is != 1) ** GOTO lbl304
                if (!it.isOutputDouble()) ** GOTO lbl302
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oaf32data[it.oIndex] = ox = (float)Math.log(ix + Math.sqrt(ix * ix + 1.0));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oaf32data[it.oIndex] = ox = (float)Math.log((double)ix + Math.sqrt(ix * ix + 1L));
lbl302:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl303:
                // 1 sources

                break;
lbl304:
                // 1 sources

                if (as != 1) ** GOTO lbl325
                if (!it.isOutputDouble()) ** GOTO lbl323
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (float)Math.log(ix + Math.sqrt(ix * ix + 1.0));
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (float)Math.log((double)ix + Math.sqrt(ix * ix + 1L));
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl323:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl324:
                // 1 sources

                break;
lbl325:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl341
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.log(ix + Math.sqrt(ix * ix + 1.0));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.log((double)ix + Math.sqrt(ix * ix + 1L));
                        ++j;
                    }
lbl341:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl342:
                // 1 sources

                break;
            }
            case 600: {
                oaf64data = ((CompoundDoubleDataset)result).getData();
                if (is != 1) ** GOTO lbl356
                if (!it.isOutputDouble()) ** GOTO lbl354
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oaf64data[it.oIndex] = ox = Math.log(ix + Math.sqrt(ix * ix + 1.0));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oaf64data[it.oIndex] = ox = Math.log((double)ix + Math.sqrt(ix * ix + 1L));
lbl354:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl355:
                // 1 sources

                break;
lbl356:
                // 1 sources

                if (as != 1) ** GOTO lbl377
                if (!it.isOutputDouble()) ** GOTO lbl375
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = Math.log(ix + Math.sqrt(ix * ix + 1.0));
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = Math.log((double)ix + Math.sqrt(ix * ix + 1L));
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl375:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl376:
                // 1 sources

                break;
lbl377:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl393
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = Math.log(ix + Math.sqrt(ix * ix + 1.0));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = Math.log((double)ix + Math.sqrt(ix * ix + 1L));
                        ++j;
                    }
lbl393:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl394:
                // 1 sources

                break;
            }
            case 7: {
                oc64data = ((ComplexFloatDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl426
                if (it.isOutputDouble()) {
                    iy = 0.0;
                    while (it.hasNext()) {
                        ix = it.aDouble;
                        tz = new Complex(-0.0, ix).asin();
                        ox = (float)tz.getImaginary();
                        oy = (float)(-tz.getReal());
                        oc64data[it.oIndex] = ox;
                        oc64data[it.oIndex + 1] = oy;
                    }
                } else {
                    iy = 0L;
                    while (it.hasNext()) {
                        ix = it.aLong;
                        tz = new Complex(0.0, (double)ix).asin();
                        ox = Maths.toLong(tz.getImaginary());
                        oy = Maths.toLong(-tz.getReal());
                        oc64data[it.oIndex] = ox;
                        oc64data[it.oIndex + 1] = oy;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aDouble;
                    iy = da.getElementDoubleAbs(it.aIndex + 1);
                    tz = new Complex(-iy, ix).asin();
                    ox = (float)tz.getImaginary();
                    oy = (float)(-tz.getReal());
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
lbl426:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl427:
                // 1 sources

                break;
            }
            case 8: {
                oc128data = ((ComplexDoubleDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl459
                if (it.isOutputDouble()) {
                    iy = 0.0;
                    while (it.hasNext()) {
                        ix = it.aDouble;
                        tz = new Complex(-0.0, ix).asin();
                        ox = tz.getImaginary();
                        oy = -tz.getReal();
                        oc128data[it.oIndex] = ox;
                        oc128data[it.oIndex + 1] = oy;
                    }
                } else {
                    iy = 0L;
                    while (it.hasNext()) {
                        ix = it.aLong;
                        tz = new Complex(0.0, (double)ix).asin();
                        ox = tz.getImaginary();
                        oy = -tz.getReal();
                        oc128data[it.oIndex] = ox;
                        oc128data[it.oIndex + 1] = oy;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aDouble;
                    iy = da.getElementDoubleAbs(it.aIndex + 1);
                    tz = new Complex(-iy, ix).asin();
                    ox = tz.getImaginary();
                    oy = -tz.getReal();
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
lbl459:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl460:
                // 1 sources

                break;
            }
            default: {
                throw new IllegalArgumentException("arcsinh supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        Maths.addFunctionName(result, "arcsinh");
        return result;
    }

    public static Dataset arccosh(Object a) {
        return Maths.arccosh(a, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset arccosh(Object a, Dataset o) {
        da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        it = new SingleInputBroadcastIterator(da, o, true);
        result = it.getOutput();
        if (!result.isComplex() && da.isComplex()) {
            da = da.getRealView();
            it = new SingleInputBroadcastIterator(da, result, true);
        }
        is = result.getElementsPerItem();
        as = da.getElementsPerItem();
        dt = result.getDType();
        switch (dt) {
            case 1: {
                oi8data = ((ByteDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl21
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi8data[it.oIndex] = ox = (byte)Maths.toLong(Math.log(ix + Math.sqrt(ix * ix - 1.0)));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi8data[it.oIndex] = ox = (byte)Maths.toLong(Math.log((double)ix + Math.sqrt(ix * ix - 1L)));
lbl21:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl22:
                // 1 sources

                break;
            }
            case 2: {
                oi16data = ((ShortDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl33
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi16data[it.oIndex] = ox = (short)Maths.toLong(Math.log(ix + Math.sqrt(ix * ix - 1.0)));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi16data[it.oIndex] = ox = (short)Maths.toLong(Math.log((double)ix + Math.sqrt(ix * ix - 1L)));
lbl33:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl34:
                // 1 sources

                break;
            }
            case 4: {
                oi64data = ((LongDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl45
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi64data[it.oIndex] = ox = Maths.toLong(Math.log(ix + Math.sqrt(ix * ix - 1.0)));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi64data[it.oIndex] = ox = Maths.toLong(Math.log((double)ix + Math.sqrt(ix * ix - 1L)));
lbl45:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl46:
                // 1 sources

                break;
            }
            case 3: {
                oi32data = ((IntegerDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl57
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi32data[it.oIndex] = ox = (int)Maths.toLong(Math.log(ix + Math.sqrt(ix * ix - 1.0)));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi32data[it.oIndex] = ox = (int)Maths.toLong(Math.log((double)ix + Math.sqrt(ix * ix - 1L)));
lbl57:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl58:
                // 1 sources

                break;
            }
            case 100: {
                oai8data = ((CompoundByteDataset)result).getData();
                if (is != 1) ** GOTO lbl72
                if (!it.isOutputDouble()) ** GOTO lbl70
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.log(ix + Math.sqrt(ix * ix - 1.0)));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(Math.log((double)ix + Math.sqrt(ix * ix - 1L)));
lbl70:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl71:
                // 1 sources

                break;
lbl72:
                // 1 sources

                if (as != 1) ** GOTO lbl93
                if (!it.isOutputDouble()) ** GOTO lbl91
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (byte)Maths.toLong(Math.log(ix + Math.sqrt(ix * ix - 1.0)));
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (byte)Maths.toLong(Math.log((double)ix + Math.sqrt(ix * ix - 1L)));
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl91:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl92:
                // 1 sources

                break;
lbl93:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl109
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.log(ix + Math.sqrt(ix * ix - 1.0)));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(Math.log((double)ix + Math.sqrt(ix * ix - 1L)));
                        ++j;
                    }
lbl109:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl110:
                // 1 sources

                break;
            }
            case 200: {
                oai16data = ((CompoundShortDataset)result).getData();
                if (is != 1) ** GOTO lbl124
                if (!it.isOutputDouble()) ** GOTO lbl122
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.log(ix + Math.sqrt(ix * ix - 1.0)));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(Math.log((double)ix + Math.sqrt(ix * ix - 1L)));
lbl122:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl123:
                // 1 sources

                break;
lbl124:
                // 1 sources

                if (as != 1) ** GOTO lbl145
                if (!it.isOutputDouble()) ** GOTO lbl143
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (short)Maths.toLong(Math.log(ix + Math.sqrt(ix * ix - 1.0)));
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (short)Maths.toLong(Math.log((double)ix + Math.sqrt(ix * ix - 1L)));
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl143:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl144:
                // 1 sources

                break;
lbl145:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl161
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.log(ix + Math.sqrt(ix * ix - 1.0)));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(Math.log((double)ix + Math.sqrt(ix * ix - 1L)));
                        ++j;
                    }
lbl161:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl162:
                // 1 sources

                break;
            }
            case 400: {
                oai64data = ((CompoundLongDataset)result).getData();
                if (is != 1) ** GOTO lbl176
                if (!it.isOutputDouble()) ** GOTO lbl174
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.log(ix + Math.sqrt(ix * ix - 1.0)));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai64data[it.oIndex] = ox = Maths.toLong(Math.log((double)ix + Math.sqrt(ix * ix - 1L)));
lbl174:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl175:
                // 1 sources

                break;
lbl176:
                // 1 sources

                if (as != 1) ** GOTO lbl197
                if (!it.isOutputDouble()) ** GOTO lbl195
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = Maths.toLong(Math.log(ix + Math.sqrt(ix * ix - 1.0)));
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = Maths.toLong(Math.log((double)ix + Math.sqrt(ix * ix - 1L)));
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl195:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl196:
                // 1 sources

                break;
lbl197:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl213
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.log(ix + Math.sqrt(ix * ix - 1.0)));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(Math.log((double)ix + Math.sqrt(ix * ix - 1L)));
                        ++j;
                    }
lbl213:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl214:
                // 1 sources

                break;
            }
            case 300: {
                oai32data = ((CompoundIntegerDataset)result).getData();
                if (is != 1) ** GOTO lbl228
                if (!it.isOutputDouble()) ** GOTO lbl226
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.log(ix + Math.sqrt(ix * ix - 1.0)));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(Math.log((double)ix + Math.sqrt(ix * ix - 1L)));
lbl226:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl227:
                // 1 sources

                break;
lbl228:
                // 1 sources

                if (as != 1) ** GOTO lbl249
                if (!it.isOutputDouble()) ** GOTO lbl247
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (int)Maths.toLong(Math.log(ix + Math.sqrt(ix * ix - 1.0)));
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (int)Maths.toLong(Math.log((double)ix + Math.sqrt(ix * ix - 1L)));
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl247:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl248:
                // 1 sources

                break;
lbl249:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl265
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.log(ix + Math.sqrt(ix * ix - 1.0)));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(Math.log((double)ix + Math.sqrt(ix * ix - 1L)));
                        ++j;
                    }
lbl265:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl266:
                // 1 sources

                break;
            }
            case 5: {
                of32data = ((FloatDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl277
                while (it.hasNext()) {
                    ix = it.aDouble;
                    of32data[it.oIndex] = ox = (float)Math.log(ix + Math.sqrt(ix * ix - 1.0));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    of32data[it.oIndex] = ox = (float)Math.log((double)ix + Math.sqrt(ix * ix - 1L));
lbl277:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl278:
                // 1 sources

                break;
            }
            case 6: {
                of64data = ((DoubleDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl289
                while (it.hasNext()) {
                    ix = it.aDouble;
                    of64data[it.oIndex] = ox = Math.log(ix + Math.sqrt(ix * ix - 1.0));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    of64data[it.oIndex] = ox = Math.log((double)ix + Math.sqrt(ix * ix - 1L));
lbl289:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl290:
                // 1 sources

                break;
            }
            case 500: {
                oaf32data = ((CompoundFloatDataset)result).getData();
                if (is != 1) ** GOTO lbl304
                if (!it.isOutputDouble()) ** GOTO lbl302
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oaf32data[it.oIndex] = ox = (float)Math.log(ix + Math.sqrt(ix * ix - 1.0));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oaf32data[it.oIndex] = ox = (float)Math.log((double)ix + Math.sqrt(ix * ix - 1L));
lbl302:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl303:
                // 1 sources

                break;
lbl304:
                // 1 sources

                if (as != 1) ** GOTO lbl325
                if (!it.isOutputDouble()) ** GOTO lbl323
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (float)Math.log(ix + Math.sqrt(ix * ix - 1.0));
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (float)Math.log((double)ix + Math.sqrt(ix * ix - 1L));
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl323:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl324:
                // 1 sources

                break;
lbl325:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl341
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.log(ix + Math.sqrt(ix * ix - 1.0));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)Math.log((double)ix + Math.sqrt(ix * ix - 1L));
                        ++j;
                    }
lbl341:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl342:
                // 1 sources

                break;
            }
            case 600: {
                oaf64data = ((CompoundDoubleDataset)result).getData();
                if (is != 1) ** GOTO lbl356
                if (!it.isOutputDouble()) ** GOTO lbl354
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oaf64data[it.oIndex] = ox = Math.log(ix + Math.sqrt(ix * ix - 1.0));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oaf64data[it.oIndex] = ox = Math.log((double)ix + Math.sqrt(ix * ix - 1L));
lbl354:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl355:
                // 1 sources

                break;
lbl356:
                // 1 sources

                if (as != 1) ** GOTO lbl377
                if (!it.isOutputDouble()) ** GOTO lbl375
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = Math.log(ix + Math.sqrt(ix * ix - 1.0));
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = Math.log((double)ix + Math.sqrt(ix * ix - 1L));
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl375:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl376:
                // 1 sources

                break;
lbl377:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl393
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = Math.log(ix + Math.sqrt(ix * ix - 1.0));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = Math.log((double)ix + Math.sqrt(ix * ix - 1L));
                        ++j;
                    }
lbl393:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl394:
                // 1 sources

                break;
            }
            case 7: {
                oc64data = ((ComplexFloatDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl426
                if (it.isOutputDouble()) {
                    iy = 0.0;
                    while (it.hasNext()) {
                        ix = it.aDouble;
                        tz = new Complex(-0.0, ix).acos();
                        ox = (float)tz.getImaginary();
                        oy = (float)(-tz.getReal());
                        oc64data[it.oIndex] = ox;
                        oc64data[it.oIndex + 1] = oy;
                    }
                } else {
                    iy = 0L;
                    while (it.hasNext()) {
                        ix = it.aLong;
                        tz = new Complex(0.0, (double)ix).acos();
                        ox = Maths.toLong(tz.getImaginary());
                        oy = Maths.toLong(-tz.getReal());
                        oc64data[it.oIndex] = ox;
                        oc64data[it.oIndex + 1] = oy;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aDouble;
                    iy = da.getElementDoubleAbs(it.aIndex + 1);
                    tz = new Complex(-iy, ix).acos();
                    ox = (float)tz.getImaginary();
                    oy = (float)(-tz.getReal());
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
lbl426:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl427:
                // 1 sources

                break;
            }
            case 8: {
                oc128data = ((ComplexDoubleDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl459
                if (it.isOutputDouble()) {
                    iy = 0.0;
                    while (it.hasNext()) {
                        ix = it.aDouble;
                        tz = new Complex(-0.0, ix).acos();
                        ox = tz.getImaginary();
                        oy = -tz.getReal();
                        oc128data[it.oIndex] = ox;
                        oc128data[it.oIndex + 1] = oy;
                    }
                } else {
                    iy = 0L;
                    while (it.hasNext()) {
                        ix = it.aLong;
                        tz = new Complex(0.0, (double)ix).acos();
                        ox = tz.getImaginary();
                        oy = -tz.getReal();
                        oc128data[it.oIndex] = ox;
                        oc128data[it.oIndex + 1] = oy;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aDouble;
                    iy = da.getElementDoubleAbs(it.aIndex + 1);
                    tz = new Complex(-iy, ix).acos();
                    ox = tz.getImaginary();
                    oy = -tz.getReal();
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
lbl459:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl460:
                // 1 sources

                break;
            }
            default: {
                throw new IllegalArgumentException("arccosh supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        Maths.addFunctionName(result, "arccosh");
        return result;
    }

    public static Dataset arctanh(Object a) {
        return Maths.arctanh(a, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset arctanh(Object a, Dataset o) {
        da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        it = new SingleInputBroadcastIterator(da, o, true);
        result = it.getOutput();
        if (!result.isComplex() && da.isComplex()) {
            da = da.getRealView();
            it = new SingleInputBroadcastIterator(da, result, true);
        }
        is = result.getElementsPerItem();
        as = da.getElementsPerItem();
        dt = result.getDType();
        switch (dt) {
            case 1: {
                oi8data = ((ByteDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl21
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi8data[it.oIndex] = ox = (byte)Maths.toLong(0.5 * Math.log((1.0 + ix) / (1.0 - ix)));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi8data[it.oIndex] = ox = (byte)Maths.toLong(0.5 * Math.log((1L + ix) / (1L - ix)));
lbl21:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl22:
                // 1 sources

                break;
            }
            case 2: {
                oi16data = ((ShortDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl33
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi16data[it.oIndex] = ox = (short)Maths.toLong(0.5 * Math.log((1.0 + ix) / (1.0 - ix)));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi16data[it.oIndex] = ox = (short)Maths.toLong(0.5 * Math.log((1L + ix) / (1L - ix)));
lbl33:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl34:
                // 1 sources

                break;
            }
            case 4: {
                oi64data = ((LongDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl45
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi64data[it.oIndex] = ox = Maths.toLong(0.5 * Math.log((1.0 + ix) / (1.0 - ix)));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi64data[it.oIndex] = ox = Maths.toLong(0.5 * Math.log((1L + ix) / (1L - ix)));
lbl45:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl46:
                // 1 sources

                break;
            }
            case 3: {
                oi32data = ((IntegerDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl57
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi32data[it.oIndex] = ox = (int)Maths.toLong(0.5 * Math.log((1.0 + ix) / (1.0 - ix)));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi32data[it.oIndex] = ox = (int)Maths.toLong(0.5 * Math.log((1L + ix) / (1L - ix)));
lbl57:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl58:
                // 1 sources

                break;
            }
            case 100: {
                oai8data = ((CompoundByteDataset)result).getData();
                if (is != 1) ** GOTO lbl72
                if (!it.isOutputDouble()) ** GOTO lbl70
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(0.5 * Math.log((1.0 + ix) / (1.0 - ix)));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai8data[it.oIndex] = ox = (byte)Maths.toLong(0.5 * Math.log((1L + ix) / (1L - ix)));
lbl70:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl71:
                // 1 sources

                break;
lbl72:
                // 1 sources

                if (as != 1) ** GOTO lbl93
                if (!it.isOutputDouble()) ** GOTO lbl91
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (byte)Maths.toLong(0.5 * Math.log((1.0 + ix) / (1.0 - ix)));
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (byte)Maths.toLong(0.5 * Math.log((1L + ix) / (1L - ix)));
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl91:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl92:
                // 1 sources

                break;
lbl93:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl109
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(0.5 * Math.log((1.0 + ix) / (1.0 - ix)));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai8data[it.oIndex + j] = ox = (byte)Maths.toLong(0.5 * Math.log((1L + ix) / (1L - ix)));
                        ++j;
                    }
lbl109:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl110:
                // 1 sources

                break;
            }
            case 200: {
                oai16data = ((CompoundShortDataset)result).getData();
                if (is != 1) ** GOTO lbl124
                if (!it.isOutputDouble()) ** GOTO lbl122
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(0.5 * Math.log((1.0 + ix) / (1.0 - ix)));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai16data[it.oIndex] = ox = (short)Maths.toLong(0.5 * Math.log((1L + ix) / (1L - ix)));
lbl122:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl123:
                // 1 sources

                break;
lbl124:
                // 1 sources

                if (as != 1) ** GOTO lbl145
                if (!it.isOutputDouble()) ** GOTO lbl143
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (short)Maths.toLong(0.5 * Math.log((1.0 + ix) / (1.0 - ix)));
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (short)Maths.toLong(0.5 * Math.log((1L + ix) / (1L - ix)));
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl143:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl144:
                // 1 sources

                break;
lbl145:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl161
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(0.5 * Math.log((1.0 + ix) / (1.0 - ix)));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai16data[it.oIndex + j] = ox = (short)Maths.toLong(0.5 * Math.log((1L + ix) / (1L - ix)));
                        ++j;
                    }
lbl161:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl162:
                // 1 sources

                break;
            }
            case 400: {
                oai64data = ((CompoundLongDataset)result).getData();
                if (is != 1) ** GOTO lbl176
                if (!it.isOutputDouble()) ** GOTO lbl174
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai64data[it.oIndex] = ox = Maths.toLong(0.5 * Math.log((1.0 + ix) / (1.0 - ix)));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai64data[it.oIndex] = ox = Maths.toLong(0.5 * Math.log((1L + ix) / (1L - ix)));
lbl174:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl175:
                // 1 sources

                break;
lbl176:
                // 1 sources

                if (as != 1) ** GOTO lbl197
                if (!it.isOutputDouble()) ** GOTO lbl195
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = Maths.toLong(0.5 * Math.log((1.0 + ix) / (1.0 - ix)));
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = Maths.toLong(0.5 * Math.log((1L + ix) / (1L - ix)));
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl195:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl196:
                // 1 sources

                break;
lbl197:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl213
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(0.5 * Math.log((1.0 + ix) / (1.0 - ix)));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai64data[it.oIndex + j] = ox = Maths.toLong(0.5 * Math.log((1L + ix) / (1L - ix)));
                        ++j;
                    }
lbl213:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl214:
                // 1 sources

                break;
            }
            case 300: {
                oai32data = ((CompoundIntegerDataset)result).getData();
                if (is != 1) ** GOTO lbl228
                if (!it.isOutputDouble()) ** GOTO lbl226
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(0.5 * Math.log((1.0 + ix) / (1.0 - ix)));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oai32data[it.oIndex] = ox = (int)Maths.toLong(0.5 * Math.log((1L + ix) / (1L - ix)));
lbl226:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl227:
                // 1 sources

                break;
lbl228:
                // 1 sources

                if (as != 1) ** GOTO lbl249
                if (!it.isOutputDouble()) ** GOTO lbl247
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (int)Maths.toLong(0.5 * Math.log((1.0 + ix) / (1.0 - ix)));
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (int)Maths.toLong(0.5 * Math.log((1L + ix) / (1L - ix)));
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl247:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl248:
                // 1 sources

                break;
lbl249:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl265
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(0.5 * Math.log((1.0 + ix) / (1.0 - ix)));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oai32data[it.oIndex + j] = ox = (int)Maths.toLong(0.5 * Math.log((1L + ix) / (1L - ix)));
                        ++j;
                    }
lbl265:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl266:
                // 1 sources

                break;
            }
            case 5: {
                of32data = ((FloatDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl277
                while (it.hasNext()) {
                    ix = it.aDouble;
                    of32data[it.oIndex] = ox = (float)(0.5 * Math.log((1.0 + ix) / (1.0 - ix)));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    of32data[it.oIndex] = ox = (float)(0.5 * Math.log((1L + ix) / (1L - ix)));
lbl277:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl278:
                // 1 sources

                break;
            }
            case 6: {
                of64data = ((DoubleDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl289
                while (it.hasNext()) {
                    ix = it.aDouble;
                    of64data[it.oIndex] = ox = 0.5 * Math.log((1.0 + ix) / (1.0 - ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    of64data[it.oIndex] = ox = 0.5 * Math.log((1L + ix) / (1L - ix));
lbl289:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl290:
                // 1 sources

                break;
            }
            case 500: {
                oaf32data = ((CompoundFloatDataset)result).getData();
                if (is != 1) ** GOTO lbl304
                if (!it.isOutputDouble()) ** GOTO lbl302
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oaf32data[it.oIndex] = ox = (float)(0.5 * Math.log((1.0 + ix) / (1.0 - ix)));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oaf32data[it.oIndex] = ox = (float)(0.5 * Math.log((1L + ix) / (1L - ix)));
lbl302:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl303:
                // 1 sources

                break;
lbl304:
                // 1 sources

                if (as != 1) ** GOTO lbl325
                if (!it.isOutputDouble()) ** GOTO lbl323
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = (float)(0.5 * Math.log((1.0 + ix) / (1.0 - ix)));
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = (float)(0.5 * Math.log((1L + ix) / (1L - ix)));
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl323:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl324:
                // 1 sources

                break;
lbl325:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl341
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(0.5 * Math.log((1.0 + ix) / (1.0 - ix)));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oaf32data[it.oIndex + j] = ox = (float)(0.5 * Math.log((1L + ix) / (1L - ix)));
                        ++j;
                    }
lbl341:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl342:
                // 1 sources

                break;
            }
            case 600: {
                oaf64data = ((CompoundDoubleDataset)result).getData();
                if (is != 1) ** GOTO lbl356
                if (!it.isOutputDouble()) ** GOTO lbl354
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oaf64data[it.oIndex] = ox = 0.5 * Math.log((1.0 + ix) / (1.0 - ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oaf64data[it.oIndex] = ox = 0.5 * Math.log((1L + ix) / (1L - ix));
lbl354:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl355:
                // 1 sources

                break;
lbl356:
                // 1 sources

                if (as != 1) ** GOTO lbl377
                if (!it.isOutputDouble()) ** GOTO lbl375
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = 0.5 * Math.log((1.0 + ix) / (1.0 - ix));
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    ox = 0.5 * Math.log((1L + ix) / (1L - ix));
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl375:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl376:
                // 1 sources

                break;
lbl377:
                // 1 sources

                if (!it.isOutputDouble()) ** GOTO lbl393
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementDoubleAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = 0.5 * Math.log((1.0 + ix) / (1.0 - ix));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        ix = da.getElementLongAbs(it.aIndex + j);
                        oaf64data[it.oIndex + j] = ox = 0.5 * Math.log((1L + ix) / (1L - ix));
                        ++j;
                    }
lbl393:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl394:
                // 1 sources

                break;
            }
            case 7: {
                oc64data = ((ComplexFloatDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl426
                if (it.isOutputDouble()) {
                    iy = 0.0;
                    while (it.hasNext()) {
                        ix = it.aDouble;
                        tz = new Complex(-0.0, ix).atan();
                        ox = (float)tz.getImaginary();
                        oy = (float)(-tz.getReal());
                        oc64data[it.oIndex] = ox;
                        oc64data[it.oIndex + 1] = oy;
                    }
                } else {
                    iy = 0L;
                    while (it.hasNext()) {
                        ix = it.aLong;
                        tz = new Complex(0.0, (double)ix).atan();
                        ox = Maths.toLong(tz.getImaginary());
                        oy = Maths.toLong(-tz.getReal());
                        oc64data[it.oIndex] = ox;
                        oc64data[it.oIndex + 1] = oy;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aDouble;
                    iy = da.getElementDoubleAbs(it.aIndex + 1);
                    tz = new Complex(-iy, ix).atan();
                    ox = (float)tz.getImaginary();
                    oy = (float)(-tz.getReal());
                    oc64data[it.oIndex] = ox;
                    oc64data[it.oIndex + 1] = oy;
lbl426:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl427:
                // 1 sources

                break;
            }
            case 8: {
                oc128data = ((ComplexDoubleDataset)result).getData();
                if (da.isComplex()) ** GOTO lbl459
                if (it.isOutputDouble()) {
                    iy = 0.0;
                    while (it.hasNext()) {
                        ix = it.aDouble;
                        tz = new Complex(-0.0, ix).atan();
                        ox = tz.getImaginary();
                        oy = -tz.getReal();
                        oc128data[it.oIndex] = ox;
                        oc128data[it.oIndex + 1] = oy;
                    }
                } else {
                    iy = 0L;
                    while (it.hasNext()) {
                        ix = it.aLong;
                        tz = new Complex(0.0, (double)ix).atan();
                        ox = tz.getImaginary();
                        oy = -tz.getReal();
                        oc128data[it.oIndex] = ox;
                        oc128data[it.oIndex + 1] = oy;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aDouble;
                    iy = da.getElementDoubleAbs(it.aIndex + 1);
                    tz = new Complex(-iy, ix).atan();
                    ox = tz.getImaginary();
                    oy = -tz.getReal();
                    oc128data[it.oIndex] = ox;
                    oc128data[it.oIndex + 1] = oy;
lbl459:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl460:
                // 1 sources

                break;
            }
            default: {
                throw new IllegalArgumentException("arctanh supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        Maths.addFunctionName(result, "arctanh");
        return result;
    }

    public static Dataset log(Object a) {
        return Maths.log(a, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset log(Object a, Dataset o) {
        da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        it = new SingleInputBroadcastIterator(da, o, true);
        result = it.getOutput();
        if (!result.isComplex() && da.isComplex()) {
            da = da.getRealView();
            it = new SingleInputBroadcastIterator(da, result, true);
        }
        is = result.getElementsPerItem();
        as = da.getElementsPerItem();
        dt = result.getDType();
        switch (dt) {
            case 1: {
                oi8data = ((ByteDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl21
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi8data[it.oIndex] = ox = (byte)Maths.toLong(Math.log(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi8data[it.oIndex] = ox = (byte)Maths.toLong(Math.log(ix));
lbl21:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl22:
                // 1 sources

                break;
            }
            case 2: {
                oi16data = ((ShortDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl33
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi16data[it.oIndex] = ox = (short)Maths.toLong(Math.log(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi16data[it.oIndex] = ox = (short)Maths.toLong(Math.log(ix));
lbl33:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl34:
                // 1 sources

                break;
            }
            case 4: {
                oi64data = ((LongDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl45
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi64data[it.oIndex] = ox = Maths.toLong(Math.log(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi64data[it.oIndex] = ox = Maths.toLong(Math.log(ix));
lbl45:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl46:
                // 1 sources

                break;
            }
            case 3: {
                oi32data = ((IntegerDataset)result).getData();
                if (!it.isOutputDouble()) ** GOTO lbl57
                while (it.hasNext()) {
                    ix = it.aDouble;
                    oi32data[it.oIndex] = ox = (int)Maths.toLong(Math.log(ix));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ix = it.aLong;
                    oi32data[it.oIndex] = ox = (int)Maths.toLong(Math.log(ix));
lbl57:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl58:
                // 1 sources

                break;
            }
            case 100: {
  