/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import org.eclipse.january.dataset.BroadcastIterator;
import org.eclipse.january.dataset.BroadcastUtils;
import org.eclipse.january.dataset.CompoundDataset;
import org.eclipse.january.dataset.CompoundDoubleDataset;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.ShortDataset;
import org.eclipse.january.dataset.Slice;
import org.junit.Assert;
import org.junit.Test;

public class BroadcastIteratorTest {
    @Test
    public void testBroadcastShape() {
        DoubleDataset a = DatasetFactory.ones((int[])new int[0]);
        this.checkBroadcastShape((Dataset)a, "scalar as scalar", new int[0], new int[0], new int[0]);
        this.checkBroadcastShape((Dataset)a, "scalar as [1]", new int[]{1}, new int[]{1}, 1);
        this.checkBroadcastShape((Dataset)a, "scalar as [3]", new int[]{1}, new int[]{3}, 3);
        this.checkBroadcastShape((Dataset)a, "scalar as [3,4]", new int[]{1, 1}, new int[]{3, 4}, 3, 4);
        a = DatasetFactory.ones((int[])new int[]{1});
        this.checkBroadcastShape((Dataset)a, "[1] as scalar", new int[]{1}, new int[0], new int[0]);
        this.checkBroadcastShape((Dataset)a, "[1] as [1]", new int[]{1}, new int[]{1}, 1);
        this.checkBroadcastShape((Dataset)a, "[1] as [3]", new int[]{1}, new int[]{3}, 3);
        this.checkBroadcastShape((Dataset)a, "[1] as [3,4]", new int[]{1, 1}, new int[]{3, 4}, 3, 4);
        a = DatasetFactory.ones((int[])new int[]{1, 1});
        this.checkBroadcastShape((Dataset)a, "[1,1] as scalar", new int[]{1, 1}, new int[0], new int[0]);
        this.checkBroadcastShape((Dataset)a, "[1,1] as [1]", new int[]{1, 1}, new int[]{1, 1}, 1);
        this.checkBroadcastShape((Dataset)a, "[1,1] as [3]", new int[]{1, 1}, new int[]{1, 3}, 3);
        this.checkBroadcastShape((Dataset)a, "[1,1] as [1,3]", new int[]{1, 1}, new int[]{1, 3}, 1, 3);
        this.checkBroadcastShape((Dataset)a, "[1,1] as [3,4]", new int[]{1, 1}, new int[]{3, 4}, 3, 4);
        a = DatasetFactory.ones((int[])new int[]{3});
        this.checkBroadcastShape((Dataset)a, "[3] as scalar", null, null, new int[0]);
        this.checkBroadcastShape((Dataset)a, "[3] as [1]", new int[]{3}, new int[]{1}, 1);
        this.checkBroadcastShape((Dataset)a, "[3] as [3]", new int[]{3}, new int[]{3}, 3);
        this.checkBroadcastShape((Dataset)a, "[3] as [1,3]", new int[]{1, 3}, new int[]{1, 3}, 1, 3);
        this.checkBroadcastShape((Dataset)a, "[3] as [3,4]", null, null, 3, 4);
        a = DatasetFactory.ones((int[])new int[]{3, 1});
        this.checkBroadcastShape((Dataset)a, "[3,1] as scalar", null, null, new int[0]);
        this.checkBroadcastShape((Dataset)a, "[3,1] as [1]", new int[]{3, 1}, new int[]{1, 1}, 1);
        this.checkBroadcastShape((Dataset)a, "[3,1] as [3]", new int[]{3, 1}, new int[]{1, 3}, 3);
        this.checkBroadcastShape((Dataset)a, "[3,1] as [1,3]", new int[]{3, 1}, new int[]{1, 3}, 1, 3);
        this.checkBroadcastShape((Dataset)a, "[3,1] as [3,4]", new int[]{3, 1}, new int[]{3, 4}, 3, 4);
        this.checkBroadcastShape((Dataset)a, "[3,1] as [6,3,4]", new int[]{1, 3, 1}, new int[]{6, 3, 4}, 6, 3, 4);
        this.checkBroadcastShape((Dataset)a, "[3,1] as [3,4,6]", null, null, 3, 4, 6);
        a = DatasetFactory.ones((int[])new int[]{1, 3});
        this.checkBroadcastShape((Dataset)a, "[1,3] as scalar", null, null, new int[0]);
        this.checkBroadcastShape((Dataset)a, "[1,3] as [1]", new int[]{1, 3}, new int[]{1, 1}, 1);
        this.checkBroadcastShape((Dataset)a, "[1,3] as [3]", new int[]{1, 3}, new int[]{1, 3}, 3);
        this.checkBroadcastShape((Dataset)a, "[1,3] as [1,3]", new int[]{1, 3}, new int[]{1, 3}, 1, 3);
        this.checkBroadcastShape((Dataset)a, "[1,3] as [3,4]", null, null, 3, 4);
        this.checkBroadcastShape((Dataset)a, "[1,3] as [4,3]", new int[]{1, 3}, new int[]{4, 3}, 4, 3);
        this.checkBroadcastShape((Dataset)a, "[1,3] as [6,4,3]", new int[]{1, 1, 3}, new int[]{6, 4, 3}, 6, 4, 3);
        this.checkBroadcastShape((Dataset)a, "[1,3] as [3,4,6]", null, null, 3, 4, 6);
    }

    private void checkBroadcastShape(Dataset a, String msg, int[] bShape, int[] cShape, int ... newShape) {
        int[][] nArrayArray;
        if (bShape == null && cShape == null) {
            nArrayArray = null;
        } else {
            int[][] nArrayArray2 = new int[2][];
            nArrayArray2[0] = bShape;
            nArrayArray = nArrayArray2;
            nArrayArray2[1] = cShape;
        }
        int[][] answer = nArrayArray;
        int[][] result = BroadcastUtils.calculateBroadcastShapes((int[])a.getShapeRef(), (int)a.getSize(), (int[])newShape);
        Assert.assertArrayEquals((String)("Broadcasting " + msg), (Object[])answer, (Object[])result);
    }

    @Test
    public void testBroadcastWithNoOutput() {
        int j;
        Dataset a = DatasetFactory.createRange((double)5.0).reshape(new int[]{5, 1});
        Dataset b = DatasetFactory.createRange((double)2.0, (double)8.0, (double)1.0).reshape(new int[]{1, 6});
        BroadcastIterator it = BroadcastIterator.createIterator((Dataset)a, (Dataset)b);
        Assert.assertArrayEquals((String)"Broadcast shape", (int[])new int[]{5, 6}, (int[])it.getShape());
        DoubleDataset c = DatasetFactory.zeros((int[])it.getShape());
        int i = 0;
        while (i < 5) {
            j = 0;
            while (j < 6) {
                Assert.assertTrue((boolean)it.hasNext());
                c.set((Object)(it.aDouble * it.bDouble), i, j);
                Assert.assertEquals((double)a.getDouble(i, 0), (double)it.aDouble, (double)1.0E-15);
                Assert.assertEquals((double)b.getDouble(0, j), (double)it.bDouble, (double)1.0E-15);
                Assert.assertEquals((double)c.getDouble(i, j), (double)((double)i * ((double)j + 2.0)), (double)1.0E-15);
                ++j;
            }
            ++i;
        }
        b.setShape(new int[]{6});
        it = BroadcastIterator.createIterator((Dataset)a, (Dataset)b);
        Assert.assertArrayEquals((String)"Broadcast shape", (int[])new int[]{5, 6}, (int[])it.getShape());
        c = DatasetFactory.zeros((int[])it.getShape());
        i = 0;
        while (i < 5) {
            j = 0;
            while (j < 6) {
                Assert.assertTrue((boolean)it.hasNext());
                c.set((Object)(it.aDouble * it.bDouble), i, j);
                Assert.assertEquals((double)a.getDouble(i, 0), (double)it.aDouble, (double)1.0E-15);
                Assert.assertEquals((double)b.getDouble(j), (double)it.bDouble, (double)1.0E-15);
                Assert.assertEquals((double)c.getDouble(i, j), (double)((double)i * ((double)j + 2.0)), (double)1.0E-15);
                ++j;
            }
            ++i;
        }
        a = DatasetFactory.ones(ShortDataset.class, (int[])new int[]{1});
        it = BroadcastIterator.createIterator((Dataset)a, (Dataset)b);
        Assert.assertArrayEquals((String)"Broadcast shape", (int[])new int[]{6}, (int[])it.getShape());
        c = DatasetFactory.zeros((int[])it.getShape());
        int j2 = 0;
        while (j2 < 6) {
            Assert.assertTrue((boolean)it.hasNext());
            c.set((Object)(it.aDouble * it.bDouble), j2);
            Assert.assertEquals((double)a.getDouble(0), (double)it.aDouble, (double)1.0E-15);
            Assert.assertEquals((double)b.getDouble(j2), (double)it.bDouble, (double)1.0E-15);
            Assert.assertEquals((double)c.getDouble(j2), (double)((double)j2 + 2.0), (double)1.0E-15);
            ++j2;
        }
        a = DatasetFactory.createFromObject((Object)1);
        it = BroadcastIterator.createIterator((Dataset)a, (Dataset)b);
        Assert.assertArrayEquals((String)"Broadcast shape", (int[])new int[]{6}, (int[])it.getShape());
        c = DatasetFactory.zeros((int[])it.getShape());
        j2 = 0;
        while (j2 < 6) {
            Assert.assertTrue((boolean)it.hasNext());
            c.set((Object)(it.aDouble * it.bDouble), j2);
            Assert.assertEquals((double)a.getDouble(), (double)it.aDouble, (double)1.0E-15);
            Assert.assertEquals((double)b.getDouble(j2), (double)it.bDouble, (double)1.0E-15);
            Assert.assertEquals((double)c.getDouble(j2), (double)((double)j2 + 2.0), (double)1.0E-15);
            ++j2;
        }
        b = DatasetFactory.createFromObject((Object)2);
        it = BroadcastIterator.createIterator((Dataset)a, (Dataset)b);
        it.setOutputDouble(true);
        Assert.assertArrayEquals((String)"Broadcast shape", (int[])new int[0], (int[])it.getShape());
        c = DatasetFactory.zeros((int[])it.getShape());
        Assert.assertTrue((boolean)it.hasNext());
        c.set((Object)(it.aDouble * it.bDouble));
        Assert.assertEquals((double)a.getDouble(), (double)it.aDouble, (double)1.0E-15);
        Assert.assertEquals((double)b.getDouble(), (double)it.bDouble, (double)1.0E-15);
        Assert.assertEquals((double)c.getDouble(), (double)2.0, (double)1.0E-15);
        a = DatasetFactory.createRange((double)5.0).reshape(new int[]{5, 1});
        b = DatasetFactory.createRange((double)2.0, (double)8.0, (double)1.0).getSliceView(new Slice[]{new Slice(null, null, Integer.valueOf(2))});
        it = BroadcastIterator.createIterator((Dataset)a, (Dataset)b);
        Assert.assertArrayEquals((String)"Broadcast shape", (int[])new int[]{5, 3}, (int[])it.getShape());
        c = DatasetFactory.zeros((int[])it.getShape());
        i = 0;
        while (i < 5) {
            j = 0;
            while (j < 3) {
                Assert.assertTrue((boolean)it.hasNext());
                c.set((Object)(it.aDouble * it.bDouble), i, j);
                Assert.assertEquals((double)a.getDouble(i, 0), (double)it.aDouble, (double)1.0E-15);
                Assert.assertEquals((double)b.getDouble(j), (double)it.bDouble, (double)1.0E-15);
                Assert.assertEquals((double)c.getDouble(i, j), (double)((double)i * ((double)(2 * j) + 2.0)), (double)1.0E-15);
                ++j;
            }
            ++i;
        }
    }

    @Test
    public void testBroadcastWithOutput() {
        int j;
        Dataset a = DatasetFactory.createRange((double)10.0).reshape(new int[]{10, 1});
        Dataset b = DatasetFactory.createRange((double)2.0, (double)14.0, (double)1.0).reshape(new int[]{1, 12});
        DoubleDataset c = DatasetFactory.zeros((int[])new int[]{10, 12});
        BroadcastIterator it = BroadcastIterator.createIterator((Dataset)a, (Dataset)b, (Dataset)c);
        Assert.assertArrayEquals((String)"Broadcast shape", (int[])new int[]{10, 12}, (int[])it.getShape());
        int i = 0;
        while (i < 10) {
            j = 0;
            while (j < 12) {
                Assert.assertTrue((boolean)it.hasNext());
                Assert.assertEquals((double)a.getDouble(i, 0), (double)it.aDouble, (double)1.0E-15);
                Assert.assertEquals((double)b.getDouble(0, j), (double)it.bDouble, (double)1.0E-15);
                c.setObjectAbs(it.oIndex, (Object)(it.aDouble * it.bDouble));
                Assert.assertEquals((double)c.getDouble(i, j), (double)((double)i * ((double)j + 2.0)), (double)1.0E-15);
                ++j;
            }
            ++i;
        }
        a = DatasetFactory.createRange((double)120.0).reshape(new int[]{10, 12});
        b = DatasetFactory.createRange((double)2.0, (double)14.0, (double)1.0).reshape(new int[]{1, 12});
        c = a;
        it = BroadcastIterator.createIterator((Dataset)a, (Dataset)b, (Dataset)c);
        Assert.assertArrayEquals((String)"Broadcast shape", (int[])new int[]{10, 12}, (int[])it.getShape());
        i = 0;
        while (i < 10) {
            j = 0;
            while (j < 12) {
                Assert.assertTrue((boolean)it.hasNext());
                Assert.assertEquals((double)a.getDouble(i, j), (double)it.aDouble, (double)1.0E-15);
                Assert.assertEquals((double)b.getDouble(0, j), (double)it.bDouble, (double)1.0E-15);
                c.setObjectAbs(it.oIndex, (Object)(it.aDouble * it.bDouble));
                Assert.assertEquals((double)c.getDouble(i, j), (double)((double)(i * 12 + j) * ((double)j + 2.0)), (double)1.0E-15);
                ++j;
            }
            ++i;
        }
        a = DatasetFactory.createRange((double)10.0).reshape(new int[]{10, 1});
        b = DatasetFactory.createRange((double)2.0, (double)122.0, (double)1.0).reshape(new int[]{10, 12});
        c = b;
        it = BroadcastIterator.createIterator((Dataset)a, (Dataset)b, (Dataset)c);
        Assert.assertArrayEquals((String)"Broadcast shape", (int[])new int[]{10, 12}, (int[])it.getShape());
        i = 0;
        while (i < 10) {
            j = 0;
            while (j < 12) {
                Assert.assertTrue((boolean)it.hasNext());
                Assert.assertEquals((double)a.getDouble(i, 0), (double)it.aDouble, (double)1.0E-15);
                Assert.assertEquals((double)b.getDouble(i, j), (double)it.bDouble, (double)1.0E-15);
                c.setObjectAbs(it.oIndex, (Object)(it.aDouble * it.bDouble));
                Assert.assertEquals((double)c.getDouble(i, j), (double)((double)i * ((double)(i * 12 + j) + 2.0)), (double)1.0E-15);
                ++j;
            }
            ++i;
        }
        a = DatasetFactory.createRange((double)240.0).reshape(new int[]{20, 12}).getSliceView(new Slice[]{new Slice(null, null, Integer.valueOf(2))});
        b = DatasetFactory.createRange((double)2.0, (double)14.0, (double)1.0).reshape(new int[]{1, 12});
        c = a;
        it = BroadcastIterator.createIterator((Dataset)a, (Dataset)b, (Dataset)c);
        Assert.assertArrayEquals((String)"Broadcast shape", (int[])new int[]{10, 12}, (int[])it.getShape());
        i = 0;
        while (i < 10) {
            j = 0;
            while (j < 12) {
                Assert.assertTrue((boolean)it.hasNext());
                Assert.assertEquals((double)a.getDouble(i, j), (double)it.aDouble, (double)1.0E-15);
                Assert.assertEquals((double)b.getDouble(0, j), (double)it.bDouble, (double)1.0E-15);
                c.setObjectAbs(it.oIndex, (Object)(it.aDouble * it.bDouble));
                Assert.assertEquals((double)c.getDouble(i, j), (double)((double)(24 * i + j) * ((double)j + 2.0)), (double)1.0E-15);
                ++j;
            }
            ++i;
        }
        a = DatasetFactory.createRange((double)12.0);
        b = DatasetFactory.createRange((double)2.0, (double)14.0, (double)1.0);
        c = DatasetFactory.zeros((int[])new int[]{10, 12});
        it = BroadcastIterator.createIterator((Dataset)a, (Dataset)b, (Dataset)c);
        Assert.assertArrayEquals((String)"Broadcast shape", (int[])new int[]{10, 12}, (int[])it.getShape());
        i = 0;
        while (i < 10) {
            j = 0;
            while (j < 12) {
                Assert.assertTrue((boolean)it.hasNext());
                Assert.assertEquals((double)a.getDouble(j), (double)it.aDouble, (double)1.0E-15);
                Assert.assertEquals((double)b.getDouble(j), (double)it.bDouble, (double)1.0E-15);
                c.setObjectAbs(it.oIndex, (Object)(it.aDouble * it.bDouble));
                Assert.assertEquals((double)c.getDouble(i, j), (double)((double)j * ((double)j + 2.0)), (double)1.0E-15);
                ++j;
            }
            ++i;
        }
        c = DatasetFactory.zeros((int)3, CompoundDoubleDataset.class, (int[])new int[]{10, 12});
        it = BroadcastIterator.createIterator((Dataset)a, (Dataset)b, (Dataset)c);
        Assert.assertArrayEquals((String)"Broadcast shape", (int[])new int[]{10, 12}, (int[])it.getShape());
        CompoundDataset cc = (CompoundDataset)c;
        int isc = c.getElementsPerItem();
        double[] ca = new double[isc];
        int i2 = 0;
        while (i2 < 10) {
            int j2 = 0;
            while (j2 < 12) {
                Assert.assertTrue((boolean)it.hasNext());
                Assert.assertEquals((double)a.getDouble(j2), (double)it.aDouble, (double)1.0E-15);
                Assert.assertEquals((double)b.getDouble(j2), (double)it.bDouble, (double)1.0E-15);
                c.setObjectAbs(it.oIndex, (Object)(it.aDouble * it.bDouble));
                Assert.assertEquals((double)c.getDouble(i2, j2), (double)((double)j2 * ((double)j2 + 2.0)), (double)1.0E-15);
                cc.getDoubleArray(ca, i2, j2);
                int k = 1;
                while (k < isc) {
                    Assert.assertEquals((double)ca[k], (double)ca[0], (double)1.0E-15);
                    ++k;
                }
                ++j2;
            }
            ++i2;
        }
    }

    @Test
    public void testPair() {
        DoubleDataset a = DatasetFactory.zeros((int[])new int[]{5, 3});
        DoubleDataset b = DatasetFactory.createRange((double)1.0, (double)31.0, (double)2.0);
        Dataset bv = b.getSliceView(new Slice[]{new Slice(Integer.valueOf(3), Integer.valueOf(8))});
        BroadcastIterator bit = BroadcastIterator.createIterator((Dataset)a, (Dataset)bv.reshape(new int[]{5, 1}));
        while (bit.hasNext()) {
            Assert.assertEquals((double)a.getElementDoubleAbs(bit.aIndex), (double)bit.aDouble, (double)1.0E-9);
            Assert.assertEquals((double)bv.getElementDoubleAbs(bit.bIndex), (double)bit.bDouble, (double)1.0E-9);
        }
    }
}

