/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.form;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.eclipse.eavp.viz.datastructures.VizObject.IManagedUpdateable;
import org.eclipse.eavp.viz.datastructures.VizObject.IManagedUpdateableListener;
import org.eclipse.eavp.viz.datastructures.VizObject.SubscriptionType;
import org.eclipse.eavp.viz.modeling.FaceController;
import org.eclipse.eavp.viz.modeling.base.BasicController;
import org.eclipse.eavp.viz.modeling.base.BasicMesh;
import org.eclipse.eavp.viz.modeling.base.BasicView;
import org.eclipse.eavp.viz.modeling.base.IController;
import org.eclipse.eavp.viz.service.IVizService;
import org.eclipse.eavp.viz.service.mesh.datastructures.MeshDescription;
import org.eclipse.january.form.Component;
import org.eclipse.january.form.ICEObject;
import org.eclipse.january.form.IComponentVisitor;
import org.eclipse.january.form.IUpdateable;
import org.eclipse.january.form.IUpdateableListener;

@XmlRootElement(name="MeshComponent")
@XmlAccessorType(value=XmlAccessType.NONE)
public class MeshComponent
extends ICEObject
implements Component,
IManagedUpdateableListener {
    private MeshDescription compressedMesh;
    private BasicController mesh = new BasicController(new BasicMesh(), new BasicView());
    private int nextPolygonID = 1;
    private int nextEdgeID = 1;
    private int nextVertexID = 1;
    private IVizService service;

    public MeshComponent() {
        this.mesh.register((IManagedUpdateableListener)this);
        this.compressedMesh = null;
        this.service = null;
    }

    public IController getMesh() {
        return this.mesh;
    }

    public void setMesh(BasicController newMesh) {
        this.mesh = newMesh;
        this.mesh.register((IManagedUpdateableListener)this);
    }

    public void addPolygon(FaceController polygon) {
        this.mesh.addEntity((IController)polygon);
        this.notifyListeners();
    }

    public void removePolygon(FaceController polygon) {
        this.mesh.removeEntity((IController)polygon);
        this.notifyListeners();
    }

    @XmlElement
    private MeshDescription getCompressedMesh() {
        return new MeshDescription((IController)this.mesh);
    }

    public List<IController> getPolygons() {
        return this.mesh.getEntities();
    }

    public int getNextPolygonId() {
        int temp = this.nextPolygonID++;
        return temp;
    }

    public int getNextVertexId() {
        int temp = this.nextVertexID++;
        return temp;
    }

    public int getNextEdgeId() {
        int temp = this.nextEdgeID++;
        return temp;
    }

    private void setCompressedMesh(MeshDescription description) {
        this.compressedMesh = description;
    }

    public void setService(IVizService service) {
        this.service = service;
        if (this.compressedMesh != null) {
            this.mesh = (BasicController)this.compressedMesh.unpack(service.getControllerProviderFactory());
            this.mesh.register((IManagedUpdateableListener)this);
            this.compressedMesh = null;
        }
    }

    @Override
    public int hashCode() {
        return this.mesh.hashCode();
    }

    @Override
    public boolean equals(Object otherObject) {
        boolean equals = false;
        if (this == otherObject) {
            equals = true;
        } else if (otherObject != null && otherObject instanceof MeshComponent) {
            MeshComponent component = (MeshComponent)otherObject;
            equals = super.equals(otherObject) && this.mesh.equals((Object)component.mesh);
        }
        return equals;
    }

    public void copy(MeshComponent component) {
        if (component != null) {
            super.copy(component);
            this.mesh.copy((IController)component.mesh);
            this.notifyListeners();
        }
    }

    @Override
    public Object clone() {
        MeshComponent object = new MeshComponent();
        object.copy(this);
        return object;
    }

    @Override
    public void accept(IComponentVisitor visitor) {
        if (visitor != null) {
            visitor.visit(this);
        }
    }

    private void notifyListeners(final IUpdateable component) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            Thread notifierThread = new Thread(){

                @Override
                public void run() {
                    int i = 0;
                    while (i < MeshComponent.this.listeners.size()) {
                        ((IUpdateableListener)MeshComponent.this.listeners.get(i)).update(component);
                        ++i;
                    }
                }
            };
            notifierThread.start();
        }
    }

    public void update(IManagedUpdateable component, SubscriptionType[] types) {
        if (types.length != 1 || !SubscriptionType.PROPERTY.equals((Object)types[0])) {
            this.notifyListeners();
        } else {
            this.notifyListeners(new ICEObject());
        }
    }

    public ArrayList<SubscriptionType> getSubscriptions(IManagedUpdateable source) {
        ArrayList<SubscriptionType> types = new ArrayList<SubscriptionType>();
        types.add(SubscriptionType.CHILD);
        types.add(SubscriptionType.PROPERTY);
        types.add(SubscriptionType.TRANSFORMATION);
        return types;
    }
}

