/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.geometry.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.BasicInternalEList;
import org.eclipse.january.geometry.GeometryFactory;
import org.eclipse.january.geometry.GeometryPackage;
import org.eclipse.january.geometry.Triangle;
import org.eclipse.january.geometry.Tube;
import org.eclipse.january.geometry.Vertex;
import org.eclipse.january.geometry.impl.ShapeImpl;
import org.eclipse.january.geometry.util.MeshUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TubeImpl
extends ShapeImpl
implements Tube {
    private static final Logger logger = LoggerFactory.getLogger(TubeImpl.class);
    protected static final double HEIGHT_EDEFAULT = 0.0;
    protected double height = 0.0;
    protected static final double INNER_RADIUS_EDEFAULT = 0.0;
    protected double innerRadius = 0.0;
    protected static final double RADIUS_EDEFAULT = 0.0;
    protected double radius = 0.0;
    protected double prevHeight;
    protected double prevInnerRadius;
    protected double prevRadius;
    protected final int SEGMENTS = 15;
    protected final int RESOLUTION = 25;

    protected TubeImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return GeometryPackage.Literals.TUBE;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(double newHeight) {
        if (newHeight != this.height) {
            double oldHeight = this.height;
            this.height = newHeight;
            if (this.properties.get("height") == null || (Double)this.properties.get("height") != this.height) {
                this.properties.put("height", this.height);
            }
            if (this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, oldHeight, this.height));
            }
        }
    }

    @Override
    public double getInnerRadius() {
        return this.innerRadius;
    }

    @Override
    public void setInnerRadius(double newInnerRadius) {
        if (newInnerRadius != this.innerRadius && (newInnerRadius <= this.radius || this.properties.get("innerRadius") == null)) {
            double oldInnerRadius = this.innerRadius;
            this.innerRadius = newInnerRadius;
            if (this.properties.get("innerRadius") == null || (Double)this.properties.get("innerRadius") != this.innerRadius) {
                this.properties.put("innerRadius", this.innerRadius);
            }
            if (this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, oldInnerRadius, this.innerRadius));
            }
        } else {
            logger.error("Attempted to set tube " + this.name + " " + this.id + "'s inner radius to " + newInnerRadius + " while radius was " + this.radius + ", but a  tube's radius must be no less than its inner radius.");
        }
    }

    @Override
    public double getRadius() {
        return this.radius;
    }

    @Override
    public void setRadius(double newRadius) {
        if (newRadius != this.radius && newRadius >= this.innerRadius) {
            double oldRadius = this.radius;
            this.radius = newRadius;
            if (this.properties.get("radius") == null || (Double)this.properties.get("radius") != this.radius) {
                this.properties.put("radius", this.radius);
            }
            if (this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, oldRadius, this.radius));
            }
        } else {
            logger.error("Attempted to set tube " + this.name + " " + this.id + "'s radius to " + newRadius + " while inner radius was " + this.innerRadius + ", but a  tube's radius must be no less than its inner radius.");
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 8: {
                return this.getHeight();
            }
            case 9: {
                return this.getInnerRadius();
            }
            case 10: {
                return this.getRadius();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 8: {
                this.setHeight((Double)newValue);
                return;
            }
            case 9: {
                this.setInnerRadius((Double)newValue);
                return;
            }
            case 10: {
                this.setRadius((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 8: {
                this.setHeight(0.0);
                return;
            }
            case 9: {
                this.setInnerRadius(0.0);
                return;
            }
            case 10: {
                this.setRadius(0.0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 8: {
                return this.height != 0.0;
            }
            case 9: {
                return this.innerRadius != 0.0;
            }
            case 10: {
                return this.radius != 0.0;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (height: ");
        result.append(this.height);
        result.append(", innerRadius: ");
        result.append(this.innerRadius);
        result.append(", radius: ");
        result.append(this.radius);
        result.append(')');
        return result.toString();
    }

    @Override
    public EList<Triangle> getTriangles() {
        if (this.prevHeight == this.height && this.prevInnerRadius == this.innerRadius && this.prevRadius == this.radius && this.triangles != null && !this.triangles.isEmpty()) {
            if (this.triangles != null) {
                return this.triangles;
            }
            this.triangles = new BasicInternalEList(Triangle.class);
            return this.triangles;
        }
        this.prevRadius = this.radius;
        if (this.triangles == null) {
            this.triangles = new BasicInternalEList(Triangle.class);
        } else {
            this.triangles.clear();
        }
        double[] vertices = MeshUtils.createTube(this.height, this.innerRadius, this.radius, 25, 15);
        this.triangles.addAll(MeshUtils.createTubeMesh(vertices, 25, 15));
        for (Triangle tri : this.triangles) {
            Vertex normal = tri.getNormal();
            EList<Vertex> currVertices = tri.getVertices();
            Vertex v0 = (Vertex)currVertices.get(0);
            Vertex v1 = (Vertex)currVertices.get(1);
            Vertex v2 = (Vertex)currVertices.get(2);
            normal.setX((v0.getX() + v1.getX() + v2.getX()) / 3.0);
            normal.setY((v0.getY() + v1.getY() + v2.getY()) / 3.0);
            normal.setZ((v0.getZ() + v1.getZ() + v2.getZ()) / 3.0);
        }
        return this.triangles;
    }

    @Override
    public void setProperty(String property, double value) {
        if ("height".equals(property)) {
            this.setHeight(value);
        } else if ("innerRadius".equals(property)) {
            this.setInnerRadius(value);
        } else if ("radius".equals(property)) {
            this.setRadius(value);
        }
        super.setProperty(property, value);
    }

    @Override
    public Object clone() {
        Tube clone = GeometryFactory.eINSTANCE.createTube();
        clone.copy(this);
        return clone;
    }
}

