/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.math3.complex.Complex;
import org.eclipse.january.dataset.AbstractDataset;
import org.eclipse.january.dataset.BooleanIterator;
import org.eclipse.january.dataset.BroadcastIterator;
import org.eclipse.january.dataset.BroadcastSelfIterator;
import org.eclipse.january.dataset.DTypeUtils;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.IntegerIterator;
import org.eclipse.january.dataset.IntegersIterator;
import org.eclipse.january.dataset.PositionIterator;
import org.eclipse.january.dataset.ShapeUtils;
import org.eclipse.january.dataset.Slice;
import org.eclipse.january.dataset.SliceIterator;

public class LongDataset
extends AbstractDataset {
    private static final long serialVersionUID = -6891075135217265625L;
    protected long[] data;

    @Override
    protected void setData() {
        this.data = (long[])this.odata;
    }

    protected static long[] createArray(int size) {
        long[] array = null;
        try {
            array = new long[size];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            logger.error("The size of the dataset ({}) that is being created is too large and there is not enough memory to hold it.", (Object)size);
            throw new OutOfMemoryError("The dimensions given are too large, and there is not enough memory available in the Java Virtual Machine");
        }
        return array;
    }

    @Override
    public int getDType() {
        return 4;
    }

    LongDataset() {
    }

    LongDataset(int ... shape) {
        if (shape != null) {
            if (shape.length == 1) {
                this.size = shape[0];
                if (this.size < 0) {
                    throw new IllegalArgumentException("Negative component in shape is not allowed");
                }
            } else {
                this.size = ShapeUtils.calcSize(shape);
            }
            this.shape = (int[])shape.clone();
            try {
                this.data = LongDataset.createArray(this.size);
                this.odata = this.data;
            }
            catch (Throwable t) {
                logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(shape), (Object)t);
                throw new IllegalArgumentException(t);
            }
        }
    }

    LongDataset(long[] data, int ... shape) {
        if (data == null) {
            throw new IllegalArgumentException("Data must not be null");
        }
        if (shape == null || shape.length == 0) {
            shape = new int[]{data.length};
        }
        this.size = ShapeUtils.calcSize(shape);
        if (this.size != data.length) {
            throw new IllegalArgumentException(String.format("Shape %s is not compatible with size of data array, %d", Arrays.toString(shape), data.length));
        }
        this.shape = this.size == 0 ? null : (int[])shape.clone();
        this.data = data;
        this.odata = data;
    }

    LongDataset(LongDataset dataset) {
        LongDataset.copyToView(dataset, this, true, true);
        try {
            if (dataset.stride == null) {
                this.data = (long[])dataset.data.clone();
                this.odata = this.data;
            } else {
                this.offset = 0;
                this.stride = null;
                this.base = null;
                this.data = LongDataset.createArray(this.size);
                this.odata = this.data;
                IndexIterator iter = dataset.getIterator();
                int i = 0;
                while (iter.hasNext()) {
                    this.data[i] = dataset.data[iter.index];
                    ++i;
                }
            }
        }
        catch (Throwable t) {
            logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(this.shape), (Object)t);
            throw new IllegalArgumentException(t);
        }
    }

    LongDataset(Dataset dataset) {
        LongDataset.copyToView(dataset, this, true, false);
        this.offset = 0;
        this.stride = null;
        this.base = null;
        try {
            this.data = LongDataset.createArray(this.size);
            this.odata = this.data;
        }
        catch (Throwable t) {
            logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(this.shape), (Object)t);
            throw new IllegalArgumentException(t);
        }
        IndexIterator iter = dataset.getIterator();
        int i = 0;
        while (iter.hasNext()) {
            this.data[i] = dataset.getElementLongAbs(iter.index);
            ++i;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getRank() == 0 && !this.getClass().equals(obj.getClass())) {
            return true;
        }
        LongDataset other = (LongDataset)obj;
        IndexIterator iter = this.getIterator();
        IndexIterator oiter = other.getIterator();
        while (iter.hasNext() && oiter.hasNext()) {
            if (this.data[iter.index] == other.data[oiter.index]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public LongDataset clone() {
        return new LongDataset(this);
    }

    static LongDataset createFromObject(Object obj) {
        LongDataset result = new LongDataset();
        if (obj != null) {
            result.shape = ShapeUtils.getShapeFromObject(obj);
            result.size = ShapeUtils.calcSize(result.shape);
            try {
                result.data = LongDataset.createArray(result.size);
                result.odata = result.data;
            }
            catch (Throwable t) {
                logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(result.shape), (Object)t);
                throw new IllegalArgumentException(t);
            }
            int[] pos = new int[result.shape.length];
            result.fillData(obj, 0, pos);
        }
        return result;
    }

    static LongDataset createRange(double stop) {
        return LongDataset.createRange(0.0, stop, 1.0);
    }

    static LongDataset createRange(double start, double stop, double step) {
        int size = LongDataset.calcSteps(start, stop, step);
        LongDataset result = new LongDataset(size);
        int i = 0;
        while (i < size) {
            result.data[i] = (long)(start + (double)i * step);
            ++i;
        }
        return result;
    }

    static LongDataset ones(int ... shape) {
        return new LongDataset(shape).fill(1);
    }

    @Override
    public LongDataset fill(Object obj) {
        long dv = DTypeUtils.toLong(obj);
        IndexIterator iter = this.getIterator();
        while (iter.hasNext()) {
            this.data[iter.index] = dv;
        }
        this.setDirty();
        return this;
    }

    public long[] getData() {
        return this.data;
    }

    @Override
    protected int getBufferLength() {
        if (this.data == null) {
            return 0;
        }
        return this.data.length;
    }

    @Override
    public LongDataset getView(boolean deepCopyMetadata) {
        LongDataset view = new LongDataset();
        LongDataset.copyToView(this, view, true, deepCopyMetadata);
        view.setData();
        return view;
    }

    public long getAbs(int index) {
        return this.data[index];
    }

    @Override
    public boolean getElementBooleanAbs(int index) {
        return this.data[index] != 0L;
    }

    @Override
    public double getElementDoubleAbs(int index) {
        return this.data[index];
    }

    @Override
    public long getElementLongAbs(int index) {
        return this.data[index];
    }

    @Override
    public Object getObjectAbs(int index) {
        return this.data[index];
    }

    @Override
    public String getStringAbs(int index) {
        return this.stringFormat == null ? String.format("%d", this.data[index]) : this.stringFormat.format(this.data[index]);
    }

    public void setAbs(int index, long val) {
        this.data[index] = val;
        this.setDirty();
    }

    @Override
    protected void setItemDirect(int dindex, int sindex, Object src) {
        long[] dsrc = (long[])src;
        this.data[dindex] = dsrc[sindex];
    }

    @Override
    public void setObjectAbs(int index, Object obj) {
        if (index < 0 || index > this.data.length) {
            throw new IndexOutOfBoundsException("Index given is outside dataset");
        }
        this.setAbs(index, DTypeUtils.toLong(obj));
    }

    public long get(int i) {
        return this.data[this.get1DIndex(i)];
    }

    public long get(int i, int j) {
        return this.data[this.get1DIndex(i, j)];
    }

    public long get(int ... pos) {
        return this.data[this.get1DIndex(pos)];
    }

    @Override
    public Object getObject(int i) {
        return this.get(i);
    }

    @Override
    public Object getObject(int i, int j) {
        return this.get(i, j);
    }

    @Override
    public Object getObject(int ... pos) {
        return this.get(pos);
    }

    @Override
    public String getString(int i) {
        return this.getStringAbs(this.get1DIndex(i));
    }

    @Override
    public String getString(int i, int j) {
        return this.getStringAbs(this.get1DIndex(i, j));
    }

    @Override
    public String getString(int ... pos) {
        return this.getStringAbs(this.get1DIndex(pos));
    }

    @Override
    public double getDouble(int i) {
        return this.get(i);
    }

    @Override
    public double getDouble(int i, int j) {
        return this.get(i, j);
    }

    @Override
    public double getDouble(int ... pos) {
        return this.get(pos);
    }

    @Override
    public float getFloat(int i) {
        return this.get(i);
    }

    @Override
    public float getFloat(int i, int j) {
        return this.get(i, j);
    }

    @Override
    public float getFloat(int ... pos) {
        return this.get(pos);
    }

    @Override
    public long getLong(int i) {
        return this.get(i);
    }

    @Override
    public long getLong(int i, int j) {
        return this.get(i, j);
    }

    @Override
    public long getLong(int ... pos) {
        return this.get(pos);
    }

    @Override
    public int getInt(int i) {
        return (int)this.get(i);
    }

    @Override
    public int getInt(int i, int j) {
        return (int)this.get(i, j);
    }

    @Override
    public int getInt(int ... pos) {
        return (int)this.get(pos);
    }

    @Override
    public short getShort(int i) {
        return (short)this.get(i);
    }

    @Override
    public short getShort(int i, int j) {
        return (short)this.get(i, j);
    }

    @Override
    public short getShort(int ... pos) {
        return (short)this.get(pos);
    }

    @Override
    public byte getByte(int i) {
        return (byte)this.get(i);
    }

    @Override
    public byte getByte(int i, int j) {
        return (byte)this.get(i, j);
    }

    @Override
    public byte getByte(int ... pos) {
        return (byte)this.get(pos);
    }

    @Override
    public boolean getBoolean(int i) {
        return this.get(i) != 0L;
    }

    @Override
    public boolean getBoolean(int i, int j) {
        return this.get(i, j) != 0L;
    }

    @Override
    public boolean getBoolean(int ... pos) {
        return this.get(pos) != 0L;
    }

    public void setItem(long value, int i) {
        this.setAbs(this.get1DIndex(i), value);
    }

    public void setItem(long value, int i, int j) {
        this.setAbs(this.get1DIndex(i, j), value);
    }

    public void setItem(long value, int ... pos) {
        this.setAbs(this.get1DIndex(pos), value);
    }

    @Override
    public void set(Object obj, int i) {
        this.setItem(DTypeUtils.toLong(obj), i);
    }

    @Override
    public void set(Object obj, int i, int j) {
        this.setItem(DTypeUtils.toLong(obj), i, j);
    }

    @Override
    public void set(Object obj, int ... pos) {
        if (pos == null || pos.length == 0 && this.shape.length > 0) {
            pos = new int[this.shape.length];
        }
        this.setItem(DTypeUtils.toLong(obj), pos);
    }

    @Override
    public void resize(int ... newShape) {
        long[] ndata;
        IndexIterator iter = this.getIterator();
        int nsize = ShapeUtils.calcSize(newShape);
        try {
            ndata = LongDataset.createArray(nsize);
        }
        catch (Throwable t) {
            logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(this.shape), (Object)t);
            throw new IllegalArgumentException(t);
        }
        int i = 0;
        while (iter.hasNext() && i < nsize) {
            ndata[i] = this.data[iter.index];
            ++i;
        }
        this.data = ndata;
        this.odata = ndata;
        this.size = nsize;
        this.shape = newShape;
        this.stride = null;
        this.offset = 0;
        this.base = null;
    }

    @Override
    public LongDataset sort(Integer axis) {
        if (axis == null) {
            if (this.stride == null) {
                Arrays.sort(this.data);
            } else {
                LongDataset ads = this.clone().sort(null);
                this.setSlicedView(this.getView(false), ads);
            }
        } else {
            axis = this.checkAxis(axis);
            LongDataset ads = new LongDataset(this.shape[axis]);
            PositionIterator pi = this.getPositionIterator(axis);
            int[] pos = pi.getPos();
            boolean[] hit = pi.getOmit();
            while (pi.hasNext()) {
                this.copyItemsFromAxes(pos, hit, ads);
                Arrays.sort(ads.data);
                this.setItemsOnAxes(pos, hit, ads.data);
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public LongDataset getUniqueItems() {
        TreeSet<Long> set = new TreeSet<Long>();
        IndexIterator it = this.getIterator();
        while (it.hasNext()) {
            set.add(this.data[it.index]);
        }
        LongDataset u = new LongDataset(set.size());
        int i = 0;
        long[] udata = u.getData();
        for (Long v : set) {
            udata[i++] = v;
        }
        return u;
    }

    @Override
    public LongDataset getSlice(SliceIterator siter) {
        LongDataset result = new LongDataset(siter.getShape());
        long[] rdata = result.data;
        int i = 0;
        while (siter.hasNext()) {
            rdata[i] = this.data[siter.index];
            ++i;
        }
        result.setName(String.valueOf(this.name) + '[' + Slice.createString(siter.shape, siter.start, siter.stop, siter.step) + ']');
        return result;
    }

    @Override
    public void fillDataset(Dataset result, IndexIterator iter) {
        IndexIterator riter = result.getIterator();
        long[] rdata = ((LongDataset)result).data;
        while (riter.hasNext() && iter.hasNext()) {
            rdata[riter.index] = this.data[iter.index];
        }
    }

    @Override
    public LongDataset setByBoolean(Object obj, Dataset selection) {
        if (obj instanceof Dataset) {
            Dataset ds = (Dataset)obj;
            int length = ((Number)selection.sum()).intValue();
            if (length != ds.getSize()) {
                throw new IllegalArgumentException("Number of true items in selection does not match number of items in dataset");
            }
            IndexIterator oiter = ds.getIterator();
            BooleanIterator biter = this.getBooleanIterator(selection);
            while (biter.hasNext() && oiter.hasNext()) {
                this.data[biter.index] = ds.getElementLongAbs(oiter.index);
            }
        } else {
            long dv = DTypeUtils.toLong(obj);
            BooleanIterator biter = this.getBooleanIterator(selection);
            while (biter.hasNext()) {
                this.data[biter.index] = dv;
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public LongDataset setBy1DIndex(Object obj, Dataset index) {
        if (obj instanceof Dataset) {
            Dataset ds = (Dataset)obj;
            if (index.getSize() != ds.getSize()) {
                throw new IllegalArgumentException("Number of items in index dataset does not match number of items in dataset");
            }
            IndexIterator oiter = ds.getIterator();
            IntegerIterator iter = new IntegerIterator(index, this.size);
            while (iter.hasNext() && oiter.hasNext()) {
                this.data[iter.index] = ds.getElementLongAbs(oiter.index);
            }
        } else {
            long dv = DTypeUtils.toLong(obj);
            IntegerIterator iter = new IntegerIterator(index, this.size);
            while (iter.hasNext()) {
                this.data[iter.index] = dv;
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public LongDataset setByIndexes(Object obj, Object ... indexes) {
        IntegersIterator iter = new IntegersIterator(this.shape, indexes);
        int[] pos = iter.getPos();
        if (obj instanceof Dataset) {
            Dataset ds = (Dataset)obj;
            if (ShapeUtils.calcSize(iter.getShape()) != ds.getSize()) {
                throw new IllegalArgumentException("Number of items in index datasets does not match number of items in dataset");
            }
            IndexIterator oiter = ds.getIterator();
            while (iter.hasNext() && oiter.hasNext()) {
                this.setItem(ds.getElementLongAbs(oiter.index), pos);
            }
        } else {
            long dv = DTypeUtils.toLong(obj);
            while (iter.hasNext()) {
                this.setItem(dv, pos);
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    LongDataset setSlicedView(Dataset view, Dataset d) {
        BroadcastSelfIterator it = BroadcastSelfIterator.createIterator(view, d);
        while (it.hasNext()) {
            this.data[it.aIndex] = it.bLong;
        }
        return this;
    }

    @Override
    public LongDataset setSlice(Object obj, IndexIterator siter) {
        if (obj instanceof IDataset) {
            IDataset ds = (IDataset)obj;
            int[] oshape = ds.getShape();
            if (!ShapeUtils.areShapesCompatible(siter.getShape(), oshape)) {
                throw new IllegalArgumentException(String.format("Input dataset is not compatible with slice: %s cf %s", Arrays.toString(oshape), Arrays.toString(siter.getShape())));
            }
            if (ds instanceof Dataset) {
                Dataset ads = (Dataset)ds;
                IndexIterator oiter = ads.getIterator();
                while (siter.hasNext() && oiter.hasNext()) {
                    this.data[siter.index] = ads.getElementLongAbs(oiter.index);
                }
            } else {
                PositionIterator oiter = new PositionIterator(oshape);
                int[] pos = ((IndexIterator)oiter).getPos();
                while (siter.hasNext() && ((IndexIterator)oiter).hasNext()) {
                    this.data[siter.index] = ds.getLong(pos);
                }
            }
        } else {
            try {
                long v = DTypeUtils.toLong(obj);
                while (siter.hasNext()) {
                    this.data[siter.index] = v;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("Object for setting slice is not a dataset or number");
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void copyItemsFromAxes(int[] pos, boolean[] axes, Dataset dest) {
        ddata = (long[])dest.getBuffer();
        siter = this.getSliceIteratorFromAxes(pos, axes);
        sshape = ShapeUtils.squeezeShape(siter.getShape(), false);
        diter = dest.getSliceIterator(null, sshape, null);
        if (ddata.length >= ShapeUtils.calcSize(sshape)) ** GOTO lbl8
        throw new IllegalArgumentException("destination array is not large enough");
lbl-1000:
        // 1 sources

        {
            ddata[diter.index] = this.data[siter.index];
lbl8:
            // 2 sources

            ** while (siter.hasNext() && diter.hasNext())
        }
lbl9:
        // 1 sources

    }

    @Override
    public void setItemsOnAxes(int[] pos, boolean[] axes, Object src) {
        long[] sdata = (long[])src;
        SliceIterator siter = this.getSliceIteratorFromAxes(pos, axes);
        if (sdata.length < ShapeUtils.calcSize(siter.getShape())) {
            throw new IllegalArgumentException("destination array is not large enough");
        }
        int i = 0;
        while (siter.hasNext()) {
            this.data[siter.index] = sdata[i];
            ++i;
        }
        this.setDirty();
    }

    @Override
    protected Number fromDoubleToNumber(double x) {
        long r = (long)x;
        return r;
    }

    private List<int[]> findPositions(long value) {
        IndexIterator iter = this.getIterator(true);
        ArrayList<int[]> posns = new ArrayList<int[]>();
        int[] pos = iter.getPos();
        while (iter.hasNext()) {
            if (this.data[iter.index] != value) continue;
            posns.add((int[])pos.clone());
        }
        return posns;
    }

    @Override
    public int[] maxPos(boolean ignoreInvalids) {
        if (this.storedValues == null || this.storedValues.isEmpty()) {
            this.calculateMaxMin(ignoreInvalids, ignoreInvalids);
        }
        String n = LongDataset.storeName(ignoreInvalids, ignoreInvalids, "maxPos");
        Object o = this.storedValues.get(n);
        List<int[]> max = null;
        if (o == null) {
            max = this.findPositions(this.max(ignoreInvalids).longValue());
            this.storedValues.put(n, max);
        } else if (o instanceof List) {
            max = (List<int[]>)o;
        } else {
            throw new InternalError("Inconsistent internal state of stored values for statistics calculation");
        }
        return (int[])max.get(0);
    }

    @Override
    public int[] minPos(boolean ignoreInvalids) {
        if (this.storedValues == null || this.storedValues.isEmpty()) {
            this.calculateMaxMin(ignoreInvalids, ignoreInvalids);
        }
        String n = LongDataset.storeName(ignoreInvalids, ignoreInvalids, "minPos");
        Object o = this.storedValues.get(n);
        List<int[]> min = null;
        if (o == null) {
            min = this.findPositions(this.min(ignoreInvalids).longValue());
            this.storedValues.put(n, min);
        } else if (o instanceof List) {
            min = (List<int[]>)o;
        } else {
            throw new InternalError("Inconsistent internal state of stored values for statistics calculation");
        }
        return (int[])min.get(0);
    }

    @Override
    public boolean containsNans() {
        return false;
    }

    @Override
    public boolean containsInfs() {
        return false;
    }

    @Override
    public boolean containsInvalidNumbers() {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public LongDataset iadd(Object b) {
        block7: {
            block6: {
                bds = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b);
                useLong = bds.getElementClass().equals(Long.class);
                if (bds.getSize() != 1) break block6;
                it = this.getIterator();
                if (useLong) {
                    lb = bds.getElementLongAbs(0);
                    while (it.hasNext()) {
                        v0 = it.index;
                        this.data[v0] = this.data[v0] + lb;
                    }
                } else {
                    db = bds.getElementDoubleAbs(0);
                    while (it.hasNext()) {
                        v1 = it.index;
                        this.data[v1] = (long)((double)this.data[v1] + db);
                    }
                }
                break block7;
            }
            it = BroadcastSelfIterator.createIterator(this, bds);
            it.setOutputDouble(useLong == false);
            if (!useLong) ** GOTO lbl29
            while (it.hasNext()) {
                v2 = it.aIndex;
                this.data[v2] = this.data[v2] + it.bLong;
            }
            break block7;
lbl-1000:
            // 1 sources

            {
                v3 = it.aIndex;
                this.data[v3] = (long)((double)this.data[v3] + it.bDouble);
lbl29:
                // 2 sources

                ** while (it.hasNext())
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public LongDataset isubtract(Object b) {
        Dataset bds = b instanceof Dataset ? (Dataset)b : DatasetFactory.createFromObject(b);
        boolean useLong = bds.getElementClass().equals(Long.class);
        if (bds.getSize() == 1) {
            IndexIterator it = this.getIterator();
            if (useLong) {
                long lb = bds.getElementLongAbs(0);
                while (it.hasNext()) {
                    int n = it.index;
                    this.data[n] = this.data[n] - lb;
                }
            } else {
                double db = bds.getElementDoubleAbs(0);
                while (it.hasNext()) {
                    int n = it.index;
                    this.data[n] = (long)((double)this.data[n] - db);
                }
            }
        } else {
            BroadcastSelfIterator it = BroadcastSelfIterator.createIterator(this, bds);
            if (useLong) {
                it.setOutputDouble(false);
                while (it.hasNext()) {
                    int n = it.aIndex;
                    this.data[n] = this.data[n] - it.bLong;
                }
            } else {
                it.setOutputDouble(true);
                while (it.hasNext()) {
                    int n = it.aIndex;
                    this.data[n] = (long)((double)this.data[n] - it.bDouble);
                }
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public LongDataset imultiply(Object b) {
        block7: {
            block6: {
                bds = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b);
                useLong = bds.getElementClass().equals(Long.class);
                if (bds.getSize() != 1) break block6;
                it = this.getIterator();
                if (useLong) {
                    lb = bds.getElementLongAbs(0);
                    while (it.hasNext()) {
                        v0 = it.index;
                        this.data[v0] = this.data[v0] * lb;
                    }
                } else {
                    db = bds.getElementDoubleAbs(0);
                    while (it.hasNext()) {
                        v1 = it.index;
                        this.data[v1] = (long)((double)this.data[v1] * db);
                    }
                }
                break block7;
            }
            it = BroadcastSelfIterator.createIterator(this, bds);
            it.setOutputDouble(useLong == false);
            if (!useLong) ** GOTO lbl29
            while (it.hasNext()) {
                v2 = it.aIndex;
                this.data[v2] = this.data[v2] * it.bLong;
            }
            break block7;
lbl-1000:
            // 1 sources

            {
                v3 = it.aIndex;
                this.data[v3] = (long)((double)this.data[v3] * it.bDouble);
lbl29:
                // 2 sources

                ** while (it.hasNext())
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public LongDataset idivide(Object b) {
        block13: {
            block12: {
                bds = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b);
                useLong = bds.getElementClass().equals(Long.class);
                if (bds.getSize() != 1) break block12;
                if (useLong) {
                    lb = bds.getElementLongAbs(0);
                    if (lb == 0L) {
                        this.fill(0);
                    } else {
                        it = this.getIterator();
                        while (it.hasNext()) {
                            v0 = it.index;
                            this.data[v0] = this.data[v0] / lb;
                        }
                    }
                } else {
                    db = bds.getElementDoubleAbs(0);
                    if (db == 0.0) {
                        this.fill(0);
                    } else {
                        it = this.getIterator();
                        while (it.hasNext()) {
                            v1 = it.index;
                            this.data[v1] = (long)((double)this.data[v1] / db);
                        }
                    }
                }
                break block13;
            }
            it = BroadcastSelfIterator.createIterator(this, bds);
            it.setOutputDouble(useLong == false);
            if (!useLong) ** GOTO lbl44
            while (it.hasNext()) {
                if (it.bLong == 0L) {
                    this.data[it.aIndex] = 0L;
                    continue;
                }
                v2 = it.aIndex;
                this.data[v2] = this.data[v2] / it.bLong;
            }
            break block13;
lbl-1000:
            // 1 sources

            {
                if (it.bDouble == 0.0) {
                    this.data[it.aIndex] = 0L;
                    continue;
                }
                v3 = it.aIndex;
                this.data[v3] = (long)((double)this.data[v3] / it.bDouble);
lbl44:
                // 3 sources

                ** while (it.hasNext())
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public LongDataset ifloor() {
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public LongDataset iremainder(Object b) {
        block15: {
            block14: {
                bds = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b);
                useLong = bds.getElementClass().equals(Long.class);
                if (bds.getSize() != 1) break block14;
                if (useLong) {
                    lb = bds.getElementLongAbs(0);
                    if (lb == 0L) {
                        this.fill(0);
                    } else {
                        it = this.getIterator();
                        while (it.hasNext()) {
                            v0 = it.index;
                            this.data[v0] = this.data[v0] % lb;
                        }
                    }
                } else {
                    lb = bds.getElementLongAbs(0);
                    if (lb == 0L) {
                        this.fill(0);
                    } else {
                        it = this.getIterator();
                        while (it.hasNext()) {
                            v1 = it.index;
                            this.data[v1] = this.data[v1] % lb;
                        }
                    }
                }
                break block15;
            }
            it = BroadcastSelfIterator.createIterator(this, bds);
            it.setOutputDouble(useLong == false);
            if (!useLong) ** GOTO lbl46
            while (it.hasNext()) {
                try {
                    v2 = it.aIndex;
                    this.data[v2] = this.data[v2] % it.bLong;
                }
                catch (ArithmeticException v3) {
                    this.data[it.aIndex] = 0L;
                }
            }
            break block15;
lbl-1000:
            // 1 sources

            {
                try {
                    v4 = it.aIndex;
                    this.data[v4] = (long)((double)this.data[v4] % it.bDouble);
                    continue;
                }
                catch (ArithmeticException v5) {
                    this.data[it.aIndex] = 0L;
                }
lbl46:
                // 3 sources

                ** while (it.hasNext())
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public LongDataset ipower(Object b) {
        block8: {
            block7: {
                v0 = bds = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b);
                if (bds.getSize() != 1) break block7;
                vr = bds.getElementDoubleAbs(0);
                it = this.getIterator();
                if (!bds.isComplex()) ** GOTO lbl22
                vi = bds.getElementDoubleAbs(1);
                if (vi == 0.0) {
                    while (it.hasNext()) {
                        v = Math.pow(this.data[it.index], vr);
                        this.data[it.index] = Double.isInfinite(v) != false || Double.isNaN(v) != false ? 0L : (long)v;
                    }
                } else {
                    zv = new Complex(vr, vi);
                    while (it.hasNext()) {
                        zd = new Complex((double)this.data[it.index], 0.0);
                        v = zd.pow(zv).getReal();
                        this.data[it.index] = Double.isInfinite(v) != false || Double.isNaN(v) != false ? 0L : (long)v;
                    }
                }
                break block8;
lbl-1000:
                // 1 sources

                {
                    v = Math.pow(this.data[it.index], vr);
                    this.data[it.index] = Double.isInfinite(v) != false || Double.isNaN(v) != false ? 0L : (long)v;
lbl22:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl23:
                // 1 sources

                break block8;
            }
            it = BroadcastIterator.createIterator(this, bds);
            it.setOutputDouble(true);
            if (!bds.isComplex()) ** GOTO lbl36
            while (it.hasNext()) {
                zv = new Complex(it.bDouble, bds.getElementDoubleAbs(it.bIndex + 1));
                v = new Complex(it.aDouble, 0.0).pow(zv).getReal();
                this.data[it.aIndex] = Double.isInfinite(v) != false || Double.isNaN(v) != false ? 0L : (long)v;
            }
            break block8;
lbl-1000:
            // 1 sources

            {
                v = Math.pow(it.aDouble, it.bDouble);
                this.data[it.aIndex] = Double.isInfinite(v) != false || Double.isNaN(v) != false ? 0L : (long)v;
lbl36:
                // 2 sources

                ** while (it.hasNext())
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public double residual(Object b, Dataset w, boolean ignoreNaNs) {
        Dataset bds = b instanceof Dataset ? (Dataset)b : DatasetFactory.createFromObject(b);
        BroadcastIterator it = BroadcastIterator.createIterator(this, bds);
        it.setOutputDouble(true);
        double sum = 0.0;
        double comp = 0.0;
        if (w == null) {
            while (it.hasNext()) {
                double diff = it.aDouble - it.bDouble;
                double err = diff * diff - comp;
                double temp = sum + err;
                comp = temp - sum - err;
                sum = temp;
            }
        } else {
            IndexIterator itw = w.getIterator();
            while (it.hasNext() && itw.hasNext()) {
                double diff = it.aDouble - it.bDouble;
                double err = diff * diff * w.getElementDoubleAbs(itw.index) - comp;
                double temp = sum + err;
                comp = temp - sum - err;
                sum = temp;
            }
        }
        return sum;
    }
}

