/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.antserver.client;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import net.sf.antcontrib.antserver.Command;
import net.sf.antcontrib.antserver.Response;
import net.sf.antcontrib.antserver.Util;
import net.sf.antcontrib.antserver.commands.DisconnectCommand;
import org.apache.tools.ant.Project;

public class Client {
    private String machine;
    private int port;
    private Project project;
    private Socket socket;
    private OutputStream os;
    private InputStream is;
    private ObjectOutputStream oos;
    private ObjectInputStream ois;
    private boolean connected;

    public Client(Project project, String machine, int port) {
        this.machine = machine;
        this.port = port;
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws IOException {
        block20: {
            this.project.log("Opening connection to " + this.machine + ":" + this.port, 4);
            try {
                this.socket = new Socket(this.machine, this.port);
                this.socket.setKeepAlive(true);
                this.project.log("Got connection to " + this.machine + ":" + this.port, 4);
                this.os = this.socket.getOutputStream();
                this.is = this.socket.getInputStream();
                this.oos = new ObjectOutputStream(this.os);
                this.ois = new ObjectInputStream(this.is);
                this.connected = true;
                try {
                    this.ois.readObject();
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                Object var3_2 = null;
                if (this.connected) break block20;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (!this.connected) {
                    try {
                        if (this.os != null) {
                            this.os.close();
                        }
                        this.os = null;
                        this.oos = null;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        if (this.is != null) {
                            this.is.close();
                        }
                        this.is = null;
                        this.ois = null;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        if (this.socket != null) {
                            this.socket.close();
                        }
                        this.socket = null;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                if (this.os != null) {
                    this.os.close();
                }
                this.os = null;
                this.oos = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (this.is != null) {
                    this.is.close();
                }
                this.is = null;
                this.ois = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
                this.socket = null;
            }
            catch (IOException iOException) {}
        }
    }

    public void shutdown() {
        try {
            if (this.os != null) {
                this.os.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.os = null;
        this.oos = null;
        try {
            if (this.is != null) {
                this.is.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.is = null;
        this.ois = null;
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.socket = null;
        this.connected = false;
    }

    public void disconnect() throws IOException {
        if (!this.connected) {
            return;
        }
        try {
            this.oos.writeObject(DisconnectCommand.DISCONNECT_COMMAND);
            try {
                this.ois.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            this.shutdown();
        }
        catch (SocketException socketException) {
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public Response sendCommand(Command command) throws IOException {
        this.project.log("Sending command: " + command, 4);
        this.oos.writeObject(command);
        if (command.getContentLength() > 0L) {
            Util.transferBytes(command.getContentStream(), command.getContentLength(), this.os, true);
        }
        Response response = null;
        try {
            response = (Response)this.ois.readObject();
            this.project.log("Received Response: " + response, 4);
            if (response.getContentLength() != 0L) {
                command.respond(this.project, response.getContentLength(), this.is);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return response;
    }
}

