/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.framework.junit.extensions;

import jakarta.enterprise.inject.spi.CDI;
import java.util.logging.Logger;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;

public class CDIConditionExtension
implements ExecutionCondition {
    private static final Logger log = Logger.getLogger(CDIConditionExtension.class.getCanonicalName());

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        if (!Boolean.parseBoolean(context.getConfigurationParameter("insideArquillian").orElse("false"))) {
            log.info("Outside Jakarta EE Platform, waiting to test CDI provider until inside.");
            return ConditionEvaluationResult.enabled((String)"Deploying test to container.");
        }
        log.info("Inside Jakarta EE Platform, testing CDI provider.");
        try {
            CDI.current();
            return ConditionEvaluationResult.enabled((String)"CDI provider is available");
        }
        catch (IllegalStateException e) {
            return ConditionEvaluationResult.disabled((String)"CDI provider is not available");
        }
        catch (Throwable t) {
            return ConditionEvaluationResult.disabled((String)"CDI provider available state unknown", (String)t.getLocalizedMessage());
        }
    }
}

