/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ManagedScheduledExecutorService.resourcedef;

import ee.jakarta.tck.concurrent.common.context.IntContext;
import ee.jakarta.tck.concurrent.common.context.StringContext;
import ee.jakarta.tck.concurrent.framework.TestServlet;
import ee.jakarta.tck.concurrent.spec.ManagedScheduledExecutorService.resourcedef.ReqBean;
import jakarta.annotation.Resource;
import jakarta.enterprise.concurrent.ContextService;
import jakarta.enterprise.concurrent.CronTrigger;
import jakarta.enterprise.concurrent.LastExecution;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorDefinition;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorService;
import jakarta.enterprise.concurrent.Trigger;
import jakarta.enterprise.concurrent.ZonedTrigger;
import jakarta.inject.Inject;
import jakarta.servlet.annotation.WebServlet;
import jakarta.transaction.UserTransaction;
import java.time.DayOfWeek;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.testng.Assert;

@ManagedScheduledExecutorDefinition.List(value={@ManagedScheduledExecutorDefinition(name="java:app/concurrent/ScheduledExecutorA", context="java:app/concurrent/ContextA", maxAsync=3, hungTaskThreshold=360000L), @ManagedScheduledExecutorDefinition(name="java:module/concurrent/ScheduledExecutorB", context="java:module/concurrent/ContextB", maxAsync=4), @ManagedScheduledExecutorDefinition(name="java:comp/concurrent/ScheduledExecutorC")})
@WebServlet(value={"/ManagedScheduledExecutorDefinitionServlet"})
public class ManagedScheduledExecutorDefinitionServlet
extends TestServlet {
    private static final long serialVersionUID = 1L;
    private static final long MAX_WAIT_SECONDS = TimeUnit.MINUTES.toSeconds(2L);
    @Inject
    ReqBean reqBean;
    @Resource
    UserTransaction tx;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAsyncCompletionStageMSE() throws Throwable {
        ManagedScheduledExecutorService executor = (ManagedScheduledExecutorService)InitialContext.doLookup("java:app/concurrent/ScheduledExecutorA");
        try {
            IntContext.set(100);
            StringContext.set("testAsyncCompletionStageMSE-1");
            CompletionStage future = ((CompletableFuture)executor.supplyAsync(() -> {
                try {
                    ManagedScheduledExecutorService mes = (ManagedScheduledExecutorService)InitialContext.doLookup("java:app/concurrent/ScheduledExecutorA");
                    return "Application context " + (mes == null ? "incorrect" : "propagated");
                }
                catch (NamingException x) {
                    throw new CompletionException(x);
                }
            }).applyToEitherAsync((CompletionStage)executor.newIncompleteFuture(), status -> {
                int i = IntContext.get();
                return status + ";IntContext " + (String)(i == 100 ? "propagated" : "incorrect:" + i);
            })).thenApply(status -> {
                String s = StringContext.get();
                return status + ";StringContext " + (String)("".equals(s) ? "cleared" : "incorrect:" + s);
            });
            IntContext.set(200);
            String result = (String)((CompletableFuture)future).get(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
            Assert.assertEquals((String)result, (String)"Application context propagated;IntContext propagated;StringContext cleared", (String)"Application context and IntContext must be propagated and StringContext must be cleared per ManagedScheduledExecutorDefinition and ContextServiceDefinition config.");
        }
        finally {
            IntContext.set(0);
            StringContext.set(null);
        }
    }

    public void testAsynchronousMethodRunsWithContext() throws Throwable {
        LinkedBlockingQueue results = new LinkedBlockingQueue();
        this.reqBean.lookUpAContextService().thenAccept(results::add);
        Object result = results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
        if (result instanceof Throwable) {
            throw ((Throwable)((Object)new AssertionError())).initCause((Throwable)result);
        }
        Assert.assertTrue((boolean)(result instanceof ContextService), (String)"Application context must be propagated to Asynchronous method per @ManagedScheduledExecutorDefinition config.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAsynchronousMethodWithMaxAsync3() throws Exception {
        CompletableFuture<String> future4;
        CompletableFuture<String> future3;
        CompletableFuture<String> future2;
        CompletableFuture<String> future1;
        Semaphore invocationsStarted = new Semaphore(0);
        CountDownLatch blocker = new CountDownLatch(1);
        try {
            StringContext.set("testAsynchronousMethodWithMaxAsync3");
            IntContext.set(303);
            future1 = this.reqBean.awaitAndGetThirdPartyContext(invocationsStarted, blocker);
            future2 = this.reqBean.awaitAndGetThirdPartyContext(invocationsStarted, blocker);
            future3 = this.reqBean.awaitAndGetThirdPartyContext(invocationsStarted, blocker);
            future4 = this.reqBean.awaitAndGetThirdPartyContext(invocationsStarted, blocker);
            Assert.assertEquals((boolean)invocationsStarted.tryAcquire(1, MAX_WAIT_SECONDS, TimeUnit.SECONDS), (boolean)true, (String)"Must be able to run 1 asynchronous method in parallel when maxAsync=3");
            Assert.assertEquals((boolean)invocationsStarted.tryAcquire(1, MAX_WAIT_SECONDS, TimeUnit.SECONDS), (boolean)true, (String)"Must be able to run 2 asynchronous methods in parallel when maxAsync=3");
            Assert.assertEquals((boolean)invocationsStarted.tryAcquire(1, MAX_WAIT_SECONDS, TimeUnit.SECONDS), (boolean)true, (String)"Must be able to run 3 asynchronous methods in parallel when maxAsync=3");
            Assert.assertEquals((boolean)invocationsStarted.tryAcquire(1, 1L, TimeUnit.SECONDS), (boolean)false, (String)"Must not run 4 asynchronous methods in parallel when maxAsync=3");
        }
        finally {
            StringContext.set(null);
            IntContext.set(0);
            blocker.countDown();
        }
        Assert.assertEquals((String)future1.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS), (String)"303", (String)"Third-party context type IntContext must be propagated and StringContext must be cleared on first asynchronous method invocation per the executor and ContextServiceDefinition.");
        Assert.assertEquals((String)future2.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS), (String)"303", (String)"Third-party context type IntContext must be propagated and StringContext must be cleared on second asynchronous method invocation per the executor and ContextServiceDefinition.");
        Assert.assertEquals((String)future3.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS), (String)"303", (String)"Third-party context type IntContext must be propagated and StringContext must be cleared on third asynchronous method invocation per the executor and ContextServiceDefinition.");
        Assert.assertEquals((String)future4.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS), (String)"303", (String)"Third-party context type IntContext must be propagated and StringContext must be cleared on fourth asynchronous method invocation per the executor and ContextServiceDefinition.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCompletedFutureMSE() throws Throwable {
        ManagedScheduledExecutorService executor = (ManagedScheduledExecutorService)InitialContext.doLookup("java:module/concurrent/ScheduledExecutorB");
        IntContext.set(41);
        StringContext.set("testCompletedFutureMSE-1");
        try {
            CompletableFuture stage1a = executor.completedFuture((Object)"java:module");
            CompletableFuture stage1b = executor.completedFuture((Object)"concurrent/ScheduledExecutorB");
            IntContext.set(42);
            StringContext.set("testCompletedFutureMSE-2");
            CompletionStage stage2 = stage1a.thenCombineAsync((CompletionStage)stage1b, (part1, part2) -> {
                try {
                    return InitialContext.doLookup(part1 + "/" + part2).toString();
                }
                catch (NamingException x) {
                    throw new CompletionException(x);
                }
            });
            try {
                String result = (String)((CompletableFuture)stage2).join();
                throw new AssertionError((Object)("Application context must be left unchanged per ManagedExecutorDefinition and ContextServiceDefinition config. Instead, was able to look up " + result));
            }
            catch (CompletionException x) {
                if (!(x.getCause() instanceof NamingException)) {
                    throw x;
                }
                IntContext.set(43);
                StringContext.set("testCompletedFutureMSE-3");
                CompletionStage stage3 = ((CompletableFuture)stage2).exceptionally(failure -> {
                    int i = IntContext.get();
                    String s = StringContext.get();
                    if (failure instanceof CompletionException && failure.getCause() instanceof NamingException) {
                        return "StringContext " + (String)("testCompletedFutureMSE-3".equals(s) ? "propagated" : "incorrect:" + s) + ";IntContext " + (String)(i == 43 ? "unchanged" : "incorrect:" + i);
                    }
                    if (failure == null) {
                        throw new AssertionError((Object)"Missing Throwable argument to exceptionally");
                    }
                    throw new CompletionException((Throwable)failure);
                });
                StringContext.set("testCompletedFutureMSE-4");
                String result = (String)((CompletableFuture)stage3).join();
                Assert.assertEquals((String)result, (String)"StringContext propagated;IntContext unchanged", (String)"StringContext must be propagated and Application context and IntContext must be left unchanged per ManagedScheduledExecutorDefinition and ContextServiceDefinition config.");
                IntContext.set(0);
                StringContext.set(null);
            }
        }
        catch (Throwable throwable) {
            IntContext.set(0);
            StringContext.set(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIncompleteFutureMSE() throws Throwable {
        ManagedScheduledExecutorService executor = (ManagedScheduledExecutorService)InitialContext.doLookup("java:app/concurrent/ScheduledExecutorA");
        StringBuilder results = new StringBuilder();
        try {
            IntContext.set(91);
            StringContext.set("testIncompleteFutureMSE-1");
            CompletableFuture stage1a = executor.newIncompleteFuture();
            CompletableFuture stage1b = executor.newIncompleteFuture();
            IntContext.set(92);
            CompletionStage stage2 = stage1a.thenAcceptBothAsync((CompletionStage)stage1b, (part1, part2) -> {
                try {
                    ManagedScheduledExecutorService mes = (ManagedScheduledExecutorService)InitialContext.doLookup(part1 + "/" + part2);
                    results.append("Application context ").append(mes == null ? "incorrect" : "propagated");
                }
                catch (NamingException x) {
                    throw new CompletionException(x);
                }
                String s = StringContext.get();
                results.append(";StringContext ").append((String)("".equals(s) ? "cleared" : "incorrect:" + s));
            });
            IntContext.set(93);
            CompletionStage stage3 = ((CompletableFuture)stage2).runAfterBothAsync((CompletionStage)stage1b, () -> {
                int i = IntContext.get();
                results.append(";IntContext ").append((String)(i == 93 ? "propagated" : "incorrect:" + i));
            });
            stage1a.complete("java:app");
            stage1b.complete("concurrent/ScheduledExecutorA");
            Assert.assertEquals(((CompletableFuture)stage3).join(), null, (String)"CompletableFuture with Void return type must return null from join.");
            String result = results.toString();
            Assert.assertEquals((String)result, (String)"Application context propagated;StringContext cleared;IntContext propagated", (String)"Application context and IntContext must be propagated and StringContext must be cleared per ManagedScheduledExecutorDefinition and ContextServiceDefinition config.");
        }
        finally {
            IntContext.set(0);
            StringContext.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testManagedScheduledExecutorDefinitionAllAttributes() throws Throwable {
        ManagedScheduledExecutorService executor = (ManagedScheduledExecutorService)InitialContext.doLookup("java:app/concurrent/ScheduledExecutorA");
        LinkedBlockingQueue results = new LinkedBlockingQueue();
        CountDownLatch blocker = new CountDownLatch(1);
        Runnable task = () -> {
            results.add(IntContext.get());
            try {
                blocker.await(MAX_WAIT_SECONDS * 5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException x) {
                throw new CompletionException(x);
            }
        };
        try {
            IntContext.set(33);
            executor.execute(task);
            executor.runAsync(task);
            executor.submit(task);
            executor.submit(task, (Object)"TaskResult");
            Assert.assertEquals(results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS), (Object)33, (String)"ManagedScheduledExecutorService with maxAsync=3 must be able to run an async task.");
            Assert.assertEquals(results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS), (Object)33, (String)"ManagedScheduledExecutorService with maxAsync=3 must be able to run 2 async tasks concurrently.");
            Assert.assertEquals(results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS), (Object)33, (String)"ManagedScheduledExecutorService with maxAsync=3 must be able to run 3 async tasks concurrently.");
            Assert.assertEquals(results.poll(1L, TimeUnit.SECONDS), null, (String)"ManagedScheduledExecutorService with maxAsync=3 must not run 4 async tasks concurrently.");
        }
        finally {
            IntContext.set(0);
            blocker.countDown();
        }
        Assert.assertEquals(results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS), (Object)33, (String)"ManagedScheduledExecutorService with maxAsync=3 must be able to run 4th task after 1st completes.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testManagedScheduledExecutorDefinitionDefaults() throws Throwable {
        ManagedScheduledExecutorService executor = (ManagedScheduledExecutorService)InitialContext.doLookup("java:comp/concurrent/ScheduledExecutorC");
        CountDownLatch blocker = new CountDownLatch(1);
        CountDownLatch allTasksRunning = new CountDownLatch(4);
        Callable<Integer> txCallable = () -> {
            allTasksRunning.countDown();
            UserTransaction tx = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
            int initialStatus = tx.getStatus();
            tx.begin();
            try {
                blocker.await(MAX_WAIT_SECONDS * 5L, TimeUnit.SECONDS);
            }
            finally {
                tx.rollback();
            }
            return initialStatus;
        };
        Function<String, Object> lookupFunction = jndiName -> {
            allTasksRunning.countDown();
            try {
                blocker.await(MAX_WAIT_SECONDS * 5L, TimeUnit.SECONDS);
                return InitialContext.doLookup(jndiName);
            }
            catch (InterruptedException | NamingException x) {
                throw new CompletionException(x);
            }
        };
        try {
            Future txFuture1 = executor.submit(txCallable);
            Future txFuture2 = executor.submit(txCallable);
            CompletionStage lookupFuture1 = executor.completedFuture((Object)"java:comp/concurrent/ScheduledExecutorC").thenApplyAsync(lookupFunction);
            CompletionStage lookupFuture2 = executor.completedFuture((Object)"java:module/concurrent/ScheduledExecutorB").thenApplyAsync(lookupFunction);
            Assert.assertTrue((boolean)allTasksRunning.await(MAX_WAIT_SECONDS, TimeUnit.SECONDS), (String)"ManagedScheduledExecutorService without maxAsync must be able to run async tasks concurrently.");
            blocker.countDown();
            int status = (Integer)txFuture1.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
            Assert.assertEquals((int)status, (int)6, (String)"Transaction context must be cleared from first async Callable task per java:comp/concurrent/ScheduledExecutorC configuration.");
            status = (Integer)txFuture2.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
            Assert.assertEquals((int)status, (int)6, (String)"Transaction context must be cleared from second async Callable task per java:comp/concurrent/ScheduledExecutorC configuration.");
            Assert.assertTrue((boolean)(((CompletableFuture)lookupFuture1).get(MAX_WAIT_SECONDS, TimeUnit.SECONDS) instanceof ManagedScheduledExecutorService), (String)"Application context must be propagated to first async Function per java:comp/concurrent/ScheduledExecutorC configuration.");
            Assert.assertTrue((boolean)(((CompletableFuture)lookupFuture2).get(MAX_WAIT_SECONDS, TimeUnit.SECONDS) instanceof ManagedScheduledExecutorService), (String)"Application context must be propagated to second async Function per java:comp/concurrent/ScheduledExecutorC configuration.");
        }
        finally {
            IntContext.set(0);
            blocker.countDown();
        }
        this.tx.begin();
        try {
            int status = (Integer)executor.getContextService().contextualCallable(txCallable).call();
            Assert.assertEquals((int)status, (int)6, (String)"Transaction context must be cleared from inline contextual Callable per java:comp/concurrent/ScheduledExecutorC configuration.");
        }
        finally {
            this.tx.rollback();
        }
    }

    public void testNotAnAsynchronousMethod() throws Throwable {
        String threadName = Thread.currentThread().getName();
        CompletableFuture<String> future = this.reqBean.notAsynchronous();
        Assert.assertEquals((String)future.join(), (String)threadName, (String)"A method that returns CompletableFuture but is not annotated as @Asynchronous must run inline on the same thread.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScheduleWithCronTrigger() throws Throwable {
        ManagedScheduledExecutorService executor = (ManagedScheduledExecutorService)InitialContext.doLookup("java:comp/concurrent/ScheduledExecutorC");
        ZoneId US_CENTRAL = ZoneId.of("America/Chicago");
        ZoneId US_MOUNTAIN = ZoneId.of("America/Denver");
        CronTrigger everyOtherSecond = new CronTrigger("*/2 * * * JAN-DEC SUN-SAT", US_CENTRAL);
        LinkedBlockingQueue results = new LinkedBlockingQueue();
        ScheduledFuture future = executor.schedule(() -> results.add(InitialContext.doLookup("java:comp/concurrent/ScheduledExecutorC")), (Trigger)everyOtherSecond);
        try {
            CronTrigger weekendsAtNoon6MonthsFromNow = new CronTrigger(US_MOUNTAIN).daysOfWeek(new DayOfWeek[]{DayOfWeek.SATURDAY, DayOfWeek.SUNDAY}).hours(new int[]{12}).months(new Month[]{ZonedDateTime.now(US_MOUNTAIN).plusMonths(6L).getMonth()});
            ScheduledFuture distantFuture = executor.schedule(() -> results.add(InitialContext.doLookup("java:comp/concurrent/ScheduledExecutorC")), (Trigger)weekendsAtNoon6MonthsFromNow);
            long days = distantFuture.getDelay(TimeUnit.DAYS);
            Assert.assertTrue((days > 140L ? 1 : 0) != 0, (String)("Too few days (" + days + ") until the next execution of " + weekendsAtNoon6MonthsFromNow + " which is used by " + distantFuture));
            Assert.assertTrue((days < 190L ? 1 : 0) != 0, (String)("Too many days (" + days + ") until the next execution of " + weekendsAtNoon6MonthsFromNow + " which is used by " + distantFuture));
            Assert.assertTrue((boolean)distantFuture.cancel(true), (String)("Must be able to cancel a repeating task before it runs: " + future));
            Object result = results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
            Assert.assertNotNull(result, (String)("Task scheduled with " + (Trigger)everyOtherSecond + " did not run: " + future));
            Assert.assertTrue((boolean)(result instanceof ManagedScheduledExecutorService), (String)"Application context must be propagated to first execution per java:comp/concurrent/ScheduledExecutorC configuration.");
            result = results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
            Assert.assertNotNull(result, (String)("Task scheduled with " + (Trigger)everyOtherSecond + " did not repeat: " + future));
            Assert.assertTrue((boolean)(result instanceof ManagedScheduledExecutorService), (String)"Application context must be propagated to second execution per java:comp/concurrent/ScheduledExecutorC configuration.");
            result = results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
            Assert.assertNotNull(result, (String)("Task scheduled with " + (Trigger)everyOtherSecond + " did not run 3 times: " + future));
            Assert.assertTrue((boolean)(result instanceof ManagedScheduledExecutorService), (String)"Application context must be propagated to third execution per java:comp/concurrent/ScheduledExecutorC configuration.");
            Assert.assertTrue((boolean)future.cancel(true), (String)("Must be able to cancel a repeating task after it executes a few times: " + future));
        }
        finally {
            if (!future.isDone()) {
                future.cancel(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScheduleWithZonedTrigger() throws Exception {
        ManagedScheduledExecutorService executor = (ManagedScheduledExecutorService)InitialContext.doLookup("java:comp/concurrent/ScheduledExecutorC");
        final ZoneId US_CENTRAL = ZoneId.of("America/Chicago");
        final ConcurrentHashMap startAndEndTimes = new ConcurrentHashMap();
        ZonedTrigger monthlyOnThe15th = new ZonedTrigger(){
            final Map<Long, ZonedDateTime> schedule = new ConcurrentHashMap<Long, ZonedDateTime>();

            private void initSchedule() {
                ZonedDateTime sept15 = ZonedDateTime.of(2021, 9, 15, 8, 0, 0, 0, US_CENTRAL);
                ZonedDateTime oct15 = ZonedDateTime.of(2021, 10, 15, 8, 0, 0, 0, US_CENTRAL);
                ZonedDateTime nov15 = ZonedDateTime.of(2021, 11, 15, 8, 0, 0, 0, US_CENTRAL);
                this.schedule.put(0L, sept15);
                this.schedule.put(sept15.toEpochSecond(), oct15);
                this.schedule.put(oct15.toEpochSecond(), nov15);
            }

            public ZonedDateTime getNextRunTime(LastExecution lastExecution, ZonedDateTime scheduledAt) {
                if (lastExecution == null) {
                    this.initSchedule();
                } else {
                    startAndEndTimes.put(lastExecution.getRunStart(US_CENTRAL), lastExecution.getRunEnd(US_CENTRAL));
                }
                long key = lastExecution == null ? 0L : lastExecution.getScheduledStart(US_CENTRAL).toEpochSecond();
                return this.schedule.get(key);
            }

            public ZoneId getZoneId() {
                return US_CENTRAL;
            }
        };
        LinkedBlockingQueue results = new LinkedBlockingQueue();
        ScheduledFuture future = executor.schedule(() -> results.add(InitialContext.doLookup("java:comp/concurrent/ScheduledExecutorC")), (Trigger)monthlyOnThe15th);
        try {
            Object result = results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
            Assert.assertNotNull(result, (String)("Task scheduled with " + (Trigger)monthlyOnThe15th + " did not run: " + future));
            Assert.assertTrue((boolean)(result instanceof ManagedScheduledExecutorService), (String)"Application context must be propagated to first execution per java:comp/concurrent/ScheduledExecutorC configuration.");
            result = results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
            Assert.assertNotNull(result, (String)("Task scheduled with " + (Trigger)monthlyOnThe15th + " did not repeat: " + future));
            Assert.assertTrue((boolean)(result instanceof ManagedScheduledExecutorService), (String)"Application context must be propagated to second execution per java:comp/concurrent/ScheduledExecutorC configuration.");
            result = results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
            Assert.assertNotNull(result, (String)("Task scheduled with " + (Trigger)monthlyOnThe15th + " did not run 3 times: " + future));
            Assert.assertTrue((boolean)(result instanceof ManagedScheduledExecutorService), (String)"Application context must be propagated to third execution per java:comp/concurrent/ScheduledExecutorC configuration.");
        }
        finally {
            if (!future.isDone()) {
                future.cancel(true);
            }
        }
        for (Map.Entry entry : startAndEndTimes.entrySet()) {
            ZonedDateTime endAt;
            ZonedDateTime startAt = (ZonedDateTime)entry.getKey();
            Assert.assertTrue((startAt.isBefore(endAt = (ZonedDateTime)entry.getValue()) || startAt.isEqual(endAt) ? 1 : 0) != 0, (String)("LastExecution runStart and runEnd methods returned inconsistent times: " + startAndEndTimes));
        }
    }
}

