/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ContextService.tx;

import ee.jakarta.tck.concurrent.framework.TestUtil;
import ee.jakarta.tck.concurrent.spec.ContextService.tx.TestWorkInterface;
import ee.jakarta.tck.concurrent.spec.ContextService.tx.Util;
import jakarta.transaction.UserTransaction;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class TestTransactionWork
implements TestWorkInterface,
Serializable {
    protected String result;
    protected Connection con;
    protected String sqlTemplate;
    protected boolean beginTran = false;
    protected boolean commit = false;
    protected boolean rollback = false;
    protected String userName;
    protected String password;

    @Override
    public void doSomeWork() {
        UserTransaction ut = null;
        if (this.beginTran) {
            try {
                ut = (UserTransaction)TestUtil.lookup("java:comp/UserTransaction");
                ut.begin();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Statement pStmt = null;
        try {
            this.con = Util.getConnection(false, this.userName, this.password);
            pStmt = this.con.prepareStatement(this.sqlTemplate);
            String sTypeDesc = "Type-98";
            int newType = 98;
            pStmt.setInt(1, newType);
            pStmt.setString(2, sTypeDesc);
            pStmt.executeUpdate();
            if (this.commit) {
                ut.commit();
            }
            if (this.rollback) {
                ut.rollback();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
                if (this.con != null) {
                    this.con.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public String getResult() {
        return this.result;
    }

    @Override
    public void setConnection(Connection con) {
        this.con = con;
    }

    @Override
    public void setSQLTemplate(String sqlTemplate) {
        this.sqlTemplate = sqlTemplate;
    }

    @Override
    public void needBeginTx(boolean beginTx) {
        this.beginTran = beginTx;
    }

    @Override
    public void needCommit(boolean commit) {
        this.commit = commit;
    }

    @Override
    public void needRollback(boolean rollback) {
        this.rollback = rollback;
    }

    @Override
    public void run() {
        this.doSomeWork();
    }

    @Override
    public void setUserName(String name) {
        this.userName = name;
    }

    @Override
    public void setPassword(String pass) {
        this.password = pass;
    }
}

