/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.annotations.signaturetest;

import ee.jakarta.tck.annotations.signaturetest.SigTest;
import ee.jakarta.tck.annotations.signaturetest.SignatureTestDriver;
import ee.jakarta.tck.annotations.signaturetest.SignatureTestDriverFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.jupiter.api.Test;

public class CAJSigTestIT
extends SigTest {
    private static final System.Logger logger = System.getLogger(CAJSigTestIT.class.getName());
    private Properties props = System.getProperties();
    private final String GENERATED = "jakarta.annotation.Generated";
    private final String POSTCONSTRUCT = "jakarta.annotation.PostConstruct";
    private final String PREDESTROY = "jakarta.annotation.PreDestroy";
    private final String PRIORITY = "jakarta.annotation.Priority";
    private final String RESOURCE = "jakarta.annotation.Resource,jakarta.annotation.Resource$AuthenticationType";
    private final String RESOURCES = "jakarta.annotation.Resources";
    private final String SECURITYDECLAREROLES = "jakarta.annotation.security.DeclareRoles";
    private final String SECURITYDENYALL = "jakarta.annotation.security.DenyAll";
    private final String SECURITYPERMITALL = "jakarta.annotation.security.PermitAll";
    private final String SECURITYROLESALLOWED = "jakarta.annotation.security.RolesAllowed";
    private final String SECURITYRUNAS = "jakarta.annotation.security.RunAs";
    private final String SQLDATASOURCEDEFINITION = "jakarta.annotation.sql.DataSourceDefinition";
    private final String SQLDATASOURCEDEFINITIONS = "jakarta.annotation.sql.DataSourceDefinitions";
    private boolean ca_generated = false;
    private boolean ca_postconstruct = false;
    private boolean ca_priority = false;
    private boolean ca_predestroy = false;
    private boolean ca_resource = false;
    private boolean ca_resources = false;
    private boolean ca_securitydeclareroles = false;
    private boolean ca_securitydenyall = false;
    private boolean ca_securitypermitall = false;
    private boolean ca_securityrolesallowed = false;
    private boolean ca_securityrunas = false;
    private boolean ca_sqldatasourcedefinition = false;
    private boolean ca_sqldatasourcedefinitions = false;

    public CAJSigTestIT() {
        this.setup();
    }

    @Override
    protected String[] getPackages() {
        return new String[0];
    }

    @Override
    protected String[] getClasses() {
        ArrayList<String> classesArray = new ArrayList<String>();
        if (this.ca_generated) {
            classesArray.add("jakarta.annotation.Generated");
        }
        if (this.ca_postconstruct) {
            classesArray.add("jakarta.annotation.PostConstruct");
        }
        if (this.ca_priority) {
            classesArray.add("jakarta.annotation.Priority");
        }
        if (this.ca_predestroy) {
            classesArray.add("jakarta.annotation.PreDestroy");
        }
        if (this.ca_resource) {
            String[] s = "jakarta.annotation.Resource,jakarta.annotation.Resource$AuthenticationType".split(",");
            for (int i = 0; i < s.length; ++i) {
                classesArray.add(s[i]);
            }
        }
        if (this.ca_resources) {
            classesArray.add("jakarta.annotation.Resources");
        }
        if (this.ca_securitydeclareroles) {
            classesArray.add("jakarta.annotation.security.DeclareRoles");
        }
        if (this.ca_securitydenyall) {
            classesArray.add("jakarta.annotation.security.DenyAll");
        }
        if (this.ca_securitypermitall) {
            classesArray.add("jakarta.annotation.security.PermitAll");
        }
        if (this.ca_securityrolesallowed) {
            classesArray.add("jakarta.annotation.security.RolesAllowed");
        }
        if (this.ca_securityrunas) {
            classesArray.add("jakarta.annotation.security.RunAs");
        }
        if (this.ca_sqldatasourcedefinition) {
            classesArray.add("jakarta.annotation.sql.DataSourceDefinition");
        }
        if (this.ca_sqldatasourcedefinitions) {
            classesArray.add("jakarta.annotation.sql.DataSourceDefinitions");
        }
        return classesArray.toArray(new String[classesArray.size()]);
    }

    @Override
    public void setup() {
        super.setup();
        this.ca_generated = Boolean.valueOf(this.props.getProperty("ca.sig.generated"));
        this.ca_postconstruct = Boolean.valueOf(this.props.getProperty("ca.sig.postconstruct"));
        this.ca_priority = Boolean.valueOf(this.props.getProperty("ca.sig.priority"));
        this.ca_predestroy = Boolean.valueOf(this.props.getProperty("ca.sig.predestroy"));
        this.ca_resource = Boolean.valueOf(this.props.getProperty("ca.sig.resource"));
        this.ca_resources = Boolean.valueOf(this.props.getProperty("ca.sig.resources"));
        this.ca_securitydeclareroles = Boolean.valueOf(this.props.getProperty("ca.sig.securitydeclareroles"));
        this.ca_securitydenyall = Boolean.valueOf(this.props.getProperty("ca.sig.securitydenyall"));
        this.ca_securitypermitall = Boolean.valueOf(this.props.getProperty("ca.sig.securitypermitall"));
        this.ca_securityrolesallowed = Boolean.valueOf(this.props.getProperty("ca.sig.securityrolesallowed"));
        this.ca_securityrunas = Boolean.valueOf(this.props.getProperty("ca.sig.securityrunas"));
        this.ca_sqldatasourcedefinition = Boolean.valueOf(this.props.getProperty("ca.sig.sqldatasourcedefinition"));
        this.ca_sqldatasourcedefinitions = Boolean.valueOf(this.props.getProperty("ca.sig.sqldatasourcedefinitions"));
    }

    @Test
    public void signatureTest() throws Exception {
        logger.log(System.Logger.Level.INFO, "$$$ signatureTest() called");
        String mapFile = null;
        String packageFile = null;
        Properties mapFileAsProps = null;
        String[] packages = this.getPackages();
        String apiPackage = "jakarta.annotation";
        try {
            InputStream inStreamMapfile = CAJSigTestIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/annotations/signaturetest/sig-test.map");
            File mFile = this.writeStreamToTempFile(inStreamMapfile, "sig-test", ".map");
            mapFile = mFile.getCanonicalPath();
            logger.log(System.Logger.Level.INFO, "mapFile location is :" + mapFile);
            InputStream inStreamPackageFile = CAJSigTestIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/annotations/signaturetest/sig-test-pkg-list.txt");
            File pFile = this.writeStreamToTempFile(inStreamPackageFile, "sig-test-pkg-list", ".txt");
            packageFile = pFile.getCanonicalPath();
            logger.log(System.Logger.Level.INFO, "packageFile location is :" + packageFile);
            mapFileAsProps = this.getSigTestDriver().loadMapFile(mapFile);
            String packageVersion = mapFileAsProps.getProperty(apiPackage);
            logger.log(System.Logger.Level.INFO, "Package version from mapfile :" + packageVersion);
            InputStream inStreamSigFile = CAJSigTestIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/annotations/signaturetest/jakarta.annotation.sig_" + packageVersion);
            File sigFile = this.writeStreamToSigFile(inStreamSigFile, apiPackage, packageVersion);
            logger.log(System.Logger.Level.INFO, "signature File location is :" + sigFile.getCanonicalPath());
        }
        catch (IOException ex) {
            logger.log(System.Logger.Level.ERROR, "Exception while creating temp files :" + String.valueOf(ex));
        }
        super.signatureTest(mapFile, packageFile, mapFileAsProps, packages);
    }

    @Override
    protected SignatureTestDriver getSigTestDriver() {
        if (this.driver == null) {
            this.driver = SignatureTestDriverFactory.getInstance("sigtest");
        }
        return this.driver;
    }
}

