/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.finder;

import com.sun.javatest.finder.CommentStream;
import java.io.IOException;

public class ShScriptCommentStream
extends CommentStream {
    private static final String LINESEP = System.getProperty("line.separator");

    @Override
    public String readComment() throws IOException {
        String line;
        do {
            if ((line = this.cs.readLine()) != null) continue;
            return null;
        } while ((line = this.getCommentLine(line)) == null);
        String comment = line;
        while ((line = this.cs.readLine()) != null) {
            if ((line = this.getCommentLine(line)) == null) {
                return comment;
            }
            comment = comment + line;
        }
        return comment;
    }

    private String getCommentLine(String line) {
        int pos;
        boolean isLineComment = false;
        char[] lineArray = line.toCharArray();
        for (pos = 0; pos < lineArray.length; ++pos) {
            char c = lineArray[pos];
            if (c == '#') {
                isLineComment = true;
                continue;
            }
            if (c != ' ' && c != '\t' && c != '\f') break;
        }
        if (!isLineComment) {
            return null;
        }
        return line.substring(pos) + LINESEP;
    }
}

