/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.core.security;

import com.thoughtworks.xstream.XStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.hawk.core.ICredentialsStore;
import org.eclipse.hawk.core.security.CredentialsFile;
import org.eclipse.hawk.core.security.CredentialsFileEntry;
import org.eclipse.hawk.core.util.XStreamUtils;

public class FileBasedCredentialsStore
implements ICredentialsStore {
    private final File store;
    private char[] encryptionKey;
    private byte[] salt;
    private Map<String, ICredentialsStore.Credentials> credentials;

    public FileBasedCredentialsStore(File store, char[] encryptionKey) {
        this.store = store;
        this.encryptionKey = encryptionKey;
    }

    @Override
    public void put(String repositoryKey, ICredentialsStore.Credentials creds) throws IOException, GeneralSecurityException {
        this.checkOpen();
        this.credentials.put(repositoryKey, creds);
    }

    @Override
    public ICredentialsStore.Credentials get(String repositoryKey) throws IOException, GeneralSecurityException {
        this.checkOpen();
        return this.credentials.get(repositoryKey);
    }

    @Override
    public void remove(String repositoryKey) throws IOException, GeneralSecurityException {
        this.checkOpen();
        this.credentials.remove(repositoryKey);
    }

    private void checkOpen() throws IOException, GeneralSecurityException {
        if (this.credentials != null) {
            return;
        }
        this.credentials = new HashMap<String, ICredentialsStore.Credentials>();
        if (this.store.exists()) {
            this.load();
        } else {
            this.store.createNewFile();
            SecureRandom random = new SecureRandom();
            this.salt = random.generateSeed(8);
            this.save();
        }
    }

    private void load() throws IOException, GeneralSecurityException {
        XStream stream = this.getXStream();
        CredentialsFile credsFile = null;
        Throwable throwable = null;
        Iterator<CredentialsFileEntry> iterator = null;
        try (BufferedReader br = new BufferedReader(new FileReader(this.store));){
            credsFile = (CredentialsFile)stream.fromXML((Reader)br);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.salt = FileBasedCredentialsStore.base64Decode(credsFile.getBase64Salt());
        this.credentials.clear();
        for (CredentialsFileEntry fileEntry : credsFile.getEntries()) {
            this.credentials.put(fileEntry.getRepositoryKey(), new ICredentialsStore.Credentials(fileEntry.getUsername(), this.decrypt(fileEntry.getPassword())));
        }
    }

    private void save() throws IOException, GeneralSecurityException {
        CredentialsFile credsFile = new CredentialsFile();
        credsFile.setBase64Salt(FileBasedCredentialsStore.base64Encode(this.salt));
        ArrayList<CredentialsFileEntry> fileEntries = new ArrayList<CredentialsFileEntry>();
        for (Map.Entry<String, ICredentialsStore.Credentials> credEntry : this.credentials.entrySet()) {
            ICredentialsStore.Credentials creds = credEntry.getValue();
            CredentialsFileEntry fileEntry = new CredentialsFileEntry(credEntry.getKey(), creds.getUsername(), this.encrypt(creds.getPassword()));
            fileEntries.add(fileEntry);
        }
        credsFile.setEntries(fileEntries);
        XStream stream = this.getXStream();
        Object object = null;
        Object var5_6 = null;
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(this.store));){
            stream.toXML((Object)credsFile, (Writer)bw);
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
    }

    private XStream getXStream() {
        return XStreamUtils.createXStreamLoader(CredentialsFile.class, CredentialsFileEntry.class);
    }

    @Override
    public void shutdown() throws IOException, GeneralSecurityException {
        if (this.credentials != null) {
            this.save();
            this.encryptionKey = null;
            this.credentials = null;
            this.salt = null;
        }
    }

    private String encrypt(String property) throws GeneralSecurityException, UnsupportedEncodingException {
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
        SecretKey key = keyFactory.generateSecret(new PBEKeySpec(this.encryptionKey));
        Cipher pbeCipher = Cipher.getInstance("PBEWithMD5AndDES");
        pbeCipher.init(1, (Key)key, new PBEParameterSpec(this.salt, 20));
        return FileBasedCredentialsStore.base64Encode(pbeCipher.doFinal(property.getBytes("UTF-8")));
    }

    private String decrypt(String property) throws GeneralSecurityException, IOException {
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
        SecretKey key = keyFactory.generateSecret(new PBEKeySpec(this.encryptionKey));
        Cipher pbeCipher = Cipher.getInstance("PBEWithMD5AndDES");
        pbeCipher.init(2, (Key)key, new PBEParameterSpec(this.salt, 20));
        return new String(pbeCipher.doFinal(FileBasedCredentialsStore.base64Decode(property)), "UTF-8");
    }

    private static byte[] base64Decode(String property) throws IOException {
        return new Base64().decode(property);
    }

    private static String base64Encode(byte[] bytes) {
        return new Base64().encodeAsString(bytes);
    }
}

