/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.svn.tests;

import java.io.File;
import java.util.List;
import org.eclipse.hawk.svn.tests.rules.TemporarySVNRepository;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNLogEntry;

public class TemporarySVNRepositoryTest {
    @Rule
    public TemporarySVNRepository svnRepository = new TemporarySVNRepository();

    @Test
    public void initWorks() {
        System.out.println("Created repository in " + this.svnRepository.getRepositoryDirectory() + ", checkout in " + this.svnRepository.getCheckoutDirectory());
        Assert.assertNotNull((Object)this.svnRepository.getRepository().getLocation());
    }

    @Test
    public void addRemove() throws Exception {
        File firstFile = this.svnRepository.write("this is a test", "test.txt", new String[0]).toFile();
        this.svnRepository.add(firstFile);
        SVNCommitInfo ciInfo = this.svnRepository.commit("initial commit");
        Assert.assertEquals((long)1L, (long)ciInfo.getNewRevision());
        List<SVNLogEntry> info = this.svnRepository.log(ciInfo.getNewRevision(), ciInfo.getNewRevision());
        Assert.assertEquals((long)1L, (long)info.size());
        Assert.assertEquals((long)1L, (long)info.get(0).getChangedPaths().size());
        this.svnRepository.remove(firstFile);
        this.svnRepository.commit("remove file");
        Assert.assertFalse((String)"The file should have been deleted after the update", (boolean)firstFile.exists());
    }
}

