/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.snapshot;

import java.net.URI;
import java.nio.charset.Charset;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.handly.junit.WorkspaceTestCase;
import org.eclipse.handly.snapshot.TextFileStoreSnapshot;

public class TextFileStoreSnapshotTest
extends WorkspaceTestCase {
    private IFileStore fileStore;
    private TextFileStoreSnapshot snapshot;

    protected void setUp() throws Exception {
        super.setUp();
        IProject p = this.setUpProject("Test002");
        IFile file = p.getFile("x.txt");
        this.fileStore = EFS.getStore((URI)file.getLocationURI());
        this.snapshot = new TextFileStoreSnapshot(this.fileStore, Charset.forName("UTF-8"));
    }

    public void test1() throws Exception {
        TextFileStoreSnapshotTest.assertEquals((String)"hello", (String)this.snapshot.getContents());
        IFileInfo info = this.fileStore.fetchInfo();
        info.setLastModified(info.getLastModified() + 1000L);
        this.fileStore.putInfo(info, 2048, null);
        TextFileStoreSnapshotTest.assertNull((Object)this.snapshot.getContents());
    }
}

