/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.snapshot;

import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.handly.junit.WorkspaceTestCase;
import org.eclipse.handly.snapshot.DocumentSnapshot;
import org.eclipse.handly.snapshot.Snapshot;
import org.eclipse.handly.snapshot.TextFileBufferSnapshot;
import org.eclipse.handly.snapshot.TextFileSnapshot;
import org.eclipse.handly.snapshot.TextFileSnapshotWs;
import org.eclipse.jface.text.IDocument;

public class EqualityPredictionTest
extends WorkspaceTestCase {
    private IFile fileX;
    private IFile fileY;
    private ITextFileBuffer bufferX;
    private ITextFileBuffer bufferY;
    private ITextFileBufferManager bufferManager = ITextFileBufferManager.DEFAULT;

    protected void setUp() throws Exception {
        super.setUp();
        IProject p = this.setUpProject("Test002");
        this.fileX = p.getFile("x.txt");
        this.fileY = p.getFile("y.txt");
        this.bufferManager.connect(this.fileX.getFullPath(), LocationKind.IFILE, null);
        this.bufferManager.connect(this.fileY.getFullPath(), LocationKind.IFILE, null);
        this.bufferX = this.bufferManager.getTextFileBuffer(this.fileX.getFullPath(), LocationKind.IFILE);
        this.bufferY = this.bufferManager.getTextFileBuffer(this.fileY.getFullPath(), LocationKind.IFILE);
    }

    protected void tearDown() throws Exception {
        this.bufferManager.disconnect(this.fileX.getFullPath(), LocationKind.IFILE, null);
        this.bufferManager.disconnect(this.fileY.getFullPath(), LocationKind.IFILE, null);
        super.tearDown();
    }

    public void test01() throws Exception {
        TextFileSnapshot snapshot1 = new TextFileSnapshot(this.fileX, TextFileSnapshot.Layer.WORKSPACE);
        TextFileBufferSnapshot snapshot2 = new TextFileBufferSnapshot(this.bufferX, this.bufferManager);
        EqualityPredictionTest.assertEquals((Object)Boolean.TRUE, (Object)snapshot1.predictEquality((Snapshot)snapshot2));
        EqualityPredictionTest.assertEquals((Object)Boolean.TRUE, (Object)snapshot2.predictEquality((Snapshot)snapshot1));
    }

    public void test02() throws Exception {
        TextFileSnapshot snapshot1 = new TextFileSnapshot(this.fileX, TextFileSnapshot.Layer.WORKSPACE);
        TextFileSnapshotWs snapshot2 = new TextFileSnapshotWs(this.fileX);
        EqualityPredictionTest.assertEquals((Object)Boolean.TRUE, (Object)snapshot1.predictEquality((Snapshot)snapshot2));
        EqualityPredictionTest.assertFalse((boolean)Boolean.FALSE.equals(snapshot2.predictEquality((Snapshot)snapshot1)));
    }

    public void test03() throws Exception {
        TextFileBufferSnapshot snapshot1 = new TextFileBufferSnapshot(this.bufferX, this.bufferManager);
        TextFileSnapshotWs snapshot2 = new TextFileSnapshotWs(this.fileX);
        EqualityPredictionTest.assertEquals((Object)Boolean.TRUE, (Object)snapshot1.predictEquality((Snapshot)snapshot2));
        EqualityPredictionTest.assertFalse((boolean)Boolean.FALSE.equals(snapshot2.predictEquality((Snapshot)snapshot1)));
    }

    public void test04() throws Exception {
        IDocument document = this.bufferX.getDocument();
        document.set("good bye");
        TextFileBufferSnapshot snapshot1 = new TextFileBufferSnapshot(this.bufferX, this.bufferManager);
        DocumentSnapshot snapshot2 = new DocumentSnapshot(document);
        EqualityPredictionTest.assertEquals((Object)Boolean.TRUE, (Object)snapshot1.predictEquality((Snapshot)snapshot2));
        EqualityPredictionTest.assertFalse((boolean)Boolean.FALSE.equals(snapshot2.predictEquality((Snapshot)snapshot1)));
    }

    public void test05() throws Exception {
        IDocument document = this.bufferX.getDocument();
        DocumentSnapshot snapshot1 = new DocumentSnapshot(document);
        DocumentSnapshot snapshot2 = new DocumentSnapshot(document);
        EqualityPredictionTest.assertEquals((Object)Boolean.TRUE, (Object)snapshot1.predictEquality((Snapshot)snapshot2));
        EqualityPredictionTest.assertEquals((Object)Boolean.TRUE, (Object)snapshot2.predictEquality((Snapshot)snapshot1));
        document.set("good bye");
        EqualityPredictionTest.assertEquals((Object)Boolean.TRUE, (Object)snapshot1.predictEquality((Snapshot)snapshot2));
        EqualityPredictionTest.assertEquals((Object)Boolean.TRUE, (Object)snapshot2.predictEquality((Snapshot)snapshot1));
    }

    public void test06() throws Exception {
        IDocument document = this.bufferX.getDocument();
        DocumentSnapshot snapshot1 = new DocumentSnapshot(document);
        document.set("good bye");
        DocumentSnapshot snapshot2 = new DocumentSnapshot(document);
        EqualityPredictionTest.assertEquals((Object)Boolean.FALSE, (Object)snapshot1.predictEquality((Snapshot)snapshot2));
        EqualityPredictionTest.assertEquals((Object)Boolean.FALSE, (Object)snapshot2.predictEquality((Snapshot)snapshot1));
    }

    public void test07() throws Exception {
        DocumentSnapshot snapshot1 = new DocumentSnapshot(this.bufferX.getDocument());
        DocumentSnapshot snapshot2 = new DocumentSnapshot(this.bufferY.getDocument());
        EqualityPredictionTest.assertNull((Object)snapshot1.predictEquality((Snapshot)snapshot2));
        EqualityPredictionTest.assertNull((Object)snapshot2.predictEquality((Snapshot)snapshot1));
    }

    public void test08() throws Exception {
        TextFileSnapshotWs snapshot1 = new TextFileSnapshotWs(this.fileX);
        TextFileSnapshotWs snapshot2 = new TextFileSnapshotWs(this.fileX);
        EqualityPredictionTest.assertEquals((Object)Boolean.TRUE, (Object)snapshot1.predictEquality((Snapshot)snapshot2));
        EqualityPredictionTest.assertEquals((Object)Boolean.TRUE, (Object)snapshot2.predictEquality((Snapshot)snapshot1));
        this.bufferX.getDocument().set("good bye");
        this.bufferX.commit(null, true);
        EqualityPredictionTest.assertEquals((Object)Boolean.TRUE, (Object)snapshot1.predictEquality((Snapshot)snapshot2));
        EqualityPredictionTest.assertEquals((Object)Boolean.TRUE, (Object)snapshot2.predictEquality((Snapshot)snapshot1));
    }

    public void test09() throws Exception {
        TextFileSnapshotWs snapshot1 = new TextFileSnapshotWs(this.fileX);
        this.bufferX.getDocument().set("good bye");
        this.bufferX.commit(null, true);
        TextFileSnapshotWs snapshot2 = new TextFileSnapshotWs(this.fileX);
        EqualityPredictionTest.assertEquals((Object)Boolean.FALSE, (Object)snapshot1.predictEquality((Snapshot)snapshot2));
        EqualityPredictionTest.assertEquals((Object)Boolean.FALSE, (Object)snapshot2.predictEquality((Snapshot)snapshot1));
    }

    public void test10() throws Exception {
        TextFileSnapshotWs snapshot1 = new TextFileSnapshotWs(this.fileX);
        TextFileSnapshotWs snapshot2 = new TextFileSnapshotWs(this.fileY);
        EqualityPredictionTest.assertNull((Object)snapshot1.predictEquality((Snapshot)snapshot2));
        EqualityPredictionTest.assertNull((Object)snapshot2.predictEquality((Snapshot)snapshot1));
    }
}

