/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.gef.ui.internal.actions;

import java.util.ArrayList;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;

public class MenuManagerEx
extends ContributionManager
implements IMenuManager {
    private Menu menu = null;
    private ListenerList listeners = new ListenerList(1);
    private String id;
    private MenuItem menuItem;
    private String menuText;
    private boolean removeAllWhenShown = false;
    private boolean visible = true;

    public MenuManagerEx() {
        this(null, null);
    }

    public MenuManagerEx(String text) {
        this(text, null);
    }

    public MenuManagerEx(String text, String id) {
        this.menuText = text;
        this.id = id;
    }

    public void addMenuListener(IMenuListener listener) {
        this.listeners.add((Object)listener);
    }

    public Menu createContextMenu(Control parent) {
        if (this.menu == null || this.menu.isDisposed()) {
            this.menu = new Menu(parent);
            this.initializeMenu();
        }
        return this.menu;
    }

    public Menu createMenuBar(Shell parent) {
        if (this.menu == null || this.menu.isDisposed()) {
            this.menu = new Menu((Decorations)parent, 2);
            this.update(false);
        }
        return this.menu;
    }

    public Menu createSubMenu(Menu parent) {
        if (this.menu == null || this.menu.isDisposed()) {
            this.menu = new Menu(parent);
            this.initializeMenu();
        }
        return this.menu;
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
        if (this.menuItem != null) {
            this.menuItem.dispose();
            this.menuItem = null;
        }
    }

    public void fill(Composite parent) {
    }

    public void fill(Menu parent, int index) {
        if (this.menuItem == null || this.menuItem.isDisposed()) {
            this.menuItem = index >= 0 ? new MenuItem(parent, 64, index) : new MenuItem(parent, 64);
            this.menuItem.setText(this.menuText);
            if (this.menu == null || this.menu.isDisposed()) {
                this.menu = new Menu(parent);
            }
            this.menuItem.setMenu(this.menu);
            this.initializeMenu();
            this.update(true);
        }
    }

    public void fill(ToolBar parent, int index) {
    }

    public IMenuManager findMenuUsingPath(String path) {
        IContributionItem item = this.findUsingPath(path);
        if (item instanceof IMenuManager) {
            return (IMenuManager)item;
        }
        return null;
    }

    public IContributionItem findUsingPath(String path) {
        String menuId = path;
        String rest = null;
        int separator = path.indexOf(47);
        if (separator == -1) {
            return super.find(path);
        }
        menuId = path.substring(0, separator);
        rest = path.substring(separator + 1);
        IContributionItem item = super.find(menuId);
        if (item instanceof IMenuManager) {
            IMenuManager manager = (IMenuManager)item;
            return manager.findUsingPath(rest);
        }
        return null;
    }

    private void fireAboutToShow(IMenuManager manager) {
        Object[] listenerList = this.listeners.getListeners();
        int i = 0;
        while (i < listenerList.length) {
            ((IMenuListener)listenerList[i]).menuAboutToShow(manager);
            ++i;
        }
    }

    public String getId() {
        return this.id;
    }

    public Menu getMenu() {
        return this.menu;
    }

    public boolean getRemoveAllWhenShown() {
        return this.removeAllWhenShown;
    }

    private void handleAboutToShow() {
        if (this.removeAllWhenShown) {
            this.removeAll();
        }
        this.fireAboutToShow(this);
        this.update(false);
    }

    private void initializeMenu() {
        this.menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                MenuManagerEx.this.handleAboutToShow();
            }

            public void menuHidden(MenuEvent e) {
            }
        });
        this.markDirty();
    }

    public boolean isDynamic() {
        return false;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isGroupMarker() {
        return false;
    }

    public boolean isSeparator() {
        return false;
    }

    public boolean isSubstituteFor(IContributionItem item) {
        return ((Object)((Object)this)).equals(item);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void removeMenuListener(IMenuListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void setRemoveAllWhenShown(boolean removeAll) {
        this.removeAllWhenShown = removeAll;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setParent(IContributionManager manager) {
    }

    public void update() {
        this.updateMenuItem();
    }

    public void update(boolean force) {
        this.update(force, false);
    }

    protected boolean shouldDisplay(IContributionItem ci) {
        return ci.isVisible();
    }

    protected void update(boolean force, boolean recursive) {
        if (this.isDirty() || force) {
            if (this.menu != null && !this.menu.isDisposed()) {
                IContributionItem[] items = this.getItems();
                ArrayList<IContributionItem> clean = new ArrayList<IContributionItem>(items.length);
                IContributionItem separator = null;
                int i = 0;
                while (i < items.length) {
                    IContributionItem ci = items[i];
                    if (this.shouldDisplay(ci)) {
                        if (ci.isSeparator()) {
                            separator = ci;
                        } else {
                            if (separator != null) {
                                if (clean.size() > 0) {
                                    clean.add(separator);
                                }
                                separator = null;
                            }
                            clean.add(ci);
                        }
                    }
                    ++i;
                }
                MenuItem[] mi = this.menu.getItems();
                int i2 = 0;
                while (i2 < mi.length) {
                    Object data = mi[i2].getData();
                    if (data == null || !clean.contains(data) || data instanceof IContributionItem && ((IContributionItem)data).isDynamic()) {
                        mi[i2].dispose();
                    }
                    ++i2;
                }
                mi = this.menu.getItems();
                int srcIx = 0;
                int destIx = 0;
                for (IContributionItem src : clean) {
                    IContributionItem dest = srcIx < mi.length ? (IContributionItem)mi[srcIx].getData() : null;
                    if (dest != null && src.equals(dest)) {
                        ++srcIx;
                        ++destIx;
                    } else if (dest != null && dest.isSeparator() && src.isSeparator()) {
                        mi[srcIx].setData((Object)src);
                        ++srcIx;
                        ++destIx;
                    } else {
                        int start = this.menu.getItemCount();
                        src.fill(this.menu, destIx);
                        int newItems = this.menu.getItemCount() - start;
                        MenuItem[] tis = this.menu.getItems();
                        int i3 = 0;
                        while (i3 < newItems) {
                            tis[destIx + i3].setData((Object)src);
                            ++i3;
                        }
                        destIx += newItems;
                    }
                    if (!recursive || !(src instanceof IMenuManager)) continue;
                    ((IMenuManager)src).updateAll(force);
                }
                this.setDirty(false);
                this.updateMenuItem();
            }
        } else if (recursive) {
            IContributionItem[] items = this.getItems();
            int i = 0;
            while (i < items.length) {
                IMenuManager mm;
                IContributionItem ci = items[i];
                if (ci instanceof IMenuManager && (mm = (IMenuManager)ci).isVisible()) {
                    mm.updateAll(force);
                }
                ++i;
            }
        }
    }

    public void update(String property) {
        IContributionItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].update(property);
            ++i;
        }
        if (this.menu != null && "text".equals(property)) {
            String text = this.getOverrides().getText((IContributionItem)this);
            if (text == null) {
                text = this.menuText;
            }
            if (this.menu == null || this.menu.isDisposed()) {
                return;
            }
            if (text != null && this.menu.getParentItem() != null) {
                this.menu.getParentItem().setText(text);
            }
        }
    }

    public void updateAll(boolean force) {
        this.update(force, true);
    }

    private void updateMenuItem() {
        if (this.menuItem != null && !this.menuItem.isDisposed()) {
            boolean enabled;
            boolean bl = enabled = this.menu.getItemCount() > 0;
            if (this.menuItem.getEnabled() != enabled) {
                this.menuItem.setEnabled(enabled);
            }
        }
    }

    public void fill(CoolBar parent, int index) {
    }

    public void saveWidgetState() {
    }
}

