/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.disposable;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.glsp.server.disposable.Disposable;
import org.eclipse.glsp.server.disposable.IDisposable;

public class DisposableCollection
extends Disposable {
    private final List<IDisposable> disposables = new ArrayList<IDisposable>();

    public void add(IDisposable disposable) {
        if (!this.isDisposed()) {
            this.disposables.add(disposable);
        }
    }

    public void add(Runnable runnable) {
        this.add(IDisposable.create(runnable));
    }

    public void remove(IDisposable disposable) {
        if (!this.isDisposed()) {
            this.disposables.remove(disposable);
        }
    }

    @Override
    protected void doDispose() {
        this.disposables.forEach(IDisposable::dispose);
        this.disposables.clear();
    }
}

