/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.example.workflow.provider;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.glsp.example.workflow.handler.GridSnapper;
import org.eclipse.glsp.graph.GPoint;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.actions.SetEditModeAction;
import org.eclipse.glsp.server.features.contextmenu.ContextMenuItemProvider;
import org.eclipse.glsp.server.features.contextmenu.MenuItem;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.operations.CreateNodeOperation;

public class WorkflowContextMenuItemProvider
implements ContextMenuItemProvider {
    @Inject
    protected GModelState modelState;

    public List<MenuItem> getItems(List<String> selectedElementIds, GPoint position, Map<String, String> args) {
        SetEditModeAction editModeAction = new SetEditModeAction(this.modelState.isReadonly() ? "editable" : "readonly");
        MenuItem editModeMenu = new MenuItem("editMode", "Readonly Mode", Arrays.asList(editModeAction), true);
        editModeMenu.setToggled(this.modelState.isReadonly());
        if (this.modelState.isReadonly()) {
            return Arrays.asList(editModeMenu);
        }
        GPoint snappedPosition = GridSnapper.snap(position);
        MenuItem newAutTask = new MenuItem("newAutoTask", "Automated Task", Arrays.asList(new CreateNodeOperation("task:automated", snappedPosition)), true);
        MenuItem newManTask = new MenuItem("newManualTask", "Manual Task", Arrays.asList(new CreateNodeOperation("task:manual", snappedPosition)), true);
        MenuItem hiddenItem = new MenuItem("hiddenItem", "Should be hidden", Arrays.asList(new Action[0]), false);
        MenuItem newChildMenu = new MenuItem("new", "New", Arrays.asList(newAutTask, newManTask, hiddenItem), "add", "0_new");
        return Arrays.asList(newChildMenu, editModeMenu);
    }
}

