/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.document.parser.documents.ods;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.gendoc.document.parser.documents.AbstractZipDocument;
import org.eclipse.gendoc.document.parser.documents.Document;
import org.eclipse.gendoc.document.parser.documents.XMLParser;
import org.w3c.dom.Node;

public class ODSDocument
extends AbstractZipDocument {
    private List<String> currentRow = null;
    private int currentIndex = -1;
    private Node currentNode = null;

    public ODSDocument(File documentFile, Map<Document.CONFIGURATION, Boolean> configuration) throws MalformedURLException {
        this(documentFile.toURI().toURL(), configuration);
    }

    public ODSDocument(URL url, Map<Document.CONFIGURATION, Boolean> configuration) {
        super(url, configuration);
    }

    @Override
    protected Collection<XMLParser> getXmlParsers(Document.CONFIGURATION idForDocument) {
        LinkedList<XMLParser> result = new LinkedList<XMLParser>();
        switch (idForDocument) {
            case content: {
                XMLParser content = new XMLParser(this.getUnzipper().getFile("content.xml"), idForDocument);
                result.add(content);
                break;
            }
        }
        return result;
    }

    public String getStyle() {
        return "";
    }

    @Override
    public boolean next() {
        boolean result = true;
        if (this.getXMLParser().getCurrentNode() != this.currentNode) {
            if ("table:table-row".equals(this.getXMLParser().getCurrentNode().getNodeName())) {
                this.currentNode = this.getXMLParser().getCurrentNode();
                this.currentRow = new LinkedList<String>();
                int i = 0;
                while (i < this.currentNode.getChildNodes().getLength()) {
                    Node child = this.currentNode.getChildNodes().item(i);
                    if ("table:table-cell".equals(child.getNodeName())) {
                        this.fillRowWithcell(child);
                    }
                    ++i;
                }
                this.currentIndex = 0;
                result = true;
            } else {
                result = super.next();
            }
        } else if (this.currentIndex == this.currentRow.size() - 1) {
            this.currentIndex = -1;
            this.currentRow = null;
            result = super.next();
        } else {
            ++this.currentIndex;
            result = true;
        }
        return result;
    }

    public String getText() {
        if (this.currentRow != null && this.currentIndex != -1) {
            return this.currentRow.get(this.currentIndex);
        }
        return "";
    }

    private void fillRowWithcell(Node theNode) {
        Node attribute;
        int count = 1;
        if ("table:table-cell".equals(theNode.getNodeName()) && (attribute = theNode.getAttributes().getNamedItem("table:number-columns-repeated")) != null) {
            count = Integer.valueOf(attribute.getTextContent());
        }
        String found = "";
        int i = 0;
        while (i < theNode.getChildNodes().getLength() && found.length() == 0) {
            Node child = theNode.getChildNodes().item(i);
            if ("text:p".equals(child.getNodeName())) {
                found = child.getTextContent();
            }
            ++i;
        }
        if (this.isLast(theNode) && found.length() == 0) {
            count = 1;
        }
        int j = 0;
        while (j < count) {
            this.currentRow.add(found);
            ++j;
        }
    }

    private boolean isLast(Node theNode) {
        int length = theNode.getParentNode().getChildNodes().getLength() - 1;
        int cursor = 0;
        int i = 0;
        while (i < theNode.getParentNode().getChildNodes().getLength()) {
            if (theNode.getParentNode().getChildNodes().item(i) == theNode) {
                cursor = i;
                break;
            }
            ++i;
        }
        return cursor == length;
    }

    @Override
    public String getTextCorrespondingToCurrentStyle() {
        return null;
    }

    @Override
    public int getColumnNumber() {
        return this.currentIndex;
    }

    @Override
    public Object get(Document.PROPERTY property) {
        switch (property) {
            case column: {
                return this.getColumnNumber();
            }
            case row: {
                return this.getRowNumber();
            }
            case text: {
                return this.getText();
            }
        }
        return null;
    }

    private int getRowNumber() {
        return 0;
    }
}

