/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.dialect.description;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.sirius.business.api.dialect.description.AbstractInterpretedExpressionQuery;
import org.eclipse.sirius.business.api.dialect.description.DefaultInterpretedExpressionTargetSwitch;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionQuery;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionTargetSwitch;
import org.eclipse.sirius.business.api.dialect.description.MultiLanguagesValidator;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.interpreter.ValidationResult;
import org.eclipse.sirius.common.tools.api.interpreter.VariableType;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.ContainerLayout;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.business.api.diagramtype.DiagramTypeDescriptorRegistry;
import org.eclipse.sirius.diagram.business.api.diagramtype.IDiagramTypeDescriptor;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.business.internal.dialect.description.DiagramInterpretedExpressionTargetSwitch;
import org.eclipse.sirius.diagram.business.internal.dialect.description.DiagramStyleInterpretedExpressionTargetSwitch;
import org.eclipse.sirius.diagram.business.internal.dialect.description.DiagramToolInterpretedExpressionTargetSwitch;
import org.eclipse.sirius.diagram.business.internal.dialect.description.FilterInterpretedExpressionTargetSwitch;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ConditionalContainerStyleDescription;
import org.eclipse.sirius.diagram.description.ConditionalEdgeStyleDescription;
import org.eclipse.sirius.diagram.description.ConditionalNodeStyleDescription;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.DiagramExtensionDescription;
import org.eclipse.sirius.diagram.description.DragAndDropTargetDescription;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.EdgeMappingImport;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.OrderedTreeLayout;
import org.eclipse.sirius.diagram.description.concern.ConcernPackage;
import org.eclipse.sirius.diagram.description.filter.FilterPackage;
import org.eclipse.sirius.diagram.description.style.ContainerStyleDescription;
import org.eclipse.sirius.diagram.description.style.EdgeStyleDescription;
import org.eclipse.sirius.diagram.description.style.NodeStyleDescription;
import org.eclipse.sirius.diagram.description.style.StylePackage;
import org.eclipse.sirius.diagram.description.tool.ContainerCreationDescription;
import org.eclipse.sirius.diagram.description.tool.CreateEdgeView;
import org.eclipse.sirius.diagram.description.tool.CreateView;
import org.eclipse.sirius.diagram.description.tool.DeleteElementDescription;
import org.eclipse.sirius.diagram.description.tool.DiagramNavigationDescription;
import org.eclipse.sirius.diagram.description.tool.DirectEditLabel;
import org.eclipse.sirius.diagram.description.tool.DoubleClickDescription;
import org.eclipse.sirius.diagram.description.tool.EdgeCreationDescription;
import org.eclipse.sirius.diagram.description.tool.NodeCreationDescription;
import org.eclipse.sirius.diagram.description.tool.ReconnectEdgeDescription;
import org.eclipse.sirius.diagram.description.tool.ToolPackage;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.tools.api.interpreter.context.SiriusInterpreterContextFactory;
import org.eclipse.sirius.viewpoint.description.ConditionalStyleDescription;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;
import org.eclipse.sirius.viewpoint.description.style.BasicLabelStyleDescription;
import org.eclipse.sirius.viewpoint.description.tool.EditMaskVariables;
import org.eclipse.sirius.viewpoint.description.tool.ModelOperation;
import org.eclipse.sirius.viewpoint.description.tool.OperationAction;
import org.eclipse.sirius.viewpoint.description.tool.RepresentationCreationDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;

public class DiagramInterpretedExpressionQuery
extends AbstractInterpretedExpressionQuery
implements IInterpretedExpressionQuery {
    private static final String DIAGRAM_D_DIAGRAM_ELEMENT_CONTAINER = "diagram.DDiagramElementContainer";
    private static final String DIAGRAM_D_SEMANTIC_DIAGRAM = "diagram.DSemanticDiagram";
    private static final String DIAGRAM_D_NODE = "diagram.DNode";
    private static final String DIAGRAM_D_NODE_LIST = "diagram.DNodeList";
    private static final String DIAGRAM_D_NODE_CONTAINER = "diagram.DNodeContainer";
    private static final String DIAGRAM_D_EDGE_TYPE = "diagram.DEdge";
    private static final VariableType EDGE_TARGET_POSSIBILITIES = VariableType.fromStrings((Collection)Sets.newHashSet((Object[])new String[]{"diagram.DEdge", "diagram.DNode", "diagram.DDiagramElementContainer"}));

    public DiagramInterpretedExpressionQuery(EObject target, EStructuralFeature feature) {
        super(target, feature);
    }

    public Collection<EPackage> getPackagesToImport() {
        Collection superResult = super.getPackagesToImport();
        superResult.add(DiagramPackage.eINSTANCE);
        superResult.add(DescriptionPackage.eINSTANCE);
        superResult.add(StylePackage.eINSTANCE);
        superResult.add(ToolPackage.eINSTANCE);
        superResult.add(FilterPackage.eINSTANCE);
        superResult.add(ConcernPackage.eINSTANCE);
        return superResult;
    }

    protected void initializeTargetSwitch() {
        this.targetSwitch = new DiagramGlobalInterpretedTargetSwitch();
    }

    protected void appendAllLocalVariableDefinitions(Map<String, Collection<VariableType>> definitions, EObject context) {
        super.appendAllLocalVariableDefinitions(definitions, context);
        if (context instanceof DirectEditLabel && ((DirectEditLabel)context).getMask() != null) {
            EditMaskVariables emv = ((DirectEditLabel)context).getMask();
            this.appendEditMaskVariables(emv, definitions);
        }
        if (context instanceof CreateView) {
            this.availableVariables.put(((CreateView)context).getVariableName(), VariableType.ANY_EOBJECT);
        }
    }

    protected void collectContextualVariableForOperation(EObject current, Map<String, Collection<VariableType>> definitions, EObject leaf) {
        super.collectContextualVariableForOperation(current, definitions, leaf);
        if (current instanceof CreateView) {
            CreateView op = (CreateView)current;
            DiagramElementMapping mapping = op.getMapping();
            if (mapping instanceof NodeMapping) {
                this.changeSelfType(VariableType.fromString((String)DIAGRAM_D_NODE));
            } else if (mapping instanceof ContainerMapping) {
                if (((ContainerMapping)mapping).getChildrenPresentation() == ContainerLayout.LIST) {
                    this.changeSelfType(VariableType.fromString((String)DIAGRAM_D_NODE_LIST));
                } else {
                    this.changeSelfType(VariableType.fromString((String)DIAGRAM_D_NODE_CONTAINER));
                }
            } else if (mapping instanceof EdgeMapping) {
                this.changeSelfType(VariableType.fromString((String)DIAGRAM_D_EDGE_TYPE));
            }
        }
    }

    public Map<String, VariableType> getAvailableVariables() {
        LinkedHashSet<String> possibleContainerTypes;
        LinkedHashSet<String> possibleContainerViewTypes;
        Map availableVariables = super.getAvailableVariables();
        if (this.target instanceof EdgeCreationDescription) {
            EdgeCreationDescription tool = (EdgeCreationDescription)this.target;
            this.collectEdgeCreationDescriptionVariableTypes(availableVariables, tool);
        } else if (this.target instanceof ConditionalNodeStyleDescription || this.target instanceof NodeStyleDescription) {
            availableVariables.put("view", VariableType.fromString((String)DIAGRAM_D_NODE));
        } else if (this.target instanceof ConditionalContainerStyleDescription || this.target instanceof ContainerStyleDescription) {
            availableVariables.put("view", VariableType.fromString((String)DIAGRAM_D_NODE_CONTAINER));
        } else if (this.target instanceof ConditionalEdgeStyleDescription || this.target instanceof EdgeStyleDescription || this.target instanceof BasicLabelStyleDescription) {
            availableVariables.put("view", VariableType.fromString((String)DIAGRAM_D_EDGE_TYPE));
        } else if (this.target instanceof DiagramElementMapping && this.feature == DescriptionPackage.Literals.DIAGRAM_ELEMENT_MAPPING__PRECONDITION_EXPRESSION) {
            possibleContainerViewTypes = new LinkedHashSet();
            possibleContainerTypes = new LinkedHashSet();
            this.collectPotentialContainerTypes(possibleContainerTypes, possibleContainerViewTypes, (Collection<? extends DiagramElementMapping>)ImmutableList.of((Object)((DiagramElementMapping)this.target)));
            availableVariables.put("container", VariableType.fromStrings(possibleContainerTypes));
            availableVariables.put("containerView", VariableType.fromStrings(possibleContainerViewTypes));
        }
        if (this.target instanceof EdgeMapping && this.feature == DescriptionPackage.Literals.DIAGRAM_ELEMENT_MAPPING__PRECONDITION_EXPRESSION) {
            EdgeMapping edge = (EdgeMapping)this.target;
            LinkedHashSet<String> sourceSemanticType = new LinkedHashSet<String>();
            LinkedHashSet<String> sourceViewType = new LinkedHashSet<String>();
            for (DiagramElementMapping m : edge.getSourceMapping()) {
                this.collectTypes(sourceSemanticType, sourceViewType, m);
            }
            availableVariables.put("source", VariableType.fromStrings(sourceSemanticType));
            availableVariables.put("sourceView", VariableType.fromStrings(sourceViewType));
            LinkedHashSet<String> targetSemanticType = new LinkedHashSet<String>();
            LinkedHashSet<String> targetViewType = new LinkedHashSet<String>();
            for (DiagramElementMapping m : edge.getTargetMapping()) {
                this.collectTypes(targetSemanticType, targetViewType, m);
            }
            availableVariables.put("target", VariableType.fromStrings(targetSemanticType));
            availableVariables.put("targetView", VariableType.fromStrings(targetViewType));
        }
        if (this.target instanceof ConditionalStyleDescription && this.feature == DescriptionPackage.Literals.CONDITIONAL_STYLE_DESCRIPTION__PREDICATE_EXPRESSION) {
            availableVariables.put("diagram", VariableType.fromString((String)DIAGRAM_D_SEMANTIC_DIAGRAM));
        }
        if ((this.target instanceof NodeCreationDescription || this.target instanceof ContainerCreationDescription) && this.feature == ToolPackage.Literals.ABSTRACT_TOOL_DESCRIPTION__PRECONDITION) {
            possibleContainerViewTypes = new LinkedHashSet<String>();
            possibleContainerTypes = new LinkedHashSet<String>();
            LinkedHashSet<DragAndDropTargetDescription> mappings = new LinkedHashSet<DragAndDropTargetDescription>();
            if (this.target instanceof NodeCreationDescription) {
                mappings.addAll((Collection<DragAndDropTargetDescription>)((NodeCreationDescription)this.target).getNodeMappings());
            }
            if (this.target instanceof ContainerCreationDescription) {
                mappings.addAll((Collection<DragAndDropTargetDescription>)((ContainerCreationDescription)this.target).getContainerMappings());
            }
            this.collectPotentialContainerTypes(possibleContainerTypes, possibleContainerViewTypes, mappings);
            if (this.target instanceof ContainerCreationDescription) {
                this.addExtraMappings((Collection<String>)possibleContainerTypes, (Collection<AbstractNodeMapping>)((ContainerCreationDescription)this.target).getExtraMappings());
            }
            if (this.target instanceof NodeCreationDescription) {
                this.addExtraMappings((Collection<String>)possibleContainerTypes, (Collection<AbstractNodeMapping>)((NodeCreationDescription)this.target).getExtraMappings());
            }
            availableVariables.put("container", VariableType.fromStrings(possibleContainerTypes));
            availableVariables.put("containerView", VariableType.fromStrings(possibleContainerViewTypes));
        }
        if (this.target instanceof OrderedTreeLayout && this.feature == DescriptionPackage.Literals.ORDERED_TREE_LAYOUT__CHILDREN_EXPRESSION) {
            LinkedHashSet<String> possibleSemanticTypes = new LinkedHashSet<String>();
            for (AbstractNodeMapping n : ((OrderedTreeLayout)this.target).getNodeMapping()) {
                this.collectTypes(possibleSemanticTypes, Sets.newLinkedHashSet(), n);
            }
            this.refineVariableType(availableVariables, "self", possibleSemanticTypes);
        }
        if (this.target instanceof ReconnectEdgeDescription && this.feature == ToolPackage.Literals.ABSTRACT_TOOL_DESCRIPTION__PRECONDITION) {
            this.collectReconnectEdgeDescriptionVariableTypes(availableVariables);
        }
        if (this.target instanceof RepresentationCreationDescription) {
            this.typeVariablesForDiagramCreationRepresentation((RepresentationCreationDescription)this.target, availableVariables);
        }
        return availableVariables;
    }

    private void addExtraMappings(Collection<String> possibleContainerTypes, Collection<AbstractNodeMapping> extra) {
        for (AbstractNodeMapping np : extra) {
            String domainClass = np.getDomainClass();
            if (StringUtil.isEmpty((String)domainClass)) continue;
            possibleContainerTypes.add(domainClass);
        }
    }

    private void typeVariablesForDiagramCreationRepresentation(RepresentationCreationDescription desc, Map<String, VariableType> availableVariables) {
        LinkedHashSet<String> possibleSemanticTypes = new LinkedHashSet<String>();
        LinkedHashSet<String> possibleViewTypes = new LinkedHashSet<String>();
        LinkedHashSet<String> possibleContainerViewTypes = new LinkedHashSet<String>();
        LinkedHashSet<String> possibleContainerTypes = new LinkedHashSet<String>();
        for (DiagramElementMapping n : Iterables.filter((Iterable)desc.getMappings(), DiagramElementMapping.class)) {
            this.collectTypes(possibleSemanticTypes, possibleViewTypes, n);
            this.collectPotentialContainerTypes(possibleContainerTypes, possibleContainerViewTypes, n);
        }
        this.refineVariableType(availableVariables, "self", possibleSemanticTypes);
        if (this.feature == ToolPackage.Literals.ABSTRACT_TOOL_DESCRIPTION__PRECONDITION) {
            availableVariables.put("container", VariableType.fromStrings(possibleContainerTypes));
            availableVariables.put("containerView", VariableType.fromStrings(possibleContainerViewTypes));
        } else if (this.feature != ToolPackage.Literals.REPRESENTATION_CREATION_DESCRIPTION__BROWSE_EXPRESSION) {
            availableVariables.put("containerView", VariableType.fromStrings(possibleContainerViewTypes));
            if (desc.getRepresentationNameVariable() != null && !StringUtil.isEmpty((String)desc.getRepresentationNameVariable().getName())) {
                availableVariables.put(desc.getRepresentationNameVariable().getName(), VariableType.fromJavaClass(String.class));
            }
        }
    }

    private void collectEdgeCreationDescriptionVariableTypes(Map<String, VariableType> availableVariables, EdgeCreationDescription tool) {
        LinkedHashSet<String> possibleSemanticSources = new LinkedHashSet<String>();
        LinkedHashSet<String> possibleViewSources = new LinkedHashSet<String>();
        LinkedHashSet<String> possibleSemanticTargets = new LinkedHashSet<String>();
        LinkedHashSet<String> possibleViewTargets = new LinkedHashSet<String>();
        LinkedHashSet<String> possibleContainerTypes = new LinkedHashSet<String>();
        this.collectPotentialContainerTypes((Collection<String>)possibleContainerTypes, (Collection<String>)Sets.newLinkedHashSet(), (Collection<? extends DiagramElementMapping>)tool.getEdgeMappings());
        for (EdgeMapping eMapping : tool.getEdgeMappings()) {
            for (DiagramElementMapping endMapping : eMapping.getSourceMapping()) {
                this.collectTypes(possibleSemanticSources, possibleViewSources, endMapping);
            }
            for (DiagramElementMapping endMapping : eMapping.getTargetMapping()) {
                this.collectTypes(possibleSemanticTargets, possibleViewTargets, endMapping);
            }
        }
        for (DiagramElementMapping extraSource : tool.getExtraSourceMappings()) {
            this.collectTypes(possibleSemanticSources, possibleViewSources, extraSource);
        }
        for (DiagramElementMapping extraTarget : tool.getExtraTargetMappings()) {
            this.collectTypes(possibleSemanticTargets, possibleViewTargets, extraTarget);
        }
        if (ToolPackage.Literals.ABSTRACT_TOOL_DESCRIPTION__PRECONDITION.equals(this.feature)) {
            availableVariables.put("container", VariableType.fromStrings(possibleContainerTypes));
            availableVariables.put("diagram", VariableType.fromString((String)DIAGRAM_D_SEMANTIC_DIAGRAM));
            availableVariables.put("preSource", VariableType.fromStrings(possibleSemanticSources));
            availableVariables.put("preSourceView", VariableType.fromStrings(possibleViewSources));
            availableVariables.put("preTarget", VariableType.fromStrings(possibleSemanticTargets));
            availableVariables.put("preTargetView", VariableType.fromStrings(possibleViewTargets));
        }
        if (this.feature == ToolPackage.Literals.EDGE_CREATION_DESCRIPTION__CONNECTION_START_PRECONDITION) {
            availableVariables.put("container", VariableType.fromStrings(possibleContainerTypes));
            availableVariables.put("diagram", VariableType.fromString((String)DIAGRAM_D_SEMANTIC_DIAGRAM));
            availableVariables.put("preSource", VariableType.fromStrings(possibleSemanticSources));
            availableVariables.put("preSourceView", VariableType.fromStrings(possibleViewSources));
        }
    }

    protected void addVariableFromCreateOperation(ModelOperation modelOperation) {
        super.addVariableFromCreateOperation(modelOperation);
        if (modelOperation instanceof CreateEdgeView) {
            this.availableVariables.put(((CreateEdgeView)modelOperation).getVariableName(), VariableType.fromString((String)DIAGRAM_D_EDGE_TYPE));
        } else if (modelOperation instanceof CreateView) {
            this.availableVariables.put(((CreateView)modelOperation).getVariableName(), VariableType.fromString((String)"viewpoint.DView"));
        }
    }

    protected void addVariablesFromToolContext(EObject toolContext) {
        if (toolContext != null) {
            LinkedHashSet<String> possibleViewTypes;
            LinkedHashSet<String> possibleSemanticTypes;
            Object tool;
            this.addVariablesForCreationTools(toolContext);
            if (toolContext instanceof DeleteElementDescription) {
                tool = (DeleteElementDescription)toolContext;
                possibleSemanticTypes = new LinkedHashSet<String>();
                possibleViewTypes = new LinkedHashSet<String>();
                LinkedHashSet<String> possibleContainerViewTypes = new LinkedHashSet<String>();
                for (DiagramElementMapping mapping : tool.getMappings()) {
                    this.collectTypes(possibleSemanticTypes, possibleViewTypes, mapping);
                    this.collectPotentialContainerTypes((Collection<String>)Sets.newLinkedHashSet(), possibleContainerViewTypes, mapping);
                }
                this.refineVariableType(this.availableVariables, "element", possibleSemanticTypes);
                this.refineVariableType(this.availableVariables, "elementView", possibleViewTypes);
                this.refineVariableType(this.availableVariables, "containerView", possibleContainerViewTypes);
            }
            if (toolContext instanceof OperationAction) {
                tool = (OperationAction)toolContext;
                if (new EObjectQuery((EObject)tool).getFirstAncestorOfType(DescriptionPackage.Literals.DIAGRAM_DESCRIPTION).some()) {
                    this.availableVariables.put("diagram", VariableType.fromString((String)DIAGRAM_D_SEMANTIC_DIAGRAM));
                }
                this.availableVariables.put("views", VariableType.fromString((String)"viewpoint.DSemanticDecorator"));
            }
            if (toolContext instanceof ToolDescription && !StringUtil.isEmpty((String)(tool = (ToolDescription)toolContext).getPrecondition())) {
                IInterpreterContext iContext = SiriusInterpreterContextFactory.createInterpreterContext((EObject)tool, (EStructuralFeature)ToolPackage.Literals.ABSTRACT_TOOL_DESCRIPTION__PRECONDITION);
                ValidationResult res = MultiLanguagesValidator.getInstance().validateExpression(iContext, tool.getPrecondition());
                Map inferedTypes = res.getInferredVariableTypes(Boolean.TRUE);
                for (Map.Entry infered : inferedTypes.entrySet()) {
                    if ("self".equals(infered.getKey())) {
                        this.changeSelfType((VariableType)infered.getValue());
                        continue;
                    }
                    if (((VariableType)infered.getValue()).getPossibleTypes().size() <= 0) continue;
                    this.availableVariables.put((String)infered.getKey(), (VariableType)infered.getValue());
                }
                this.availableVariables.put("diagram", VariableType.fromString((String)DIAGRAM_D_SEMANTIC_DIAGRAM));
            }
            if (toolContext instanceof DiagramNavigationDescription) {
                tool = (DiagramNavigationDescription)toolContext;
                LinkedHashSet<String> possibleContainerSemanticTypes = new LinkedHashSet<String>();
                LinkedHashSet<String> possibleContainerViewTypes = new LinkedHashSet<String>();
                this.collectPotentialContainerTypes(possibleContainerSemanticTypes, possibleContainerViewTypes, Lists.newArrayList((Iterable)Iterables.filter((Iterable)tool.getMappings(), DiagramElementMapping.class)));
                this.refineVariableType(this.availableVariables, tool.getContainerVariable().getName(), possibleContainerSemanticTypes);
                this.refineVariableType(this.availableVariables, tool.getContainerViewVariable().getName(), possibleContainerViewTypes);
            }
            if (toolContext instanceof DoubleClickDescription) {
                tool = (DoubleClickDescription)toolContext;
                possibleSemanticTypes = new LinkedHashSet();
                possibleViewTypes = new LinkedHashSet();
                for (DiagramElementMapping m : tool.getMappings()) {
                    this.collectTypes(possibleSemanticTypes, possibleViewTypes, m);
                }
                this.refineVariableType(this.availableVariables, tool.getElement().getName(), possibleSemanticTypes);
                this.refineVariableType(this.availableVariables, tool.getElementView().getName(), possibleViewTypes);
            }
            if (toolContext instanceof RepresentationCreationDescription) {
                this.typeVariablesForDiagramCreationRepresentation((RepresentationCreationDescription)toolContext, this.availableVariables);
            }
        }
    }

    private void addVariablesForCreationTools(EObject toolContext) {
        LinkedHashSet<String> possibleViewTypes;
        String domainClass;
        Object tool;
        if (toolContext instanceof EdgeCreationDescription) {
            tool = (EdgeCreationDescription)toolContext;
            this.declareEdgeSourceTargets(this.availableVariables, (Collection<EdgeMapping>)tool.getEdgeMappings(), (Collection<DiagramElementMapping>)tool.getExtraSourceMappings(), (Collection<DiagramElementMapping>)tool.getExtraTargetMappings());
        }
        if (toolContext instanceof ReconnectEdgeDescription) {
            tool = (ReconnectEdgeDescription)toolContext;
            this.declareEdgeSourceTargets(this.availableVariables, (Collection<EdgeMapping>)tool.getMappings(), (Collection<DiagramElementMapping>)Collections.emptyList(), (Collection<DiagramElementMapping>)Collections.emptyList());
            this.availableVariables.put("otherEnd", EDGE_TARGET_POSSIBILITIES);
            this.availableVariables.put("edgeView", VariableType.fromString((String)DIAGRAM_D_EDGE_TYPE));
            ArrayList<String> possibleSources = new ArrayList<String>();
            for (EdgeMapping eMapping : tool.getMappings()) {
                this.collectSemanticElementType(possibleSources, eMapping);
            }
            this.refineVariableType(this.availableVariables, "element", possibleSources);
        }
        if (toolContext instanceof NodeCreationDescription) {
            tool = (NodeCreationDescription)toolContext;
            LinkedHashSet<String> possibleSemanticTypes = new LinkedHashSet<String>();
            for (AbstractNodeMapping np : tool.getExtraMappings()) {
                domainClass = np.getDomainClass();
                if (StringUtil.isEmpty((String)domainClass)) continue;
                possibleSemanticTypes.add(domainClass);
            }
            possibleViewTypes = new LinkedHashSet<String>();
            this.collectPotentialContainerTypes((Collection<String>)possibleSemanticTypes, (Collection<String>)possibleViewTypes, (Collection<? extends DiagramElementMapping>)tool.getNodeMappings());
            this.changeSelfType(VariableType.fromStrings(possibleSemanticTypes));
            this.refineVariableType(this.availableVariables, "container", possibleSemanticTypes);
            this.refineVariableType(this.availableVariables, "containerView", possibleViewTypes);
        }
        if (toolContext instanceof ContainerCreationDescription) {
            tool = (ContainerCreationDescription)toolContext;
            LinkedHashSet<String> possibleTypes = new LinkedHashSet<String>();
            for (AbstractNodeMapping np : tool.getExtraMappings()) {
                domainClass = np.getDomainClass();
                if (StringUtil.isEmpty((String)domainClass)) continue;
                possibleTypes.add(domainClass);
            }
            possibleViewTypes = new LinkedHashSet();
            this.collectPotentialContainerTypes((Collection<String>)possibleTypes, (Collection<String>)possibleViewTypes, (Collection<? extends DiagramElementMapping>)tool.getContainerMappings());
            this.changeSelfType(VariableType.fromStrings(possibleTypes));
            this.refineVariableType(this.availableVariables, "containerView", possibleViewTypes);
            this.refineVariableType(this.availableVariables, "container", possibleTypes);
        }
    }

    private void refineVariableType(Map<String, VariableType> availableVariables, String variableName, Collection<String> foundTypes) {
        if (foundTypes.size() > 0) {
            availableVariables.put(variableName, VariableType.fromStrings(foundTypes));
        }
    }

    private void collectPotentialContainerTypes(Collection<String> possibleSemanticTypes, Collection<String> possibleViewTypes, Collection<? extends DiagramElementMapping> toolMappings) {
        for (DiagramElementMapping diagramElementMapping : toolMappings) {
            this.collectPotentialContainerTypes(possibleSemanticTypes, possibleViewTypes, diagramElementMapping);
        }
    }

    private void collectPotentialContainerTypes(Collection<String> possibleSemanticTypes, Collection<String> possibleViewTypes, DiagramElementMapping mapping) {
        String domainClass;
        EObject container = mapping.eContainer();
        if (container instanceof Layer) {
            container = container.eContainer();
        }
        if (container instanceof AbstractNodeMapping) {
            domainClass = ((AbstractNodeMapping)container).getDomainClass();
            if (!StringUtil.isEmpty((String)domainClass)) {
                possibleSemanticTypes.add(domainClass);
            }
            this.collectViewTypes(possibleViewTypes, (AbstractNodeMapping)container);
        } else if (container instanceof DiagramDescription) {
            domainClass = ((DiagramDescription)container).getDomainClass();
            if (!StringUtil.isEmpty((String)domainClass)) {
                possibleSemanticTypes.add(domainClass);
            }
            possibleViewTypes.add(DIAGRAM_D_SEMANTIC_DIAGRAM);
        }
        ECrossReferenceAdapter crossReferencer = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)mapping);
        if (crossReferencer != null) {
            for (EStructuralFeature.Setting xRef : crossReferencer.getInverseReferences((EObject)mapping)) {
                String domainClass2;
                EStructuralFeature eStructuralFeature = xRef.getEStructuralFeature();
                EObject referencingObject = xRef.getEObject();
                if (eStructuralFeature == DescriptionPackage.Literals.DIAGRAM_DESCRIPTION__REUSED_MAPPINGS && referencingObject instanceof DiagramDescription) {
                    domainClass2 = ((DiagramDescription)referencingObject).getDomainClass();
                    if (StringUtil.isEmpty((String)domainClass2)) continue;
                    possibleSemanticTypes.add(domainClass2);
                    continue;
                }
                if (eStructuralFeature == DescriptionPackage.Literals.ABSTRACT_NODE_MAPPING__REUSED_BORDERED_NODE_MAPPINGS && referencingObject instanceof AbstractNodeMapping) {
                    domainClass2 = ((AbstractNodeMapping)referencingObject).getDomainClass();
                    if (StringUtil.isEmpty((String)domainClass2)) continue;
                    possibleSemanticTypes.add(domainClass2);
                    continue;
                }
                if (eStructuralFeature != DescriptionPackage.Literals.CONTAINER_MAPPING__REUSED_CONTAINER_MAPPINGS && eStructuralFeature != DescriptionPackage.Literals.CONTAINER_MAPPING__REUSED_NODE_MAPPINGS || !(referencingObject instanceof ContainerMapping) || StringUtil.isEmpty((String)(domainClass2 = ((ContainerMapping)referencingObject).getDomainClass()))) continue;
                possibleSemanticTypes.add(domainClass2);
            }
        }
    }

    private void declareEdgeSourceTargets(Map<String, VariableType> availableVariables, Collection<EdgeMapping> eMappings, Collection<DiagramElementMapping> extraSourceMappings, Collection<DiagramElementMapping> extraTargetMappings) {
        LinkedHashSet<String> possibleSemanticSources = new LinkedHashSet<String>();
        LinkedHashSet<String> possibleViewSources = new LinkedHashSet<String>();
        LinkedHashSet<String> possibleSemanticTargets = new LinkedHashSet<String>();
        LinkedHashSet<String> possibleViewTargets = new LinkedHashSet<String>();
        for (EdgeMapping eMapping : eMappings) {
            for (DiagramElementMapping endMapping : eMapping.getSourceMapping()) {
                this.collectTypes(possibleSemanticSources, possibleViewSources, endMapping);
            }
            for (DiagramElementMapping endMapping : eMapping.getTargetMapping()) {
                this.collectTypes(possibleSemanticTargets, possibleViewTargets, endMapping);
            }
        }
        for (DiagramElementMapping extraSource : extraSourceMappings) {
            this.collectTypes(possibleSemanticSources, possibleViewSources, extraSource);
        }
        for (DiagramElementMapping extraTarget : extraTargetMappings) {
            this.collectTypes(possibleSemanticTargets, possibleViewTargets, extraTarget);
        }
        this.refineVariableType(availableVariables, "sourceView", possibleViewSources);
        this.refineVariableType(availableVariables, "preSourceView", possibleViewSources);
        this.refineVariableType(availableVariables, "targetView", possibleViewTargets);
        this.refineVariableType(availableVariables, "preSource", possibleSemanticSources);
        this.refineVariableType(availableVariables, "source", possibleSemanticSources);
        if (this.feature != ToolPackage.Literals.EDGE_CREATION_DESCRIPTION__CONNECTION_START_PRECONDITION) {
            this.refineVariableType(availableVariables, "preTarget", possibleSemanticTargets);
            this.refineVariableType(availableVariables, "target", possibleSemanticTargets);
            this.refineVariableType(availableVariables, "preTargetView", possibleViewTargets);
        }
    }

    private void collectTypes(Collection<String> possibleSemanticTypes, Collection<String> possibleViewTypes, DiagramElementMapping endMapping) {
        this.collectViewTypes(possibleViewTypes, endMapping);
        if (endMapping instanceof AbstractNodeMapping) {
            String domainClass = ((AbstractNodeMapping)endMapping).getDomainClass();
            if (!StringUtil.isEmpty((String)domainClass)) {
                possibleSemanticTypes.add(domainClass);
            }
        } else if (endMapping instanceof EdgeMapping) {
            EdgeMapping edgeMapping = (EdgeMapping)endMapping;
            this.collectSemanticElementType(possibleSemanticTypes, edgeMapping);
        }
    }

    private void collectViewTypes(Collection<String> possibleViewTypes, DiagramElementMapping endMapping) {
        if (endMapping instanceof ContainerMapping) {
            if (((ContainerMapping)endMapping).getChildrenPresentation() == ContainerLayout.LIST) {
                possibleViewTypes.add(DIAGRAM_D_NODE_LIST);
            } else {
                possibleViewTypes.add(DIAGRAM_D_NODE_CONTAINER);
            }
        } else if (endMapping instanceof NodeMapping) {
            possibleViewTypes.add(DIAGRAM_D_NODE);
        } else if (endMapping instanceof EdgeMapping) {
            possibleViewTypes.add(DIAGRAM_D_EDGE_TYPE);
        }
    }

    private void collectSemanticElementType(Collection<String> possibleSources, EdgeMapping edgeMapping) {
        if (edgeMapping.isUseDomainElement()) {
            String domainClass = edgeMapping.getDomainClass();
            if (!StringUtil.isEmpty((String)domainClass)) {
                possibleSources.add(domainClass);
            }
        } else {
            for (AbstractNodeMapping nMapping : Iterables.filter(edgeMapping.getSourceMapping(), AbstractNodeMapping.class)) {
                String domainClass = nMapping.getDomainClass();
                if (StringUtil.isEmpty((String)domainClass)) continue;
                possibleSources.add(domainClass);
            }
        }
    }

    private void collectReconnectEdgeDescriptionVariableTypes(Map<String, VariableType> availableVariables) {
        LinkedHashSet<String> possibleContainerTypes = new LinkedHashSet<String>();
        EList<EdgeMapping> mappings = ((ReconnectEdgeDescription)this.target).getMappings();
        this.collectPotentialContainerTypes((Collection<String>)possibleContainerTypes, (Collection<String>)Sets.newLinkedHashSet(), (Collection<? extends DiagramElementMapping>)mappings);
        availableVariables.put("container", VariableType.fromStrings(possibleContainerTypes));
        LinkedHashSet<String> sourceSemanticType = new LinkedHashSet<String>();
        LinkedHashSet<String> sourceViewType = new LinkedHashSet<String>();
        LinkedHashSet<String> targetSemanticType = new LinkedHashSet<String>();
        LinkedHashSet<String> targetViewType = new LinkedHashSet<String>();
        for (EdgeMapping edgeMapping : mappings) {
            for (DiagramElementMapping m : edgeMapping.getSourceMapping()) {
                this.collectTypes(sourceSemanticType, sourceViewType, m);
            }
            for (DiagramElementMapping m : edgeMapping.getTargetMapping()) {
                this.collectTypes(targetSemanticType, targetViewType, m);
            }
        }
        availableVariables.put("source", VariableType.fromStrings(sourceSemanticType));
        availableVariables.put("sourceView", VariableType.fromStrings(sourceViewType));
        availableVariables.put("target", VariableType.fromStrings(targetSemanticType));
        availableVariables.put("targetView", VariableType.fromStrings(targetViewType));
        availableVariables.put("diagram", VariableType.fromString((String)DIAGRAM_D_SEMANTIC_DIAGRAM));
    }

    private class DiagramGlobalInterpretedTargetSwitch
    implements IInterpretedExpressionTargetSwitch {
        private DefaultInterpretedExpressionTargetSwitch defaultSwitch;
        private DiagramInterpretedExpressionTargetSwitch diagramDescriptionSwitch;
        private DiagramStyleInterpretedExpressionTargetSwitch diagramStyleSwitch;
        private DiagramToolInterpretedExpressionTargetSwitch diagramToolSwitch;
        private FilterInterpretedExpressionTargetSwitch diagramFilterSwitch;

        private DiagramGlobalInterpretedTargetSwitch() {
            this.defaultSwitch = new DefaultInterpretedExpressionTargetSwitch(DiagramInterpretedExpressionQuery.this.feature, this){

                public EObject getFirstRelevantContainer(EObject obj) {
                    return DiagramGlobalInterpretedTargetSwitch.this.getFirstRelevantContainer(obj);
                }
            };
            this.diagramDescriptionSwitch = new DiagramInterpretedExpressionTargetSwitch(DiagramInterpretedExpressionQuery.this.feature, this);
            this.diagramStyleSwitch = new DiagramStyleInterpretedExpressionTargetSwitch(DiagramInterpretedExpressionQuery.this.feature, this);
            this.diagramToolSwitch = new DiagramToolInterpretedExpressionTargetSwitch(DiagramInterpretedExpressionQuery.this.feature, this);
            this.diagramFilterSwitch = new FilterInterpretedExpressionTargetSwitch(DiagramInterpretedExpressionQuery.this.feature, this);
        }

        public Option<Collection<String>> doSwitch(EObject target, boolean considerFeature) {
            LinkedHashSet targetTypes = new LinkedHashSet();
            Option expressionTarget = Options.newSome(targetTypes);
            if (target != null) {
                for (IDiagramTypeDescriptor diagramTypeDescriptor : DiagramTypeDescriptorRegistry.getInstance().getAllDiagramTypeDescriptors()) {
                    IInterpretedExpressionTargetSwitch contributedSwitch;
                    if (!diagramTypeDescriptor.getDiagramDescriptionProvider().handles(target.eClass().getEPackage()) || (contributedSwitch = diagramTypeDescriptor.getDiagramDescriptionProvider().createInterpretedExpressionSwitch(DiagramInterpretedExpressionQuery.this.feature, this)) == null) continue;
                    expressionTarget = contributedSwitch.doSwitch(target, considerFeature);
                }
                if (expressionTarget.some() && ((Collection)expressionTarget.get()).isEmpty()) {
                    this.diagramDescriptionSwitch.setConsiderFeature(considerFeature);
                    expressionTarget = this.diagramDescriptionSwitch.doSwitch(target);
                }
                if (expressionTarget.some() && ((Collection)expressionTarget.get()).isEmpty()) {
                    this.diagramStyleSwitch.setConsiderFeature(considerFeature);
                    expressionTarget = this.diagramStyleSwitch.doSwitch(target);
                }
                if (expressionTarget.some() && ((Collection)expressionTarget.get()).isEmpty()) {
                    this.diagramToolSwitch.setConsiderFeature(considerFeature);
                    expressionTarget = this.diagramToolSwitch.doSwitch(target);
                }
                if (expressionTarget.some() && ((Collection)expressionTarget.get()).isEmpty()) {
                    this.diagramFilterSwitch.setConsiderFeature(considerFeature);
                    expressionTarget = this.diagramFilterSwitch.doSwitch(target);
                }
                if (expressionTarget.some() && ((Collection)expressionTarget.get()).isEmpty()) {
                    expressionTarget = this.defaultSwitch.doSwitch(target, considerFeature);
                }
            }
            return expressionTarget;
        }

        public EObject getFirstRelevantContainer(EObject obj) {
            if (obj != null) {
                EObject container = obj.eContainer();
                while (container != null && !this.isRelevant(container)) {
                    container = container.eContainer();
                }
                return container;
            }
            return null;
        }

        private boolean isRelevant(EObject container) {
            return container instanceof RepresentationDescription || container instanceof RepresentationElementMapping || container instanceof EdgeMappingImport || container instanceof DiagramExtensionDescription;
        }
    }
}

