/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.graphical.edit.policies;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class ChangeBoundRequestRecorder {
    private Multimap<EditPart, ChangeBoundsRequest> allRequests = HashMultimap.create();
    private boolean recording;

    public void startRecording() {
        this.recording = true;
        this.allRequests = HashMultimap.create();
    }

    public void stopRecording() {
        this.recording = false;
    }

    public boolean isRecording() {
        return this.recording;
    }

    public Multimap<EditPart, ChangeBoundsRequest> getAllRequests() {
        return this.allRequests;
    }

    public void processRequest(Request request, EditPart host) {
        if (this.isRecording() && request instanceof ChangeBoundsRequest) {
            this.allRequests.put((Object)host, (Object)((ChangeBoundsRequest)request));
        }
    }

    public void dispose() {
        if (this.isRecording()) {
            this.stopRecording();
        }
        if (this.allRequests != null) {
            this.allRequests.clear();
        }
        this.allRequests = null;
    }
}

