/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.figure;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.draw2d.ui.internal.figures.TransparentBorder;

public class NotificationFigure
extends RectangleFigure {
    private static final int WARNING_COLOR_VALUE = 0xCBFFFF;
    private static final int WIDTH = 400;
    private static final int HEIGHT = 30;
    private static final int TEXT_OFFSET = 5;
    private int transparency = 20;
    private PropertyChangeListener propListener;
    private Viewport viewport;
    private DiagramRootEditPart rootEditPart;

    public NotificationFigure(DiagramRootEditPart rootEditPart, String message) {
        this.rootEditPart = rootEditPart;
        this.viewport = (Viewport)rootEditPart.getFigure();
        this.setSize(400, 30);
        this.setBackgroundColor(DiagramColorRegistry.getInstance().getColor(Integer.valueOf(0xCBFFFF)));
        this.updateLocation();
        Cross cross = new Cross();
        int crossSize = cross.getSize().width;
        cross.setLocation(new Point(400 - crossSize - 3, 3));
        this.add((IFigure)cross);
        cross.initialize();
        Label label = new Label(message);
        label.setSize(395 - crossSize, 25);
        this.add((IFigure)label);
        this.propListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                NotificationFigure.this.updateLocation();
            }
        };
    }

    private void updateLocation() {
        Point viewLocation = this.viewport.getViewLocation().getCopy();
        Dimension viewSize = this.viewport.getSize().getCopy();
        double notationFigureOffset = (double)(viewSize.width - 400) / 2.0 / (this.rootEditPart.getZoomManager().getZoom() * this.rootEditPart.getZoomManager().getZoom());
        viewLocation.performScale(1.0 / this.rootEditPart.getZoomManager().getZoom());
        this.setLocation((Point)new PrecisionPoint((double)viewLocation.x + notationFigureOffset, (double)viewLocation.y));
    }

    public void addNotify() {
        super.addNotify();
        this.viewport.addPropertyChangeListener("viewLocation", this.propListener);
    }

    public void removeNotify() {
        super.removeNotify();
        this.viewport.removePropertyChangeListener("viewLocation", this.propListener);
        this.viewport = null;
    }

    protected boolean useLocalCoordinates() {
        return true;
    }

    public static void createNotification(DiagramRootEditPart rootEditPart, String message) {
        LayeredPane pane = (LayeredPane)rootEditPart.getLayer((Object)"Printable Layers");
        NotificationFigure nf = new NotificationFigure(rootEditPart, message);
        pane.add((IFigure)nf);
    }

    public void paintFigure(Graphics g) {
        this.applyTransparency(g);
        super.paintFigure(g);
        g.setAlpha(255);
    }

    public Rectangle getHandleBounds() {
        Insets insets = new Insets(0, 0, 0, 0);
        if (this.getBorder() instanceof TransparentBorder) {
            insets = ((TransparentBorder)this.getBorder()).getTransparentInsets((IFigure)this);
        }
        return new Rectangle(this.getBounds().x + insets.left, this.getBounds().y + insets.top, this.getBounds().width - (insets.right + insets.left), this.getBounds().height - (insets.bottom + insets.top));
    }

    public int getTransparency() {
        return this.transparency;
    }

    public void setTransparency(int transparency) {
        if (transparency != this.transparency && transparency >= 0 && transparency <= 100) {
            this.transparency = transparency;
            this.repaint();
        }
    }

    protected void applyTransparency(Graphics g) {
        g.setAlpha(255 - this.transparency * 255 / 100);
    }

    private static class Cross
    extends Shape {
        Cross() {
            this.setSize(10, 10);
        }

        protected boolean useLocalCoordinates() {
            return true;
        }

        protected void fillShape(Graphics graphics) {
            graphics.pushState();
            int x = this.getBounds().x;
            int y = this.getBounds().y;
            int[] shape = new int[]{x, y, x + 2, y, x + 4, y + 2, x + 5, y + 2, x + 7, y, x + 9, y, x + 9, y + 2, x + 7, y + 4, x + 7, y + 5, x + 9, y + 7, x + 9, y + 9, x + 7, y + 9, x + 5, y + 7, x + 4, y + 7, x + 2, y + 9, x, y + 9, x, y + 7, x + 2, y + 5, x + 2, y + 4, x, y + 2};
            graphics.setBackgroundColor(ColorConstants.red);
            graphics.fillPolygon(shape);
            graphics.setForegroundColor(ColorConstants.black);
            graphics.drawPolygon(shape);
            graphics.popState();
        }

        protected void outlineShape(Graphics arg0) {
        }

        public void initialize() {
            this.addMouseListener((MouseListener)new MouseListener.Stub(){

                public void mousePressed(MouseEvent me) {
                    this.getParent().getParent().remove(this.getParent());
                }
            });
        }
    }
}

