/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editparts;

import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserService;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.LabelDirectEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.diagram.ui.label.ILabelDelegate;
import org.eclipse.gmf.runtime.diagram.ui.label.WrappingLabelDelegate;
import org.eclipse.gmf.runtime.diagram.ui.tools.TextDirectEditManager;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ParserHintAdapter;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.TextAlignment;
import org.eclipse.gmf.runtime.notation.TextStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;

public class TextCompartmentEditPart
extends CompartmentEditPart
implements ITextAwareEditPart {
    private DirectEditManager manager;
    protected IParser parser;
    private ParserOptions parserOptions;
    private List parserElements = null;
    private int numIcons = 0;
    private Label toolTipLabel = new Label();
    private ILabelDelegate labelDelegate;

    public TextCompartmentEditPart(EObject model) {
        super(model);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new LabelDirectEditPolicy());
        this.removeEditPolicy("CreationPolicy");
    }

    protected IFigure createFigure() {
        return this.createWrapLabel();
    }

    protected WrapLabel createWrapLabel() {
        return new WrapLabel();
    }

    protected ILabelDelegate createLabelDelegate() {
        WrapLabel label = this.getLabel();
        WrappingLabelDelegate newLabelDelegate = null;
        newLabelDelegate = label != null ? new WrappingLabelDelegate((WrappingLabel)label) : new WrappingLabelDelegate((WrappingLabel)this.getFigure());
        newLabelDelegate.setTextJustification(2);
        newLabelDelegate.setAlignment(2);
        newLabelDelegate.setTextAlignment(8);
        return newLabelDelegate;
    }

    public IFigure getFigure() {
        if (this.figure == null) {
            this.setFigure(this.createFigure());
            this.setLabelDelegate(this.createLabelDelegate());
        }
        return this.figure;
    }

    public ILabelDelegate getLabelDelegate() {
        if (this.labelDelegate == null) {
            this.getFigure();
            if (this.labelDelegate == null) {
                this.setLabelDelegate(this.createLabelDelegate());
            }
            return this.labelDelegate;
        }
        return this.labelDelegate;
    }

    protected void setLabelDelegate(ILabelDelegate labelDelegate) {
        this.labelDelegate = labelDelegate;
    }

    public Object getAdapter(Class key) {
        if (key == ILabelDelegate.class) {
            return this.getLabelDelegate();
        }
        return super.getAdapter(key);
    }

    public WrapLabel getLabel() {
        return (WrapLabel)this.getFigure();
    }

    protected Image getLabelIcon(int index) {
        return null;
    }

    protected String getLabelText() {
        EObject element = this.resolveSemanticElement();
        return element == null ? null : (this.getParser() == null ? null : this.getParser().getPrintString((IAdaptable)new EObjectAdapter(element), this.getParserOptions().intValue()));
    }

    public String getEditText() {
        EObject element = this.resolveSemanticElement();
        return element == null ? "" : this.getParser().getEditString((IAdaptable)new EObjectAdapter(element), this.getParserOptions().intValue());
    }

    public void setLabelText(String text) {
        this.getLabelDelegate().setText(text);
    }

    public IContentAssistProcessor getCompletionProcessor() {
        EObject element = this.resolveSemanticElement();
        if (element != null) {
            return this.getParser().getCompletionProcessor((IAdaptable)new EObjectAdapter(element));
        }
        return null;
    }

    private boolean canParse() {
        return this.getEditText() != null;
    }

    public ICellEditorValidator getEditTextValidator() {
        return new ICellEditorValidator(){

            public String isValid(final Object value) {
                if (value instanceof String) {
                    final EObject element = TextCompartmentEditPart.this.resolveSemanticElement();
                    final IParser theParser = TextCompartmentEditPart.this.getParser();
                    try {
                        IParserEditStatus isValid = (IParserEditStatus)TextCompartmentEditPart.this.getEditingDomain().runExclusive((Runnable)new RunnableWithResult.Impl(){

                            public void run() {
                                this.setResult(theParser.isValidEditString((IAdaptable)new EObjectAdapter(element), (String)value));
                            }
                        });
                        return isValid.getCode() == 0 ? null : isValid.getMessage();
                    }
                    catch (InterruptedException e) {
                        Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"getEditTextValidator", (Throwable)e);
                        Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"getEditTextValidator", (Throwable)e);
                    }
                }
                return null;
            }
        };
    }

    public final ParserOptions getParserOptions() {
        if (this.parserOptions == null) {
            this.parserOptions = this.buildParserOptions();
        }
        return this.parserOptions;
    }

    protected ParserOptions buildParserOptions() {
        return ParserOptions.NONE;
    }

    protected final void refreshParserOptions() {
        this.parserOptions = this.buildParserOptions();
    }

    protected boolean isAffectingParserOptions(PropertyChangeEvent evt) {
        return false;
    }

    protected boolean isAffectingParserOptions(Notification evt) {
        return false;
    }

    protected IFigure getLabelToolTip() {
        String text = this.getToolTipText();
        if (text != null && text.length() > 0) {
            this.toolTipLabel.setText(text);
            return this.toolTipLabel;
        }
        return null;
    }

    protected String getToolTipText() {
        return null;
    }

    protected boolean isEditable() {
        EObject element = this.resolveSemanticElement();
        return element != null && this.canParse();
    }

    protected void performDirectEdit() {
        this.getManager().show();
    }

    protected void performDirectEdit(Point eventLocation) {
        if (this.getManager().getClass() == TextDirectEditManager.class) {
            ((TextDirectEditManager)this.getManager()).show(eventLocation.getSWTPoint());
        } else {
            this.performDirectEdit();
        }
    }

    private void performDirectEdit(char initialCharacter) {
        if (this.getManager() instanceof TextDirectEditManager) {
            ((TextDirectEditManager)this.getManager()).show(initialCharacter);
        } else {
            this.performDirectEdit();
        }
    }

    private void showEditPart() {
        EditPartViewer viewer;
        EditPart parent = this.getParent();
        if (parent != null && (viewer = parent.getViewer()) != null) {
            viewer.reveal((EditPart)this);
        }
    }

    protected void performDirectEditRequest(Request request) {
        final Request theRequest = request;
        try {
            this.getEditingDomain().runExclusive(new Runnable(){

                public void run() {
                    if (TextCompartmentEditPart.this.isActive() && TextCompartmentEditPart.this.isEditable()) {
                        TextCompartmentEditPart.this.showEditPart();
                        if (theRequest.getExtendedData().get("directedit_extendeddata_initial_char") instanceof Character) {
                            Character initialChar = (Character)theRequest.getExtendedData().get("directedit_extendeddata_initial_char");
                            TextCompartmentEditPart.this.performDirectEdit(initialChar.charValue());
                        } else if (theRequest instanceof DirectEditRequest && TextCompartmentEditPart.this.getEditText().equals(TextCompartmentEditPart.this.getLabelText())) {
                            DirectEditRequest editRequest = (DirectEditRequest)theRequest;
                            TextCompartmentEditPart.this.performDirectEdit(editRequest.getLocation());
                        } else {
                            TextCompartmentEditPart.this.performDirectEdit();
                        }
                    }
                }
            });
        }
        catch (InterruptedException e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"performDirectEditRequest", (Throwable)e);
            Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"performDirectEditRequest", (Throwable)e);
        }
    }

    protected void handleNotificationEvent(Notification event) {
        Object feature = event.getFeature();
        if (NotationPackage.eINSTANCE.getFontStyle_FontColor().equals(feature)) {
            Integer c = (Integer)event.getNewValue();
            this.setFontColor(DiagramColorRegistry.getInstance().getColor(c));
        } else if (NotationPackage.eINSTANCE.getFontStyle_Underline().equals(feature)) {
            this.refreshUnderline();
        } else if (NotationPackage.eINSTANCE.getFontStyle_StrikeThrough().equals(feature)) {
            this.refreshStrikeThrough();
        } else if (NotationPackage.eINSTANCE.getFontStyle_FontHeight().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_FontName().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_Bold().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_Italic().equals(feature)) {
            this.refreshFont();
        } else if (NotationPackage.eINSTANCE.getTextStyle_TextAlignment().equals(feature)) {
            this.refreshTextAlignment();
        } else if (this.isAffectingParserOptions(event)) {
            this.refreshParserOptions();
            this.refreshLabel();
        } else if (this.getParser() != null) {
            boolean sematicsAffected = this.getParser() instanceof ISemanticParser && ((ISemanticParser)this.getParser()).areSemanticElementsAffected(null, (Object)event);
            boolean parserAffected = this.getParser().isAffectingEvent((Object)event, this.getParserOptions().intValue());
            if (sematicsAffected) {
                this.removeSemanticListeners();
                if (this.resolveSemanticElement() != null) {
                    this.addSemanticListeners();
                }
            }
            if (sematicsAffected || parserAffected) {
                this.refreshLabel();
            }
        }
        super.handleNotificationEvent(event);
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshParserOptions();
        this.refreshLabel();
        this.refreshFont();
        this.refreshUnderline();
        this.refreshStrikeThrough();
        this.refreshFontColor();
        this.refreshTextAlignment();
    }

    protected void refreshFont() {
        FontStyle style = (FontStyle)this.getPrimaryView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        FontData fontData = null;
        fontData = style != null ? new FontData(style.getFontName(), style.getFontHeight(), (style.isBold() ? 1 : 0) | (style.isItalic() ? 2 : 0)) : PreferenceConverter.getFontData((IPreferenceStore)((IPreferenceStore)this.getDiagramPreferencesHint().getPreferenceStore()), (String)"Appearance.defaultFont");
        this.setFont(fontData);
    }

    protected void setFontColor(Color color) {
        this.getFigure().setForegroundColor(color);
    }

    protected void addNotationalListeners() {
        super.addNotationalListeners();
        this.addListenerFilter("PrimaryView", this, (EObject)this.getPrimaryView());
    }

    protected void addSemanticListeners() {
        if (this.getParser() instanceof ISemanticParser) {
            EObject semanticElement = this.resolveSemanticElement();
            this.parserElements = ((ISemanticParser)this.getParser()).getSemanticElementsBeingParsed(semanticElement);
            int i = 0;
            while (i < this.parserElements.size()) {
                this.addListenerFilter("SemanticModel" + i, this, (EObject)this.parserElements.get(i));
                ++i;
            }
        } else {
            super.addSemanticListeners();
        }
    }

    protected void removeNotationalListeners() {
        super.removeNotationalListeners();
        this.removeListenerFilter("PrimaryView");
    }

    protected void removeSemanticListeners() {
        if (this.parserElements != null) {
            int i = 0;
            while (i < this.parserElements.size()) {
                this.removeListenerFilter("SemanticModel" + i);
                ++i;
            }
        } else {
            super.removeSemanticListeners();
        }
    }

    public int getNumIcons() {
        return this.numIcons;
    }

    public void setNumIcons(int numIcons) {
        this.numIcons = numIcons;
    }

    protected List getModelChildren() {
        return Collections.EMPTY_LIST;
    }

    public IParser getParser() {
        if (this.parser == null) {
            String parserHint = ((View)this.getModel()).getType();
            EObject element = this.resolveSemanticElement();
            if (element != null) {
                ParserHintAdapter hintAdapter = new ParserHintAdapter(element, parserHint);
                this.parser = ParserService.getInstance().getParser((IAdaptable)hintAdapter);
            }
        }
        return this.parser;
    }

    protected void refreshLabel() {
        this.getLabelDelegate().setText(this.getLabelText());
        int i = 0;
        while (i < this.numIcons) {
            this.getLabelDelegate().setIcon(this.getLabelIcon(i), i);
            ++i;
        }
        this.getFigure().setToolTip(this.getLabelToolTip());
    }

    protected void refreshUnderline() {
        FontStyle style = (FontStyle)this.getPrimaryView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        if (style != null) {
            this.getLabelDelegate().setTextUnderline(style.isUnderline());
        }
    }

    protected void refreshStrikeThrough() {
        FontStyle style = (FontStyle)this.getPrimaryView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        if (style != null) {
            this.getLabelDelegate().setTextStrikeThrough(style.isStrikeThrough());
        }
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.accessibleEP == null) {
            this.accessibleEP = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

                public void getName(AccessibleEvent e) {
                    ILabelDelegate label = TextCompartmentEditPart.this.getLabelDelegate();
                    if (label != null) {
                        e.result = label.getText();
                    }
                }
            };
        }
        return this.accessibleEP;
    }

    public IGraphicalEditPart getChildBySemanticHint(String semanticHint) {
        return null;
    }

    protected DirectEditManager getManager() {
        if (this.manager == null) {
            this.setManager(new TextDirectEditManager(this));
        }
        return this.manager;
    }

    protected void setManager(DirectEditManager manager) {
        this.manager = manager;
    }

    public View getPrimaryChildView() {
        if (this.getModel() != null) {
            View view = (View)this.getModel();
            return ViewUtil.getChildBySemanticHint((View)view, (String)"Description");
        }
        return null;
    }

    protected void refreshTextAlignment() {
        TextStyle style = (TextStyle)this.getPrimaryView().getStyle(NotationPackage.eINSTANCE.getTextStyle());
        if (style != null) {
            if (style.getTextAlignment() == TextAlignment.RIGHT_LITERAL) {
                if (this.getLabelDelegate().getIcon(0) == null) {
                    this.getLabelDelegate().setAlignment(4);
                } else {
                    this.getLabelDelegate().setTextJustification(4);
                }
            } else if (style.getTextAlignment() == TextAlignment.CENTER_LITERAL) {
                if (this.getLabelDelegate().getIcon(0) == null) {
                    this.getLabelDelegate().setAlignment(2);
                } else {
                    this.getLabelDelegate().setTextJustification(2);
                }
            } else if (this.getLabelDelegate().getIcon(0) == null) {
                this.getLabelDelegate().setAlignment(1);
            } else {
                this.getLabelDelegate().setTextJustification(1);
            }
        }
    }
}

