/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.trace.metamodel.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gemoc.trace.metamodel.generator.TraceMMStrings;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

public class TraceMMExplorer {
    private final EPackage tracemm;
    @Accessors(value={AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER})
    protected final EClass stateClass;
    @Accessors(value={AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER})
    protected final EClass specificStateClass;
    @Accessors(value={AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER})
    protected final EClass specificTraceClass;
    @Accessors(value={AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER})
    protected final EClass specificTracedObjectClass;
    @Accessors(value={AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER})
    protected final EClass specificDimensionClass;
    @Accessors(value={AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER})
    protected final EClass specificStepClass;
    @Accessors(value={AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER})
    protected final EClass specificRootStepClass;
    @Accessors(value={AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER})
    protected final EClass specificValueClass;
    @Accessors(value={AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER})
    protected final EClass specificAttributeValueClass;
    @Accessors(value={AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER})
    protected final EClass specificReferenceValueClass;
    @Accessors(value={AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER})
    protected final EReference dimensionsReference;
    @Accessors(value={AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER})
    protected final EPackage stepsPackage;
    @Accessors(value={AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER})
    protected final EPackage statesPackage;
    protected final EFactory rootFactory;
    protected final EFactory stepFactory;
    protected final EFactory stateFactory;
    private boolean initDone = false;
    private Set<EClass> stepClassesCache = null;
    private final Map<EClass, EReference> stepSequenceRefOfCache = new HashMap<EClass, EReference>();
    private Set<EReference> refs_valueRefsFromStateClassCache;
    private final Map<EClass, Set<EReference>> refs_originalObjectCache = new HashMap<EClass, Set<EReference>>();

    public TraceMMExplorer(EPackage traceMetamodel) {
        EPackage _findFirst_10;
        EClass _findFirst_9;
        EClass _findFirst_8;
        EClass _findFirst_7;
        EClass _findFirst_6;
        EClass _findFirst_5;
        EClass _findFirst_4;
        EClass _findFirst_3;
        EClass _findFirst_2;
        EClass _findFirst_1;
        EClass _findFirst;
        this.tracemm = traceMetamodel;
        Functions.Function1<EClass, Boolean> _function = new Functions.Function1<EClass, Boolean>(){

            public Boolean apply(EClass c) {
                return c.getName().equals("SpecificTrace");
            }
        };
        this.specificTraceClass = _findFirst = (EClass)IteratorExtensions.findFirst((Iterator)Iterators.filter((Iterator)this.tracemm.eAllContents(), EClass.class), (Functions.Function1)_function);
        Functions.Function1<EClass, Boolean> _function_1 = new Functions.Function1<EClass, Boolean>(){

            public Boolean apply(EClass c) {
                return c.getName().equals("SpecificState");
            }
        };
        this.specificStateClass = _findFirst_1 = (EClass)IteratorExtensions.findFirst((Iterator)Iterators.filter((Iterator)this.tracemm.eAllContents(), EClass.class), (Functions.Function1)_function_1);
        Functions.Function1<EClass, Boolean> _function_2 = new Functions.Function1<EClass, Boolean>(){

            public Boolean apply(EClass c) {
                return c.getName().equals("State");
            }
        };
        this.stateClass = _findFirst_2 = (EClass)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)this.specificStateClass.getEAllSuperTypes(), EClass.class), (Functions.Function1)_function_2);
        Functions.Function1<EClass, Boolean> _function_3 = new Functions.Function1<EClass, Boolean>(){

            public Boolean apply(EClass c) {
                return c.getName().equals("SpecificTracedObject");
            }
        };
        this.specificTracedObjectClass = _findFirst_3 = (EClass)IteratorExtensions.findFirst((Iterator)Iterators.filter((Iterator)this.tracemm.eAllContents(), EClass.class), (Functions.Function1)_function_3);
        Functions.Function1<EReference, Boolean> _function_4 = new Functions.Function1<EReference, Boolean>(){

            public Boolean apply(EReference r) {
                return r.getName().equals("dimensions");
            }
        };
        this.dimensionsReference = (EReference)IterableExtensions.findFirst((Iterable)this.specificTracedObjectClass.getEAllContainments(), (Functions.Function1)_function_4);
        Functions.Function1<EClass, Boolean> _function_5 = new Functions.Function1<EClass, Boolean>(){

            public Boolean apply(EClass c) {
                return c.getName().equals("SpecificDimension");
            }
        };
        this.specificDimensionClass = _findFirst_4 = (EClass)IteratorExtensions.findFirst((Iterator)Iterators.filter((Iterator)this.tracemm.eAllContents(), EClass.class), (Functions.Function1)_function_5);
        Functions.Function1<EClass, Boolean> _function_6 = new Functions.Function1<EClass, Boolean>(){

            public Boolean apply(EClass c) {
                return c.getName().equals("SpecificValue");
            }
        };
        this.specificValueClass = _findFirst_5 = (EClass)IteratorExtensions.findFirst((Iterator)Iterators.filter((Iterator)this.tracemm.eAllContents(), EClass.class), (Functions.Function1)_function_6);
        Functions.Function1<EClass, Boolean> _function_7 = new Functions.Function1<EClass, Boolean>(){

            public Boolean apply(EClass c) {
                return c.getName().equals("SpecificAttributeValue");
            }
        };
        this.specificAttributeValueClass = _findFirst_6 = (EClass)IteratorExtensions.findFirst((Iterator)Iterators.filter((Iterator)this.tracemm.eAllContents(), EClass.class), (Functions.Function1)_function_7);
        Functions.Function1<EClass, Boolean> _function_8 = new Functions.Function1<EClass, Boolean>(){

            public Boolean apply(EClass c) {
                return c.getName().equals("SpecificReferenceValue");
            }
        };
        this.specificReferenceValueClass = _findFirst_7 = (EClass)IteratorExtensions.findFirst((Iterator)Iterators.filter((Iterator)this.tracemm.eAllContents(), EClass.class), (Functions.Function1)_function_8);
        Functions.Function1<EClass, Boolean> _function_9 = new Functions.Function1<EClass, Boolean>(){

            public Boolean apply(EClass c) {
                return c.getName().equals("SpecificStep");
            }
        };
        this.specificStepClass = _findFirst_8 = (EClass)IteratorExtensions.findFirst((Iterator)Iterators.filter((Iterator)this.tracemm.eAllContents(), EClass.class), (Functions.Function1)_function_9);
        this.stepsPackage = this.specificStepClass.getEPackage();
        Functions.Function1<EClass, Boolean> _function_10 = new Functions.Function1<EClass, Boolean>(){

            public Boolean apply(EClass c) {
                return c.getName().equals("SpecificRootStep");
            }
        };
        this.specificRootStepClass = _findFirst_9 = (EClass)IteratorExtensions.findFirst((Iterator)Iterators.filter((Iterator)this.tracemm.eAllContents(), EClass.class), (Functions.Function1)_function_10);
        Functions.Function1<EPackage, Boolean> _function_11 = new Functions.Function1<EPackage, Boolean>(){

            public Boolean apply(EPackage p) {
                return p.getName().equals("States");
            }
        };
        this.statesPackage = _findFirst_10 = (EPackage)IteratorExtensions.findFirst((Iterator)Iterators.filter((Iterator)this.tracemm.eAllContents(), EPackage.class), (Functions.Function1)_function_11);
        this.rootFactory = this.tracemm.getEFactoryInstance();
        this.stepFactory = this.stepsPackage.getEFactoryInstance();
        this.stateFactory = this.statesPackage.getEFactoryInstance();
    }

    public void init() {
        if (!this.initDone) {
            HashSet<EClass> _hashSet = new HashSet<EClass>();
            this.stepClassesCache = _hashSet;
            Functions.Function1<EClass, Boolean> _function = new Functions.Function1<EClass, Boolean>(){

                public Boolean apply(EClass c) {
                    return !Objects.equal((Object)c, (Object)TraceMMExplorer.this.specificStepClass);
                }
            };
            this.stepClassesCache.addAll(IteratorExtensions.toSet((Iterator)IteratorExtensions.filter((Iterator)Iterators.filter((Iterator)this.stepsPackage.eAllContents(), EClass.class), (Functions.Function1)_function)));
            Functions.Function1<EReference, Boolean> _function_1 = new Functions.Function1<EReference, Boolean>(){

                public Boolean apply(EReference r) {
                    boolean _equals = r.getName().equals("statesRef");
                    return !_equals;
                }
            };
            this.refs_valueRefsFromStateClassCache = IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)this.specificStateClass.getEAllReferences(), (Functions.Function1)_function_1));
            this.initDone = true;
        }
    }

    public Set<EClass> stepClasses() {
        this.init();
        return this.stepClassesCache;
    }

    public EReference stepSequenceRefOf(final EClass stepClass) {
        boolean _not;
        boolean _containsKey = this.stepSequenceRefOfCache.containsKey(stepClass);
        boolean bl = _not = !_containsKey;
        if (_not) {
            Functions.Function1<EReference, Boolean> _function = new Functions.Function1<EReference, Boolean>(){

                public Boolean apply(EReference r) {
                    return r.getName().equals(TraceMMStrings.ref_createTraceClassToStepClass(stepClass));
                }
            };
            this.stepSequenceRefOfCache.put(stepClass, (EReference)IterableExtensions.findFirst((Iterable)this.specificTraceClass.getEReferences(), (Functions.Function1)_function));
        }
        return this.stepSequenceRefOfCache.get(stepClass);
    }

    public EObject createEventOccurrence(EClass stepClass) {
        return this.stepFactory.create(stepClass);
    }

    public EObject createTracedObject(EClass tracedClass) {
        return tracedClass.getEPackage().getEFactoryInstance().create(tracedClass);
    }

    public EObject createState(EClass stateClass) {
        return this.stateFactory.create(stateClass);
    }

    public Set<EReference> refs_valueRefsFromStateClass() {
        this.init();
        return this.refs_valueRefsFromStateClassCache;
    }

    public Set<EReference> refs_originalObject(EClass traceClass) {
        boolean _not;
        boolean _containsKey = this.refs_originalObjectCache.containsKey(traceClass);
        boolean bl = _not = !_containsKey;
        if (_not) {
            Functions.Function1<EReference, Boolean> _function = new Functions.Function1<EReference, Boolean>(){

                public Boolean apply(EReference r) {
                    return r.getName().startsWith("originalObject");
                }
            };
            this.refs_originalObjectCache.put(traceClass, IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)traceClass.getEAllReferences(), (Functions.Function1)_function)));
        }
        return this.refs_originalObjectCache.get(traceClass);
    }

    @Pure
    public EClass getStateClass() {
        return this.stateClass;
    }

    @Pure
    public EClass getSpecificStateClass() {
        return this.specificStateClass;
    }

    @Pure
    public EClass getSpecificTraceClass() {
        return this.specificTraceClass;
    }

    @Pure
    public EClass getSpecificTracedObjectClass() {
        return this.specificTracedObjectClass;
    }

    @Pure
    public EClass getSpecificDimensionClass() {
        return this.specificDimensionClass;
    }

    @Pure
    public EClass getSpecificStepClass() {
        return this.specificStepClass;
    }

    @Pure
    public EClass getSpecificRootStepClass() {
        return this.specificRootStepClass;
    }

    @Pure
    public EClass getSpecificValueClass() {
        return this.specificValueClass;
    }

    @Pure
    public EClass getSpecificAttributeValueClass() {
        return this.specificAttributeValueClass;
    }

    @Pure
    public EClass getSpecificReferenceValueClass() {
        return this.specificReferenceValueClass;
    }

    @Pure
    public EReference getDimensionsReference() {
        return this.dimensionsReference;
    }

    @Pure
    public EPackage getStepsPackage() {
        return this.stepsPackage;
    }

    @Pure
    public EPackage getStatesPackage() {
        return this.statesPackage;
    }
}

