/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.interpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.runtime.EvaluationResult;
import org.eclipse.acceleo.query.runtime.IQueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.IQueryEvaluationEngine;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecoretools.ale.core.interpreter.DynamicFeatureRegistry;
import org.eclipse.emf.ecoretools.ale.implementation.Attribute;
import org.eclipse.emf.ecoretools.ale.implementation.Block;
import org.eclipse.emf.ecoretools.ale.implementation.ConditionalBlock;
import org.eclipse.emf.ecoretools.ale.implementation.ExpressionStatement;
import org.eclipse.emf.ecoretools.ale.implementation.FeatureAssignment;
import org.eclipse.emf.ecoretools.ale.implementation.FeatureInsert;
import org.eclipse.emf.ecoretools.ale.implementation.FeaturePut;
import org.eclipse.emf.ecoretools.ale.implementation.FeatureRemove;
import org.eclipse.emf.ecoretools.ale.implementation.ForEach;
import org.eclipse.emf.ecoretools.ale.implementation.If;
import org.eclipse.emf.ecoretools.ale.implementation.Method;
import org.eclipse.emf.ecoretools.ale.implementation.VariableAssignment;
import org.eclipse.emf.ecoretools.ale.implementation.VariableDeclaration;
import org.eclipse.emf.ecoretools.ale.implementation.VariableInsert;
import org.eclipse.emf.ecoretools.ale.implementation.VariableRemove;
import org.eclipse.emf.ecoretools.ale.implementation.While;
import org.eclipse.emf.ecoretools.ale.implementation.util.ImplementationSwitch;

public class MethodEvaluator
extends ImplementationSwitch<Object> {
    public static final String PLUGIN_ID = "interpreter";
    public static final String AQL_ERROR = "An error occured during evaluation of a query";
    public static final String MTD_ERROR = "Can't eval null method on %s";
    IQueryEvaluationEngine aqlEngine;
    DynamicFeatureRegistry dynamicFeatureAccess;
    BasicDiagnostic diagnostic;
    Stack<Map<String, Object>> variablesStack;

    public MethodEvaluator(IQueryEvaluationEngine aqlEngine, DynamicFeatureRegistry dynamicFeatureAccess) {
        this.aqlEngine = aqlEngine;
        this.dynamicFeatureAccess = dynamicFeatureAccess;
    }

    public EvaluationResult eval(EObject target, Method operation, List<Object> parameters) {
        this.variablesStack = new Stack();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("self", target);
        variables.put("result", null);
        EOperation opDefinition = operation.getOperationRef();
        if (opDefinition != null) {
            int i = 0;
            while (i < opDefinition.getEParameters().size()) {
                EParameter param = (EParameter)opDefinition.getEParameters().get(i);
                variables.put(param.getName(), parameters.get(i));
                ++i;
            }
            this.variablesStack.push(variables);
            this.diagnostic = new BasicDiagnostic();
            this.doSwitch(operation.getBody());
            Object result = variables.get("result");
            this.variablesStack.pop();
            return new EvaluationResult(result, (Diagnostic)this.diagnostic);
        }
        BasicDiagnostic child = new BasicDiagnostic(4, PLUGIN_ID, 0, String.format(MTD_ERROR, target), new Object[0]);
        this.diagnostic.add((Diagnostic)child);
        return new EvaluationResult(null, (Diagnostic)this.diagnostic);
    }

    @Override
    public Object caseBlock(Block block) {
        HashMap newScope = new HashMap();
        this.variablesStack.push(newScope);
        block.getStatements().stream().forEach(stmt -> {
            Object object = this.doSwitch((EObject)stmt);
        });
        this.variablesStack.pop();
        return null;
    }

    @Override
    public Object caseVariableDeclaration(VariableDeclaration varDecl) {
        Object value = this.aqlEval(varDecl.getInitialValue());
        this.variablesStack.peek().put(varDecl.getName(), value);
        return null;
    }

    @Override
    public Object caseVariableAssignment(VariableAssignment varAssign) {
        Map<String, Object> scope = this.findScope(varAssign.getName());
        if (scope != null) {
            Object value = this.aqlEval(varAssign.getValue());
            scope.put(varAssign.getName(), value);
        }
        return null;
    }

    @Override
    public Object caseFeatureAssignment(FeatureAssignment featAssign) {
        Object assigned = this.aqlEval(featAssign.getTarget());
        Object value = this.aqlEval(featAssign.getValue());
        if (assigned instanceof EObject) {
            EReference oppositeRef;
            Optional<Attribute> featureDef;
            EStructuralFeature feature = ((EObject)assigned).eClass().getEStructuralFeature(featAssign.getTargetFeature());
            if (feature != null) {
                if (value instanceof List) {
                    BasicEList newList = new BasicEList((Collection)((List)value));
                    ((EObject)assigned).eSet(feature, (Object)newList);
                } else {
                    ((EObject)assigned).eSet(feature, value);
                }
            } else {
                this.dynamicFeatureAccess.setDynamicFeatureValue((EObject)assigned, featAssign.getTargetFeature(), value);
            }
            if (value instanceof EObject && feature instanceof EReference) {
                EReference oppositeRef2 = ((EReference)feature).getEOpposite();
                if (oppositeRef2 != null) {
                    EStructuralFeature opFeat = ((EObject)value).eClass().getEStructuralFeature(oppositeRef2.getName());
                    if (opFeat != null) {
                        ((EObject)value).eSet(opFeat, assigned);
                    } else {
                        this.dynamicFeatureAccess.setDynamicFeatureValue((EObject)value, oppositeRef2.getName(), assigned);
                    }
                }
            } else if (value instanceof EObject && feature == null && (featureDef = this.dynamicFeatureAccess.findFeature(((EObject)assigned).eClass(), featAssign.getTargetFeature())).isPresent() && featureDef.get().getFeatureRef() instanceof EReference && (oppositeRef = ((EReference)featureDef.get().getFeatureRef()).getEOpposite()) != null) {
                EStructuralFeature opFeat = ((EObject)value).eClass().getEStructuralFeature(oppositeRef.getName());
                if (opFeat != null) {
                    ((EObject)value).eSet(opFeat, assigned);
                } else {
                    this.dynamicFeatureAccess.setDynamicFeatureValue((EObject)value, oppositeRef.getName(), assigned);
                }
            }
        }
        return null;
    }

    @Override
    public Object caseVariableInsert(VariableInsert varInsert) {
        Map<String, Object> scope = this.findScope(varInsert.getName());
        if (scope != null) {
            Object insertedValue = this.aqlEval(varInsert.getValue());
            Object variableValue = scope.get(varInsert.getName());
            if (variableValue instanceof List) {
                if (insertedValue instanceof List) {
                    ((List)variableValue).addAll((List)insertedValue);
                } else {
                    ((List)variableValue).add(insertedValue);
                }
            }
        }
        return null;
    }

    @Override
    public Object caseVariableRemove(VariableRemove varInsert) {
        Map<String, Object> scope = this.findScope(varInsert.getName());
        if (scope != null) {
            Object insertedValue = this.aqlEval(varInsert.getValue());
            Object variableValue = scope.get(varInsert.getName());
            if (variableValue instanceof List) {
                if (insertedValue instanceof List) {
                    ((List)variableValue).removeAll((List)insertedValue);
                } else {
                    ((List)variableValue).remove(insertedValue);
                }
            }
        }
        return null;
    }

    @Override
    public Object caseFeatureInsert(FeatureInsert featInsert) {
        Object assigned = this.aqlEval(featInsert.getTarget());
        Object value = this.aqlEval(featInsert.getValue());
        if (assigned instanceof EObject) {
            EStructuralFeature feature = ((EObject)assigned).eClass().getEStructuralFeature(featInsert.getTargetFeature());
            if (feature != null) {
                Object featureValue = ((EObject)assigned).eGet(feature);
                if (featureValue instanceof EList) {
                    ((EList)featureValue).add(value);
                }
            } else {
                this.dynamicFeatureAccess.insertDynamicFeatureValue((EObject)assigned, featInsert.getTargetFeature(), value);
            }
        }
        return null;
    }

    @Override
    public Object caseFeatureRemove(FeatureRemove featRemove) {
        Object assigned = this.aqlEval(featRemove.getTarget());
        Object value = this.aqlEval(featRemove.getValue());
        if (assigned instanceof EObject) {
            EStructuralFeature feature = ((EObject)assigned).eClass().getEStructuralFeature(featRemove.getTargetFeature());
            if (feature != null) {
                Object featureValue = ((EObject)assigned).eGet(feature);
                if (featureValue instanceof EList) {
                    ((EList)featureValue).remove(value);
                }
            } else {
                this.dynamicFeatureAccess.removeDynamicFeatureValue((EObject)assigned, featRemove.getTargetFeature(), value);
            }
        }
        return null;
    }

    @Override
    public Object caseFeaturePut(FeaturePut featPut) {
        EStructuralFeature feature;
        Object featureValue;
        Object assigned = this.aqlEval(featPut.getTarget());
        Object key = this.aqlEval(featPut.getKey());
        Object value = this.aqlEval(featPut.getValue());
        if (assigned instanceof EObject && (featureValue = ((EObject)assigned).eGet(feature = ((EObject)assigned).eClass().getEStructuralFeature(featPut.getTargetFeature()))) instanceof EMap) {
            ((EMap)featureValue).put(key, value);
        }
        return null;
    }

    @Override
    public Object caseForEach(ForEach forEach) {
        Collection collection = (Collection)this.aqlEval(forEach.getCollectionExpression());
        HashMap newScope = new HashMap();
        this.variablesStack.push(newScope);
        collection.stream().forEach(elem -> {
            newScope.put(forEach.getVariable(), elem);
            this.doSwitch(forEach.getBody());
        });
        this.variablesStack.pop();
        return null;
    }

    @Override
    public Object caseWhile(While loop) {
        Object conditionValue = this.aqlEval(loop.getCondition());
        while (conditionValue instanceof Boolean && conditionValue.equals(true)) {
            this.doSwitch(loop.getBody());
            conditionValue = this.aqlEval(loop.getCondition());
        }
        return null;
    }

    @Override
    public Object caseIf(If ifStmt) {
        Block selectedBlock = null;
        for (ConditionalBlock conditionalBlock : ifStmt.getBlocks()) {
            Object resEval = this.aqlEval(conditionalBlock.getCondition());
            if (!(resEval instanceof Boolean) || !((Boolean)resEval).booleanValue()) continue;
            selectedBlock = conditionalBlock.getBlock();
            break;
        }
        if (selectedBlock != null) {
            this.doSwitch(selectedBlock);
        } else if (ifStmt.getElse() != null) {
            this.doSwitch(ifStmt.getElse());
        }
        return null;
    }

    @Override
    public Object caseExpressionStatement(ExpressionStatement stmt) {
        return this.aqlEval(stmt.getExpression());
    }

    private Map<String, Object> getCurrentScope() {
        HashMap<String, Object> scope = new HashMap<String, Object>();
        this.variablesStack.stream().flatMap(scp -> scp.entrySet().stream()).forEachOrdered(entry -> {
            Object v = scope.put((String)entry.getKey(), entry.getValue());
        });
        return scope;
    }

    private Object aqlEval(Expression expression) {
        IQueryBuilderEngine.AstResult dummyAstResult = new IQueryBuilderEngine.AstResult(expression, new HashMap(), new HashMap(), new ArrayList(), (Diagnostic)new BasicDiagnostic());
        EvaluationResult result = this.aqlEngine.eval(dummyAstResult, this.getCurrentScope());
        if (result.getDiagnostic().getSeverity() != 0) {
            BasicDiagnostic child = new BasicDiagnostic(result.getDiagnostic().getSeverity(), PLUGIN_ID, 0, AQL_ERROR, new Object[]{expression, result.getDiagnostic()});
            this.diagnostic.add((Diagnostic)child);
        }
        return result.getResult();
    }

    private Map<String, Object> findScope(String variable) {
        int i = this.variablesStack.size() - 1;
        while (i >= 0) {
            Map scope = (Map)this.variablesStack.get(i);
            if (scope.keySet().contains(variable)) {
                return scope;
            }
            --i;
        }
        return null;
    }
}

