/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.solver;

import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.InstantiatedElement;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.InstantiationPath;
import fr.inria.aoste.timesquare.ccslkernel.runtime.IExpressionClock;
import fr.inria.aoste.timesquare.ccslkernel.runtime.elements.RuntimeClock;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.SimulationException;
import fr.inria.aoste.timesquare.ccslkernel.runtime.expressions.AbstractRuntimeExpression;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractSemanticHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractUpdateHelper;
import fr.inria.aoste.timesquare.ccslkernel.solver.TimeModel.SolverClock;

public class ImplicitClock
extends SolverClock
implements IExpressionClock {
    private static int count = 1;
    private AbstractRuntimeExpression entity;

    public ImplicitClock() {
        this.init();
    }

    public ImplicitClock(InstantiatedElement element) {
        super(element);
        this.init();
        this.setName("IC_" + element.getInstantiationPath().getLast().getName() + element.getId());
    }

    private void init() {
        this.setName("IC_" + count);
        ++count;
        this.setDead(false);
        this.bddVariableNumber = UNALLOCATEDBDDVARIABLE;
    }

    public AbstractRuntimeExpression getExpression() {
        return this.entity;
    }

    public void setExpression(AbstractRuntimeExpression expression) {
        this.entity = expression;
    }

    @Override
    public InstantiationPath getInstantiationPath() {
        return this.instantiationPath;
    }

    @Override
    public String toString() {
        return "[" + (this.getName() != null ? this.getName() : "") + "/" + this.tickCount + (this.isDead() ? "/D" : "") + "]";
    }

    @Override
    public void start(AbstractSemanticHelper helper) throws SimulationException {
        if (this.entity != null) {
            this.entity.start(helper);
        }
        super.start(helper);
    }

    @Override
    public void semantic(AbstractSemanticHelper semanticHelper) throws SimulationException {
        if (this.entity != null) {
            this.entity.semantic(semanticHelper);
        }
    }

    @Override
    public void deathSemantic(AbstractSemanticHelper semanticHelper) throws SimulationException {
        if (this.entity != null) {
            this.entity.deathSemantic(semanticHelper);
        }
    }

    @Override
    public void update(AbstractUpdateHelper helper) throws SimulationException {
        if (this.entity != null) {
            this.entity.update(helper);
            if (this.entity.isDead()) {
                this.setDead(true);
            }
        }
    }

    @Override
    public void terminate(AbstractUpdateHelper helper) throws SimulationException {
        this.state = RuntimeClock.ClockState.DEAD;
        if (this.entity != null) {
            this.entity.terminate(helper);
        }
    }

    @Override
    public boolean isTerminated() {
        if (this.entity == null) {
            return false;
        }
        return this.entity.isTerminated();
    }
}

