/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import com.google.common.base.Preconditions;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.macro.declaration.JvmMethodDeclarationImpl;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtext.common.types.JvmOperation;

public class MutableJvmMethodDeclarationImpl
extends JvmMethodDeclarationImpl
implements MutableMethodDeclaration {
    public void markAsRead() {
        this.checkMutable();
        this.getCompilationUnit().getReadAndWriteTracking().markReadAccess((EObject)this.getDelegate());
    }

    @Override
    public Iterable<? extends MutableParameterDeclaration> getParameters() {
        Iterable<ParameterDeclaration> _parameters = super.getParameters();
        return _parameters;
    }

    @Override
    public Iterable<? extends MutableTypeParameterDeclaration> getTypeParameters() {
        Iterable<TypeParameterDeclaration> _typeParameters = super.getTypeParameters();
        return _typeParameters;
    }

    public MutableTypeDeclaration getDeclaringType() {
        TypeDeclaration _declaringType = super.getDeclaringType();
        return (MutableTypeDeclaration)_declaringType;
    }

    public void setStrictFloatingPoint(boolean isStrictFloatingPoint) {
        this.checkMutable();
        ((JvmOperation)this.getDelegate()).setStrictFloatingPoint(isStrictFloatingPoint);
    }

    public void setNative(boolean isNative) {
        this.checkMutable();
        ((JvmOperation)this.getDelegate()).setNative(isNative);
    }

    public void setReturnType(TypeReference type) {
        this.checkMutable();
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"returnType cannot be null");
        ((JvmOperation)this.getDelegate()).setReturnType(this.getCompilationUnit().toJvmTypeReference(type));
    }

    public void setAbstract(boolean isAbstract) {
        this.checkMutable();
        ((JvmOperation)this.getDelegate()).setAbstract(isAbstract);
    }

    public void setFinal(boolean isFinal) {
        this.checkMutable();
        ((JvmOperation)this.getDelegate()).setFinal(isFinal);
    }

    public void setStatic(boolean isStatic) {
        this.checkMutable();
        ((JvmOperation)this.getDelegate()).setStatic(isStatic);
    }

    public void setSynchronized(boolean isSynchronized) {
        this.checkMutable();
        ((JvmOperation)this.getDelegate()).setSynchronized(isSynchronized);
    }

    public void setDefault(boolean isDefault) {
        this.checkMutable();
        ((JvmOperation)this.getDelegate()).setDefault(isDefault);
    }
}

