/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.trace.metamodel.generator;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import opsemanticsview.OperationalSemanticsView;
import opsemanticsview.Rule;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gemoc.trace.metamodel.generator.TraceMMExplorer;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

public class TraceMMGenerationTraceability {
    @Accessors(value={AccessorType.PUBLIC_GETTER, AccessorType.PACKAGE_SETTER})
    private final TraceMMExplorer traceMMExplorer;
    @Accessors(value={AccessorType.PUBLIC_GETTER, AccessorType.PACKAGE_SETTER})
    private final OperationalSemanticsView mmext;
    private Set<EClass> runtimeClasses = new HashSet<EClass>();
    private Map<EClass, Set<EStructuralFeature>> mutableProperties = new HashMap<EClass, Set<EStructuralFeature>>();
    private final HashMap<EClass, EClass> tracedClasses = new HashMap();
    private final HashMap<EStructuralFeature, EClass> dimensionClasses = new HashMap();
    private final HashMap<EStructuralFeature, EReference> dimensionRefs = new HashMap();
    private Map<EClass, Set<EReference>> refs_originalObject = new HashMap<EClass, Set<EReference>>();
    private Map<EStructuralFeature, EClass> valueClass = new HashMap<EStructuralFeature, EClass>();
    private Map<EStructuralFeature, EReference> stateClassToValueClass = new HashMap<EStructuralFeature, EReference>();
    private Set<EClass> stepClasses = new HashSet<EClass>();
    private final Map<Rule, EClass> stepRuleToStepClass = new HashMap<Rule, EClass>();
    private Set<EClass> bigStepClasses = new HashSet<EClass>();
    private Map<EClass, EClass> implicitStepClasses = new HashMap<EClass, EClass>();
    private final Map<EClass, EReference> stepSequences = new HashMap<EClass, EReference>();
    private final Map<EStructuralFeature, EStructuralFeature> mutablePropertyToValueProperty = new HashMap<EStructuralFeature, EStructuralFeature>();

    public TraceMMGenerationTraceability(TraceMMExplorer traceMMExplorer, OperationalSemanticsView mmext) {
        this.traceMMExplorer = traceMMExplorer;
        this.mmext = mmext;
    }

    void addRuntimeClass(EClass c) {
        this.runtimeClasses.add(c);
    }

    public Set<EClass> getRuntimeClasses() {
        return ImmutableSet.copyOf(this.runtimeClasses);
    }

    void addMutableProperty(EClass c, EStructuralFeature r) {
        boolean _not;
        boolean _containsKey = this.mutableProperties.containsKey(c);
        boolean bl = _not = !_containsKey;
        if (_not) {
            HashSet _hashSet = new HashSet();
            this.mutableProperties.put(c, _hashSet);
        }
        Set<EStructuralFeature> _get = this.mutableProperties.get(c);
        _get.add(r);
    }

    public Set<EStructuralFeature> getMutablePropertiesOf(EClass c) {
        boolean _containsKey = this.mutableProperties.containsKey(c);
        if (_containsKey) {
            Set<EStructuralFeature> _get = this.mutableProperties.get(c);
            return ImmutableSet.copyOf(_get);
        }
        return Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new EStructuralFeature[0]));
    }

    public Set<EStructuralFeature> getAllMutableProperties() {
        Collection<Set<EStructuralFeature>> _values = this.mutableProperties.values();
        Iterable _flatten = Iterables.concat(_values);
        return IterableExtensions.toSet((Iterable)_flatten);
    }

    void putTracedClasses(EClass runtimeClass, EClass tracedClass) {
        this.tracedClasses.put(runtimeClass, tracedClass);
    }

    public EClass getTracedClass(EClass mutableClass) {
        return this.tracedClasses.get(mutableClass);
    }

    public Set<EClass> getTracedClassSet() {
        HashSet<EClass> result = new HashSet<EClass>();
        Set<EClass> _keySet = this.tracedClasses.keySet();
        result.addAll(_keySet);
        return result;
    }

    public EClass putDimensionClass(EStructuralFeature property, EClass dimension) {
        return this.dimensionClasses.put(property, dimension);
    }

    public EClass getDimensionClass(EStructuralFeature property) {
        return this.dimensionClasses.get(property);
    }

    public EReference putDimensionRef(EStructuralFeature property, EReference dimensionRef) {
        return this.dimensionRefs.put(property, dimensionRef);
    }

    public EReference getDimensionRef(EStructuralFeature property) {
        return this.dimensionRefs.get(property);
    }

    public Set<EClass> getNewClasses() {
        EList _dynamicClasses = this.mmext.getDynamicClasses();
        return IterableExtensions.toSet((Iterable)_dynamicClasses);
    }

    public boolean hasTracedClass(EClass mutableClass) {
        return this.tracedClasses.containsKey(mutableClass);
    }

    public Set<EClass> getAllMutableClasses() {
        return this.tracedClasses.keySet();
    }

    public EClass getRealMutableClass(final EClass tracedClass) {
        boolean _notEquals;
        Functions.Function1<Map.Entry<EClass, EClass>, Boolean> _function;
        Set<Map.Entry<EClass, EClass>> _entrySet = this.tracedClasses.entrySet();
        Map.Entry mutClass = (Map.Entry)IterableExtensions.findFirst(_entrySet, (Functions.Function1)(_function = new Functions.Function1<Map.Entry<EClass, EClass>, Boolean>(){

            public Boolean apply(Map.Entry<EClass, EClass> p) {
                EClass _value = p.getValue();
                return Objects.equal((Object)_value, (Object)tracedClass);
            }
        }));
        boolean bl = _notEquals = !Objects.equal((Object)mutClass, null);
        if (_notEquals) {
            return (EClass)mutClass.getKey();
        }
        return null;
    }

    void addRefs_originalObject(EClass c1, EReference r) {
        boolean _not;
        boolean _containsKey = this.refs_originalObject.containsKey(c1);
        boolean bl = _not = !_containsKey;
        if (_not) {
            HashSet _hashSet = new HashSet();
            this.refs_originalObject.put(c1, _hashSet);
        }
        Set<EReference> _get = this.refs_originalObject.get(c1);
        _get.add(r);
    }

    public Set<EReference> getRefs_originalObject(EClass class1) {
        HashSet<EReference> res = new HashSet<EReference>();
        EList _eAllSuperTypes = class1.getEAllSuperTypes();
        Functions.Function1<EClass, Set<EReference>> _function = new Functions.Function1<EClass, Set<EReference>>(){

            public Set<EReference> apply(EClass c) {
                return TraceMMGenerationTraceability.this.getRefs_originalObject(c);
            }
        };
        List _map = ListExtensions.map((List)_eAllSuperTypes, (Functions.Function1)_function);
        Iterable _flatten = Iterables.concat((Iterable)_map);
        Set existingRefs = IterableExtensions.toSet((Iterable)_flatten);
        res.addAll(existingRefs);
        Set<EReference> refsForThisClass = this.refs_originalObject.get(class1);
        if (!Objects.equal(refsForThisClass, null) && !refsForThisClass.isEmpty()) {
            res.addAll(refsForThisClass);
        }
        return res;
    }

    void putValueClass(EStructuralFeature r, EClass c) {
        this.valueClass.put(r, c);
    }

    public EClass getValueClass(EStructuralFeature s) {
        return this.valueClass.get(s);
    }

    void putStateClassToValueClass(EStructuralFeature r1, EReference r2) {
        this.stateClassToValueClass.put(r1, r2);
    }

    public EReference getStateClassToValueClass(final EStructuralFeature s) {
        boolean _containsValue = this.mutablePropertyToValueProperty.containsValue(s);
        if (_containsValue) {
            Set<Map.Entry<EStructuralFeature, EStructuralFeature>> _entrySet = this.mutablePropertyToValueProperty.entrySet();
            Functions.Function1<Map.Entry<EStructuralFeature, EStructuralFeature>, Boolean> _function = new Functions.Function1<Map.Entry<EStructuralFeature, EStructuralFeature>, Boolean>(){

                public Boolean apply(Map.Entry<EStructuralFeature, EStructuralFeature> entry) {
                    EStructuralFeature _value = entry.getValue();
                    return Objects.equal((Object)_value, (Object)s);
                }
            };
            Map.Entry _findFirst = (Map.Entry)IterableExtensions.findFirst(_entrySet, (Functions.Function1)_function);
            EStructuralFeature key = (EStructuralFeature)_findFirst.getKey();
            return this.stateClassToValueClass.get(key);
        }
        return this.stateClassToValueClass.get(s);
    }

    void addStepClass(EClass c) {
        this.stepClasses.add(c);
    }

    public Set<EClass> getStepClasses() {
        return ImmutableSet.copyOf(this.stepClasses);
    }

    void addStepRuleToStepClass(Rule stepRule, EClass stepClass) {
        this.stepRuleToStepClass.put(stepRule, stepClass);
    }

    public EClass getStepClassFromStepRule(Rule stepRule) {
        return this.stepRuleToStepClass.get(stepRule);
    }

    void addBigStepClass(EClass c) {
        this.bigStepClasses.add(c);
    }

    public Set<EClass> getBigStepClasses() {
        return ImmutableSet.copyOf(this.bigStepClasses);
    }

    void putImplicitStepClass(EClass step, EClass containgClass) {
        this.implicitStepClasses.put(step, containgClass);
    }

    public Set<EClass> getImplicitStepClasses() {
        Set<EClass> _keySet = this.implicitStepClasses.keySet();
        return ImmutableSet.copyOf(_keySet);
    }

    public EClass getImplicitStepContainingClass(EClass implicitStepClass) {
        return this.implicitStepClasses.get(implicitStepClass);
    }

    void addStepSequence(EClass stepClass, EReference trace) {
        this.stepSequences.put(stepClass, trace);
    }

    public EReference getStepSequence(EClass stepClass) {
        return this.stepSequences.get(stepClass);
    }

    public boolean hasExeClass(final EClass tracedClass) {
        Set<EClass> _keySet = this.tracedClasses.keySet();
        Functions.Function1<EClass, Boolean> _function = new Functions.Function1<EClass, Boolean>(){

            public Boolean apply(EClass k) {
                EClass _get = (EClass)TraceMMGenerationTraceability.this.tracedClasses.get(k);
                return Objects.equal((Object)_get, (Object)tracedClass);
            }
        };
        return IterableExtensions.exists(_keySet, (Functions.Function1)_function);
    }

    public EClass getExeClass(final EClass tracedClass) {
        Set<EClass> _keySet = this.tracedClasses.keySet();
        Functions.Function1<EClass, Boolean> _function = new Functions.Function1<EClass, Boolean>(){

            public Boolean apply(EClass k) {
                EClass _get = (EClass)TraceMMGenerationTraceability.this.tracedClasses.get(k);
                return Objects.equal((Object)_get, (Object)tracedClass);
            }
        };
        return (EClass)IterableExtensions.findFirst(_keySet, (Functions.Function1)_function);
    }

    public void putMutablePropertyToValueProperty(EStructuralFeature mutableProperty, EStructuralFeature valueProperty) {
        this.mutablePropertyToValueProperty.put(mutableProperty, valueProperty);
    }

    public EStructuralFeature getValuePropertyOfMutableProperty(EStructuralFeature mutableProperty) {
        return this.mutablePropertyToValueProperty.get(mutableProperty);
    }

    @Pure
    public TraceMMExplorer getTraceMMExplorer() {
        return this.traceMMExplorer;
    }

    @Pure
    public OperationalSemanticsView getMmext() {
        return this.mmext;
    }
}

