/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.trace.commons;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gemoc.trace.commons.EMFUtil;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class EclipseUtil {
    public static List<IFolder> findSrcFoldersOf(IJavaProject p) throws NoSourceFolderException {
        IWorkspace _workspace = ResourcesPlugin.getWorkspace();
        final IWorkspaceRoot root = _workspace.getRoot();
        List<IClasspathEntry> _findClassPathEntriesOf = EclipseUtil.findClassPathEntriesOf(p, 3);
        Functions.Function1<IClasspathEntry, IFolder> _function = new Functions.Function1<IClasspathEntry, IFolder>(){

            public IFolder apply(IClasspathEntry e) {
                IPath _path = e.getPath();
                return root.getFolder(_path);
            }
        };
        return ListExtensions.map(_findClassPathEntriesOf, (Functions.Function1)_function);
    }

    public static List<IClasspathEntry> findClassPathEntriesOf(IJavaProject p, int type) {
        try {
            ArrayList<IClasspathEntry> res = new ArrayList<IClasspathEntry>();
            IClasspathEntry[] entries = p.getResolvedClasspath(true);
            int i = 0;
            while (i < entries.length) {
                boolean _equals;
                IClasspathEntry entry = entries[i];
                int _entryKind = entry.getEntryKind();
                boolean bl = _equals = _entryKind == 3;
                if (_equals) {
                    res.add(entry);
                }
                ++i;
            }
            return res;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static void copyFolder(File src, File dest) throws FileNotFoundException, IOException {
        boolean _isDirectory = src.isDirectory();
        if (_isDirectory) {
            String[] files;
            boolean _not;
            boolean _exists = dest.exists();
            boolean bl = _not = !_exists;
            if (_not) {
                dest.mkdir();
            }
            String[] stringArray = files = src.list();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                File srcFile = new File(src, file);
                File destFile = new File(dest, file);
                EclipseUtil.copyFolder(srcFile, destFile);
                ++n2;
            }
        } else {
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dest);
            byte[] buffer = new byte[1024];
            int length = 0;
            while ((length = ((InputStream)in).read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, length);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    public static Set<IResource> findAllFilesOf(IFolder f) {
        HashSet<IResource> result = new HashSet<IResource>();
        try {
            IResource[] _members;
            IResource[] iResourceArray = _members = f.members();
            int n = _members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource r = iResourceArray[n2];
                if (r instanceof IFile) {
                    result.add(r);
                } else if (r instanceof IFolder) {
                    Set<IResource> _findAllFilesOf = EclipseUtil.findAllFilesOf((IFolder)r);
                    result.addAll(_findAllFilesOf);
                }
                ++n2;
            }
        }
        catch (Throwable _t) {
            if (_t instanceof CoreException) {
                CoreException cfr_ignored_0 = (CoreException)_t;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return result;
    }

    public static void error(String msg, String pluginID, Throwable e) throws CoreException {
        Status _status = new Status(4, pluginID, msg, e);
        throw new CoreException((IStatus)_status);
    }

    public static Set<EPackage> findAllEPackagesIn(Set<IContainer> containers) {
        try {
            final HashSet<EPackage> inputMetamodel = new HashSet<EPackage>();
            final ResourceSetImpl rs = new ResourceSetImpl();
            for (IContainer container : containers) {
                IResourceVisitor _function = new IResourceVisitor(){

                    public boolean visit(IResource r) throws CoreException {
                        try {
                            String _name;
                            String _lowerCase;
                            boolean _endsWith;
                            if (r instanceof IFile && (_endsWith = (_lowerCase = (_name = ((IFile)r).getName()).toLowerCase()).endsWith(".ecore"))) {
                                IPath _fullPath = ((IFile)r).getFullPath();
                                String _string = _fullPath.toString();
                                URI uri = URI.createPlatformResourceURI((String)_string, (boolean)true);
                                Resource model = EMFUtil.loadModelURI(uri, (ResourceSet)rs);
                                HashSet<EPackage> result = new HashSet<EPackage>();
                                EList _contents = model.getContents();
                                for (EObject c : _contents) {
                                    if (!(c instanceof EPackage)) continue;
                                    result.add((EPackage)c);
                                }
                                inputMetamodel.addAll(result);
                            }
                            return true;
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                };
                container.accept(_function);
            }
            return inputMetamodel;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static class NoSourceFolderException
    extends Exception {
        public NoSourceFolderException(JavaModelException exception) {
            super((Throwable)exception);
        }

        public NoSourceFolderException() {
        }
    }
}

