/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.sequential.javaengine.ui.launcher.tabs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.gemoc.execution.sequential.javaengine.ui.launcher.tabs.LaunchConfigurationTab;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.IEngineAddon;
import org.eclipse.gemoc.xdsmlframework.api.extensions.engine_addon.EngineAddonSpecificationExtension;
import org.eclipse.gemoc.xdsmlframework.api.extensions.engine_addon_group.EngineAddonGroupSpecificationExtension;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public abstract class LaunchConfigurationDataProcessingTab
extends LaunchConfigurationTab {
    private HashMap<EngineAddonSpecificationExtension, Button> _components = new HashMap();

    protected LaunchConfigurationDataProcessingTab() {
        for (EngineAddonSpecificationExtension extension : this.getExtensionSpecifications()) {
            String id = extension.getAddonGroupId();
            if (id != null && !id.equals("Sequential.AddonGroup") && !id.equals("General.AddonGroup")) continue;
            this._components.put(extension, null);
        }
    }

    protected abstract Collection<EngineAddonSpecificationExtension> getExtensionSpecifications();

    protected abstract Collection<EngineAddonGroupSpecificationExtension> getGroupExtensionSpecifications();

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        content.setLayout((Layout)gl);
        content.layout();
        this.setControl((Control)content);
        this.createLayout(content);
    }

    private void createLayout(Composite parent) {
        HashMap<String, Group> groupmap = new HashMap<String, Group>();
        for (EngineAddonGroupSpecificationExtension engineAddonGroupSpecificationExtension : this.getGroupExtensionSpecifications()) {
            groupmap.put(engineAddonGroupSpecificationExtension.getId(), this.createGroup(parent, engineAddonGroupSpecificationExtension.getName()));
        }
        groupmap.put("", this.createGroup(parent, "Uncategorized"));
        for (EngineAddonSpecificationExtension engineAddonSpecificationExtension : this._components.keySet()) {
            Group parentGroup = (Group)groupmap.get("");
            String addonGroupId = engineAddonSpecificationExtension.getAddonGroupId();
            if (addonGroupId != null && (parentGroup = (Group)groupmap.get(engineAddonSpecificationExtension.getAddonGroupId())) == null) {
                parentGroup = (Group)groupmap.get("");
            }
            Button checkbox = this.createCheckButton((Composite)parentGroup, engineAddonSpecificationExtension.getName());
            if (engineAddonSpecificationExtension.getShortDescription() != null) {
                checkbox.setToolTipText(engineAddonSpecificationExtension.getShortDescription());
            }
            checkbox.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    LaunchConfigurationDataProcessingTab.this.updateLaunchConfigurationDialog();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this._components.put(engineAddonSpecificationExtension, checkbox);
        }
        for (Group group : groupmap.values()) {
            if (group.getChildren().length != 0) continue;
            group.dispose();
            parent.layout(true);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        for (EngineAddonSpecificationExtension entry : this._components.keySet()) {
            configuration.setAttribute(entry.getName(), entry.getDefaultActivationValue().booleanValue());
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        for (EngineAddonSpecificationExtension extension : this._components.keySet()) {
            try {
                boolean value = configuration.getAttribute(extension.getName(), false);
                Button checkbox = this._components.get(extension);
                checkbox.setSelection(value);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        for (Map.Entry<EngineAddonSpecificationExtension, Button> entry : this._components.entrySet()) {
            configuration.setAttribute(entry.getKey().getName(), entry.getValue().getSelection());
        }
    }

    public boolean isValid(ILaunchConfiguration config) {
        try {
            ArrayList<IEngineAddon> addons = new ArrayList<IEngineAddon>();
            for (Map.Entry<EngineAddonSpecificationExtension, Button> entry : this._components.entrySet()) {
                if (!entry.getValue().getSelection()) continue;
                addons.add(entry.getKey().instanciateComponent());
            }
            ArrayList errors = new ArrayList();
            for (IEngineAddon iEngineAddon : addons) {
                errors.addAll(iEngineAddon.validate(addons));
            }
            if (!errors.isEmpty()) {
                for (String msg : errors) {
                    this.setErrorMessage(msg);
                }
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setErrorMessage(null);
        return true;
    }
}

