/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.util;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.elk.core.klayoutdata.KEdgeLayout;
import org.eclipse.elk.core.klayoutdata.KIdentifier;
import org.eclipse.elk.core.klayoutdata.KInsets;
import org.eclipse.elk.core.klayoutdata.KLayoutData;
import org.eclipse.elk.core.klayoutdata.KLayoutDataFactory;
import org.eclipse.elk.core.klayoutdata.KPoint;
import org.eclipse.elk.core.klayoutdata.KShapeLayout;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.options.EdgeLabelPlacement;
import org.eclipse.elk.core.options.NodeLabelPlacement;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.core.options.SizeOptions;
import org.eclipse.elk.core.util.selection.DefaultSelectionIterator;
import org.eclipse.elk.core.util.selection.SelectionIterator;
import org.eclipse.elk.graph.KEdge;
import org.eclipse.elk.graph.KGraphData;
import org.eclipse.elk.graph.KGraphElement;
import org.eclipse.elk.graph.KGraphFactory;
import org.eclipse.elk.graph.KLabel;
import org.eclipse.elk.graph.KLabeledGraphElement;
import org.eclipse.elk.graph.KNode;
import org.eclipse.elk.graph.KPort;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

public final class ElkUtil {
    public static final float DEFAULT_MIN_WIDTH = 20.0f;
    public static final float DEFAULT_MIN_HEIGHT = 20.0f;

    private ElkUtil() {
    }

    public static KNode createInitializedNode() {
        KNode layoutNode = KGraphFactory.eINSTANCE.createKNode();
        KShapeLayout layout = KLayoutDataFactory.eINSTANCE.createKShapeLayout();
        layout.setInsets(KLayoutDataFactory.eINSTANCE.createKInsets());
        layoutNode.getData().add((Object)layout);
        return layoutNode;
    }

    public static KEdge createInitializedEdge() {
        KEdge edge = KGraphFactory.eINSTANCE.createKEdge();
        KEdgeLayout edgeLayout = KLayoutDataFactory.eINSTANCE.createKEdgeLayout();
        edgeLayout.setSourcePoint(KLayoutDataFactory.eINSTANCE.createKPoint());
        edgeLayout.setTargetPoint(KLayoutDataFactory.eINSTANCE.createKPoint());
        edge.getData().add((Object)edgeLayout);
        return edge;
    }

    public static KPort createInitializedPort() {
        KPort port = KGraphFactory.eINSTANCE.createKPort();
        KShapeLayout portLayout = KLayoutDataFactory.eINSTANCE.createKShapeLayout();
        portLayout.setInsets(KLayoutDataFactory.eINSTANCE.createKInsets());
        port.getData().add((Object)portLayout);
        return port;
    }

    public static KLabel createInitializedLabel(KLabeledGraphElement element) {
        KLabel label = KGraphFactory.eINSTANCE.createKLabel();
        KShapeLayout labelLayout = KLayoutDataFactory.eINSTANCE.createKShapeLayout();
        label.getData().add((Object)labelLayout);
        label.setText("");
        label.setParent(element);
        return label;
    }

    public static void validate(KNode graph) {
        KLayoutDataFactory layoutFactory = KLayoutDataFactory.eINSTANCE;
        Iterator contentIter = Iterators.concat(Lists.newArrayList((Object[])new KNode[]{graph}).iterator(), (Iterator)Iterators.filter((Iterator)graph.eAllContents(), KGraphElement.class));
        while (contentIter.hasNext()) {
            KPort targetPort;
            KPort sourcePort;
            EObject element = (EObject)contentIter.next();
            if (element instanceof KNode) {
                KNode node = (KNode)element;
                KShapeLayout nodeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
                if (nodeLayout == null) {
                    nodeLayout = layoutFactory.createKShapeLayout();
                    node.getData().add((Object)nodeLayout);
                }
                if (nodeLayout.getInsets() != null) continue;
                nodeLayout.setInsets(layoutFactory.createKInsets());
                continue;
            }
            if (element instanceof KPort) {
                KPort port = (KPort)element;
                KShapeLayout portLayout = (KShapeLayout)port.getData(KShapeLayout.class);
                if (portLayout != null) continue;
                port.getData().add((Object)layoutFactory.createKShapeLayout());
                continue;
            }
            if (element instanceof KLabel) {
                KLabel label = (KLabel)element;
                KShapeLayout labelLayout = (KShapeLayout)label.getData(KShapeLayout.class);
                if (labelLayout == null) {
                    label.getData().add((Object)layoutFactory.createKShapeLayout());
                }
                if (label.getText() != null) continue;
                label.setText("");
                continue;
            }
            if (!(element instanceof KEdge)) continue;
            KEdge edge = (KEdge)element;
            KEdgeLayout edgeLayout = (KEdgeLayout)edge.getData(KEdgeLayout.class);
            if (edgeLayout == null) {
                edgeLayout = layoutFactory.createKEdgeLayout();
                edge.getData().add((Object)edgeLayout);
            }
            if (edgeLayout.getSourcePoint() == null) {
                edgeLayout.setSourcePoint(layoutFactory.createKPoint());
            }
            if (edgeLayout.getTargetPoint() == null) {
                edgeLayout.setTargetPoint(layoutFactory.createKPoint());
            }
            if ((sourcePort = edge.getSourcePort()) != null && !sourcePort.getEdges().contains((Object)edge)) {
                sourcePort.getEdges().add((Object)edge);
            }
            if ((targetPort = edge.getTargetPort()) == null || targetPort.getEdges().contains((Object)edge)) continue;
            targetPort.getEdges().add((Object)edge);
        }
    }

    public static void createIdentifier(KGraphElement element) {
        KIdentifier identifier = (KIdentifier)element.getData(KIdentifier.class);
        if (identifier == null) {
            identifier = KLayoutDataFactory.eINSTANCE.createKIdentifier();
            element.getData().add((Object)identifier);
        }
        identifier.setId(Integer.toString(element.hashCode()));
    }

    public static PortSide calcPortSide(KPort port, Direction direction) {
        KShapeLayout portLayout = (KShapeLayout)port.getData(KShapeLayout.class);
        KShapeLayout nodeLayout = (KShapeLayout)port.getNode().getData(KShapeLayout.class);
        float nodeWidth = nodeLayout.getWidth();
        float nodeHeight = nodeLayout.getHeight();
        if (nodeWidth <= 0.0f && nodeHeight <= 0.0f) {
            return PortSide.UNDEFINED;
        }
        float xpos = portLayout.getXpos();
        float ypos = portLayout.getYpos();
        switch (direction) {
            case RIGHT: 
            case LEFT: {
                if (xpos < 0.0f) {
                    return PortSide.WEST;
                }
                if (!(xpos + portLayout.getWidth() > nodeWidth)) break;
                return PortSide.EAST;
            }
            case DOWN: 
            case UP: {
                if (ypos < 0.0f) {
                    return PortSide.NORTH;
                }
                if (!(ypos + portLayout.getHeight() > nodeHeight)) break;
                return PortSide.SOUTH;
            }
        }
        float widthPercent = (xpos + portLayout.getWidth() / 2.0f) / nodeWidth;
        float heightPercent = (ypos + portLayout.getHeight() / 2.0f) / nodeHeight;
        if (widthPercent + heightPercent <= 1.0f && widthPercent - heightPercent <= 0.0f) {
            return PortSide.WEST;
        }
        if (widthPercent + heightPercent >= 1.0f && widthPercent - heightPercent >= 0.0f) {
            return PortSide.EAST;
        }
        if (heightPercent < 0.5f) {
            return PortSide.NORTH;
        }
        return PortSide.SOUTH;
    }

    public static float calcPortOffset(KPort port, PortSide side) {
        KShapeLayout portLayout = (KShapeLayout)port.getData(KShapeLayout.class);
        KShapeLayout nodeLayout = (KShapeLayout)port.getNode().getData(KShapeLayout.class);
        switch (side) {
            case NORTH: {
                return -(portLayout.getYpos() + portLayout.getHeight());
            }
            case EAST: {
                return portLayout.getXpos() - nodeLayout.getWidth();
            }
            case SOUTH: {
                return portLayout.getYpos() - nodeLayout.getHeight();
            }
            case WEST: {
                return -(portLayout.getXpos() + portLayout.getWidth());
            }
        }
        return 0.0f;
    }

    public static KVector resizeNode(KNode node) {
        KShapeLayout nodeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
        Set sizeConstraint = (Set)nodeLayout.getProperty(CoreOptions.NODE_SIZE_CONSTRAINTS);
        if (sizeConstraint.isEmpty()) {
            return null;
        }
        float newWidth = 0.0f;
        float newHeight = 0.0f;
        if (sizeConstraint.contains((Object)SizeConstraint.PORTS)) {
            PortConstraints portConstraints = (PortConstraints)((Object)nodeLayout.getProperty(CoreOptions.PORT_CONSTRAINTS));
            float minNorth = 2.0f;
            float minEast = 2.0f;
            float minSouth = 2.0f;
            float minWest = 2.0f;
            Direction direction = node.getParent() == null ? (Direction)((Object)nodeLayout.getProperty(CoreOptions.DIRECTION)) : (Direction)((Object)((KShapeLayout)node.getParent().getData(KShapeLayout.class)).getProperty(CoreOptions.DIRECTION));
            for (KPort port : node.getPorts()) {
                KShapeLayout portLayout = (KShapeLayout)port.getData(KShapeLayout.class);
                PortSide portSide = (PortSide)((Object)portLayout.getProperty(CoreOptions.PORT_SIDE));
                if (portSide == PortSide.UNDEFINED) {
                    portSide = ElkUtil.calcPortSide(port, direction);
                    portLayout.setProperty(CoreOptions.PORT_SIDE, (Object)portSide);
                }
                if (portConstraints == PortConstraints.FIXED_POS) {
                    switch (portSide) {
                        case NORTH: {
                            minNorth = Math.max(minNorth, portLayout.getXpos() + portLayout.getWidth());
                            break;
                        }
                        case EAST: {
                            minEast = Math.max(minEast, portLayout.getYpos() + portLayout.getHeight());
                            break;
                        }
                        case SOUTH: {
                            minSouth = Math.max(minSouth, portLayout.getXpos() + portLayout.getWidth());
                            break;
                        }
                        case WEST: {
                            minWest = Math.max(minWest, portLayout.getYpos() + portLayout.getHeight());
                        }
                    }
                    continue;
                }
                switch (portSide) {
                    case NORTH: {
                        minNorth += portLayout.getWidth() + 2.0f;
                        break;
                    }
                    case EAST: {
                        minEast += portLayout.getHeight() + 2.0f;
                        break;
                    }
                    case SOUTH: {
                        minSouth += portLayout.getWidth() + 2.0f;
                        break;
                    }
                    case WEST: {
                        minWest += portLayout.getHeight() + 2.0f;
                    }
                }
            }
            newWidth = Math.max(minNorth, minSouth);
            newHeight = Math.max(minEast, minWest);
        }
        return ElkUtil.resizeNode(node, newWidth, newHeight, true, true);
    }

    public static KVector resizeNode(KNode node, float newWidth, float newHeight, boolean movePorts, boolean moveLabels) {
        KVector newSize;
        KShapeLayout nodeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
        Set sizeConstraint = (Set)nodeLayout.getProperty(CoreOptions.NODE_SIZE_CONSTRAINTS);
        KVector oldSize = new KVector(nodeLayout.getWidth(), nodeLayout.getHeight());
        if (sizeConstraint.contains((Object)SizeConstraint.MINIMUM_SIZE)) {
            float minHeight;
            float minWidth;
            Set sizeOptions = (Set)nodeLayout.getProperty(CoreOptions.NODE_SIZE_OPTIONS);
            KVector minSize = (KVector)nodeLayout.getProperty(CoreOptions.NODE_SIZE_MINIMUM);
            if (minSize == null) {
                minWidth = ((Float)nodeLayout.getProperty(CoreOptions.NODE_SIZE_MIN_WIDTH)).floatValue();
                minHeight = ((Float)nodeLayout.getProperty(CoreOptions.NODE_SIZE_MIN_HEIGHT)).floatValue();
            } else {
                minWidth = (float)minSize.x;
                minHeight = (float)minSize.y;
            }
            if (sizeOptions.contains((Object)SizeOptions.DEFAULT_MINIMUM_SIZE)) {
                if (minWidth <= 0.0f) {
                    minWidth = 20.0f;
                }
                if (minHeight <= 0.0f) {
                    minHeight = 20.0f;
                }
            }
            newSize = new KVector(Math.max(newWidth, minWidth), Math.max(newHeight, minHeight));
        } else {
            newSize = new KVector(newWidth, newHeight);
        }
        float widthRatio = (float)(newSize.x / oldSize.x);
        float heightRatio = (float)(newSize.y / oldSize.y);
        float widthDiff = (float)(newSize.x - oldSize.x);
        float heightDiff = (float)(newSize.y - oldSize.y);
        if (movePorts) {
            Direction direction = node.getParent() == null ? (Direction)((Object)nodeLayout.getProperty(CoreOptions.DIRECTION)) : (Direction)((Object)((KShapeLayout)node.getParent().getData(KShapeLayout.class)).getProperty(CoreOptions.DIRECTION));
            boolean fixedPorts = nodeLayout.getProperty(CoreOptions.PORT_CONSTRAINTS) == PortConstraints.FIXED_POS;
            for (KPort port : node.getPorts()) {
                KShapeLayout portLayout = (KShapeLayout)port.getData(KShapeLayout.class);
                PortSide portSide = (PortSide)((Object)portLayout.getProperty(CoreOptions.PORT_SIDE));
                if (portSide == PortSide.UNDEFINED) {
                    portSide = ElkUtil.calcPortSide(port, direction);
                    portLayout.setProperty(CoreOptions.PORT_SIDE, (Object)portSide);
                }
                switch (portSide) {
                    case NORTH: {
                        if (fixedPorts) break;
                        portLayout.setXpos(portLayout.getXpos() * widthRatio);
                        break;
                    }
                    case EAST: {
                        portLayout.setXpos(portLayout.getXpos() + widthDiff);
                        if (fixedPorts) break;
                        portLayout.setYpos(portLayout.getYpos() * heightRatio);
                        break;
                    }
                    case SOUTH: {
                        if (!fixedPorts) {
                            portLayout.setXpos(portLayout.getXpos() * widthRatio);
                        }
                        portLayout.setYpos(portLayout.getYpos() + heightDiff);
                        break;
                    }
                    case WEST: {
                        if (fixedPorts) break;
                        portLayout.setYpos(portLayout.getYpos() * heightRatio);
                    }
                }
            }
        }
        nodeLayout.setSize((float)newSize.x, (float)newSize.y);
        if (moveLabels) {
            for (KLabel label : node.getLabels()) {
                float midy;
                float heightPercent;
                KShapeLayout labelLayout = (KShapeLayout)label.getData(KShapeLayout.class);
                float midx = labelLayout.getXpos() + labelLayout.getWidth() / 2.0f;
                float widthPercent = midx / (float)oldSize.x;
                if (!(widthPercent + (heightPercent = (midy = labelLayout.getYpos() + labelLayout.getHeight() / 2.0f) / (float)oldSize.y) >= 1.0f)) continue;
                if (widthPercent - heightPercent > 0.0f && midy >= 0.0f) {
                    labelLayout.setXpos(labelLayout.getXpos() + widthDiff);
                    labelLayout.setYpos(labelLayout.getYpos() + heightDiff * heightPercent);
                    continue;
                }
                if (!(widthPercent - heightPercent < 0.0f) || !(midx >= 0.0f)) continue;
                labelLayout.setXpos(labelLayout.getXpos() + widthDiff * widthPercent);
                labelLayout.setYpos(labelLayout.getYpos() + heightDiff);
            }
        }
        nodeLayout.setProperty(CoreOptions.NODE_SIZE_CONSTRAINTS, SizeConstraint.fixed());
        return new KVector(widthRatio, heightRatio);
    }

    public static void applyConfiguredNodeScaling(KNode node) {
        KShapeLayout shapeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
        float scalingFactor = ((Float)shapeLayout.getProperty(CoreOptions.SCALE_FACTOR)).floatValue();
        if (scalingFactor == 1.0f) {
            return;
        }
        shapeLayout.setSize(scalingFactor * shapeLayout.getWidth(), scalingFactor * shapeLayout.getHeight());
        for (KGraphElement kge : Iterables.concat((Iterable)node.getPorts(), (Iterable)node.getLabels())) {
            KShapeLayout kgeLayout = (KShapeLayout)kge.getData(KShapeLayout.class);
            kgeLayout.setPos(scalingFactor * kgeLayout.getXpos(), scalingFactor * kgeLayout.getYpos());
            kgeLayout.setSize(scalingFactor * kgeLayout.getWidth(), scalingFactor * kgeLayout.getHeight());
            KVector anchor = (KVector)kgeLayout.getProperty(CoreOptions.PORT_ANCHOR);
            if (anchor == null) continue;
            anchor.x *= (double)scalingFactor;
            anchor.y *= (double)scalingFactor;
        }
    }

    public static boolean isDescendant(KNode child, KNode parent) {
        KNode current = child;
        while (current.getParent() != null) {
            if ((current = current.getParent()) != parent) continue;
            return true;
        }
        return false;
    }

    public static KVector toAbsolute(KVector point, KNode parent) {
        KNode node = parent;
        while (node != null) {
            KShapeLayout nodeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
            KInsets insets = nodeLayout.getInsets();
            point.add(nodeLayout.getXpos() + insets.getLeft(), nodeLayout.getYpos() + insets.getTop());
            node = node.getParent();
        }
        return point;
    }

    public static KVector toRelative(KVector point, KNode parent) {
        KNode node = parent;
        while (node != null) {
            KShapeLayout nodeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
            KInsets insets = nodeLayout.getInsets();
            point.add(-nodeLayout.getXpos() - insets.getLeft(), -nodeLayout.getYpos() - insets.getTop());
            node = node.getParent();
        }
        return point;
    }

    public static void translate(KNode parent, float xoffset, float yoffset) {
        for (KNode child : parent.getChildren()) {
            KShapeLayout nodeLayout = (KShapeLayout)child.getData(KShapeLayout.class);
            nodeLayout.setXpos(nodeLayout.getXpos() + xoffset);
            nodeLayout.setYpos(nodeLayout.getYpos() + yoffset);
            for (KEdge edge : child.getOutgoingEdges()) {
                if (ElkUtil.isDescendant(edge.getTarget(), child)) continue;
                KEdgeLayout edgeLayout = (KEdgeLayout)edge.getData(KEdgeLayout.class);
                ElkUtil.translate(edgeLayout.getSourcePoint(), xoffset, yoffset);
                for (KPoint bendPoint : edgeLayout.getBendPoints()) {
                    ElkUtil.translate(bendPoint, xoffset, yoffset);
                }
                ElkUtil.translate(edgeLayout.getTargetPoint(), xoffset, yoffset);
                for (KLabel edgeLabel : edge.getLabels()) {
                    KShapeLayout labelLayout = (KShapeLayout)edgeLabel.getData(KShapeLayout.class);
                    labelLayout.setXpos(labelLayout.getXpos() + xoffset);
                    labelLayout.setYpos(labelLayout.getYpos() + yoffset);
                }
            }
        }
    }

    public static void translate(KPoint point, float xoffset, float yoffset) {
        point.setX(point.getX() + xoffset);
        point.setY(point.getY() + yoffset);
    }

    public static void persistDataElements(KNode graph) {
        TreeIterator iterator = graph.eAllContents();
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            if (!(eObject instanceof KGraphData)) continue;
            ((KGraphData)eObject).makePersistent();
        }
    }

    public static KVectorChain determineJunctionPoints(KEdge edge) {
        KVectorChain junctionPoints = new KVectorChain();
        HashMap pointsMap = Maps.newHashMap();
        pointsMap.put(edge, ElkUtil.getPoints(edge));
        ArrayList connectedPorts = Lists.newArrayListWithCapacity((int)2);
        if (edge.getSourcePort() != null) {
            connectedPorts.add(edge.getSourcePort());
        }
        if (edge.getTargetPort() != null) {
            connectedPorts.add(edge.getTargetPort());
        }
        for (KPort p : connectedPorts) {
            boolean reverse;
            KVector p1;
            LinkedList allConnectedEdges = Lists.newLinkedList();
            allConnectedEdges.addAll(p.getEdges());
            allConnectedEdges.remove(edge);
            if (allConnectedEdges.isEmpty()) continue;
            KVector[] thisPoints = (KVector[])pointsMap.get(edge);
            if (p == edge.getTargetPort()) {
                p1 = thisPoints[thisPoints.length - 1];
                reverse = true;
            } else {
                p1 = thisPoints[0];
                reverse = false;
            }
            int i = 1;
            while (i < thisPoints.length) {
                KVector p2 = reverse ? thisPoints[thisPoints.length - 1 - i] : thisPoints[i];
                Iterator allEdgeIter = allConnectedEdges.iterator();
                while (allEdgeIter.hasNext()) {
                    KEdge otherEdge = (KEdge)allEdgeIter.next();
                    KVector[] otherPoints = (KVector[])pointsMap.get(otherEdge);
                    if (otherPoints == null) {
                        otherPoints = ElkUtil.getPoints(otherEdge);
                        pointsMap.put(otherEdge, otherPoints);
                    }
                    if (otherPoints.length <= i) {
                        allEdgeIter.remove();
                        continue;
                    }
                    KVector p3 = reverse ? otherPoints[otherPoints.length - 1 - i] : otherPoints[i];
                    if (p2.x == p3.x && p2.y == p3.y) continue;
                    double dx3 = p3.x - p1.x;
                    double dy2 = p2.y - p1.y;
                    double dy3 = p3.y - p1.y;
                    double dx2 = p2.x - p1.x;
                    if (dx3 * dy2 == dy3 * dx2 && ElkUtil.signum(dx2) == ElkUtil.signum(dx3) && ElkUtil.signum(dy2) == ElkUtil.signum(dy3)) {
                        if (Math.abs(dx2) < Math.abs(dx3) || Math.abs(dy2) < Math.abs(dy3)) {
                            junctionPoints.add(p2);
                        }
                    } else if (i > 1) {
                        junctionPoints.add(p1);
                    }
                    allEdgeIter.remove();
                }
                p1 = p2;
                ++i;
            }
        }
        return junctionPoints;
    }

    private static int signum(double x) {
        if (x < 0.0) {
            return -1;
        }
        if (x > 0.0) {
            return 1;
        }
        return 0;
    }

    private static KVector[] getPoints(KEdge edge) {
        KEdgeLayout edgeLayout = (KEdgeLayout)edge.getData(KEdgeLayout.class);
        int n = edgeLayout.getBendPoints().size() + 2;
        KVector[] points = new KVector[n];
        points[0] = edgeLayout.getSourcePoint().createVector();
        ListIterator pointIter = edgeLayout.getBendPoints().listIterator();
        while (pointIter.hasNext()) {
            KPoint bendPoint = (KPoint)pointIter.next();
            points[pointIter.nextIndex()] = bendPoint.createVector();
        }
        points[n - 1] = edgeLayout.getTargetPoint().createVector();
        return points;
    }

    public static Iterator<KEdge> getConnectedEdges(Iterable<KEdge> kedges) {
        return Iterators.concat((Iterator)Iterators.transform(kedges.iterator(), (Function)new Function<KEdge, Iterator<KEdge>>(){

            public Iterator<KEdge> apply(KEdge kedge) {
                return ElkUtil.getConnectedEdges(kedge);
            }
        }));
    }

    public static Iterator<KEdge> getConnectedEdges(KEdge kedge) {
        return Iterators.filter(ElkUtil.getConnectedElements(kedge, false), KEdge.class);
    }

    public static Iterator<KGraphElement> getConnectedElements(KEdge kedge, boolean addPorts) {
        DefaultSelectionIterator sourceSideIt = new DefaultSelectionIterator(kedge, addPorts, false);
        DefaultSelectionIterator targetSideIt = new DefaultSelectionIterator(kedge, addPorts, true);
        return ElkUtil.getConnectedElements(kedge, sourceSideIt, targetSideIt);
    }

    public static Iterator<KGraphElement> getConnectedElements(KEdge kedge, SelectionIterator sourceIterator, SelectionIterator targetIterator) {
        SelectionIterator targetSideIt;
        SelectionIterator sourceSideIt;
        UnmodifiableIterator kedgeIt = Iterators.singletonIterator((Object)kedge);
        HashSet visited = Sets.newHashSet();
        SelectionIterator selectionIterator = sourceSideIt = kedge.getSourcePort() == null ? null : sourceIterator;
        if (sourceSideIt != null) {
            sourceSideIt.attachVisitedSet(visited);
        }
        SelectionIterator selectionIterator2 = targetSideIt = kedge.getTargetPort() == null ? null : targetIterator;
        if (targetSideIt != null) {
            targetSideIt.attachVisitedSet(visited);
        }
        SelectionIterator connectedEdges = sourceSideIt == null ? targetSideIt : (targetSideIt == null ? sourceSideIt : Iterators.concat((Iterator)((Object)sourceSideIt), (Iterator)((Object)targetSideIt)));
        return connectedEdges == null ? kedgeIt : Iterators.concat((Iterator)kedgeIt, (Iterator)((Object)connectedEdges));
    }

    public static void configureDefaultsRecursively(KNode graph) {
        UnmodifiableIterator kgeIt = Iterators.filter((Iterator)graph.eAllContents(), KGraphElement.class);
        while (kgeIt.hasNext()) {
            KGraphElement kge = (KGraphElement)kgeIt.next();
            if (kge instanceof KNode) {
                ElkUtil.configureWithDefaultValues((KNode)kge);
                continue;
            }
            if (kge instanceof KPort) {
                ElkUtil.configureWithDefaultValues((KPort)kge);
                continue;
            }
            if (!(kge instanceof KEdge)) continue;
            ElkUtil.configureWithDefaultValues((KEdge)kge);
        }
    }

    public static void configureWithDefaultValues(KNode node) {
        Set nlp;
        Set sc;
        KShapeLayout sl = (KShapeLayout)node.getData(KShapeLayout.class);
        if (sl != null && (sc = (Set)sl.getProperty(CoreOptions.NODE_SIZE_CONSTRAINTS)).equals(SizeConstraint.fixed()) && sl.getWidth() == 0.0f && sl.getHeight() == 0.0f) {
            sl.setWidth(80.0f);
            sl.setHeight(80.0f);
        }
        ElkUtil.ensureLabel((KLabeledGraphElement)node);
        if (sl != null && (nlp = (Set)sl.getProperty(CoreOptions.NODE_LABELS_PLACEMENT)).equals(NodeLabelPlacement.fixed())) {
            sl.setProperty(CoreOptions.NODE_LABELS_PLACEMENT, NodeLabelPlacement.insideCenter());
        }
    }

    public static void configureWithDefaultValues(KPort port) {
        KShapeLayout sl = (KShapeLayout)port.getData(KShapeLayout.class);
        if (sl != null && sl.getWidth() == 0.0f && sl.getHeight() == 0.0f) {
            sl.setWidth(5.0f);
            sl.setHeight(5.0f);
        }
        ElkUtil.ensureLabel((KLabeledGraphElement)port);
    }

    public static void configureWithDefaultValues(KEdge edge) {
        EdgeLabelPlacement elp;
        KLayoutData ld = (KLayoutData)edge.getData(KLayoutData.class);
        if (ld != null && (elp = (EdgeLabelPlacement)((Object)ld.getProperty(CoreOptions.EDGE_LABELS_PLACEMENT))) == EdgeLabelPlacement.UNDEFINED) {
            ld.setProperty(CoreOptions.EDGE_LABELS_PLACEMENT, (Object)EdgeLabelPlacement.CENTER);
        }
    }

    private static void ensureLabel(KLabeledGraphElement klge) {
        KIdentifier id;
        if (klge.getLabels().isEmpty() && (id = (KIdentifier)klge.getData(KIdentifier.class)) != null && !Strings.isNullOrEmpty((String)id.getId())) {
            KLabel label = ElkUtil.createInitializedLabel(klge);
            label.setText(id.getId());
        }
    }

    public static void printElementPath(KGraphElement element, StringBuilder builder) {
        String text;
        if (element.eContainer() instanceof KGraphElement) {
            ElkUtil.printElementPath((KGraphElement)element.eContainer(), builder);
            builder.append(" > ");
        } else {
            builder.append("Root ");
        }
        String className = element.eClass().getName();
        if (className.startsWith("K")) {
            builder.append(className.substring(1));
        } else {
            builder.append(className);
        }
        if (element instanceof KLabeledGraphElement) {
            KLabel firstLabel;
            String text2;
            KLabeledGraphElement labeledElement = (KLabeledGraphElement)element;
            if (!labeledElement.getLabels().isEmpty() && (text2 = (firstLabel = (KLabel)labeledElement.getLabels().get(0)).getText()) != null && !text2.isEmpty()) {
                builder.append(' ').append(text2);
            }
        } else if (element instanceof KLabel && (text = ((KLabel)element).getText()) != null && !text.isEmpty()) {
            builder.append(' ').append(text);
        }
    }
}

