/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.greedyswitch;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.core.options.PortSide;

final class PortIterable
implements Iterable<LPort> {
    private final PortSide side;
    private final LNode node;
    private final PortOrder order;

    private PortIterable(LNode node, PortSide side, PortOrder order) {
        this.node = node;
        this.side = side;
        this.order = order;
    }

    public static Iterable<LPort> inNorthSouthEastWestOrder(LNode node, PortSide side) {
        return new PortIterable(node, side, PortOrder.NORTHSOUTH_EASTWEST);
    }

    public static Iterable<LPort> inClockwiseOrder(LNode node, PortSide side) {
        return new PortIterable(node, side, PortOrder.CLOCKWISE);
    }

    public static Iterable<LPort> inCounterClockwiseOrder(LNode node, PortSide side) {
        return new PortIterable(node, side, PortOrder.COUNTER_CLOCKWISE);
    }

    @Override
    public Iterator<LPort> iterator() {
        List<LPort> ports = this.node.getPorts();
        switch (this.order) {
            case CLOCKWISE: {
                return this.node.getPorts().iterator();
            }
            case COUNTER_CLOCKWISE: {
                return Iterators.filter(this.getCCWIterator(ports), this.getPredicate());
            }
            case NORTHSOUTH_EASTWEST: {
                switch (this.side) {
                    case NORTH: 
                    case EAST: {
                        return Iterators.filter(ports.iterator(), this.getPredicate());
                    }
                    case SOUTH: 
                    case WEST: {
                        return Iterators.filter(this.getCCWIterator(ports), this.getPredicate());
                    }
                }
            }
        }
        throw new UnsupportedOperationException("PortOrder not implemented.");
    }

    private Predicate<LPort> getPredicate() {
        switch (this.side) {
            case NORTH: {
                return LPort.NORTH_PREDICATE;
            }
            case EAST: {
                return LPort.EAST_PREDICATE;
            }
            case SOUTH: {
                return LPort.SOUTH_PREDICATE;
            }
            case WEST: {
                return LPort.WEST_PREDICATE;
            }
        }
        throw new UnsupportedOperationException("Can't filter on undefined side");
    }

    private Iterator<LPort> getCCWIterator(List<LPort> ports) {
        Iterator<LPort> iterator = new Iterator<LPort>(ports){
            private final ListIterator<LPort> listIterator;
            {
                this.listIterator = list.listIterator(list.size());
            }

            @Override
            public boolean hasNext() {
                return this.listIterator.hasPrevious();
            }

            @Override
            public LPort next() {
                return this.listIterator.previous();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return iterator;
    }

    private static enum PortOrder {
        CLOCKWISE,
        COUNTER_CLOCKWISE,
        NORTHSOUTH_EASTWEST;

    }
}

