/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import java.util.List;
import java.util.Set;
import org.eclipse.elk.alg.layered.ILayoutProcessor;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LGraphUtil;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.p5edges.splines.ConnectedSelfLoopComponent;
import org.eclipse.elk.alg.layered.properties.InternalProperties;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.core.labels.ILabelManager;
import org.eclipse.elk.core.labels.LabelManagementOptions;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class LabelManagementProcessor
implements ILayoutProcessor {
    private static final double MIN_WIDTH_EDGE_LABELS = 60.0;
    private static final double MIN_WIDTH_PORT_LABELS = 20.0;

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Label management", 1.0f);
        ILabelManager labelManager = (ILabelManager)layeredGraph.getProperty(LabelManagementOptions.LABEL_MANAGER);
        if (labelManager != null) {
            double labelSpacing = ((Float)layeredGraph.getProperty(LayeredOptions.SPACING_LABEL)).doubleValue();
            for (Layer layer : layeredGraph) {
                this.manageLabels(layer, labelManager, labelSpacing);
            }
        }
        monitor.done();
    }

    private void manageLabels(Layer layer, ILabelManager labelManager, double labelSpacing) {
        assert (labelManager != null) : "labelManager is null";
        boolean verticalLayout = ((Direction)layer.getGraph().getProperty(LayeredOptions.DIRECTION)).isVertical();
        double maxWidth = Math.max(60.0, LGraphUtil.findMaxNonDummyNodeWidth(layer, false));
        for (LNode layerNode : layer) {
            switch (layerNode.getType()) {
                case NORMAL: {
                    List<LPort> ports = layerNode.getPorts();
                    for (LPort port : ports) {
                        this.doManageLabels(labelManager, port.getLabels(), 20.0, null, 0.0, verticalLayout);
                    }
                    List components = (List)layerNode.getProperty(InternalProperties.SPLINE_SELFLOOP_COMPONENTS);
                    for (ConnectedSelfLoopComponent component : components) {
                        Set<LEdge> edges = component.getEdges();
                        for (LEdge edge : edges) {
                            this.doManageLabels(labelManager, edge.getLabels(), maxWidth, null, labelSpacing, verticalLayout);
                        }
                    }
                    break;
                }
                case LABEL: {
                    LEdge edge = layerNode.getConnectedEdges().iterator().next();
                    double edgeThickness = ((Float)edge.getProperty(LayeredOptions.EDGE_THICKNESS)).doubleValue();
                    KVector newDummySize = new KVector(0.0, edgeThickness);
                    Iterable labels = (Iterable)layerNode.getProperty(InternalProperties.REPRESENTED_LABELS);
                    newDummySize = this.doManageLabels(labelManager, labels, maxWidth, newDummySize, labelSpacing, verticalLayout);
                    layerNode.getSize().x = newDummySize.x;
                    layerNode.getSize().y = newDummySize.y;
                }
            }
            for (LEdge edge : layerNode.getOutgoingEdges()) {
                this.doManageLabels(labelManager, edge.getLabels(), 60.0, null, 0.0, verticalLayout);
            }
        }
    }

    private KVector doManageLabels(ILabelManager labelManager, Iterable<LLabel> labels, double targetWidth, KVector newDummySize, double labelSpacing, boolean verticalLayout) {
        for (LLabel label : labels) {
            KVector newSize;
            Object origin = label.getProperty(InternalProperties.ORIGIN);
            if (origin != null && (newSize = labelManager.manageLabelSize(origin, targetWidth)) != null) {
                if (verticalLayout) {
                    label.getSize().x = newSize.y;
                    label.getSize().y = newSize.x;
                } else {
                    label.getSize().x = newSize.x;
                    label.getSize().y = newSize.y;
                }
            }
            if (newDummySize == null) continue;
            newDummySize.x = Math.max(newDummySize.x, label.getSize().x);
            newDummySize.y += label.getSize().y + labelSpacing;
        }
        return newDummySize;
    }
}

