/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.graph;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LInsets;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LShape;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.PortSide;

public final class LPort
extends LShape {
    private static final long serialVersionUID = -3406558719744943360L;
    public static final Predicate<LPort> OUTPUT_PREDICATE = new Predicate<LPort>(){

        public boolean apply(LPort port) {
            return !port.outgoingEdges.isEmpty();
        }
    };
    public static final Predicate<LPort> INPUT_PREDICATE = new Predicate<LPort>(){

        public boolean apply(LPort port) {
            return !port.incomingEdges.isEmpty();
        }
    };
    public static final Predicate<LPort> NORTH_PREDICATE = new Predicate<LPort>(){

        public boolean apply(LPort port) {
            return port.side == PortSide.NORTH;
        }
    };
    public static final Predicate<LPort> EAST_PREDICATE = new Predicate<LPort>(){

        public boolean apply(LPort port) {
            return port.side == PortSide.EAST;
        }
    };
    public static final Predicate<LPort> SOUTH_PREDICATE = new Predicate<LPort>(){

        public boolean apply(LPort port) {
            return port.side == PortSide.SOUTH;
        }
    };
    public static final Predicate<LPort> WEST_PREDICATE = new Predicate<LPort>(){

        public boolean apply(LPort port) {
            return port.side == PortSide.WEST;
        }
    };
    private LNode owner;
    private PortSide side = PortSide.UNDEFINED;
    private final KVector anchor = new KVector();
    private final LInsets margin = new LInsets();
    private final List<LLabel> labels = Lists.newArrayListWithCapacity((int)2);
    private final List<LEdge> incomingEdges = Lists.newArrayListWithCapacity((int)4);
    private final List<LEdge> outgoingEdges = Lists.newArrayListWithCapacity((int)4);

    public LNode getNode() {
        return this.owner;
    }

    public void setNode(LNode node) {
        if (this.owner != null) {
            this.owner.getPorts().remove((Object)this);
        }
        this.owner = node;
        if (this.owner != null) {
            this.owner.getPorts().add(this);
        }
    }

    public PortSide getSide() {
        return this.side;
    }

    public void setSide(PortSide theside) {
        if (theside == null) {
            throw new NullPointerException();
        }
        this.side = theside;
    }

    public KVector getAnchor() {
        return this.anchor;
    }

    public KVector getAbsoluteAnchor() {
        return KVector.sum((KVector[])new KVector[]{this.owner.getPosition(), this.getPosition(), this.anchor});
    }

    public LInsets getMargin() {
        return this.margin;
    }

    public List<LLabel> getLabels() {
        return this.labels;
    }

    public String getName() {
        if (!this.labels.isEmpty()) {
            return this.labels.get(0).getText();
        }
        return null;
    }

    public int getDegree() {
        return this.incomingEdges.size() + this.outgoingEdges.size();
    }

    public int getNetFlow() {
        return this.incomingEdges.size() - this.outgoingEdges.size();
    }

    public List<LEdge> getIncomingEdges() {
        return this.incomingEdges;
    }

    public List<LEdge> getOutgoingEdges() {
        return this.outgoingEdges;
    }

    public Iterable<LEdge> getConnectedEdges() {
        return Iterables.concat(this.incomingEdges, this.outgoingEdges);
    }

    public Iterable<LPort> getPredecessorPorts() {
        return new Iterable<LPort>(){

            @Override
            public Iterator<LPort> iterator() {
                final Iterator edgesIter = LPort.this.incomingEdges.iterator();
                return new Iterator<LPort>(){

                    @Override
                    public boolean hasNext() {
                        return edgesIter.hasNext();
                    }

                    @Override
                    public LPort next() {
                        return ((LEdge)((Object)edgesIter.next())).getSource();
                    }

                    @Override
                    public void remove() {
                        edgesIter.remove();
                    }
                };
            }
        };
    }

    public Iterable<LPort> getSuccessorPorts() {
        return new Iterable<LPort>(){

            @Override
            public Iterator<LPort> iterator() {
                final Iterator edgesIter = LPort.this.outgoingEdges.iterator();
                return new Iterator<LPort>(){

                    @Override
                    public boolean hasNext() {
                        return edgesIter.hasNext();
                    }

                    @Override
                    public LPort next() {
                        return ((LEdge)((Object)edgesIter.next())).getTarget();
                    }

                    @Override
                    public void remove() {
                        edgesIter.remove();
                    }
                };
            }
        };
    }

    public Iterable<LPort> getConnectedPorts() {
        return Iterables.concat(this.getPredecessorPorts(), this.getSuccessorPorts());
    }

    public int getIndex() {
        if (this.owner == null) {
            return -1;
        }
        return this.owner.getPorts().indexOf((Object)this);
    }

    public String toString() {
        String text = this.getName();
        if (text == null) {
            return "p_" + this.id;
        }
        return "p_" + text;
    }
}

