/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.force.properties;

import java.util.EnumSet;
import org.eclipse.elk.alg.force.model.ForceModelStrategy;
import org.eclipse.elk.alg.force.properties.ForceOptions;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.util.ExclusiveBounds;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;

public class ForceMetaDataProvider
implements ILayoutMetaDataProvider {
    private static final ForceModelStrategy MODEL_DEFAULT = ForceModelStrategy.FRUCHTERMAN_REINGOLD;
    public static final IProperty<ForceModelStrategy> MODEL = new Property("org.eclipse.elk.force.model", (Object)MODEL_DEFAULT, null, null);
    private static final int ITERATIONS_DEFAULT = 300;
    private static final Comparable<? super Integer> ITERATIONS_LOWER_BOUND = 1;
    public static final IProperty<Integer> ITERATIONS = new Property("org.eclipse.elk.force.iterations", (Object)300, ITERATIONS_LOWER_BOUND, null);
    private static final int REPULSIVE_POWER_DEFAULT = 0;
    private static final Comparable<? super Integer> REPULSIVE_POWER_LOWER_BOUND = 0;
    public static final IProperty<Integer> REPULSIVE_POWER = new Property("org.eclipse.elk.force.repulsivePower", (Object)0, REPULSIVE_POWER_LOWER_BOUND, null);
    private static final float TEMPERATURE_DEFAULT = 0.001f;
    private static final Comparable<? super Float> TEMPERATURE_LOWER_BOUND = ExclusiveBounds.greaterThan((double)0.0);
    public static final IProperty<Float> TEMPERATURE = new Property("org.eclipse.elk.force.temperature", (Object)Float.valueOf(0.001f), TEMPERATURE_LOWER_BOUND, null);
    private static final float REPULSION_DEFAULT = 5.0f;
    private static final Comparable<? super Float> REPULSION_LOWER_BOUND = ExclusiveBounds.greaterThan((double)0.0);
    public static final IProperty<Float> REPULSION = new Property("org.eclipse.elk.force.repulsion", (Object)Float.valueOf(5.0f), REPULSION_LOWER_BOUND, null);
    private static final ForceModelStrategy TEMPERATURE_DEP_MODEL = ForceModelStrategy.FRUCHTERMAN_REINGOLD;
    private static final ForceModelStrategy REPULSION_DEP_MODEL = ForceModelStrategy.EADES;

    public void apply(ILayoutMetaDataProvider.Registry registry) {
        registry.register(new LayoutOptionData("org.eclipse.elk.force.model", "", "Force Model", "Determines the model for force calculation.", (Object)MODEL_DEFAULT, null, null, LayoutOptionData.Type.ENUM, ForceModelStrategy.class, EnumSet.of(LayoutOptionData.Target.PARENTS), LayoutOptionData.Visibility.VISIBLE, new String[0]));
        registry.register(new LayoutOptionData("org.eclipse.elk.force.iterations", "", "Iterations", "The number of iterations on the force model.", (Object)300, ITERATIONS_LOWER_BOUND, null, LayoutOptionData.Type.INT, Integer.class, EnumSet.of(LayoutOptionData.Target.PARENTS), LayoutOptionData.Visibility.VISIBLE, new String[0]));
        registry.register(new LayoutOptionData("org.eclipse.elk.force.repulsivePower", "", "Repulsive Power", "Determines how many bend points are added to the edge; such bend points are regarded as repelling particles in the force model", (Object)0, REPULSIVE_POWER_LOWER_BOUND, null, LayoutOptionData.Type.INT, Integer.class, EnumSet.of(LayoutOptionData.Target.EDGES), LayoutOptionData.Visibility.VISIBLE, new String[0]));
        registry.register(new LayoutOptionData("org.eclipse.elk.force.temperature", "", "FR Temperature", "The temperature is used as a scaling factor for particle displacements.", (Object)Float.valueOf(0.001f), TEMPERATURE_LOWER_BOUND, null, LayoutOptionData.Type.FLOAT, Float.class, EnumSet.of(LayoutOptionData.Target.PARENTS), LayoutOptionData.Visibility.VISIBLE, new String[0]));
        registry.addDependency("org.eclipse.elk.force.temperature", "org.eclipse.elk.force.model", (Object)TEMPERATURE_DEP_MODEL);
        registry.register(new LayoutOptionData("org.eclipse.elk.force.repulsion", "", "Eades Repulsion", "Factor for repulsive forces in Eades' model.", (Object)Float.valueOf(5.0f), REPULSION_LOWER_BOUND, null, LayoutOptionData.Type.FLOAT, Float.class, EnumSet.of(LayoutOptionData.Target.PARENTS), LayoutOptionData.Visibility.VISIBLE, new String[0]));
        registry.addDependency("org.eclipse.elk.force.repulsion", "org.eclipse.elk.force.model", (Object)REPULSION_DEP_MODEL);
        new ForceOptions().apply(registry);
    }
}

