/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.nd;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.org.eclipse.jdt.internal.core.nd.IReader;
import org.aspectj.org.eclipse.jdt.internal.core.nd.ITypeFactory;
import org.aspectj.org.eclipse.jdt.internal.core.nd.NdNode;
import org.aspectj.org.eclipse.jdt.internal.core.nd.NdNodeTypeRegistry;
import org.aspectj.org.eclipse.jdt.internal.core.nd.Package;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.ChunkCache;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.Database;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.IndexException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class Nd {
    private static final int CANCELLATION_CHECK_INTERVAL = 500;
    private static final int BLOCKED_WRITE_LOCK_OUTPUT_INTERVAL = 30000;
    private static final int LONG_WRITE_LOCK_REPORT_THRESHOLD = 1000;
    private static final int LONG_READ_LOCK_WAIT_REPORT_THRESHOLD = 1000;
    public static boolean sDEBUG_LOCKS = false;
    public static boolean DEBUG_DUPLICATE_DELETIONS = false;
    private final int currentVersion;
    private final int maxVersion;
    private final int minVersion;
    protected Database db;
    private File fPath;
    private final HashMap<Object, Object> fResultCache = new HashMap();
    private final NdNodeTypeRegistry<NdNode> fNodeTypeRegistry;
    private HashMap<Long, Object> pendingDeletions = new HashMap();
    private IReader fReader = new IReader(){

        @Override
        public void close() {
            Nd.this.releaseReadLock();
        }
    };
    private long fWriteNumber;
    private final Object mutex = new Object();
    private int lockCount;
    private int waitingReaders;
    private long lastWriteAccess = 0L;
    private long timeWriteLockAcquired;
    private Map<Thread, DebugLockInfo> fLockDebugging;

    public static int version(int major, int minor) {
        return (major << 16) + minor;
    }

    public int getDefaultVersion() {
        return this.currentVersion;
    }

    public boolean isSupportedVersion(int vers) {
        return vers >= this.minVersion && vers <= this.maxVersion;
    }

    public int getMinSupportedVersion() {
        return this.minVersion;
    }

    public int getMaxSupportedVersion() {
        return this.maxVersion;
    }

    public static String versionString(int version) {
        int major = version >> 16;
        int minor = version & 0xFFFF;
        return "" + major + '.' + minor;
    }

    public Nd(File dbPath, NdNodeTypeRegistry<NdNode> nodeTypes, int minVersion, int maxVersion, int currentVersion) throws IndexException {
        this(dbPath, ChunkCache.getSharedInstance(), nodeTypes, minVersion, maxVersion, currentVersion);
    }

    public Nd(File dbPath, ChunkCache chunkCache, NdNodeTypeRegistry<NdNode> nodeTypes, int minVersion, int maxVersion, int currentVersion) throws IndexException {
        this.currentVersion = currentVersion;
        this.maxVersion = maxVersion;
        this.minVersion = minVersion;
        this.fNodeTypeRegistry = nodeTypes;
        this.loadDatabase(dbPath, chunkCache);
        if (sDEBUG_LOCKS) {
            this.fLockDebugging = new HashMap<Thread, DebugLockInfo>();
            System.out.println("Debugging database Locks");
        }
    }

    public File getPath() {
        return this.fPath;
    }

    public long getWriteNumber() {
        return this.fWriteNumber;
    }

    public void scheduleDeletion(long addressOfNodeToDelete) {
        if (this.pendingDeletions.containsKey(addressOfNodeToDelete)) {
            this.logDoubleDeletion(addressOfNodeToDelete);
            return;
        }
        Serializable data = Boolean.TRUE;
        if (DEBUG_DUPLICATE_DELETIONS) {
            data = new RuntimeException();
        }
        this.pendingDeletions.put(addressOfNodeToDelete, data);
    }

    protected void logDoubleDeletion(long addressOfNodeToDelete) {
        Package.log("Database object queued for deletion twice", new RuntimeException());
        Object earlierData = this.pendingDeletions.get(addressOfNodeToDelete);
        if (earlierData instanceof RuntimeException) {
            RuntimeException exception = (RuntimeException)earlierData;
            Package.log("Data associated with earlier deletion stack was:", exception);
        }
    }

    public void processDeletions() {
        while (!this.pendingDeletions.isEmpty()) {
            long next = this.pendingDeletions.keySet().iterator().next();
            this.deleteIfUnreferenced(next);
            this.pendingDeletions.remove(next);
        }
    }

    protected boolean isPermanentlyReadOnly() {
        return false;
    }

    private void loadDatabase(File dbPath, ChunkCache cache) throws IndexException {
        this.fPath = dbPath;
        boolean lockDB = this.db == null || this.lockCount != 0;
        this.clearCaches();
        this.db = new Database(this.fPath, cache, this.getDefaultVersion(), this.isPermanentlyReadOnly());
        this.db.setLocked(lockDB);
        if (!this.isSupportedVersion()) {
            Package.logInfo("Index database uses the unsupported version " + this.db.getVersion() + ". Deleting and recreating.");
            this.db.close();
            this.fPath.delete();
            this.db = new Database(this.fPath, cache, this.getDefaultVersion(), this.isPermanentlyReadOnly());
            this.db.setLocked(lockDB);
        }
        this.fWriteNumber = this.db.getLong(2052L);
        this.db.setLocked(this.lockCount != 0);
    }

    public Database getDB() {
        return this.db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IReader acquireReadLock() {
        try {
            long t = sDEBUG_LOCKS ? System.nanoTime() : 0L;
            Object object = this.mutex;
            synchronized (object) {
                ++this.waitingReaders;
                try {
                    while (this.lockCount < 0) {
                        this.mutex.wait();
                    }
                }
                finally {
                    --this.waitingReaders;
                }
                ++this.lockCount;
                this.db.setLocked(true);
                if (sDEBUG_LOCKS) {
                    t = (System.nanoTime() - t) / 1000000L;
                    if (t >= 1000L) {
                        System.out.println("Acquired index read lock after " + t + " ms wait.");
                    }
                    Nd.incReadLock(this.fLockDebugging);
                }
                return this.fReader;
            }
        }
        catch (InterruptedException e) {
            throw new OperationCanceledException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseReadLock() {
        Object object = this.mutex;
        synchronized (object) {
            assert (this.lockCount > 0) : "No lock to release";
            if (sDEBUG_LOCKS) {
                Nd.decReadLock(this.fLockDebugging);
            }
            if (this.lockCount > 0) {
                --this.lockCount;
            }
            this.mutex.notifyAll();
            this.db.setLocked(this.lockCount != 0);
        }
    }

    public void acquireWriteLock(IProgressMonitor monitor) {
        try {
            this.acquireWriteLock(0, monitor);
        }
        catch (InterruptedException e) {
            throw new OperationCanceledException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireWriteLock(int giveupReadLocks, IProgressMonitor monitor) throws InterruptedException {
        assert (!this.isPermanentlyReadOnly());
        Object object = this.mutex;
        synchronized (object) {
            if (sDEBUG_LOCKS) {
                this.incWriteLock(giveupReadLocks);
            }
            if (giveupReadLocks > 0) {
                assert (this.lockCount >= giveupReadLocks) : "Not enough locks to release";
                if (this.lockCount < giveupReadLocks) {
                    giveupReadLocks = this.lockCount;
                }
            } else {
                giveupReadLocks = 0;
            }
            long start = sDEBUG_LOCKS ? System.currentTimeMillis() : 0L;
            while (this.lockCount > giveupReadLocks || this.waitingReaders > 0) {
                this.mutex.wait(500L);
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (!sDEBUG_LOCKS) continue;
                start = this.reportBlockedWriteLock(start, giveupReadLocks);
            }
            this.lockCount = -1;
            if (sDEBUG_LOCKS) {
                this.timeWriteLockAcquired = System.currentTimeMillis();
            }
            this.db.setExclusiveLock();
        }
    }

    public final void releaseWriteLock() {
        this.releaseWriteLock(0, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseWriteLock(int establishReadLocks, boolean flush) {
        boolean wasInterrupted = false;
        if (establishReadLocks == 0) {
            this.processDeletions();
            this.db.putLong(2052L, ++this.fWriteNumber);
            this.clearResultCache();
        }
        try {
            wasInterrupted = this.db.giveUpExclusiveLock(flush) || wasInterrupted;
        }
        catch (IndexException e) {
            Package.log(e);
        }
        assert (this.lockCount == -1);
        this.lastWriteAccess = System.currentTimeMillis();
        Object object = this.mutex;
        synchronized (object) {
            if (sDEBUG_LOCKS) {
                long timeHeld = this.lastWriteAccess - this.timeWriteLockAcquired;
                if (timeHeld >= 1000L) {
                    System.out.println("Index write lock held for " + timeHeld + " ms");
                }
                this.decWriteLock(establishReadLocks);
            }
            if (this.lockCount < 0) {
                this.lockCount = establishReadLocks;
            }
            this.mutex.notifyAll();
            this.db.setLocked(this.lockCount != 0);
        }
        if (wasInterrupted) {
            throw new OperationCanceledException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasWaitingReaders() {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitingReaders > 0;
        }
    }

    public long getLastWriteAccess() {
        return this.lastWriteAccess;
    }

    public boolean isSupportedVersion() throws IndexException {
        int version = this.db.getVersion();
        return version >= this.minVersion && version <= this.maxVersion;
    }

    public void close() throws IndexException {
        this.db.close();
        this.clearCaches();
    }

    private void clearCaches() {
        this.clearResultCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearResultCache() {
        HashMap<Object, Object> hashMap = this.fResultCache;
        synchronized (hashMap) {
            this.fResultCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCachedResult(Object key) {
        HashMap<Object, Object> hashMap = this.fResultCache;
        synchronized (hashMap) {
            return this.fResultCache.get(key);
        }
    }

    public void putCachedResult(Object key, Object result) {
        this.putCachedResult(key, result, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object putCachedResult(Object key, Object result, boolean replace) {
        HashMap<Object, Object> hashMap = this.fResultCache;
        synchronized (hashMap) {
            Object old = this.fResultCache.put(key, result);
            if (old != null && !replace) {
                this.fResultCache.put(key, old);
                return old;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCachedResult(Object key) {
        HashMap<Object, Object> hashMap = this.fResultCache;
        synchronized (hashMap) {
            this.fResultCache.remove(key);
        }
    }

    private static DebugLockInfo getLockInfo(Map<Thread, DebugLockInfo> lockDebugging) {
        assert (sDEBUG_LOCKS);
        Thread key = Thread.currentThread();
        DebugLockInfo result = lockDebugging.get(key);
        if (result == null) {
            result = new DebugLockInfo();
            lockDebugging.put(key, result);
        }
        return result;
    }

    static void incReadLock(Map<Thread, DebugLockInfo> lockDebugging) {
        DebugLockInfo info = Nd.getLockInfo(lockDebugging);
        ++info.fReadLocks;
        if (info.addTrace() > 10) {
            Nd.outputReadLocks(lockDebugging);
        }
    }

    static void decReadLock(Map<Thread, DebugLockInfo> lockDebugging) throws AssertionError {
        DebugLockInfo info = Nd.getLockInfo(lockDebugging);
        if (info.fReadLocks <= 0) {
            Nd.outputReadLocks(lockDebugging);
            throw new AssertionError((Object)"Superfluous releaseReadLock");
        }
        if (info.fWriteLocks != 0) {
            Nd.outputReadLocks(lockDebugging);
            throw new AssertionError((Object)"Releasing readlock while holding write lock");
        }
        if (--info.fReadLocks == 0) {
            lockDebugging.remove(Thread.currentThread());
        } else {
            info.addTrace();
        }
    }

    private void incWriteLock(int giveupReadLocks) throws AssertionError {
        DebugLockInfo info = Nd.getLockInfo(this.fLockDebugging);
        if (info.fReadLocks != giveupReadLocks) {
            Nd.outputReadLocks(this.fLockDebugging);
            throw new AssertionError((Object)("write lock with " + giveupReadLocks + " readlocks, expected " + info.fReadLocks));
        }
        if (info.fWriteLocks != 0) {
            throw new AssertionError((Object)"Duplicate write lock");
        }
        ++info.fWriteLocks;
    }

    private void decWriteLock(int establishReadLocks) throws AssertionError {
        DebugLockInfo info = Nd.getLockInfo(this.fLockDebugging);
        if (info.fReadLocks != establishReadLocks) {
            throw new AssertionError((Object)("release write lock with " + establishReadLocks + " readlocks, expected " + info.fReadLocks));
        }
        if (info.fWriteLocks != 1) {
            throw new AssertionError((Object)"Wrong release write lock");
        }
        info.fWriteLocks = 0;
        if (info.fReadLocks == 0) {
            this.fLockDebugging.remove(Thread.currentThread());
        }
    }

    private long reportBlockedWriteLock(long start, int giveupReadLocks) {
        long now = System.currentTimeMillis();
        if (now >= start + 30000L) {
            System.out.println();
            System.out.println("Blocked writeLock");
            System.out.println("  lockcount= " + this.lockCount + ", giveupReadLocks=" + giveupReadLocks + ", waitingReaders=" + this.waitingReaders);
            Nd.outputReadLocks(this.fLockDebugging);
            start = now;
        }
        return start;
    }

    private static void outputReadLocks(Map<Thread, DebugLockInfo> lockDebugging) {
        System.out.println("---------------------  Lock Debugging -------------------------");
        for (Thread th : lockDebugging.keySet()) {
            DebugLockInfo info = lockDebugging.get(th);
            info.write(th.getName());
        }
        System.out.println("---------------------------------------------------------------");
    }

    public void adjustThreadForReadLock(Map<Thread, DebugLockInfo> lockDebugging) {
        for (Thread th : lockDebugging.keySet()) {
            DebugLockInfo val = lockDebugging.get(th);
            if (val.fReadLocks <= 0) continue;
            DebugLockInfo myval = this.fLockDebugging.get(th);
            if (myval == null) {
                myval = new DebugLockInfo();
                this.fLockDebugging.put(th, myval);
            }
            myval.inc(val);
            int i = 0;
            while (i < val.fReadLocks) {
                Nd.decReadLock(this.fLockDebugging);
                ++i;
            }
        }
    }

    public NdNode getNode(long address, short nodeType) throws IndexException {
        return this.fNodeTypeRegistry.createNode(this, address, nodeType);
    }

    public <T extends NdNode> ITypeFactory<T> getTypeFactory(short nodeType) {
        return this.fNodeTypeRegistry.getTypeFactory(nodeType);
    }

    public short getNodeType(Class<? extends NdNode> toQuery) {
        return this.fNodeTypeRegistry.getTypeForClass(toQuery);
    }

    private void deleteIfUnreferenced(long address) {
        if (address == 0L) {
            return;
        }
        short nodeType = NdNode.NODE_TYPE.get(this, address);
        ITypeFactory factory1 = this.getTypeFactory(nodeType);
        if (factory1.isReadyForDeletion(this, address)) {
            factory1.destruct(this, address);
            this.getDB().free(address, (short)(256 + nodeType));
        }
    }

    public void delete(long address) {
        if (address == 0L) {
            return;
        }
        short nodeType = NdNode.NODE_TYPE.get(this, address);
        ITypeFactory factory1 = this.getTypeFactory(nodeType);
        factory1.destruct(this, address);
        this.getDB().free(address, (short)(256 + nodeType));
        if (this.pendingDeletions.containsKey(address)) {
            this.logDoubleDeletion(address);
            this.pendingDeletions.remove(address);
        }
    }

    public NdNodeTypeRegistry<NdNode> getTypeRegistry() {
        return this.fNodeTypeRegistry;
    }

    public void clear(IProgressMonitor monitor) {
        this.getDB().clear(this.getDefaultVersion());
    }

    static class DebugLockInfo {
        int fReadLocks;
        int fWriteLocks;
        List<StackTraceElement[]> fTraces = new ArrayList<StackTraceElement[]>();

        DebugLockInfo() {
        }

        public int addTrace() {
            this.fTraces.add(Thread.currentThread().getStackTrace());
            return this.fTraces.size();
        }

        public void write(String threadName) {
            System.out.println("Thread: '" + threadName + "': " + this.fReadLocks + " readlocks, " + this.fWriteLocks + " writelocks");
            for (StackTraceElement[] trace : this.fTraces) {
                System.out.println("  Stacktrace:");
                StackTraceElement[] stackTraceElementArray = trace;
                int n = trace.length;
                int n2 = 0;
                while (n2 < n) {
                    StackTraceElement ste = stackTraceElementArray[n2];
                    System.out.println("    " + ste);
                    ++n2;
                }
            }
        }

        public void inc(DebugLockInfo val) {
            this.fReadLocks += val.fReadLocks;
            this.fWriteLocks += val.fWriteLocks;
            this.fTraces.addAll(val.fTraces);
        }
    }
}

